/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.px;

import com.tridium.hx.px.BHxPxRect;
import com.tridium.hx.px.BHxPxSvgGraphics;
import javax.baja.gx.BBrush;
import javax.baja.gx.BTransform;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.hx.HxOp;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.shape.BShape;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"bajaui:Shape"})})
@NiagaraSingleton
public class BHxPxShape
extends BHxPxSvgGraphics {
    @Generated
    public static final BHxPxShape INSTANCE = new BHxPxShape();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxPxShape.class);
    private static LexiconModule LEX = LexiconModule.make(BHxPxRect.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxPxShape() {
    }

    @Override
    public IRectGeom getGeom(BWidget widget, HxOp op) {
        BShape shape = (BShape)op.get();
        IRectGeom geom = shape.getShapeGeom().bounds();
        Point tl = new Point(geom.x(), geom.y());
        Point br = new Point(geom.width() + geom.x(), geom.height() + geom.y());
        if (shape.getParent() != null) {
            tl = ((BWidget)shape.getParent()).translateFromChild((BWidget)shape, tl);
            br = ((BWidget)shape.getParent()).translateFromChild((BWidget)shape, br);
        } else {
            tl = new Point(0.0, 100.0);
            br = new Point(shape.getWidth(), shape.getHeight() + 100.0);
        }
        int border = (int)Math.ceil(((BShape)widget).getPen().getWidth());
        int width = (int)(br.x - tl.x);
        int height = (int)(br.y - tl.y);
        return new RectGeom(tl.x(), tl.y(), (double)Math.max(width, border), (double)Math.max(height, border));
    }

    @Override
    public BTransform getTransformations(HxOp op) {
        BShape shape = (BShape)op.get();
        IRectGeom geom = shape.getShapeGeom().bounds();
        Point tl = new Point(geom.x(), geom.y());
        Point br = new Point(geom.width() + geom.x(), geom.height() + geom.y());
        if (shape.getParent() != null) {
            tl = ((BWidget)shape.getParent()).translateFromChild((BWidget)shape, tl);
            br = ((BWidget)shape.getParent()).translateFromChild((BWidget)shape, br);
        } else {
            tl = new Point(0.0, 100.0);
            br = new Point(shape.getWidth(), shape.getHeight() + 100.0);
        }
        double widgetWidth = br.x - tl.x;
        double widgetHeight = br.y - tl.y;
        double scaleX = BHxPxShape.getScale(widgetWidth, geom.width());
        double scaleY = BHxPxShape.getScale(widgetHeight, geom.height());
        return BTransform.make((BTransform.Transform[])new BTransform.Transform[]{new BTransform.Scale(scaleX, scaleY), new BTransform.Translate(-geom.x(), -geom.y())});
    }

    private static double getScale(double widgetDim, double geomDim) {
        if (widgetDim == geomDim) {
            return 1.0;
        }
        if (geomDim == 0.0) {
            return 0.0;
        }
        return widgetDim / geomDim;
    }

    @Override
    public String validateWidget(BWidget widget, Context cx) {
        BBrush.Paint strokePaint;
        StringBuilder b = new StringBuilder();
        BShape shape = (BShape)widget;
        BBrush.Paint fillPaint = shape.getFill().getPaint();
        if (fillPaint instanceof BBrush.Image && ((BBrush.Image)fillPaint).getTile() != 1) {
            if (b.length() > 0) {
                b.append("\n");
            }
            b.append(LEX.getText("validateMedia.onlyTiledFillImages", cx));
        }
        if ((strokePaint = shape.getStroke().getPaint()) instanceof BBrush.Image) {
            if (b.length() > 0) {
                b.append("\n");
            }
            b.append(LEX.getText("validateMedia.onlySomeSupportForTiledStrokeImages", cx));
        }
        if (b.length() > 0) {
            return b.toString();
        }
        return null;
    }
}

