/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.progress;

import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public final class HxProgressJobDialog
extends Dialog {
    private CancelEvent cancelEvent;
    private String title;
    private IHxProgressDialogParent parent;
    private static final String JOB_NAME = "job";
    private static final String EVENT_NAME = "job-event-id";
    private IJobCompleteHandler jobCompleteHandler = new FailureDialog(new Ok());

    private HxProgressJobDialog(String title, BHxView view, IHxProgressDialogParent parent, Command handler) {
        super(title, handler);
        this.title = title;
        this.parent = parent;
        this.cancelEvent = new CancelEvent(view);
        view.registerEvent(this.cancelEvent);
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void writeContent(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BJob job = this.parent.submitJob(this, op);
        out.w((Object)"<div class='progressJobDialog-outer'>");
        out.w((Object)"<div class='progressJobDialog'>");
        out.w((Object)"<div id='").w((Object)op.scope("progbar")).w((Object)"' class='progressJobDialog-bar'></div>");
        out.w((Object)"</div>");
        out.w((Object)"</div>");
        StringBuilder buff = new StringBuilder();
        String value = job.getHandleOrd().toString();
        String name = op.scope(JOB_NAME);
        buff.append("hx.setFormValue('").append(name).append("'").append(", '").append(value).append("');");
        buff.append("hx.addFormElementToPoll('").append(name).append("');");
        String eventName = op.scope(EVENT_NAME);
        buff.append("hx.setFormValue('").append(eventName).append("'").append(", '").append(this.getHandler().getId()).append("');");
        buff.append("hx.addFormElementToPoll('").append(eventName).append("');");
        buff.append("hx.poll();");
        op.addOnload(buff.toString());
    }

    public void updateContent(HxOp op) throws Exception {
        String eventId = op.getFormValue(EVENT_NAME);
        if (eventId == null) {
            return;
        }
        if (!eventId.equals(this.getHandler().getId())) {
            return;
        }
        String ordStr = op.getUnsafeFormValue(JOB_NAME);
        if (ordStr == null) {
            return;
        }
        BOrd jobOrd = BOrd.make((String)ordStr);
        BJob job = null;
        try {
            job = (BJob)jobOrd.get(op.get());
        }
        catch (Exception e) {
            job = (BJob)jobOrd.get((BObject)Sys.getStation());
        }
        if (job.getJobState().isComplete()) {
            this.stopProgressBar(op);
            if (this.jobCompleteHandler != null) {
                this.jobCompleteHandler.invoke(job, op);
            }
        } else {
            int progress = job.getProgress();
            if (progress < 0) {
                progress = 0;
            }
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var elem = document.getElementById('").w((Object)op.scope("progbar")).w((Object)"');");
            out.w((Object)"if (elem != null) elem.style.width='").w(progress).w((Object)"%';");
        }
    }

    @Override
    public Command[] getCommands() {
        return new Command[]{new ProgressCancel()};
    }

    public static ProgressEvent makeProgress(String title, BHxView view, IHxProgressDialogParent parent) {
        return new ProgressEvent(title, view, parent);
    }

    private void stopProgressBar(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String name = op.scope(JOB_NAME);
        out.w((Object)"hx.removeFormElementFromPoll('").w((Object)name).w((Object)"');");
        String eventName = op.scope(EVENT_NAME);
        out.w((Object)"hx.removeFormElementFromPoll('").w((Object)eventName).w((Object)"');");
        out.w((Object)"if(document.getElementById('").w((Object)op.scope("progbar")).w((Object)"') != null)");
        out.w((Object)"hx.closeDialog(null,null,null);");
    }

    private class Ok
    extends Dialog.Cancel {
        private Ok() {
            super(HxProgressJobDialog.this);
        }

        @Override
        public String getDisplayName(HxOp op) {
            return Lexicon.make((String)"hx", (Context)op).getText("ok");
        }
    }

    private static class FailureDialog
    extends Dialog
    implements IJobCompleteHandler {
        private FailureDialog(Command cmd) {
            super("Error", cmd);
        }

        @Override
        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            HxUtil.makeImageJS(BImage.make((BOrd)BOrd.make((String)"module://icons/x32/error.png")), null, "failed", op);
            out.w((Object)"Task failed!");
        }

        @Override
        public Command[] getCommands() {
            return new Command[]{this.getHandler()};
        }

        @Override
        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed)) {
                this.open(op);
            }
        }
    }

    public static interface IJobCompleteHandler {
        public void invoke(BJob var1, HxOp var2) throws Exception;
    }

    public static interface IHxProgressDialogParent {
        public BJob submitJob(HxProgressJobDialog var1, HxOp var2);
    }

    private class ProgressCancel
    extends Dialog.Cancel {
        public ProgressCancel() {
            super(HxProgressJobDialog.this);
        }

        @Override
        public String getDisplayName(HxOp op) {
            return Lexicon.make((String)"hx", (Context)op).getText("cancel");
        }

        @Override
        public String getInvokeCode(HxOp op) {
            return HxProgressJobDialog.this.cancelEvent.getInvokeCode(op);
        }
    }

    private class CancelEvent
    extends Command {
        private CancelEvent(BHxView owner) {
            super(owner);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            BOrd jobOrd = BOrd.make((String)op.getUnsafeFormValue(HxProgressJobDialog.JOB_NAME));
            BJob job = null;
            try {
                job = (BJob)jobOrd.get(op.get());
            }
            catch (Exception e) {
                job = (BJob)jobOrd.get((BObject)Sys.getStation());
            }
            job.cancel();
            op.getHtmlWriter().w((Object)"hx.poll();");
        }
    }

    public static class ProgressEvent
    extends Command {
        private HxProgressJobDialog dlg;

        public ProgressEvent(String title, BHxView view, IHxProgressDialogParent parent) {
            super(view);
            this.dlg = new HxProgressJobDialog(title, view, parent, this);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
            } else {
                this.refresh(op);
            }
        }

        public void setJobCompleteHandler(IJobCompleteHandler jobCompleteHandler) {
            this.dlg.jobCompleteHandler = jobCompleteHandler;
        }

        public HxProgressJobDialog getDialog() {
            return this.dlg;
        }
    }
}

