/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.gx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.baja.gx.BBrush;
import javax.baja.gx.BLineGeom;
import javax.baja.gx.BPolygonGeom;
import javax.baja.gx.BRectGeom;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.sys.BObject;
import javax.baja.ui.shape.BLine;
import javax.baja.ui.shape.BPolygon;
import javax.baja.ui.shape.BRect;

public final class UxShapeUtil {
    private UxShapeUtil() {
    }

    public static RotateInfo getRotateInfo(BObject subject) {
        if (subject instanceof BLine) {
            BLine line = (BLine)subject;
            BBrush.Paint paint = line.getStroke().getPaint();
            boolean isGradient = paint instanceof BBrush.Gradient;
            if (isGradient) {
                BLineGeom geom = line.getGeom();
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(new Point(geom.x1(), geom.y1()));
                points.add(new Point(geom.x2(), geom.y2()));
                return UxShapeUtil.getRotateInfo(points, false, false);
            }
        } else if (subject instanceof BRect) {
            boolean isGradient;
            BRect rect = (BRect)subject;
            BBrush.Paint paintStroke = rect.getStroke().getPaint();
            BBrush.Paint paintFill = rect.getFill().getPaint();
            boolean bl = isGradient = paintStroke instanceof BBrush.Gradient || paintFill instanceof BBrush.Gradient;
            if (isGradient) {
                BRectGeom geom = rect.getGeom();
                double x = geom.x();
                double y = geom.y();
                double width = geom.width();
                double height = geom.height();
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(new Point(x, y));
                points.add(new Point(x, y + height));
                points.add(new Point(x + width, y + height));
                points.add(new Point(x + width, y));
                return UxShapeUtil.getRotateInfo(points, true, false);
            }
        } else if (subject instanceof BPolygon) {
            boolean isGradient;
            BPolygon polygon = (BPolygon)subject;
            BBrush.Paint paintStroke = polygon.getStroke().getPaint();
            BBrush.Paint paintFill = polygon.getFill().getPaint();
            boolean bl = isGradient = paintStroke instanceof BBrush.Gradient || paintFill instanceof BBrush.Gradient;
            if (isGradient) {
                ArrayList<Point> points = new ArrayList<Point>();
                BPolygonGeom geom = polygon.getGeom();
                for (int i = 0; i < geom.size(); ++i) {
                    points.add(new Point(geom.x(i), geom.y(i)));
                }
                return UxShapeUtil.getRotateInfo(points, false, true);
            }
        }
        return null;
    }

    public static RotateInfo getRotateInfo(ArrayList<Point> points, boolean forceZeroPointAngle, boolean avoidGradientDistortion) {
        double rotateAngle;
        double angle;
        if (points.size() < 2) {
            return null;
        }
        ArrayList<Point> rotatedPoints = new ArrayList<Point>();
        ShapeInfo info = UxShapeUtil.getInfo(points);
        double height = info.height;
        double width = info.width;
        double centerX = info.centerX;
        double centerY = info.centerY;
        if (avoidGradientDistortion && height > 1.0 && width > 1.0) {
            return null;
        }
        double actualAngle = 0.0;
        if (!forceZeroPointAngle) {
            actualAngle = UxShapeUtil.getAngle(points);
        }
        if (avoidGradientDistortion && width < 1.0 && height > 1.0) {
            actualAngle = 0.0;
        }
        if (avoidGradientDistortion && width > 1.0 && height < 1.0) {
            actualAngle = 90.0;
        }
        if ((angle = 45.0 - (rotateAngle = actualAngle % 90.0)) % 90.0 == 0.0) {
            angle = 0.0;
        }
        double transformAngle = -angle;
        for (Point point : points) {
            double x = point.x;
            double y = point.y;
            rotatedPoints.add(UxShapeUtil.rotatePoint(x, y, centerX, centerY, angle));
        }
        if (angle == 0.0) {
            return null;
        }
        double radians = Math.PI / 180 * angle;
        double a = Math.abs(width * Math.sin(radians)) + Math.abs(height * Math.cos(radians));
        double b = Math.abs(width * Math.cos(radians)) + Math.abs(height * Math.sin(radians));
        double radialScale = Math.max(width, height) / a;
        double scaleHeight = height / b;
        double scaleWidth = width / a;
        String radialGradientTransform = "translate(0.5, 0.5) rotate(" + angle + ") scale(" + radialScale + ", " + radialScale + ") translate(-0.5, -0.5)";
        double radialXFactor = 1.0;
        double radialYFactor = 1.0;
        if (width > height) {
            radialYFactor = height / width;
        } else {
            radialXFactor = width / height;
        }
        String linearGradientTransform = null;
        String patternTransform = null;
        String rotateString = "";
        if (angle != 0.0) {
            rotateString = "rotate(" + angle + ')';
            patternTransform = "rotate(" + angle + ", " + centerX + ", " + centerY + ')';
        }
        if (scaleWidth != 0.0 && scaleHeight != 0.0 && (scaleWidth != 1.0 || scaleHeight != 1.0) && Double.isFinite(scaleHeight) && Double.isFinite(scaleWidth)) {
            linearGradientTransform = "translate(0.5, 0.5) " + rotateString + " scale(" + scaleWidth + ", " + scaleHeight + ") translate(-0.5, -0.5)";
        } else if (angle != 0.0) {
            linearGradientTransform = "rotate(" + angle + ", 0.5, 0.5)";
        }
        String transform = "rotate(" + transformAngle + ", " + centerX + ',' + centerY + ')';
        String groupTransform = null;
        if (angle != 0.0) {
            groupTransform = transform;
        }
        return new RotateInfo(radialXFactor, radialYFactor, linearGradientTransform, radialGradientTransform, patternTransform, groupTransform, rotatedPoints);
    }

    public static double getAngle(List<Point> points) {
        if (points.size() < 2) {
            return 0.0;
        }
        double dy = points.get((int)1).y - points.get((int)0).y;
        double dx = points.get((int)1).x - points.get((int)0).x;
        double theta = Math.atan2(dy, dx);
        return theta *= 57.29577951308232;
    }

    public static String pointsToString(List<Point> points) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < points.size(); ++i) {
            if (i > 0) {
                b.append(' ');
            }
            b.append(points.get((int)i).x + "," + points.get((int)i).y);
        }
        return b.toString();
    }

    public static BBrush.RadialGradient getRadialGradient(BBrush.RadialGradient original, RotateInfo rotateInfo) {
        double cx = original.getCenter().x();
        double cy = original.getCenter().y();
        double fx = original.getFocal().x();
        double fy = original.getFocal().y();
        double r = original.getRadius();
        if (rotateInfo != null) {
            if (Double.isFinite(rotateInfo.getRadialXFactor())) {
                cx = UxShapeUtil.applyFactor(cx, rotateInfo.getRadialXFactor());
                fx = UxShapeUtil.applyFactor(fx, rotateInfo.getRadialXFactor());
            }
            if (Double.isFinite(rotateInfo.getRadialYFactor())) {
                cy = UxShapeUtil.applyFactor(cy, rotateInfo.getRadialYFactor());
                fy = UxShapeUtil.applyFactor(fy, rotateInfo.getRadialYFactor());
            }
        }
        double unsafePercentDifference = r * 0.34;
        if (Math.abs(cx - fx) >= r - unsafePercentDifference) {
            fx = cx > fx ? cx - r + unsafePercentDifference : cx + r - unsafePercentDifference;
        }
        if (Math.abs(cy - fy) >= r - unsafePercentDifference) {
            fy = cy > fy ? cy - r + unsafePercentDifference : cy + r - unsafePercentDifference;
        }
        return (BBrush.RadialGradient)BBrush.makeRadialGradient((BBrush.Stop[])original.getStops(), (int)original.getSpread(), (IPoint)new Point(cx, cy), (double)r, (IPoint)new Point(fx, fy)).getPaint();
    }

    private static ShapeInfo getInfo(List<Point> points) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Point p : points) {
            minX = Math.min(minX, p.x());
            maxX = Math.max(maxX, p.x());
            minY = Math.min(minY, p.y());
            maxY = Math.max(maxY, p.y());
        }
        ShapeInfo info = new ShapeInfo();
        info.centerX = (minX + maxX) / 2.0;
        info.centerY = (minY + maxY) / 2.0;
        info.width = maxX - minX;
        info.height = maxY - minY;
        return info;
    }

    private static double applyFactor(double value, double factor) {
        value = (value - 50.0) * factor + 50.0;
        return value;
    }

    private static Point rotatePoint(double x, double y, double cx, double cy, double angle) {
        double radians = Math.PI / 180 * angle;
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double nx = cos * (x - cx) - sin * (y - cy) + cx;
        double ny = cos * (y - cy) + sin * (x - cx) + cy;
        return new Point(nx, ny);
    }

    public static class RotateInfo {
        private final double radialXFactor;
        private final double radialYFactor;
        private final String linearGradientTransform;
        private final String radialGradientTransform;
        private final String patternTransform;
        private final String groupTransform;
        private final List<Point> rotatedPoints;

        public RotateInfo(double radialXFactor, double radialYFactor, String linearGradientTransform, String radialGradientTransform, String patternTransform, String groupTransform, List<Point> rotatedPoints) {
            this.radialXFactor = radialXFactor;
            this.radialYFactor = radialYFactor;
            this.linearGradientTransform = linearGradientTransform;
            this.radialGradientTransform = radialGradientTransform;
            this.patternTransform = patternTransform;
            this.groupTransform = groupTransform;
            this.rotatedPoints = Collections.unmodifiableList(rotatedPoints);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.valueOf(this.radialXFactor) + this.radialYFactor + this.linearGradientTransform + this.radialGradientTransform + this.patternTransform + this.groupTransform;
        }

        public double getRadialXFactor() {
            return this.radialXFactor;
        }

        public double getRadialYFactor() {
            return this.radialYFactor;
        }

        public String getLinearGradientTransform() {
            return this.linearGradientTransform;
        }

        public String getRadialGradientTransform() {
            return this.radialGradientTransform;
        }

        public String getPatternTransform() {
            return this.patternTransform;
        }

        public String getGroupTransform() {
            return this.groupTransform;
        }

        public List<Point> getRotatedPoints() {
            return this.rotatedPoints;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            return o.toString().equals(this.toString());
        }
    }

    private static class ShapeInfo {
        private double centerX;
        private double centerY;
        private double width;
        private double height;

        private ShapeInfo() {
        }
    }
}

