/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx;

import java.text.DecimalFormat;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"baja:IDirectory"}, requiredPermissions="r")})
@NiagaraSingleton
public class BHxDirectoryList
extends BHxView {
    @Generated
    public static final BHxDirectoryList INSTANCE = new BHxDirectoryList();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxDirectoryList.class);
    static DecimalFormat sizeFormat = new DecimalFormat("#,##0.# KB");
    static final LexiconModule lex = LexiconModule.make((String)"bajaui");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxDirectoryList() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        BIDirectory dir = (BIDirectory)op.get();
        String name = dir.getNavDisplayName((Context)op);
        BIFile[] kids = dir.listFiles();
        String size = "text-align:right;";
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table width='100%' cellspacing='0' class='table'>");
        out.w((Object)"<tr>");
        out.w((Object)" <th>").safe((Object)lex.getText("name", (Context)op)).w((Object)"</th>");
        out.w((Object)" <th>").safe((Object)lex.getText("type", (Context)op)).w((Object)"</th>");
        out.w((Object)" <th ").attr("style", size).w((Object)">").safe((Object)lex.getText("size", (Context)op)).w((Object)"</th>");
        out.w((Object)" <th>").safe((Object)lex.getText("modified", (Context)op)).w((Object)"</th>");
        out.w((Object)"</tr>");
        for (int i = 0; i < kids.length; ++i) {
            BIFile file = kids[i];
            if (!file.getPermissions((Context)op).hasOperatorRead()) continue;
            BImage icon = BImage.make((BIcon)file.getNavIcon());
            out.w((Object)"<tr>");
            out.w((Object)" <td style='white-space:nowrap;'>");
            HxUtil.makeImageJS(icon, "style='vertical-align:middle;'", null, null, op);
            out.w((Object)"&nbsp;");
            HxUtil.writeSafeAnchor(file.getNavOrd(), file.getNavDisplayName((Context)op), op);
            out.w((Object)" </td>");
            out.w((Object)" <td style='white-space:nowrap;'>");
            out.safe((Object)file.asObject().getType().getTypeName());
            out.w((Object)" </td>");
            out.w((Object)" <td ").attr("style", size).w((Object)">");
            String s = this.size(file.getSize());
            if (s.length() == 0) {
                out.w((Object)"&nbsp;");
            } else {
                out.safe((Object)s);
            }
            out.w((Object)" </td>");
            out.w((Object)"<td style='white-space:nowrap;'>");
            out.safe((Object)file.getLastModified().toString((Context)op));
            out.w((Object)" </td>");
            out.w((Object)"</tr>");
        }
        out.w((Object)"</table>");
    }

    String size(long size) {
        if (size < 0L) {
            return "";
        }
        if (size < 1024L) {
            return "1 KB";
        }
        double d = size / 1024L;
        return sizeFormat.format(d);
    }
}

