/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.block;

import com.tridium.platDataRecovery.BDataRecoveryService;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManagerStatus;
import com.tridium.platDataRecovery.block.BDataRecoveryFlushEvent;
import com.tridium.platDataRecovery.block.DataRecoveryBlock;
import com.tridium.platDataRecovery.block.DataRecoveryWriteResponse;
import com.tridium.platDataRecovery.block.UsedDataRecoveryBlock;
import com.tridium.platDataRecovery.collection.DataRecoveryRecord;
import com.tridium.platDataRecovery.exceptions.DataRecoveryBlockInvalidException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryStoreUnavailableException;
import com.tridium.platDataRecovery.exceptions.DataRecoveryTooLargeEventEncounteredException;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoverySource;
import javax.baja.dataRecovery.DataRecoveryException;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maxCapacity", type="int", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.UNITS, BFacets.MIN, BFacets.MAX }, new BIDataValue[] { BUnit.make(\"byte\", \"B\", BDimension.NULL, 1d), BInteger.make(0), BInteger.MAX })")}), @NiagaraProperty(name="currentManagerStatus", type="BDataRecoveryBlockManagerStatus", defaultValue="BDataRecoveryBlockManagerStatus.unknown", flags=3)})
@NiagaraAction(name="dumpRecoveryData", returnType="BBoolean", flags=4)
@NiagaraTopics(value={@NiagaraTopic(name="blockFlushed", eventType="BDataRecoveryFlushEvent"), @NiagaraTopic(name="sizesUpdated")})
public abstract class BDataRecoveryBlockManager
extends BComponent {
    @Generated
    public static final Property maxCapacity = BDataRecoveryBlockManager.newProperty((int)3, (int)0, (BFacets)BFacets.make((String[])new String[]{"units", "min", "max"}, (BIDataValue[])new BIDataValue[]{BUnit.make((String)"byte", (String)"B", (BDimension)BDimension.NULL, (double)1.0), BInteger.make((int)0), BInteger.MAX}));
    @Generated
    public static final Property currentManagerStatus = BDataRecoveryBlockManager.newProperty((int)3, (BValue)BDataRecoveryBlockManagerStatus.unknown, null);
    @Generated
    public static final Action dumpRecoveryData = BDataRecoveryBlockManager.newAction((int)4, null);
    @Generated
    public static final Topic blockFlushed = BDataRecoveryBlockManager.newTopic((int)0, null);
    @Generated
    public static final Topic sizesUpdated = BDataRecoveryBlockManager.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDataRecoveryBlockManager.class);
    protected static boolean debug = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.platDataRecovery.blockDebug"));
    protected static boolean failFast = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.platDataRecovery.exitOnRestoreFailure"));
    private int overheadSpaceAttribute = 0;
    private int usedSpaceAttribute = 0;
    private int freeSpaceAttribute = 0;
    protected final Object sizeMonitor = new Object();
    long lastMillisFired = 0L;
    protected static final Logger log = Logger.getLogger("platDataRecovery.manager");
    public static final Comparator<BDataRecoveryBlockManager> DEFAULT_RECOVERY_MANAGER_COMPARATOR = Comparator.comparingInt(BDataRecoveryBlockManager::getFreeSpace);
    public static final Comparator<File> DEFAULT_ACTIVE_FILE_COMPARATOR = (o1, o2) -> Long.compare(o2.length(), o1.length());
    public static final Comparator<File> PERSISTENT_FILE_COMPARATOR = (o1, o2) -> {
        String name1 = o1.getName().substring(0, o1.getName().indexOf(46));
        String name2 = o2.getName().substring(0, o2.getName().indexOf(46));
        long long1 = Long.parseLong(name1);
        long long2 = Long.parseLong(name2);
        return Long.compare(long1, long2);
    };
    protected ArrayList<DataRecoveryBlock> blocks = null;
    protected final Object blocksMonitor = new Object();
    protected boolean activeFileOpen = false;
    protected File file = null;
    protected static boolean dirsInitialized = false;
    protected static File persistentDirectory = null;
    protected static File activeDirectory = null;
    public static final Object persistentDirectoryMonitor = new Object();
    public static final Object activeDirectoryMonitor = new Object();
    protected static int chunkSize = -1;
    protected static int totalChunks = -1;
    protected int remainingChunks = -1;

    @Generated
    public int getMaxCapacity() {
        return this.getInt(maxCapacity);
    }

    @Generated
    public void setMaxCapacity(int v) {
        this.setInt(maxCapacity, v, null);
    }

    @Generated
    public BDataRecoveryBlockManagerStatus getCurrentManagerStatus() {
        return (BDataRecoveryBlockManagerStatus)this.get(currentManagerStatus);
    }

    @Generated
    public void setCurrentManagerStatus(BDataRecoveryBlockManagerStatus v) {
        this.set(currentManagerStatus, (BValue)v, null);
    }

    @Generated
    public BBoolean dumpRecoveryData() {
        return (BBoolean)this.invoke(dumpRecoveryData, null, null);
    }

    @Generated
    public void fireBlockFlushed(BDataRecoveryFlushEvent event) {
        this.fire(blockFlushed, (BValue)event, null);
    }

    @Generated
    public void fireSizesUpdated(BValue event) {
        this.fire(sizesUpdated, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public abstract void openActiveFile(String var1) throws Exception;

    public abstract void closeActiveFile() throws Exception;

    public abstract boolean isActiveOpen();

    protected abstract void readFromActive() throws Exception;

    protected abstract void formatActiveFile() throws Exception;

    public abstract DataRecoveryWriteResponse appendData(byte var1, byte[] var2, byte[] var3) throws DataRecoveryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeDirectories(String tempActiveDirectory, String tempPersistentDirectory) {
        block27: {
            boolean directoryCreated;
            Object object;
            boolean trace;
            block26: {
                block25: {
                    block24: {
                        trace = log.isLoggable(Level.FINEST);
                        if (!dirsInitialized) break block24;
                        if (trace) {
                            log.finest("Data recovery active directory already initialized");
                        }
                        if (tempActiveDirectory.equals(activeDirectory.getAbsolutePath())) break block25;
                    }
                    if (trace) {
                        log.finest("Setting active data recovery directory to: " + tempActiveDirectory);
                    }
                    object = activeDirectoryMonitor;
                    synchronized (object) {
                        activeDirectory = new File(tempActiveDirectory);
                        if (activeDirectory.exists()) {
                            if (!activeDirectory.isDirectory()) {
                                log.severe("Active data recovery file already exists but is not a directory.");
                                throw new BajaRuntimeException("Active data recovery file already exists but is not a directory");
                            }
                        } else {
                            directoryCreated = AccessController.doPrivileged(activeDirectory::mkdirs);
                            if (!directoryCreated) {
                                log.severe("Failed to create active data recovery directory: " + activeDirectory.getAbsolutePath());
                                throw new BajaRuntimeException("Failed to create active data recovery directory");
                            }
                        }
                    }
                }
                if (!dirsInitialized) break block26;
                if (trace) {
                    log.finest("Data recovery persistent directory already initialized");
                }
                if (tempPersistentDirectory.equals(persistentDirectory.getAbsolutePath())) break block27;
            }
            if (trace) {
                log.finest("Setting persistent data recovery directory to: " + tempPersistentDirectory);
            }
            object = persistentDirectoryMonitor;
            synchronized (object) {
                persistentDirectory = new File(tempPersistentDirectory);
                if (persistentDirectory.exists()) {
                    if (!persistentDirectory.isDirectory()) {
                        log.severe("Persistent data recovery file already exists but is not a directory.");
                        throw new BajaRuntimeException("Persistent data recovery file already exists but is not a directory");
                    }
                } else {
                    directoryCreated = AccessController.doPrivileged(persistentDirectory::mkdirs);
                    if (!directoryCreated) {
                        log.severe("Failed to create persistent data recovery directory: " + persistentDirectory.getAbsolutePath());
                        throw new BajaRuntimeException("Failed to create persistent data recovery directory");
                    }
                }
            }
        }
        dirsInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean recoveryDataExists() throws DataRecoveryException {
        if (!dirsInitialized) {
            throw new DataRecoveryStoreUnavailableException("Data recovery directories are not initialized");
        }
        Object object = persistentDirectoryMonitor;
        synchronized (object) {
            File[] persistentChildren = persistentDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
            if (persistentChildren != null && persistentChildren.length != 0) {
                return true;
            }
        }
        object = activeDirectoryMonitor;
        synchronized (object) {
            File[] activeChildren = activeDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
            if (activeChildren != null) {
                for (File activeChild : activeChildren) {
                    if (BDataRecoveryService.lengthOfFile(activeChild) == 0L) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void recalculateSpace() throws DataRecoveryException {
        if (!this.activeFileOpen) {
            throw new DataRecoveryStoreUnavailableException("Active data recovery file is not open.");
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Recalculating allocation sizes for file: " + this.file.getName());
            }
            int totalOverheadSpace = 0;
            int totalFreeSpace = 0;
            int totalUsedSpace = 0;
            Iterator<DataRecoveryBlock> blockIterator = this.blocks.iterator();
            if (chunkSize > 0) {
                this.remainingChunks = totalChunks;
            }
            while (blockIterator.hasNext()) {
                DataRecoveryBlock current = blockIterator.next();
                if (chunkSize < 0) {
                    totalFreeSpace += current.getFreeSpace();
                    totalUsedSpace += current.getUsedSpace();
                    totalOverheadSpace += current.getOverheadSpace();
                    continue;
                }
                if (current.getBlockState() == 0) continue;
                int chunksOccupiedByBlock = current.getTotalSize() / chunkSize;
                if (current.getTotalSize() % chunkSize != 0) {
                    ++chunksOccupiedByBlock;
                }
                int chunkOverhead = chunksOccupiedByBlock * chunkSize - current.getTotalSize();
                totalUsedSpace += current.getUsedSpace();
                totalOverheadSpace += current.getOverheadSpace() + chunkOverhead;
                this.remainingChunks -= chunksOccupiedByBlock;
                totalFreeSpace = this.remainingChunks * chunkSize;
            }
            Object object2 = this.sizeMonitor;
            synchronized (object2) {
                long currentMillis;
                if (this.getMaxCapacity() == 0) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("In BDataRecoveryBlockManager::recalculateSpace(), setting maxCapacity to: " + totalFreeSpace + totalUsedSpace + totalOverheadSpace);
                    }
                    this.setMaxCapacity(totalFreeSpace + totalUsedSpace + totalOverheadSpace);
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("In BDataRecoveryBlockManager::recalculateSpace(), maxCapacity was already set to: " + this.getMaxCapacity());
                    }
                    if (totalUsedSpace + totalFreeSpace + totalOverheadSpace != this.getMaxCapacity()) {
                        totalFreeSpace = this.getMaxCapacity() - totalUsedSpace - totalOverheadSpace;
                    }
                    if (chunkSize > 0 && totalFreeSpace == this.getMaxCapacity()) {
                        this.remainingChunks = totalChunks;
                    }
                }
                try {
                    this.setUsedSpace(totalUsedSpace);
                    this.setFreeSpace(totalFreeSpace);
                    this.setOverheadSpace(totalOverheadSpace);
                }
                catch (Exception e) {
                    throw new DataRecoveryException("Error while recalculating sizes: ", (Throwable)e);
                }
                if (this.isSubscribed() && (currentMillis = System.currentTimeMillis()) - this.lastMillisFired > 5000L) {
                    this.fireSizesUpdated(null);
                    this.lastMillisFired = currentMillis;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("In BDataRecoveryBlockManager::recalculateSpace(), free space is now: " + totalFreeSpace);
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("In BDataRecoveryBlockManager::recalculateSpace(), used space is now: " + totalUsedSpace);
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("In BDataRecoveryBlockManager::recalculateSpace(), overhead space is now: " + totalOverheadSpace);
                }
            }
        }
    }

    public static LinkedList<IDataRecoveryRecord> replayActiveRecoveryData() {
        return BDataRecoveryBlockManager.replayActiveRecoveryData(DEFAULT_ACTIVE_FILE_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<IDataRecoveryRecord> replayActiveRecoveryData(Comparator<File> sortMetric) {
        if (sortMetric == null) {
            return BDataRecoveryBlockManager.replayActiveRecoveryData();
        }
        LinkedList<IDataRecoveryRecord> activeRecoveryData = new LinkedList<IDataRecoveryRecord>();
        if (!dirsInitialized) {
            return activeRecoveryData;
        }
        Object object = activeDirectoryMonitor;
        synchronized (object) {
            Object[] activeChildren = activeDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
            if (activeChildren != null) {
                log.finer("Sorting active file database for replay...");
                SortUtil.sort((Object[])activeChildren, (Object[])activeChildren, sortMetric);
                for (int index = 0; index < activeChildren.length; ++index) {
                    if (log.isLoggable(Level.FINER)) {
                        long sequenceNumber = BDataRecoveryService.extractActiveSequenceNumberFromRecoveryData(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)activeChildren[index], true));
                        log.finer("Replaying active file " + (index + 1) + " of " + activeChildren.length + ", sequence number is " + sequenceNumber);
                    }
                    activeRecoveryData.addAll(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)activeChildren[index], true));
                }
            }
        }
        return activeRecoveryData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<IDataRecoveryRecord> replayPersistentRecoveryData() {
        LinkedList<IDataRecoveryRecord> persistentRecoveryData = new LinkedList<IDataRecoveryRecord>();
        if (!dirsInitialized) {
            return persistentRecoveryData;
        }
        Object object = persistentDirectoryMonitor;
        synchronized (object) {
            Object[] persistentChildren = persistentDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
            if (persistentChildren != null) {
                log.finer("Sorting persistent file database for replay...");
                SortUtil.sort((Object[])persistentChildren, (Object[])persistentChildren, PERSISTENT_FILE_COMPARATOR);
                for (int index = 0; index < persistentChildren.length; ++index) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Replaying persistent file " + (index + 1) + " of " + persistentChildren.length);
                    }
                    persistentRecoveryData.addAll(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)persistentChildren[index], false));
                }
            }
        }
        return persistentRecoveryData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<IDataRecoveryRecord> replayLastPersistentFile() {
        LinkedList<IDataRecoveryRecord> persistentRecoveryData = new LinkedList<IDataRecoveryRecord>();
        if (!dirsInitialized) {
            return persistentRecoveryData;
        }
        Object object = persistentDirectoryMonitor;
        synchronized (object) {
            Object[] persistentChildren = persistentDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
            if (persistentChildren != null) {
                log.finer("Sorting persistent file database for last replay...");
                SortUtil.sort((Object[])persistentChildren, (Object[])persistentChildren, PERSISTENT_FILE_COMPARATOR);
                if (persistentChildren.length != 0) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Replaying last persistent file \"" + persistentChildren[persistentChildren.length - 1] + "\"");
                    }
                    persistentRecoveryData.addAll(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)persistentChildren[persistentChildren.length - 1], false));
                }
            }
        }
        return persistentRecoveryData;
    }

    public static void replayRecoveryData(HashMap<Byte, BIDataRecoverySource> dataRecoverySources) {
        BDataRecoveryBlockManager.replayRecoveryData(dataRecoverySources, DEFAULT_ACTIVE_FILE_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replayRecoveryData(HashMap<Byte, BIDataRecoverySource> dataRecoverySources, Comparator<File> activeSortMetric) {
        if (activeSortMetric == null) {
            BDataRecoveryBlockManager.replayRecoveryData(dataRecoverySources);
        }
        if (!dirsInitialized) {
            log.severe("Directories are not initialized, can not replay data at this time");
            return;
        }
        if (dataRecoverySources == null) {
            log.severe("Provided dataRecoverySources null, can not replay data");
            return;
        }
        try {
            int index;
            Object object = persistentDirectoryMonitor;
            synchronized (object) {
                Object[] persistentChildren = persistentDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
                if (persistentChildren != null) {
                    log.finer("Sorting persistent file database for replay...");
                    SortUtil.sort((Object[])persistentChildren, (Object[])persistentChildren, PERSISTENT_FILE_COMPARATOR);
                    for (index = 0; index < persistentChildren.length; ++index) {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("Replaying persistent file " + (index + 1) + " of " + persistentChildren.length);
                        }
                        BDataRecoveryBlockManager.restoreRecoveryDataHelper(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)persistentChildren[index], false), dataRecoverySources);
                    }
                }
            }
            object = activeDirectoryMonitor;
            synchronized (object) {
                Object[] activeChildren = activeDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
                if (activeChildren != null) {
                    log.finer("Sorting active file database for replay...");
                    SortUtil.sort((Object[])activeChildren, (Object[])activeChildren, activeSortMetric);
                    for (index = 0; index < activeChildren.length; ++index) {
                        if (log.isLoggable(Level.FINER)) {
                            long sequenceNumber = BDataRecoveryService.extractActiveSequenceNumberFromRecoveryData(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)activeChildren[index], true));
                            log.finer("Replaying active file " + (index + 1) + " of " + activeChildren.length + ", sequence number is " + sequenceNumber);
                        }
                        BDataRecoveryBlockManager.restoreRecoveryDataHelper(BDataRecoveryBlockManager.replayRecoveryDataHelper((File)activeChildren[index], true), dataRecoverySources);
                    }
                }
            }
        }
        catch (DataRecoveryTooLargeEventEncounteredException drtlee) {
            IDataRecoveryRecord record = drtlee.getRecord();
            log.warning("Encountered Data Recovery Too Large Event");
            byte[] tooLargeDataBytes = record.getData();
            try {
                ByteBuffer bufferUtil = new ByteBuffer(tooLargeDataBytes);
                BAbsTime occurredAt = (BAbsTime)BAbsTime.DEFAULT.decode((DataInput)bufferUtil);
                BOrd sourceOrd = (BOrd)BOrd.DEFAULT.decode((DataInput)bufferUtil);
                log.severe("Data Recovery encountered an event from source \"" + sourceOrd + "\" that was too large to restore.");
                log.severe("The station cannot be completely restored.  Station is current as of " + occurredAt);
            }
            catch (IOException ioe) {
                log.severe("Error decoding Data Recovery Too Large data, can not print");
            }
        }
        Set<Map.Entry<Byte, BIDataRecoverySource>> sourceSet = dataRecoverySources.entrySet();
        for (Map.Entry<Byte, BIDataRecoverySource> entry : sourceSet) {
            entry.getValue().dataRecoveryRestoreComplete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LinkedList<IDataRecoveryRecord> replayRecoveryDataHelper(File fileToReplay, boolean addOnFailure) {
        DataInputStream dis;
        boolean trace = log.isLoggable(Level.FINER);
        if (trace) {
            log.finer("Replaying file name: " + fileToReplay.getName());
        }
        LinkedList<IDataRecoveryRecord> dataRecoveryRecordsInFile = new LinkedList<IDataRecoveryRecord>();
        try {
            dis = new DataInputStream(new FileInputStream(fileToReplay));
        }
        catch (FileNotFoundException e) {
            log.log(Level.SEVERE, "File not found: " + fileToReplay.getName(), e);
            return new LinkedList<IDataRecoveryRecord>();
        }
        DataRecoveryBlock.maxReadSize = BDataRecoveryService.lengthOfFile(fileToReplay);
        boolean errorOccurred = false;
        for (int count = 0; count >= 0; ++count) {
            try {
                DataRecoveryBlock currentBlock = DataRecoveryBlock.read(dis);
                if (currentBlock.getBlockState() == 0) {
                    if (!trace) continue;
                    log.finer("Ignoring free block of size " + currentBlock.getTotalSize() + " in data recovery file.");
                    continue;
                }
                DataRecoveryRecord recordToAdd = new DataRecoveryRecord(currentBlock.getSpaceIdentifier(), currentBlock.getKeyInSourceSpace(), currentBlock.getPayload());
                dataRecoveryRecordsInFile.addLast(recordToAdd);
                continue;
            }
            catch (EOFException e) {
                if (!trace) break;
                log.finer("Reached expected EOF in data recovery file.");
                break;
            }
            catch (DataRecoveryBlockInvalidException e) {
                log.warning("Data recovery block " + count + " was determined to be corrupted (" + e.getMessage() + "), data may be lost");
                errorOccurred = true;
                if (e.wasMagicStartByteInvalid()) {
                    if (dataRecoveryRecordsInFile.size() <= 0) break;
                    dataRecoveryRecordsInFile.removeLast();
                    break;
                }
                if (e.wasMagicEndByteInvalid()) break;
                break;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "General exception errorOccurred while reading data recovery block, error errorOccurred on record " + count + ":", e);
                errorOccurred = true;
                break;
            }
        }
        try {
            dis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (errorOccurred && !addOnFailure) {
            return new LinkedList<IDataRecoveryRecord>();
        }
        return dataRecoveryRecordsInFile;
    }

    private static void restoreRecoveryDataHelper(LinkedList<IDataRecoveryRecord> records, HashMap<Byte, BIDataRecoverySource> sources) {
        if (records == null) {
            return;
        }
        if (sources == null) {
            return;
        }
        HashSet<Byte> ignoredBytes = new HashSet<Byte>();
        while (!records.isEmpty()) {
            BIDataRecoverySource targetSource;
            IDataRecoveryRecord currentRecord = records.remove(0);
            if (currentRecord == null) {
                log.warning("Ignoring NULL DateRecoveryRecord");
                continue;
            }
            byte sourceByte = currentRecord.getDataRecoverySourceIdentifier();
            if (sourceByte == 0) {
                boolean tooLargeFound;
                block11: {
                    tooLargeFound = false;
                    try {
                        BBlob testBlob = (BBlob)BBlob.DEFAULT.decode((DataInput)new ByteBuffer(currentRecord.getKey()));
                        if (!testBlob.equals((Object)BDataRecoveryService.TOO_LARGE_EVENT_AS_BLOB)) break block11;
                        tooLargeFound = true;
                    }
                    catch (Exception e) {
                        log.warning("Unable to decode record that originated from service, ignoring record.");
                        continue;
                    }
                }
                if (tooLargeFound) {
                    throw new DataRecoveryTooLargeEventEncounteredException("Encountered Too Large Event while restoring data.", currentRecord);
                }
            }
            if ((targetSource = sources.get(currentRecord.getDataRecoverySourceIdentifier())) != null) {
                try {
                    targetSource.dataRecoveryRestore(currentRecord);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Exception restoring data recovery record", e);
                    if (!failFast) continue;
                    log.severe("Data recovery Source indicated an error on restore, closing VM to preserve corrupted records.");
                    AccessController.doPrivileged(() -> {
                        System.exit(-1);
                        return null;
                    });
                }
                continue;
            }
            if (ignoredBytes.contains(currentRecord.getDataRecoverySourceIdentifier())) continue;
            ignoredBytes.add(currentRecord.getDataRecoverySourceIdentifier());
            log.warning("Ignoring record(s) with source byte " + currentRecord.getDataRecoverySourceIdentifier() + ", no BIDataRecoverySource available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastPersistentFileNumber() {
        if (!dirsInitialized) {
            return -1L;
        }
        long lastPersistentFileNumber = -1L;
        Object object = persistentDirectoryMonitor;
        synchronized (object) {
            Object[] persistentChildren = persistentDirectory.listFiles(BDataRecoveryService.DATA_RECOVERY_FILE_FILTER);
            if (persistentChildren != null) {
                log.finest("Sorting persistent file database for last persistent file name...");
                SortUtil.sort((Object[])persistentChildren, (Object[])persistentChildren, PERSISTENT_FILE_COMPARATOR);
                if (persistentChildren.length != 0) {
                    Object last = persistentChildren[persistentChildren.length - 1];
                    String lastName = ((File)last).getName().substring(0, ((File)last).getName().indexOf(46));
                    lastPersistentFileNumber = Long.parseLong(lastName);
                }
            }
        }
        return lastPersistentFileNumber;
    }

    public static File getPersistentDirectory() throws DataRecoveryException {
        if (!dirsInitialized) {
            throw new DataRecoveryStoreUnavailableException("data recovery directories are not initialized");
        }
        return persistentDirectory;
    }

    public static File getActiveDirectory() throws DataRecoveryException {
        if (!dirsInitialized) {
            throw new DataRecoveryStoreUnavailableException("data recovery directories are not initialized");
        }
        return activeDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BBoolean doPurgeRecoveryData() {
        Object object = this.blocksMonitor;
        synchronized (object) {
            BDataRecoveryBlockManagerStatus old = this.getCurrentManagerStatus();
            this.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.purging);
            if (this.activeFileOpen) {
                long ticks = 0L;
                if (debug) {
                    ticks = Clock.ticks();
                }
                try {
                    this.formatActiveFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (debug && ticks != 0L) {
                    System.out.println("BDataRecoveryBlockManager::doPurgeRecoveryData() took: " + (Clock.ticks() - ticks) + " ms");
                }
            }
            if (old == BDataRecoveryBlockManagerStatus.awaitingIdle) {
                this.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.idle);
            } else {
                this.setCurrentManagerStatus(old);
            }
        }
        return BBoolean.TRUE;
    }

    public final BBoolean doFlushRecoveryData(String fileName) {
        return this.doFlushRecoveryData(fileName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BBoolean doFlushRecoveryData(String fileName, boolean notifyOthers) {
        long bytesFlushed;
        if (!this.activeFileOpen) {
            return BBoolean.FALSE;
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            BDataRecoveryBlockManagerStatus old = this.getCurrentManagerStatus();
            this.setCurrentManagerStatus(BDataRecoveryBlockManagerStatus.flushing);
            if (this.blocks.size() == 1 && this.blocks.get(0).getBlockState() == 0) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Not flushing formatted data recovery block: " + this.getName());
                }
                this.setCurrentManagerStatus(old);
                return BBoolean.TRUE;
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("Flushing data recovery block: " + this.getName() + "...");
            }
            File persistentFile = new File(persistentDirectory, fileName);
            try {
                bytesFlushed = AccessController.doPrivileged(() -> {
                    long tempBytesFlushed;
                    Object object = persistentDirectoryMonitor;
                    synchronized (object) {
                        if (persistentFile.exists()) {
                            log.severe("Persistent file with name: " + persistentFile + " already exists!");
                            return -1L;
                        }
                        File persistentFileWorking = new File(persistentDirectory, fileName + "_working");
                        if (!persistentFileWorking.createNewFile()) {
                            log.severe("Unable to create persistent file: " + persistentFileWorking.getName() + ", can not flush");
                            return -1L;
                        }
                        Iterator<DataRecoveryBlock> blockIterator = this.blocks.iterator();
                        try (DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(persistentFileWorking, false), 128000));){
                            while (blockIterator.hasNext()) {
                                DataRecoveryBlock current = blockIterator.next();
                                if (current.getBlockState() != 1) continue;
                                current.write(dataOut);
                            }
                            dataOut.flush();
                            tempBytesFlushed = dataOut.size();
                        }
                        try {
                            Files.move(persistentFileWorking.toPath(), persistentFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (AtomicMoveNotSupportedException amnse) {
                            log.severe("Unable to atomic move persistent file: " + persistentFile.getName() + ", can not flush");
                            return -1L;
                        }
                    }
                    this.formatActiveFile();
                    return tempBytesFlushed;
                });
                if (bytesFlushed == -1L) {
                    this.setCurrentManagerStatus(old);
                    return BBoolean.FALSE;
                }
            }
            catch (PrivilegedActionException pae) {
                log.log(Level.SEVERE, "Error creating persistent file: ", pae.getException());
                this.setCurrentManagerStatus(old);
                return BBoolean.FALSE;
            }
            this.setCurrentManagerStatus(old);
        }
        if (notifyOthers) {
            this.fireBlockFlushed(new BDataRecoveryFlushEvent(bytesFlushed));
        }
        return BBoolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BBoolean doDumpRecoveryData() {
        Object object = this.blocksMonitor;
        synchronized (object) {
            this.visualDump(System.out);
        }
        return BBoolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintStream out) {
        if (!this.activeFileOpen) {
            return;
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            out.println("Active Path     :            " + activeDirectory);
            out.println("Persistent Path :            " + persistentDirectory);
            out.println("Status          :            " + this.getCurrentManagerStatus().getDisplayTag((Context)BFacets.NULL));
            out.println("File Size       :            " + this.getMaxCapacity() + " bytes");
            out.println("Overhead Space  :            " + this.getOverheadSpace() + " bytes");
            out.println("Free Space      :            " + this.getFreeSpace() + " bytes");
            out.println("Used Space      :            " + this.getUsedSpace() + " bytes");
            out.println("Blocks          :            ");
            out.println("{");
            int currentOffset = 0;
            for (int i = 0; i < this.blocks.size(); ++i) {
                DataRecoveryBlock current = this.blocks.get(i);
                out.println("  Block Number [ " + i + " ] at offset: " + currentOffset);
                out.println("  {");
                out.println("    Total Size           :  " + current.getTotalSize() + " bytes");
                out.println("    Header Size          :  " + current.getHeaderSize() + " bytes");
                out.println("    State                :  " + current.getBlockState());
                if (current.getBlockState() != 0) {
                    out.println("    Source ID            :  " + current.getSpaceIdentifier());
                    out.println("    Client Key Size      :  " + current.getKeyInSourceSpaceSize() + " bytes");
                    out.println("    Client Key as String :  " + TextUtil.bytesToHexString((byte[])current.keyInSourceSpace));
                    out.println("    Payload Size         :  " + current.getPayloadSize() + " bytes");
                    out.println("    Payload as String    :  " + TextUtil.bytesToHexString((byte[])current.payload));
                } else {
                    out.println("    Payload Size         :  " + current.getPayloadSize() + " bytes");
                }
                out.println("  }");
                currentOffset += current.getTotalSize();
            }
            out.println("}");
            out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visualDump(PrintStream out) {
        if (!this.activeFileOpen) {
            return;
        }
        Object object = this.blocksMonitor;
        synchronized (object) {
            out.println("File Size     :            " + this.getMaxCapacity() + " bytes");
            out.println("Overhead Space:            " + this.getOverheadSpace() + " bytes");
            out.println("Free Space    :            " + this.getFreeSpace() + " bytes");
            out.println("Used Space    :            " + this.getUsedSpace() + " bytes");
            Iterator<DataRecoveryBlock> blockIterator = this.blocks.iterator();
            int count = 0;
            while (blockIterator.hasNext()) {
                DataRecoveryBlock current = blockIterator.next();
                System.out.println("At index: " + count++);
                current.visual(out);
            }
            out.println();
        }
    }

    public boolean isEmpty() {
        return this.overheadSpaceAttribute + this.usedSpaceAttribute == 0;
    }

    public File getFile() {
        return this.file;
    }

    void setOverheadSpace(int overheadSpace) throws Exception {
        if (overheadSpace < 0) {
            throw new Exception("Invalid overhead space size: " + overheadSpace);
        }
        this.overheadSpaceAttribute = overheadSpace;
    }

    void setUsedSpace(int usedSpace) throws Exception {
        if (usedSpace < 0) {
            throw new Exception("Invalid used space size: " + usedSpace);
        }
        this.usedSpaceAttribute = usedSpace;
    }

    void setFreeSpace(int freeSpace) throws Exception {
        if (freeSpace < 0) {
            throw new Exception("Invalid free space size: " + freeSpace);
        }
        this.freeSpaceAttribute = freeSpace;
    }

    public int getOverheadSpace() {
        return this.overheadSpaceAttribute;
    }

    public int getUsedSpace() {
        return this.usedSpaceAttribute;
    }

    public int getFreeSpace() {
        return this.freeSpaceAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox)})
    public BVector getSpaceRemote(Object obj, Context cxt) {
        BVector sizeVector = new BVector();
        Object object = this.sizeMonitor;
        synchronized (object) {
            sizeVector.add("freespace", (BValue)BInteger.make((int)this.freeSpaceAttribute));
            sizeVector.add("usedspace", (BValue)BInteger.make((int)this.usedSpaceAttribute));
            sizeVector.add("overheadspace", (BValue)BInteger.make((int)this.overheadSpaceAttribute));
        }
        return sizeVector;
    }

    public static void setChunkSize(int newChunkSize) {
        chunkSize = newChunkSize;
    }

    public static void setTotalChunks(int totalChunkSize) {
        totalChunks = totalChunkSize;
    }

    public void spy(SpyWriter out) throws Exception {
        this.spy(out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out, boolean spySuper) throws Exception {
        if (spySuper) {
            super.spy(out);
        }
        out.startProps("data recovery Block Manager " + this.getName() + " Sizes");
        Object object = this.sizeMonitor;
        synchronized (object) {
            out.prop((Object)"Current Status", (Object)this.getCurrentManagerStatus().encodeToString());
            out.prop((Object)"Maximum Capacity", this.getMaxCapacity());
            out.prop((Object)"Block Free Space", this.getFreeSpace());
            out.prop((Object)"Block Used Space", this.getUsedSpace());
            out.prop((Object)"Block Overhead Space", this.getOverheadSpace());
        }
        out.endProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<IDataRecoveryRecord> scanBlocksForSource(byte sourceByte) {
        LinkedList<IDataRecoveryRecord> currentEntries = new LinkedList<IDataRecoveryRecord>();
        Object object = this.blocksMonitor;
        synchronized (object) {
            this.blocks.stream().filter(block -> block instanceof UsedDataRecoveryBlock && block.getSpaceIdentifier() == sourceByte).forEach(block -> currentEntries.addLast(new DataRecoveryRecord(sourceByte, block.getKeyInSourceSpace(), block.getPayload())));
        }
        return currentEntries;
    }
}

