/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui.chart;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.baja.chart.BAxis;
import javax.baja.chart.BChart;
import javax.baja.chart.ChartModel;
import javax.baja.chart.Series;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BDouble;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="barWidthPercent", type="int", defaultValue="75"), @NiagaraProperty(name="pen", type="BPen", defaultValue="BPen.make(1)"), @NiagaraProperty(name="stroke", type="BBrush", defaultValue="BColor.black.toBrush()"), @NiagaraProperty(name="font", type="BFont", defaultValue="BFont.DEFAULT"), @NiagaraProperty(name="isAscOrder", type="boolean", defaultValue="false")})
public class BRankingChart
extends BChart {
    @Generated
    public static final Property barWidthPercent = BRankingChart.newProperty((int)0, (int)75, null);
    @Generated
    public static final Property pen = BRankingChart.newProperty((int)0, (BValue)BPen.make((double)1.0), null);
    @Generated
    public static final Property stroke = BRankingChart.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    @Generated
    public static final Property font = BRankingChart.newProperty((int)0, (BValue)BFont.DEFAULT, null);
    @Generated
    public static final Property isAscOrder = BRankingChart.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRankingChart.class);
    public final Comparator<Object> seriesComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            BINumeric number = BRankingChart.this.getFirstRecord((Series)o1);
            double oN = number.getNumeric();
            BINumeric number2 = BRankingChart.this.getFirstRecord((Series)o2);
            double oN2 = number2.getNumeric();
            if (Double.isNaN(oN2) && Double.isNaN(oN)) {
                return 0;
            }
            if (Double.isNaN(oN2)) {
                return -1;
            }
            if (Double.isNaN(oN)) {
                return 1;
            }
            if (BRankingChart.this.getIsAscOrder()) {
                return Double.compare(oN, oN2);
            }
            return Double.compare(oN2, oN);
        }
    };
    Series[] allSeries = null;
    private int rval = 2;
    private Array<BINumeric> array;
    private double maxVal;
    private double minVal;

    @Generated
    public int getBarWidthPercent() {
        return this.getInt(barWidthPercent);
    }

    @Generated
    public void setBarWidthPercent(int v) {
        this.setInt(barWidthPercent, v, null);
    }

    @Generated
    public BPen getPen() {
        return (BPen)this.get(pen);
    }

    @Generated
    public void setPen(BPen v) {
        this.set(pen, (BValue)v, null);
    }

    @Generated
    public BBrush getStroke() {
        return (BBrush)this.get(stroke);
    }

    @Generated
    public void setStroke(BBrush v) {
        this.set(stroke, (BValue)v, null);
    }

    @Generated
    public BFont getFont() {
        return (BFont)this.get(font);
    }

    @Generated
    public void setFont(BFont v) {
        this.set(font, (BValue)v, null);
    }

    @Generated
    public boolean getIsAscOrder() {
        return this.getBoolean(isAscOrder);
    }

    @Generated
    public void setIsAscOrder(boolean v) {
        this.setBoolean(isAscOrder, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRankingChart() {
    }

    public BRankingChart(ChartModel model) {
        super(model);
    }

    private BINumeric getFirstRecord(Series series) {
        if (series.getRowCount() == 0) {
            return BDouble.NaN;
        }
        Object val = series.getValue(0, 1);
        if (!(val instanceof BINumeric)) {
            return BDouble.NaN;
        }
        return (BINumeric)val;
    }

    public double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public boolean usesXAxis() {
        return false;
    }

    public void doLayout(BWidget[] kids) {
        ChartModel model = this.getModel();
        int specCount = model.getSpecCount();
        if (specCount == 0) {
            return;
        }
        if (this.allSeries == null || this.allSeries.length == 0) {
            this.allSeries = model.getAllSeries();
        }
        this.maxVal = Double.MIN_VALUE;
        this.minVal = Double.MAX_VALUE;
        List<Series> list = Arrays.asList(this.allSeries);
        Collections.sort(list, this.seriesComparator);
        this.allSeries = (Series[])list.toArray();
        if (this.allSeries.length == 1) {
            BINumeric number = (BINumeric)this.allSeries[0].getValue(0, 1);
            double d = number.getNumeric();
            this.maxVal = d = this.round(d, this.rval);
            this.minVal = d;
            double maxinc = this.maxVal * 0.04;
            double mindec = this.maxVal * 0.1;
            if (this.maxVal > 0.0) {
                this.maxVal += maxinc;
                this.minVal -= mindec;
            } else {
                this.maxVal -= maxinc;
                this.minVal += mindec;
            }
        } else {
            for (int i = 0; i < this.allSeries.length; ++i) {
                BINumeric number = (BINumeric)this.allSeries[i].getValue(0, 1);
                double d = number.getNumeric();
                if (Double.isNaN(d = this.round(d, this.rval))) continue;
                if (d > this.maxVal) {
                    this.maxVal = d;
                }
                if (!(d < this.minVal)) continue;
                this.minVal = d;
            }
            if (this.maxVal - this.minVal == 0.0) {
                double inc = Math.abs(this.maxVal) * 0.1;
                if (this.maxVal > 0.0) {
                    this.maxVal += inc;
                    this.minVal -= inc;
                } else {
                    this.maxVal -= inc;
                    this.minVal += inc;
                }
            } else {
                double inc = (this.maxVal - this.minVal) * 0.1;
                this.maxVal += inc;
                this.minVal -= inc;
            }
        }
        BAxis yaxis = model.getSpec(0).getYAxis();
        yaxis.setAxisMax((Object)BDouble.make((double)this.maxVal));
        yaxis.setAxisMin((Object)BDouble.make((double)this.minVal));
        yaxis.setShowSwatches(false);
        yaxis.setMaxAuto(false);
        yaxis.setMinAuto(false);
    }

    public void doPaint(Graphics g) {
        ChartModel model = this.getModel();
        int specCount = model.getSpecCount();
        if (specCount == 0) {
            return;
        }
        if (this.allSeries == null || this.allSeries.length == 0) {
            this.allSeries = model.getAllSeries();
        }
        int NaNC = 0;
        List<Series> list = Arrays.asList(this.allSeries);
        Collections.sort(list, this.seriesComparator);
        this.allSeries = (Series[])list.toArray();
        this.array = new Array(BINumeric.class);
        for (int i = 0; i < this.allSeries.length; ++i) {
            Series series = this.allSeries[i];
            BINumeric num = this.getFirstRecord(series);
            double d = num.getNumeric();
            if (!Double.isNaN(d)) {
                this.array.add((Object)num);
                continue;
            }
            ++NaNC;
        }
        int nob = this.array.size() - NaNC;
        double barSpace = this.getWidth() / (double)nob;
        double barWidth = barSpace * (double)this.getBarWidthPercent() * 0.01;
        double barPadding = (barSpace - barWidth) / 2.0;
        BAxis yaxis = model.getSpec(0).getYAxis();
        yaxis.setMaxAuto(false);
        yaxis.setMinAuto(false);
        double zeroLoc = 0.0;
        double maxLoc = 0.0;
        zeroLoc = yaxis.toDisplaySpace(yaxis.getAxisMin());
        maxLoc = yaxis.toDisplaySpace(yaxis.getAxisMax());
        double x = 0.0;
        for (int i = 0; i < nob; ++i) {
            x += barPadding;
            BINumeric numeric = (BINumeric)this.array.get(i);
            double val = numeric.getNumeric();
            if (Double.isNaN(val)) continue;
            val = this.round(val, this.rval);
            double nume = this.maxVal - val;
            double denom = this.maxVal - this.minVal;
            double percent = nume / denom;
            double y = (zeroLoc - maxLoc) * percent + maxLoc;
            g.setBrush(this.allSeries[i].getBrush());
            g.fillRect(x, y, barWidth, zeroLoc);
            g.setBrush(this.getStroke());
            g.strokeRect(x, y, barWidth, zeroLoc);
            String dataString = this.allSeries[i].getName() + ", " + numeric.toString(null);
            double labelWidth = this.getFont().width(dataString);
            double labelX = x + (barWidth - labelWidth) / 2.0;
            g.drawString(dataString, labelX, y - 2.0);
            x = x + barWidth + barPadding;
        }
    }
}

