/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui.chart;

import javax.baja.chart.BContinuousAxis;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.UnboundException;

@NiagaraType
public class BDaysAxis
extends BContinuousAxis {
    @Generated
    public static final Type TYPE = Sys.loadType(BDaysAxis.class);
    BAbsTime min = BAbsTime.DEFAULT;
    BAbsTime max = BAbsTime.DEFAULT;
    BAbsTime axisMin = this.min;
    BAbsTime axisMax = this.max;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDaysAxis() {
    }

    public int hashCode() {
        throw new UnboundException();
    }

    public BDaysAxis(Object min, Object max) {
        this.setAxisMin(min);
        this.setAxisMax(max);
    }

    public String getTitle() {
        return "Date";
    }

    public boolean getShowSwatches() {
        return false;
    }

    public double toPercentOfRange(Object value) {
        BAbsTime time = (BAbsTime)value;
        return (double)this.axisMin.delta(time).getMillis() / (double)this.axisMin.delta(this.axisMax).getMillis();
    }

    public Object fromPercentOfRange(double percent) {
        return BAbsTime.make((long)(this.axisMin.getMillis() + (long)((double)this.axisMin.delta(this.axisMax).getMillis() * percent)));
    }

    public Object getZero() {
        return BAbsTime.DEFAULT;
    }

    public Type getValueType() {
        return BAbsTime.TYPE;
    }

    public Object getAxisMin() {
        return this.axisMin;
    }

    public void setAxisMin(Object newMin) {
        this.min = (BAbsTime)newMin;
        this.axisMin = this.min.timeOfDay(1, 0, 0, 0);
    }

    public Object getAxisMax() {
        return this.axisMax;
    }

    public void setAxisMax(Object newMax) {
        this.max = (BAbsTime)newMax;
        this.axisMax = this.max.timeOfDay(0, 0, 0, 0).add(BRelTime.DAY).subtract(BRelTime.makeHours((int)1));
    }

    public Object[] getTickValues() {
        Array array = new Array(BAbsTime.class);
        long lastDay = this.max.timeOfDay(12, 0, 0, 0).getMillis();
        for (long firstDay = this.min.timeOfDay(12, 0, 0, 0).getMillis(); firstDay <= lastDay; firstDay += 86400000L) {
            array.add((Object)BAbsTime.make((long)firstDay));
        }
        return array.trim();
    }

    public String valueToString(Object value) {
        return ((BAbsTime)value).toDateString(null);
    }
}

