/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BAbsTimeFE;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridiumx.analytics.chart.ux.configuration.BAnalyticsChartBaselineDetails;
import com.tridiumx.analytics.report.ux.configuration.BBaselineTimeRangeEnum;
import com.tridiumx.analytics.util.Utils;
import com.tridiumx.analytics.ux.BAnalyticsBoundTable;
import com.tridiumx.analytics.ux.BAverageProfileUxChart;
import com.tridiumx.analytics.ux.BBaseC3UxChart;
import com.tridiumx.analytics.ux.BLoadDurationUxChart;
import java.util.Arrays;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.bajax.analytics.data.BAbsStartEndTime;
import javax.bajax.analytics.time.BAnalyticTimeRange;

@NiagaraType(agent={@AgentOn(types={"analytics:AnalyticsChartBaselineDetails"})})
@NiagaraActions(value={@NiagaraAction(name="feModified"), @NiagaraAction(name="startTimeModified")})
public class BBaselineCellValueEditor
extends BWbFieldEditor {
    @Generated
    public static final Action feModified = BBaselineCellValueEditor.newAction((int)0, null);
    @Generated
    public static final Action startTimeModified = BBaselineCellValueEditor.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBaselineCellValueEditor.class);
    private static BFacets timeFacets = BBaselineCellValueEditor.makeTimeFacets();
    private BGridPane baselinePane;
    private BBooleanFE enabledFE;
    private BFrozenEnumFE timeRangeFE;
    private BAbsTimeFE startTimeFE;
    private BAbsTimeFE endTimeFE;
    private BBooleanFE endTimeEnabledFE;
    private BBooleanFE alignDOWFE;
    private static final String[] BASELINE_ACCEPTED_TYPES = new String[]{BAverageProfileUxChart.TYPE.toString(), BBaseC3UxChart.TYPE.toString(), BLoadDurationUxChart.TYPE.toString(), BAnalyticsBoundTable.TYPE.toString()};
    private static final Lexicon lex = Lexicon.make(BBaselineCellValueEditor.class);

    @Generated
    public void feModified() {
        this.invoke(feModified, null, null);
    }

    @Generated
    public void startTimeModified() {
        this.invoke(startTimeModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    private void updateStartEndTime() {
        String chartTimeRange = ((BAnalyticsChartBaselineDetails)this.getCurrentValue()).getChartTimeRange();
        BAbsStartEndTime startEndTime = this.getStartEndTimes(BString.make((String)chartTimeRange));
        BAbsTime startTime = startEndTime.getStartTime().isBefore(BAbsTime.now()) ? startEndTime.getStartTime() : BAbsTime.now();
        BAbsTime endTime = startEndTime.getEndTime().isBefore(BAbsTime.now()) ? startEndTime.getEndTime() : BAbsTime.now();
        this.setBaselineTimeRange(startTime, endTime);
    }

    private void setBaselineTimeRange(BAbsTime startTime, BAbsTime endTime) {
        try {
            BAbsStartEndTime baselineStartEndTime;
            BAnalyticsChartBaselineDetails baselineDetails = this.saveAllValues();
            if (baselineDetails.getTimeRange().equals((Object)BBaselineTimeRangeEnum.previousWeek)) {
                baselineStartEndTime = Utils.evaluatePrevWeekRange((BAbsTime)startTime, (BAbsTime)endTime);
            } else if (baselineDetails.getTimeRange().equals((Object)BBaselineTimeRangeEnum.previousMonth)) {
                baselineStartEndTime = Utils.evaluatePrevMonthRange((BAbsTime)startTime, (BAbsTime)endTime, (boolean)baselineDetails.getAlignDOW());
            } else if (baselineDetails.getTimeRange().equals((Object)BBaselineTimeRangeEnum.previousYear)) {
                baselineStartEndTime = Utils.evaluatePrevYearRange((BAbsTime)startTime, (BAbsTime)endTime, (boolean)baselineDetails.getAlignDOW());
            } else {
                if (!baselineDetails.getEndTimeEnabled()) {
                    baselineStartEndTime = Utils.evaluateCustomRange((BAbsTime)startTime, (BAbsTime)endTime, (BAbsTime)baselineDetails.getStartTime());
                } else {
                    baselineStartEndTime = new BAbsStartEndTime();
                    baselineStartEndTime.setEndTime(baselineDetails.getEndTime());
                }
                baselineStartEndTime.setStartTime(baselineDetails.getStartTime());
            }
            baselineDetails.setStartTime(baselineStartEndTime.getStartTime());
            baselineDetails.setEndTime(baselineStartEndTime.getEndTime());
            this.loadBaselineDetails(baselineDetails);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BAnalyticsChartBaselineDetails saveAllValues() {
        BAnalyticsChartBaselineDetails baselineDetails = new BAnalyticsChartBaselineDetails();
        try {
            baselineDetails.setEnabled(((BBoolean)this.enabledFE.saveValue()).getBoolean());
            baselineDetails.setTimeRange((BBaselineTimeRangeEnum)this.timeRangeFE.saveValue());
            baselineDetails.setStartTime((BAbsTime)this.startTimeFE.saveValue());
            baselineDetails.setEndTime((BAbsTime)this.endTimeFE.saveValue());
            baselineDetails.setEndTimeEnabled(((BBoolean)this.endTimeEnabledFE.saveValue()).getBoolean());
            baselineDetails.setAlignDOW(((BBoolean)this.alignDOWFE.saveValue()).getBoolean());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baselineDetails;
    }

    public final BAbsStartEndTime getStartEndTimes(BString parameter) {
        BAnalyticTimeRange timeRange = BAnalyticTimeRange.make((String)SlotPath.unescape((String)parameter.getString()));
        BAbsStartEndTime startEndTime = new BAbsStartEndTime();
        startEndTime.setStartTime(BAbsTime.make((long)timeRange.getStart()));
        startEndTime.setEndTime(BAbsTime.make((long)timeRange.getEnd()));
        startEndTime.setFormat("D MMM YY HH:mm");
        long now = BAbsTime.now().getMillis();
        startEndTime.setCurrent(now);
        return startEndTime;
    }

    private void updateFlags() {
        try {
            BAnalyticsChartBaselineDetails baselineDetails = this.saveAllValues();
            if (baselineDetails.getTimeRange().equals((Object)BBaselineTimeRangeEnum.customPeriod)) {
                this.startTimeFE.setReadonly(false);
                this.endTimeFE.setReadonly(!baselineDetails.getEndTimeEnabled());
            } else {
                this.startTimeFE.setReadonly(true);
                this.endTimeFE.setReadonly(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BBaselineCellValueEditor() {
        this.makeWidgets();
    }

    private void makeWidgets() {
        this.baselinePane = new BGridPane(2);
        this.setContent((BWidget)this.baselinePane);
    }

    private void makeInputPane() {
        this.enabledFE = new BBooleanFE();
        LabelUtil.addLabelWidgetPair((BPane)this.baselinePane, (String)lex.get("baselineCellValueEditor.enabled"), (BWidget)this.enabledFE);
        this.timeRangeFE = new BFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)this.baselinePane, (String)lex.get("baselineCellValueEditor.timeRange"), (BWidget)this.timeRangeFE);
        this.startTimeFE = this.makeTimeFE();
        LabelUtil.addLabelWidgetPair((BPane)this.baselinePane, (String)lex.get("baselineCellValueEditor.startTime"), (BWidget)this.startTimeFE);
        this.endTimeFE = this.makeTimeFE();
        LabelUtil.addLabelWidgetPair((BPane)this.baselinePane, (String)lex.get("baselineCellValueEditor.endTime"), (BWidget)this.endTimeFE);
        this.endTimeEnabledFE = new BBooleanFE();
        LabelUtil.addLabelWidgetPair((BPane)this.baselinePane, (String)lex.get("baselineCellValueEditor.endTimeEnabled"), (BWidget)this.endTimeEnabledFE);
        this.alignDOWFE = new BBooleanFE();
        LabelUtil.addLabelWidgetPair((BPane)this.baselinePane, (String)lex.get("baselineCellValueEditor.alignDow"), (BWidget)this.alignDOWFE);
    }

    private void makeErrorPane() {
        this.baselinePane.setColumnCount(1);
        this.baselinePane.add(null, (BValue)new BLabel(lex.get("baselineCellValueEditor.featureNotSupported")));
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BAnalyticsChartBaselineDetails baselineDetails = (BAnalyticsChartBaselineDetails)value;
        if (Arrays.asList(BASELINE_ACCEPTED_TYPES).contains(baselineDetails.getChartType())) {
            this.makeInputPane();
            this.loadBaselineDetails(baselineDetails);
            this.link((BWbFieldEditor)this.enabledFE);
            this.link((BWbFieldEditor)this.timeRangeFE);
            this.link((BWbFieldEditor)this.startTimeFE);
            this.link((BWbFieldEditor)this.endTimeFE);
            this.link((BWbFieldEditor)this.endTimeEnabledFE);
            this.link((BWbFieldEditor)this.alignDOWFE);
            this.linkTo(null, (BComponent)this.timeRangeFE, (Slot)BFrozenEnumFE.setModified, (Slot)feModified);
            this.linkTo(null, (BComponent)this.endTimeEnabledFE, (Slot)BBooleanFE.setModified, (Slot)feModified);
            this.linkTo(null, (BComponent)this.alignDOWFE, (Slot)BBooleanFE.setModified, (Slot)feModified);
            this.linkTo(null, (BComponent)this.startTimeFE, (Slot)BAbsTimeFE.setModified, (Slot)startTimeModified);
            this.feModified();
        } else {
            this.makeErrorPane();
        }
    }

    public void doStartTimeModified() {
        BAbsStartEndTime baselineStartEndTime;
        BAbsTime endTime;
        BAnalyticsChartBaselineDetails baselineDetails = this.saveAllValues();
        String chartTimeRange = ((BAnalyticsChartBaselineDetails)this.getCurrentValue()).getChartTimeRange();
        BAbsStartEndTime startEndTime = this.getStartEndTimes(BString.make((String)chartTimeRange));
        BAbsTime startTime = startEndTime.getStartTime().isBefore(BAbsTime.now()) ? startEndTime.getStartTime() : BAbsTime.now();
        BAbsTime bAbsTime = endTime = startEndTime.getEndTime().isBefore(BAbsTime.now()) ? startEndTime.getEndTime() : BAbsTime.now();
        if (!baselineDetails.getEndTimeEnabled()) {
            baselineStartEndTime = Utils.evaluateCustomRange((BAbsTime)startTime, (BAbsTime)endTime, (BAbsTime)baselineDetails.getStartTime());
        } else {
            baselineStartEndTime = new BAbsStartEndTime();
            baselineStartEndTime.setEndTime(baselineDetails.getEndTime());
        }
        this.endTimeFE.loadValue((BObject)baselineStartEndTime.getEndTime(), (Context)timeFacets);
    }

    private void loadBaselineDetails(BAnalyticsChartBaselineDetails baselineDetails) {
        this.enabledFE.loadValue((BObject)BBoolean.make((boolean)baselineDetails.getEnabled()));
        this.timeRangeFE.loadValue((BObject)baselineDetails.getTimeRange());
        this.startTimeFE.loadValue((BObject)baselineDetails.getStartTime(), (Context)timeFacets);
        this.endTimeFE.loadValue((BObject)baselineDetails.getEndTime(), (Context)timeFacets);
        this.endTimeEnabledFE.loadValue((BObject)BBoolean.make((boolean)baselineDetails.getEndTimeEnabled()));
        this.alignDOWFE.loadValue((BObject)BBoolean.make((boolean)baselineDetails.getAlignDOW()));
    }

    private void link(BWbFieldEditor ed) {
        this.linkTo(null, (BComponent)ed, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)ed, (Slot)BWbPlugin.actionPerformed, (Slot)setModified);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        ((BAnalyticsChartBaselineDetails)value).setEnabled(((BBoolean)this.enabledFE.saveValue()).getBoolean());
        ((BAnalyticsChartBaselineDetails)value).setTimeRange((BBaselineTimeRangeEnum)this.timeRangeFE.saveValue());
        ((BAnalyticsChartBaselineDetails)value).setStartTime((BAbsTime)this.startTimeFE.saveValue());
        ((BAnalyticsChartBaselineDetails)value).setEndTime((BAbsTime)this.endTimeFE.saveValue());
        ((BAnalyticsChartBaselineDetails)value).setEndTimeEnabled(((BBoolean)this.endTimeEnabledFE.saveValue()).getBoolean());
        ((BAnalyticsChartBaselineDetails)value).setAlignDOW(((BBoolean)this.alignDOWFE.saveValue()).getBoolean());
        return value;
    }

    private static BFacets makeTimeFacets() {
        BFacets f = BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE);
        f = BFacets.make((BFacets)f, (String)"showTimeZone", (BIDataValue)BBoolean.FALSE);
        return f;
    }

    private BAbsTimeFE makeTimeFE() {
        BAbsTime t = Clock.time();
        BAbsTimeFE ret = (BAbsTimeFE)BWbFieldEditor.makeFor((BObject)t);
        ret.loadValue((BObject)t, (Context)timeFacets);
        return ret;
    }

    public void doFeModified() {
        this.updateStartEndTime();
        this.updateFlags();
    }
}

