/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.videoStream.decoder;

import com.tridium.videoDriver.BIVideoPlayer;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.ui.videoStream.decoder.VideoDecoder;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.decoder.IVideoMultistreamDecoder;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;

public abstract class VideoMultistreamDecoder
extends VideoDecoder
implements IVideoMultistreamDecoder {
    protected Hashtable<BOrd, CameraGroup> ordsToCameraGroup = new Hashtable();
    protected BIVideoDvr videoDvr;
    protected IVideoMultistreamDecoder.MultistreamFrame mostRecentMultistreamFrame;
    protected CameraGroup[] cameraGroups;
    protected ByteBuffer rawFrameUndecoded;

    public VideoMultistreamDecoder(BOrdList cameras, BIVideoDvr dvr) {
        if (log.isLoggable(Level.FINE)) {
            this.trace("VideoMultistreamDecoder() - constructor");
        }
        this.videoDvr = dvr;
        this.cameraGroups = this.groupCameraComponentsForSameFieldDevice(cameras, dvr);
    }

    protected abstract CameraGroup getCameraGroupForFrameData(ByteBuffer var1, IVideoDecoder var2);

    protected abstract boolean videoSourceBelongsInGroup(CameraGroup var1, BIVideoSource var2);

    public IVideoMultistreamDecoder.MultistreamFrame nextMultistreamFrame() {
        if (log.isLoggable(Level.FINE)) {
            this.trace("VideoMultistreamDecoder.nextMultistreamFrame");
        }
        return this.mostRecentMultistreamFrame;
    }

    @Override
    public IVideoMultistreamDecoder getMultistreamDecoder() {
        return this;
    }

    public IVideoDecoder getVideoDecoder(BOrd cameraOrd) {
        CameraGroup cameraGroup = this.ordsToCameraGroup.get(cameraOrd);
        if (cameraGroup == null) {
            for (int i = 0; i < this.cameraGroups.length && cameraGroup == null; ++i) {
                BOrdList cameraGroupOrds = this.cameraGroups[i].getOrdList();
                for (int j = 0; j < cameraGroupOrds.size() && cameraGroup == null; ++j) {
                    if (!cameraGroupOrds.get(j).equals((Object)cameraOrd)) continue;
                    cameraGroup = this.cameraGroups[i];
                    this.ordsToCameraGroup.put(cameraOrd, this.cameraGroups[i]);
                }
            }
        }
        if (cameraGroup == null) {
            return null;
        }
        return cameraGroup.videoDecoder;
    }

    @Override
    public void setMultistreamDecoder(IVideoMultistreamDecoder multistreamDecoder) {
        throw new RuntimeException("Unable to assign a multistream decoder to a multistream decoder. This was not expected to occur in the first place!");
    }

    @Override
    public void init(BIVideoSource videoSource, BIVideoPlayer videoPlayer, BRelTime stopDecodingTimeout, IVideoSession videoSession) {
        if (log.isLoggable(Level.FINE)) {
            this.trace("VideoMultistreamDecoder() - init");
        }
        super.init(videoSource, videoPlayer, stopDecodingTimeout, videoSession);
    }

    @Override
    public boolean isFinished() {
        if (log.isLoggable(Level.FINE)) {
            this.trace("VideoMultistreamDecoder() - isFinished");
        }
        try {
            if (super.isFinished()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.cameraGroups.length; ++i) {
            if (!this.cameraGroups[i].videoDecoder.isFinished()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void keepAlive() {
        try {
            super.keepAlive();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.cameraGroups.length; ++i) {
            try {
                this.cameraGroups[i].videoDecoder.keepAlive();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected VidFrame initVidFrame() {
        return new IVideoMultistreamDecoder.MultistreamFrame();
    }

    @Override
    public void readFrameData(VidFrame vf) throws Exception {
        IVideoMultistreamDecoder.MultistreamFrame mvFrame = (IVideoMultistreamDecoder.MultistreamFrame)vf;
        if (log.isLoggable(Level.FINE)) {
            this.trace("VideoMultistreamDecoder - readFrameData");
        }
        VideoDecoder rawFrameParser = this.getRawFrameParser();
        rawFrameParser.readFrameData((VidFrame)mvFrame);
    }

    @Override
    public void decodeFrame(VidFrame vf) throws Exception {
        BOrdList cameraComponentsForFrame;
        IVideoMultistreamDecoder.MultistreamFrame mvFrame = (IVideoMultistreamDecoder.MultistreamFrame)vf;
        VideoDecoder rawFrameParser = this.getRawFrameParser();
        if (log.isLoggable(Level.FINE)) {
            this.trace("VideoMultistreamDecoder - decodeFrame");
        }
        CameraGroup rawFrameCameraGroup = this.getCameraGroupForFrameData(mvFrame.rawData, rawFrameParser);
        VideoDecoder decoderForCameraGroup = (VideoDecoder)rawFrameCameraGroup.getVideoDecoder();
        decoderForCameraGroup.decodeFrame((VidFrame)mvFrame);
        if (log.isLoggable(Level.FINE) && (cameraComponentsForFrame = rawFrameCameraGroup.getOrdList()) != null) {
            this.trace("Decoded frame for cameras: " + cameraComponentsForFrame.toString());
        }
        mvFrame.videoCameras = rawFrameCameraGroup.getOrdList();
    }

    private VideoDecoder getRawFrameParser() {
        return (VideoDecoder)this.cameraGroups[0].videoDecoder;
    }

    @Override
    public void stopDecoding(WaitForStopDecoding monitor) {
        if (log.isLoggable(Level.FINE)) {
            this.trace("VideoMultistreamDecoder() - stopDecoding");
        }
        for (int i = 0; i < this.cameraGroups.length; ++i) {
            try {
                this.cameraGroups[i].videoDecoder.stopDecoding(monitor);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            super.stopDecoding(monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void receiveVideoStream(IVideoStream videoStream) {
        if (log.isLoggable(Level.FINE)) {
            this.trace("VideoMultistreamDecoder() - receiveVideoStream");
        }
        this.videoStream = videoStream;
        for (int i = 0; i < this.cameraGroups.length; ++i) {
            try {
                IVideoDecoder videoDecoder = this.cameraGroups[i].getVideoDecoder();
                videoDecoder.init(this.videoSource, null, this.stopDecodingTimeout, this.videoSession);
                videoDecoder.receiveVideoStream(videoStream);
                videoDecoder.setMultistreamDecoder((IVideoMultistreamDecoder)this);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            super.receiveVideoStream(videoStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void videoStreamTimeout() {
        if (log.isLoggable(Level.FINE)) {
            this.trace("VideoMultistreamDecoder() - videoStreamTimeout");
        }
        for (int i = 0; i < this.cameraGroups.length; ++i) {
            try {
                this.cameraGroups[i].videoDecoder.videoStreamTimeout();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            super.videoStreamTimeout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected CameraGroup[] getCameraGroups() {
        return this.cameraGroups;
    }

    public ByteBuffer getRawMultistreamFrame() {
        return this.rawFrameUndecoded;
    }

    public static BIVideoSource[] resolveAllVideoSourceOrds(BOrdList videoSourceOrds, BObject dvr) {
        Array videoSourceArray = new Array(BIVideoSource.class);
        for (int i = 0; i < videoSourceOrds.size(); ++i) {
            BOrd nextCamera = videoSourceOrds.get(i);
            try {
                videoSourceArray.add((Object)((BIVideoSource)nextCamera.get(dvr)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BIVideoSource[] videoSources = (BIVideoSource[])videoSourceArray.trim();
        return videoSources;
    }

    public CameraGroup[] groupCameraComponentsForSameFieldDevice(BOrdList videoSourceOrds, BIVideoDvr dvr) {
        if (log.isLoggable(Level.FINE)) {
            this.trace("VideoMultistreamDecoder() - groupCameraComponentsForSameFieldDevice");
        }
        if (dvr instanceof BObject) {
            BIVideoSource[] videoSourceCameras = VideoMultistreamDecoder.resolveAllVideoSourceOrds(videoSourceOrds, (BObject)dvr);
            Array cameraGroupsArray = new Array(CameraGroup.class);
            for (int i = 0; i < videoSourceCameras.length; ++i) {
                CameraGroup cameraGroup = null;
                ListIterator cameraGroupsSoFar = cameraGroupsArray.iterator();
                while (cameraGroupsSoFar.hasNext() && cameraGroup == null) {
                    CameraGroup existingGroup = (CameraGroup)cameraGroupsSoFar.next();
                    if (!this.videoSourceBelongsInGroup(existingGroup, videoSourceCameras[i])) continue;
                    cameraGroup = existingGroup;
                }
                if (cameraGroup == null) {
                    cameraGroup = new CameraGroup(this.videoDvr, this);
                    cameraGroupsArray.add((Object)cameraGroup);
                }
                cameraGroup.addCamera(videoSourceCameras[i]);
            }
            return (CameraGroup[])cameraGroupsArray.trim();
        }
        throw new IllegalArgumentException("The given 'dvr' must be an instance of BObject.");
    }

    public class CameraGroup {
        public VideoMultistreamDecoder videoMultistreamDecoder;
        public IVideoDecoder videoDecoder;
        public BIVideoDvr videoDvr;
        public Array<BOrd> cameraOrds = new Array(BOrd.class);
        public BOrdList cameraOrdList;

        public CameraGroup(BIVideoDvr videoDvr, VideoMultistreamDecoder videoMultistreamDecoder) {
            this.videoDvr = videoDvr;
            this.videoMultistreamDecoder = videoMultistreamDecoder;
        }

        public void addCamera(BIVideoSource videoSourceCamera) {
            this.cameraOrds.add((Object)videoSourceCamera.getSlotPathOrd());
        }

        public BOrdList getOrdList() {
            if (this.cameraOrdList == null) {
                this.cameraOrdList = BOrdList.make((BOrd[])((BOrd[])this.cameraOrds.trim()));
            }
            return this.cameraOrdList;
        }

        public BObject getVideoSourceObject(int ordListPosition) {
            BOrd sampleVideoCamera = this.getOrdList().get(ordListPosition);
            if (sampleVideoCamera == null || sampleVideoCamera.isNull()) {
                throw new IllegalStateException("Unsupported: Sample video camera is null or NULL!");
            }
            BObject videoDvrObject = (BObject)this.videoDvr;
            BObject videoCameraObject = sampleVideoCamera.get(videoDvrObject);
            if (VideoDecoder.log.isLoggable(Level.FINE)) {
                VideoMultistreamDecoder.this.trace("CameraGroup -- getVideoSourceObject - returning = " + ((BComponent)videoCameraObject).getDisplayName(null));
            }
            return videoCameraObject;
        }

        private IVideoDecoder makeDecoder() {
            if (VideoDecoder.log.isLoggable(Level.FINE)) {
                VideoMultistreamDecoder.this.trace("CameraGroup - makeDecoder");
            }
            BIVideoSource vidSource = (BIVideoSource)this.getVideoSourceObject(0);
            return vidSource.makeVideoDecoder(this.videoMultistreamDecoder.videoStream.getPlaybackParams());
        }

        private IVideoDecoder getVideoDecoder() {
            if (this.videoDecoder == null) {
                this.videoDecoder = this.makeDecoder();
            }
            return this.videoDecoder;
        }
    }
}

