/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.videoStream.decoder;

import com.tridium.videoDriver.ui.videoStream.decoder.VideoDecoder;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.decoder.HttpMultipartMimeHelper;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PushbackInputStream;
import javax.baja.gx.BImage;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.ByteBuffer;

public class GenericMjpegDecoder
extends VideoDecoder {
    public static final int MARKER_JPEG_COMMENT = 254;
    public static final int MARKER_STATE_NOT_IN_JPEG_MARKER = 0;
    public static final int MARKER_STATE_READ_JPEG_MARKER_SIZE_MSB = 1;
    public static final int MARKER_STATE_READ_JPEG_MARKER_SIZE_LSB = 2;
    public static final int MARKER_STATE_READ_JPEG_MARKER_HEADER = 3;
    protected MjpegByteBuffer mjpegByteBuffer = new MjpegByteBuffer();
    protected int positionInBuffer = 1;
    protected byte[] buffer = new byte[40960];

    @Override
    protected InputStream makeInputStreamForDecoder(IVideoStream videoStream) {
        return new PushbackInputStream(videoStream.getInputStream(), 2);
    }

    @Override
    protected void frameStarting() throws IOException {
    }

    @Override
    public void readFrameData(VidFrame vf) throws Exception {
        this.readUntilStartOfJpeg(vf);
        this.readJpegImageToBuffer(vf);
        int bufferLength = this.positionInBuffer + 1;
        this.mjpegByteBuffer.reset();
        this.mjpegByteBuffer.setBuffer(this.buffer);
        this.mjpegByteBuffer.setLength(bufferLength);
        vf.rawData = this.mjpegByteBuffer;
    }

    @Override
    public void decodeFrame(VidFrame vf) {
        vf.image = BImage.make((byte[])vf.rawData.getBytes());
    }

    protected void readUntilStartOfJpeg(VidFrame vf) throws IOException {
        if (this.isMultiPartMime()) {
            this.readUntilStartOfJpeg_mimeMultipart();
        } else {
            this.readUntilStartOfJpeg_driverSpecific(vf);
        }
    }

    protected void readUntilStartOfJpeg_driverSpecific(VidFrame vf) throws IOException {
        PushbackInputStream videoIn = (PushbackInputStream)this.videoIn;
        if (videoIn != null) {
            videoIn.read(this.buffer, 0, 2);
            int positionInBuffer = 1;
            while (true) {
                int nextByte;
                boolean isLastByte0xd8;
                int secondToLastByte = this.buffer[positionInBuffer - 1] & 0xFF;
                int lastByte = this.buffer[positionInBuffer] & 0xFF;
                boolean isSecondToLastByte0xff = secondToLastByte == 255;
                boolean bl = isLastByte0xd8 = lastByte == 216;
                if (isSecondToLastByte0xff && isLastByte0xd8) break;
                if (++positionInBuffer >= this.buffer.length) {
                    byte[] newBuffer = new byte[this.buffer.length * 2];
                    ByteArrayUtil.copy((byte[])this.buffer, (byte[])newBuffer);
                    this.buffer = newBuffer;
                }
                if ((nextByte = videoIn.read()) < 0) {
                    throw new EOFException();
                }
                this.buffer[positionInBuffer] = (byte)nextByte;
            }
            videoIn.unread(this.buffer, positionInBuffer - 1, 2);
        }
    }

    protected void readUntilStartOfJpeg_mimeMultipart() throws IOException {
        InputStream videoIn = this.videoIn;
        if (videoIn != null) {
            HttpMultipartMimeHelper h = new HttpMultipartMimeHelper(videoIn, this.getHttpPushBoundary());
            if (h.getStatusLine() == null) {
                throw new IllegalStateException("Expected mime, multi-part header with an HTTP status code but did find one.");
            }
            int httpStatusCode = h.getStatusLine().getStatusCode();
            if (httpStatusCode == 200) {
                return;
            }
            if (httpStatusCode == 100) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    throw new InterruptedIOException();
                }
                this.readUntilStartOfJpeg_mimeMultipart();
            } else {
                throw new IOException("Expected StatusCode of 200. Received " + h.getStatusLine().getStatusCode());
            }
        }
    }

    protected void readJpegImageToBuffer(VidFrame vf) throws IOException {
        InputStream videoIn = this.videoIn;
        if (videoIn != null) {
            int markerState = 0;
            int markerSizeCounter = 0;
            int markerSize = 0;
            int markerLsb = 0;
            if (this.buffer.length < 2) {
                this.buffer = new byte[40960];
            }
            videoIn.read(this.buffer, 0, 2);
            this.positionInBuffer = 1;
            while (true) {
                int nextByte;
                boolean isLastByte0xd9;
                int secondToLastByte = this.buffer[this.positionInBuffer - 1] & 0xFF;
                int lastByte = this.buffer[this.positionInBuffer] & 0xFF;
                boolean isSecondToLastByte0xff = secondToLastByte == 255;
                boolean bl = isLastByte0xd9 = lastByte == 217;
                if (isSecondToLastByte0xff && isLastByte0xd9 && markerState == 0) break;
                if (markerState == 0 && isSecondToLastByte0xff && lastByte != 0 && lastByte != 255 && lastByte != 216) {
                    markerLsb = lastByte;
                    markerState = 1;
                }
                ++this.positionInBuffer;
                if (this.positionInBuffer >= this.buffer.length) {
                    byte[] newBuffer = new byte[this.buffer.length * 2];
                    ByteArrayUtil.copy((byte[])this.buffer, (byte[])newBuffer);
                    this.buffer = newBuffer;
                }
                if ((nextByte = videoIn.read()) < 0) {
                    throw new EOFException();
                }
                this.buffer[this.positionInBuffer] = (byte)nextByte;
                if (markerState == 1) {
                    markerSize = (nextByte & 0xFF) << 8;
                    markerState = 2;
                    continue;
                }
                if (markerState == 2) {
                    markerSizeCounter = markerSize |= nextByte & 0xFF;
                    markerState = 3;
                    continue;
                }
                if (markerState != 3 || --markerSizeCounter != 0) continue;
                this.processMarker(vf, markerLsb, this.buffer, this.positionInBuffer - markerSize + 1, markerSize - 2);
                markerState = 0;
            }
        }
    }

    protected void processMarker(VidFrame vf, int markerLsb, byte[] buffer, int from, int len) {
        if (markerLsb == 254) {
            this.processJpegComment(vf, buffer, from, len);
        }
    }

    protected void processJpegComment(VidFrame vf, byte[] buffer, int from, int len) {
    }

    public class MjpegByteBuffer
    extends ByteBuffer {
        public void setLength(int newLen) {
            this.length = newLen;
        }

        public void setBuffer(byte[] newBuf) {
            this.buffer = newBuf;
        }
    }
}

