/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.playback;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.control.BIVideoFocusControl;
import com.tridium.videoDriver.camera.control.BIVideoIrisControl;
import com.tridium.videoDriver.camera.control.BIVideoPanTiltControl;
import com.tridium.videoDriver.camera.control.BIVideoPlaybackIndividualControls;
import com.tridium.videoDriver.camera.control.BIVideoStorePresetControl;
import com.tridium.videoDriver.camera.control.BIVideoZoomControl;
import com.tridium.videoDriver.camera.control.BPlaybackControlInfo;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BPlaybackSpeedEnum;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BIVideoEventProvider;
import com.tridium.videoDriver.event.BRetrieveActionParam;
import com.tridium.videoDriver.event.BRetrieveTopicEvent;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.camera.BVideoCameraPickerFE;
import com.tridium.videoDriver.ui.camera.BVideoEventChooser;
import com.tridium.videoDriver.ui.camera.BVideoLayerPane;
import com.tridium.videoDriver.ui.camera.BVideoPanTiltJoystick;
import com.tridium.videoDriver.ui.camera.BVideoPtzDialogPane;
import com.tridium.videoDriver.ui.camera.BVideoZoomSlider;
import com.tridium.videoDriver.ui.playback.BPlaybackButton;
import com.tridium.videoDriver.ui.playback.BVideoOverlayLabel;
import com.tridium.videoDriver.ui.playback.BVideoPlaybackCenterPane;
import com.tridium.videoDriver.ui.playback.PlaybackGroup;
import com.tridium.videoDriver.ui.videoStream.BVideoStreamBinding;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoPlayback;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoSource;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="zoom", parameterType="BVideoZoomEnum", defaultValue="BVideoZoomEnum.none"), @NiagaraAction(name="move", parameterType="BVideoPanTiltEnum", defaultValue="BVideoPanTiltEnum.none"), @NiagaraAction(name="adjustIrisAction", parameterType="BVideoIrisEnum", defaultValue="BVideoIrisEnum.none"), @NiagaraAction(name="adjustFocusAction", parameterType="BVideoFocusEnum", defaultValue="BVideoFocusEnum.none")})
@NiagaraTopics(value={@NiagaraTopic(name="adjustIris", eventType="BVideoIrisEnum"), @NiagaraTopic(name="adjustFocus", eventType="BVideoFocusEnum"), @NiagaraTopic(name="adjustZoom", eventType="BVideoZoomEnum")})
public class BVideoPlayback
extends BWbComponentView
implements IVideoPlayback,
BVideoEventChooser.EventPlayback {
    @Generated
    public static final Action zoom = BVideoPlayback.newAction((int)0, (BValue)BVideoZoomEnum.none, null);
    @Generated
    public static final Action move = BVideoPlayback.newAction((int)0, (BValue)BVideoPanTiltEnum.none, null);
    @Generated
    public static final Action adjustIrisAction = BVideoPlayback.newAction((int)0, (BValue)BVideoIrisEnum.none, null);
    @Generated
    public static final Action adjustFocusAction = BVideoPlayback.newAction((int)0, (BValue)BVideoFocusEnum.none, null);
    @Generated
    public static final Topic adjustIris = BVideoPlayback.newTopic((int)0, null);
    @Generated
    public static final Topic adjustFocus = BVideoPlayback.newTopic((int)0, null);
    @Generated
    public static final Topic adjustZoom = BVideoPlayback.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoPlayback.class);
    boolean initialized = false;
    public static final Lexicon LEX = Lexicon.make(BVideoPlayback.class);
    public static double TOP_TOOL_PADDING = 2.0;
    public static final String REFRESH_IMAGE_MSG = LEX.get("videoPlaybackControls.refreshEvents..", "");
    public static final BImage REFRESH_IMAGE_ICON;
    protected BVideoEventChooser videoEventChooser;
    protected Command browseEventsCmd = new Command((BWidget)this, LEX, "VideoEventChooser"){

        public CommandArtifact doInvoke() throws Exception {
            BVideoPlayback.this.doBrowseEvents();
            return null;
        }
    };
    protected Command playFromTimeIndexCmd = new Command((BWidget)this, LEX, "VideoPlaybackView.PlayFromTimeIndex"){

        public CommandArtifact doInvoke() throws Exception {
            BVideoPlayback.this.doPlayFromTimeIndex();
            return null;
        }
    };
    protected ToggleCommand playCmd;
    protected ToggleCommand pauseCmd;
    protected ToggleCommand rwdCmd;
    protected ToggleCommand ffwdCmd;
    protected ToggleCommand srwdCmd;
    protected ToggleCommand sfwdCmd;
    protected ToggleCommand liveCmd;
    protected BPlaybackButton playButton;
    protected BPlaybackButton pauseButton;
    protected BPlaybackButton rwdButton;
    protected BPlaybackButton ffwdButton;
    protected BPlaybackButton srwdButton;
    protected BPlaybackButton sfwdButton;
    protected BPlaybackButton liveButton;
    protected ToggleCommand mostRecentValidSelection = this.liveCmd;
    protected PlaybackGroup group;
    protected BLabel currentEventInfo;
    protected BPane currentEventInfoPane;
    protected BIVideoCamera videoCamera;
    protected BVideoPlaybackCenterPane videoPlayerPane;
    protected BVideoZoomSlider videoZoomSlider;
    protected BVideoPanTiltJoystick videoPanTiltJoystick;
    protected BEdgePane viewPane;
    protected BLabel loadingLabel;
    BPane browseEvent;
    protected BVideoLayerPane centerLayerPane;
    BEdgePane cameraPickerTop;
    protected BEdgePane centerEdgePane;
    protected BVideoPlayer videoPlayer;
    protected BPane presetIrisFocusPane;
    protected BBorderPane bottomPane;
    protected boolean viewLoaded = false;
    protected BVideoStreamBinding videoStreamBinding;
    protected String startPlayingEventText;
    protected BAbsTime startPlayingEventTimeStamp;
    protected boolean shouldBeLive = true;
    protected BVideoCameraPickerFE cameraPicker;
    protected BEdgePane cameraPickerPane;
    protected String cachedVideoCameraDescription = "";
    protected BIVideoDvr cachedDvr;
    protected boolean hasSuccessfullyTriedToCache = false;
    public static final Logger log;
    protected static Comparator<BVideoEvent> B_ABS_TIME_COMPARATOR_DESCENDING;
    private static final BIcon icon;
    static boolean hasOperatorInvoke;
    static boolean hasAdminInvoke;
    static boolean isMoveOperatorFlag;
    static boolean isZoomOperatorFlag;

    @Generated
    public void zoom(BVideoZoomEnum parameter) {
        this.invoke(zoom, (BValue)parameter, null);
    }

    @Generated
    public void move(BVideoPanTiltEnum parameter) {
        this.invoke(move, (BValue)parameter, null);
    }

    @Generated
    public void adjustIrisAction(BVideoIrisEnum parameter) {
        this.invoke(adjustIrisAction, (BValue)parameter, null);
    }

    @Generated
    public void adjustFocusAction(BVideoFocusEnum parameter) {
        this.invoke(adjustFocusAction, (BValue)parameter, null);
    }

    @Generated
    public void fireAdjustIris(BVideoIrisEnum event) {
        this.fire(adjustIris, (BValue)event, null);
    }

    @Generated
    public void fireAdjustFocus(BVideoFocusEnum event) {
        this.fire(adjustFocus, (BValue)event, null);
    }

    @Generated
    public void fireAdjustZoom(BVideoZoomEnum event) {
        this.fire(adjustZoom, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BVideoPlayback() {
    }

    public BVideoPlayback(BVideoCameraPickerFE cameraPicker, BEdgePane cameraPickerPane) {
        this.cameraPicker = cameraPicker;
        this.cameraPickerPane = cameraPickerPane;
    }

    public BVideoPlayback(String startPlayingEventText, BAbsTime startPlayingEventTimestamp, boolean shouldBeLive) {
        this.startPlayingEventText = startPlayingEventText;
        this.startPlayingEventTimeStamp = startPlayingEventTimestamp;
        this.shouldBeLive = shouldBeLive;
    }

    public BToolBar getViewToolBar() {
        BToolBar toolbar = new BToolBar();
        toolbar.add("frwd", (Command)this.rwdCmd);
        toolbar.add("ffwd", (Command)this.ffwdCmd);
        toolbar.add("srwd", (Command)this.srwdCmd);
        toolbar.add("sfwd", (Command)this.sfwdCmd);
        toolbar.add("play", (Command)this.playCmd);
        toolbar.add("pause", (Command)this.pauseCmd);
        toolbar.add("live", (Command)this.liveCmd);
        toolbar.add("browseEvents", this.browseEventsCmd);
        toolbar.add("playFromTimeIndex", this.playFromTimeIndexCmd);
        return toolbar;
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Do load value " + (value != null ? ((BComplex)value).getName() : "null"));
        }
        super.doLoadValue(value, context);
        this.hasSuccessfullyTriedToCache = false;
        if (value != null) {
            this.videoCamera = BVideoPlayback.getVideoSource((BIVideoCamera)value);
        }
        this.drawView();
        if (this.videoCamera != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Attempting to hook up the view.");
            }
            this.loadViewAsync();
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (event.getId() == 0 && event.getSourceComponent() instanceof BIVideoStorePresetControl && this.presetIrisFocusPane != null && this.presetIrisFocusPane.getParent() != null) {
            BPane p = this.drawIrisFocusPresetPane();
            this.presetIrisFocusPane.getParent().set(this.presetIrisFocusPane.getPropertyInParent(), (BValue)p);
            this.presetIrisFocusPane = p;
        }
        if (event.getSourceComponent() instanceof BVideoEventRecall && event.getId() == 5) {
            BRetrieveActionParam retrieveAction;
            BValue eventDataValue;
            if (event.getSlot().equals((Object)BVideoEventRecall.retrieveOk)) {
                BRetrieveTopicEvent retrieveOkEvent;
                eventDataValue = event.getValue();
                if (eventDataValue instanceof BRetrieveTopicEvent && (retrieveOkEvent = (BRetrieveTopicEvent)eventDataValue).getRetrieveParam().getClientSessionId().equals(BFoxVideoSource.getFoxWorkbenchRemoteSessionId((BObject)this.getCurrentValue()))) {
                    BVideoEvent[] videoEvents = retrieveOkEvent.getEventsArray();
                    if (this.videoEventChooser != null) {
                        this.videoEventChooser.updateEventList(videoEvents);
                        this.videoPlayerPane.getStatusOverlayBottom().getMessage1().setText(REFRESH_IMAGE_MSG);
                        this.videoPlayerPane.getStatusOverlayBottom().getMessage1().setImage(REFRESH_IMAGE_ICON);
                        this.videoPlayerPane.getStatusOverlayBottom().getMessage2().setText(REFRESH_IMAGE_MSG);
                        this.videoPlayerPane.getStatusOverlayBottom().getMessage2().setImage(REFRESH_IMAGE_ICON);
                        this.videoPlayerPane.getStatusOverlayBottom().clearSoon();
                    }
                }
            } else if (event.getSlot().equals((Object)BVideoEventRecall.retrieveFailed) && (eventDataValue = event.getValue()) instanceof BRetrieveActionParam && (retrieveAction = (BRetrieveActionParam)eventDataValue).getClientSessionId().equals(BFoxVideoSource.getFoxWorkbenchRemoteSessionId((BObject)this.getCurrentValue())) && this.videoEventChooser != null) {
                this.videoEventChooser.updateEventListFailed(retrieveAction.getFaultCause().format(null));
                this.videoPlayerPane.getStatusOverlayBottom().getMessage1().setText(REFRESH_IMAGE_MSG);
                this.videoPlayerPane.getStatusOverlayBottom().getMessage1().setImage(REFRESH_IMAGE_ICON);
                this.videoPlayerPane.getStatusOverlayBottom().getMessage1().setText("");
                this.videoPlayerPane.getStatusOverlayBottom().getMessage1().setImage(BImage.make((BIcon)BIcon.std((String)"job/failed.png")));
                this.videoPlayerPane.getStatusOverlayBottom().clearSoon();
            }
        }
    }

    @Override
    public void retrieveDriverEvents(BAbsTime epicenter, int numEvents) {
        if (this.videoCamera instanceof BIVideoEventProvider) {
            BIVideoEventProvider eventProvider = (BIVideoEventProvider)this.videoCamera;
            BVideoEventRecall eventRecall = eventProvider.getEventRecaller();
            if (eventRecall instanceof BComponent) {
                this.registerForComponentEvents((BComponent)eventRecall);
            }
            BRetrieveActionParam retrieveActionParam = new BRetrieveActionParam();
            retrieveActionParam.setTimeIndex(epicenter);
            retrieveActionParam.setNumEvents(numEvents);
            retrieveActionParam.setClientSessionId(BFoxVideoSource.getFoxWorkbenchRemoteSessionId((BObject)this.getCurrentValue()));
            eventRecall.retrieveEvents(retrieveActionParam);
        }
    }

    @Override
    public void playEvent(BVideoEvent videoEvent) {
        this.playFromTimeIndex(videoEvent.toString(null), videoEvent.getTimestamp());
    }

    public void overrideCurrentInfoMessage(String msg) {
        if (this.currentEventInfo != null) {
            this.currentEventInfo.setText(msg);
        }
    }

    public void playFromTimeIndex(String eventText, BAbsTime timeStamp) {
        this.currentEventInfo.setText(eventText);
        BPlaybackControlInfo playbackEvent = new BPlaybackControlInfo(BPlaybackTypeEnum.play, BPlaybackSpeedEnum.x1, timeStamp);
        this.controlPlayback(playbackEvent);
        this.mostRecentValidSelection = this.playCmd;
        this.playButton.invokeAction();
    }

    @Deprecated
    public void updateControls() {
        if (this.videoCamera instanceof BIVideoPlaybackIndividualControls) {
            BIVideoPlaybackIndividualControls controlledDevice = (BIVideoPlaybackIndividualControls)this.videoCamera;
            if (!controlledDevice.isFastForwardEnabled()) {
                this.ffwdButton.setEnabled(false);
            }
            if (!controlledDevice.isSlowForwardEnabled()) {
                this.sfwdButton.setEnabled(false);
            }
            if (!controlledDevice.isFastRewindEnabled()) {
                this.rwdButton.setEnabled(false);
            }
            if (!controlledDevice.isSlowRewindEnabled()) {
                this.srwdButton.setEnabled(false);
            }
            if (!controlledDevice.isPauseEnabled()) {
                this.pauseButton.setEnabled(false);
            }
        }
    }

    public void drawView() {
        if (!this.initialized) {
            this.initView();
        }
        if (this.videoCamera != null) {
            this.fillView();
        }
    }

    private void initView() {
        this.initialized = true;
        this.viewPane = new BEdgePane();
        this.currentEventInfoPane = this.drawCurrentEventInfoPane();
        this.setViewPaneTop((BWidget)this.currentEventInfoPane);
        BPane centerPane = this.drawCenter();
        this.viewPane.setCenter((BWidget)centerPane);
        this.bottomPane = this.drawBottom();
        this.viewPane.setBottom((BWidget)this.bottomPane);
        BVideoLayerPane layerPane = new BVideoLayerPane();
        layerPane.add("viewPane", (BValue)this.viewPane);
        BEdgePane loadingPane = new BEdgePane();
        this.loadingLabel = new BLabel(BImage.make((String)LEX.getText("VideoMultistreamViewer.Loading.Icon")), LEX.getText("VideoMultistreamViewer.Loading.Label"));
        this.loadingLabel.setFont(Theme.label().getLargeBoldFont());
        loadingPane.setCenter((BWidget)this.loadingLabel);
        layerPane.add("loadingPane", (BValue)loadingPane);
        this.setContent((BWidget)layerPane);
    }

    private void fillView() {
        if (this.videoCamera instanceof BIVideoSource) {
            BVideoAspectRatioEnum aspectRatio;
            BIVideoSource videoSource = (BIVideoSource)this.videoCamera;
            BColor backgroundColor = (BColor)videoSource.getPreferredBackgroundColor();
            if (backgroundColor != null) {
                this.videoPlayer.setBackgroundColor((BColor)videoSource.getPreferredBackgroundColor());
            }
            if ((aspectRatio = videoSource.getPreferredAspectRatio()) != null) {
                this.videoPlayer.setAspectRatio(videoSource.getPreferredAspectRatio());
            }
            if (!videoSource.supportsPlaybackControl()) {
                this.hideButtons(this.bottomPane.getContent());
            }
        }
        BUserService svc = (BUserService)BOrd.make((String)"service:baja:UserService").get((BObject)((BComponent)this.videoCamera));
        svc.lease();
        Context context = null;
        try {
            BISession session = BOrd.toSession((BObject)((BComponent)this.videoCamera));
            if (session != null) {
                context = session.getSessionContext();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String strLoggedUserName = ((BString)context.getFacet("username")).getString();
        BUser loggedUser = (BUser)svc.get(strLoggedUserName);
        loggedUser.lease();
        BPermissions userPermissions = loggedUser.getPermissions(context);
        hasOperatorInvoke = userPermissions.hasOperatorInvoke();
        hasAdminInvoke = userPermissions.hasAdminInvoke();
        BComponent cameraComp = (BComponent)this.videoCamera;
        isMoveOperatorFlag = (cameraComp.getFlags(cameraComp.getSlot("move")) & 0x100) != 0;
        isZoomOperatorFlag = (cameraComp.getFlags(cameraComp.getSlot("zoom")) & 0x100) != 0;
        this.videoPanTiltJoystick.setVisible(this.isPanTiltAvailable());
        this.videoZoomSlider.setVisible(this.isZoomAvailable());
        this.browseEvent.setVisible(this.videoCamera instanceof BIVideoEventProvider);
        this.presetIrisFocusPane = this.drawIrisFocusPresetPane();
    }

    protected BPane drawCenter() {
        this.centerEdgePane = new BEdgePane();
        this.videoPlayerPane = new BVideoPlaybackCenterPane();
        this.videoPlayer = this.videoPlayerPane.getVideoPlayer();
        this.centerLayerPane = new BVideoLayerPane();
        this.centerLayerPane.add("videoPlayer", (BValue)this.videoPlayerPane);
        this.videoPanTiltJoystick = new BVideoPanTiltJoystick();
        this.centerLayerPane.add("panTiltJoystick", (BValue)this.videoPanTiltJoystick);
        this.videoZoomSlider = new BVideoZoomSlider();
        this.centerEdgePane.setRight((BWidget)this.videoZoomSlider);
        this.centerEdgePane.setCenter((BWidget)this.centerLayerPane);
        BBorderPane p = new BBorderPane((BWidget)this.centerEdgePane, BBorder.inset);
        p.setPadding(BInsets.make((double)0.0));
        return p;
    }

    private BPane drawCurrentEventInfoPane() {
        this.currentEventInfo = new BLabel("");
        BButton dummyButtonForSizingPurposes = new BButton(BImage.make((BIcon)BIcon.std((String)"moveDown.png")));
        dummyButtonForSizingPurposes.setButtonStyle(BButtonStyle.toolBar);
        dummyButtonForSizingPurposes.computePreferredSize();
        BConstrainedPane dummyConstrainedPaneForSizingPurposes = new BConstrainedPane();
        dummyConstrainedPaneForSizingPurposes.setMinSize(dummyButtonForSizingPurposes.getPreferredWidth(), dummyButtonForSizingPurposes.getPreferredHeight());
        BEdgePane currentEventInfoEdgePane = new BEdgePane();
        currentEventInfoEdgePane.setRight((BWidget)dummyConstrainedPaneForSizingPurposes);
        currentEventInfoEdgePane.setCenter((BWidget)this.currentEventInfo);
        return new BBorderPane((BWidget)currentEventInfoEdgePane, BBorder.inset, BInsets.make((double)TOP_TOOL_PADDING));
    }

    private BPane drawIrisFocusPresetPane() {
        BPane presetPane = BVideoPtzDialogPane.makePresetsPane((BWidget)this, this.videoCamera, false);
        BPane irisFocusPresetPane = BVideoPtzDialogPane.makeIrisFocusButtonPane((BWidget)this, (BWidget)presetPane, this.videoCamera, adjustIris, adjustFocus, false);
        if (irisFocusPresetPane == null) {
            this.currentEventInfo.setText("");
            return this.currentEventInfoPane;
        }
        return irisFocusPresetPane;
    }

    private BBorderPane drawBottom() {
        BGridPane doublePane = new BGridPane(2);
        this.browseEvent = this.drawBrowseEventPane();
        doublePane.add("playbackControlButtons", (BValue)this.drawPlaybackControlButtons());
        doublePane.add("browseEventPane", (BValue)this.browseEvent);
        BBorderPane p = new BBorderPane((BWidget)doublePane, BBorder.none);
        p.setPadding(BInsets.make((double)6.0));
        return p;
    }

    private BPane drawBrowseEventPane() {
        BFlowPane fp = new BFlowPane();
        fp.add(null, (BValue)new BButton(this.browseEventsCmd));
        fp.add(null, (BValue)new BButton(this.playFromTimeIndexCmd));
        this.browseEventsCmd.setEnabled(false);
        this.playFromTimeIndexCmd.setEnabled(false);
        return fp;
    }

    private BPane drawPlaybackControlButtons() {
        BGridPane playbackControlButtons = new BGridPane(12);
        this.playCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.play");
        this.pauseCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.pause");
        this.rwdCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.rwd");
        this.ffwdCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.ffwd");
        this.srwdCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.srwd");
        this.sfwdCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.sfwd");
        this.liveCmd = new ToggleCommand((BWidget)this, LEX, "videoPlaybackControls.live");
        this.playButton = new BPlaybackButton((Command)this.playCmd);
        this.pauseButton = new BPlaybackButton((Command)this.pauseCmd);
        this.rwdButton = new BPlaybackButton((Command)this.rwdCmd);
        this.ffwdButton = new BPlaybackButton((Command)this.ffwdCmd);
        this.srwdButton = new BPlaybackButton((Command)this.srwdCmd);
        this.sfwdButton = new BPlaybackButton((Command)this.sfwdCmd);
        this.liveButton = new BPlaybackButton((Command)this.liveCmd);
        playbackControlButtons.add("empty1", (BValue)new BNullWidget());
        playbackControlButtons.add("rwdButton", (BValue)this.rwdButton);
        playbackControlButtons.add("ffwdButton", (BValue)this.ffwdButton);
        playbackControlButtons.add("empty2", (BValue)new BNullWidget());
        playbackControlButtons.add("swdButton", (BValue)this.srwdButton);
        playbackControlButtons.add("sfwdButton", (BValue)this.sfwdButton);
        playbackControlButtons.add("empty3", (BValue)new BNullWidget());
        playbackControlButtons.add("playButton", (BValue)this.playButton);
        playbackControlButtons.add("pauseButton", (BValue)this.pauseButton);
        playbackControlButtons.add("empty4", (BValue)new BNullWidget());
        playbackControlButtons.add("liveButton", (BValue)this.liveButton);
        this.group = new PlaybackGroup(this);
        this.group.add(this.liveCmd);
        this.group.add(this.rwdCmd);
        this.group.add(this.ffwdCmd);
        this.group.add(this.srwdCmd);
        this.group.add(this.sfwdCmd);
        this.group.add(this.playCmd);
        this.group.add(this.pauseCmd);
        if (this.videoCamera instanceof BIVideoPlaybackIndividualControls) {
            BIVideoPlaybackIndividualControls controlledDevice = (BIVideoPlaybackIndividualControls)this.videoCamera;
            this.ffwdButton.setEnabled(controlledDevice.isFastForwardEnabled());
            this.sfwdButton.setEnabled(controlledDevice.isSlowForwardEnabled());
            this.rwdButton.setEnabled(controlledDevice.isFastRewindEnabled());
            this.srwdButton.setEnabled(controlledDevice.isSlowRewindEnabled());
            this.pauseButton.setEnabled(controlledDevice.isPauseEnabled());
        }
        if (this.videoCamera == null) {
            this.rwdCmd.setEnabled(false);
            this.ffwdCmd.setEnabled(false);
            this.liveCmd.setEnabled(false);
            this.srwdCmd.setEnabled(false);
            this.sfwdCmd.setEnabled(false);
            this.playCmd.setEnabled(false);
            this.pauseCmd.setEnabled(false);
        }
        return playbackControlButtons;
    }

    private void setViewPaneTop(BWidget top) {
        if (this.cameraPickerPane == null) {
            this.viewPane.setTop(top);
        } else {
            this.cameraPickerPane.setCenter(top);
        }
    }

    private void displayLoading(boolean d) {
        block2: {
            try {
                this.loadingLabel.setVisible(d);
                ((BWidget)this.loadingLabel.getParent()).setVisible(d);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block2;
                log.log(Level.FINE, "VideoPlayback.UpdateView - Exception calling displayLoading().", e);
            }
        }
    }

    private void hideButtons(BWidget bottomWidget) {
        if (!(bottomWidget instanceof BConstrainedPane)) {
            BConstrainedPane emptyBottom = new BConstrainedPane();
            emptyBottom.setMinSize(BSize.make((double)bottomWidget.getWidth(), (double)bottomWidget.getHeight()));
            emptyBottom.setMaxSize(BSize.make((double)bottomWidget.getWidth(), (double)bottomWidget.getHeight()));
            this.bottomPane.setContent((BWidget)emptyBottom);
        }
    }

    private void loadViewAsync() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("loadViewAsync");
        }
        new Thread("VideoPlayback.UpdateView"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("VideoPlayback.UpdateView - Thread running.");
                }
                BVideoPlayback.this.viewLoaded = false;
                if (!BVideoPlayback.this.isRunning()) {
                    BVideoPlayback.this.start();
                }
                while (BVideoPlayback.this.isRunning() && !BVideoPlayback.this.viewLoaded) {
                    long startOfWhileLoopTicks = Clock.ticks();
                    try {
                        BVideoPlayback.this.displayLoading(true);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Attempting to hook up the view.");
                        }
                        BVideoPlayback.this.tryLoadViewAsync();
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("View is loaded.");
                        }
                        BVideoPlayback.this.displayLoading(false);
                        BVideoPlayback.this.viewLoaded = true;
                    }
                    catch (UnresolvedException ue) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Unable to resolve video camera at this time");
                        }
                        BVideoPlayback.this.viewLoaded = false;
                        try {
                            long nowTicks = Clock.ticks();
                            long elapsedTimeUntilException = nowTicks - startOfWhileLoopTicks;
                            if (elapsedTimeUntilException >= 15000L) continue;
                            long sleepTime = 16000L - elapsedTimeUntilException;
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Seep for " + sleepTime + " millis and retry");
                            }
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException ie) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("LiveVideo.UpdateView - Thread Interrupted");
                            }
                            return;
                        }
                    }
                    finally {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("LiveVideo.UpdateView - Thread finished");
                    }
                }
            }
        }.start();
    }

    private void tryLoadViewAsync() {
        block5: {
            try {
                if (this.videoCamera != null) {
                    if (this.shouldBeLive) {
                        this.liveCmd.setSelected(true);
                        this.changePlaybackAllowed(this.liveCmd, BPlaybackTypeEnum.live, BPlaybackSpeedEnum.x1, false);
                    } else {
                        this.playFromTimeIndex(this.startPlayingEventText, this.startPlayingEventTimeStamp);
                    }
                    this.hookWidgetsToDriver();
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block5;
                log.log(Level.FINE, "VideoPlayback.UpdateView - Exception calling tryLoadViewAsync().", e);
            }
        }
    }

    protected void changePlaybackControlDenied() {
        BVideoOverlayLabel message1 = this.videoPlayerPane.getStatusOverlayTop().getMessage1();
        BImage icon = this.mostRecentValidSelection.getIcon();
        if (icon == null) {
            icon = BImage.NULL;
        }
        message1.setImage(icon);
        String label = this.mostRecentValidSelection.getLabel();
        if (label == null) {
            label = "";
        }
        message1.setText(label);
        BVideoOverlayLabel message2 = this.videoPlayerPane.getStatusOverlayTop().getMessage2();
        message2.setText("");
        message2.setImage(BImage.make((BIcon)BIcon.std((String)"job/failed.png")));
        this.mostRecentValidSelection.setSelected(true);
        this.videoPlayerPane.getStatusOverlayTop().clearSoon();
    }

    protected void enableWidgetRecursive(BWidget w, boolean enabled) {
        w.setEnabled(enabled);
        BWidget[] children = w.getChildWidgets();
        for (int i = 0; i < children.length; ++i) {
            this.enableWidgetRecursive(children[i], enabled);
        }
    }

    public void changePlayback(BPlaybackParams playbackParams) {
        ToggleCommand toggleCommand = null;
        BPlaybackButton playbackButton = null;
        switch (playbackParams.getPlaybackType().getOrdinal()) {
            case 0: {
                toggleCommand = this.liveCmd;
                playbackButton = this.liveButton;
                break;
            }
            case 1: {
                toggleCommand = this.playCmd;
                playbackButton = this.liveButton;
                break;
            }
            case 2: {
                toggleCommand = this.ffwdCmd;
                playbackButton = this.ffwdButton;
                break;
            }
            case 3: {
                toggleCommand = this.sfwdCmd;
                playbackButton = this.sfwdButton;
                break;
            }
            case 4: {
                toggleCommand = this.rwdCmd;
                playbackButton = this.rwdButton;
                break;
            }
            case 5: {
                toggleCommand = this.srwdCmd;
                playbackButton = this.srwdButton;
                break;
            }
            case 6: {
                toggleCommand = this.pauseCmd;
                playbackButton = this.pauseButton;
                break;
            }
        }
        if (toggleCommand.isEnabled()) {
            if (toggleCommand.isSelected()) {
                this.changePlaybackAllowed(toggleCommand, playbackParams.getPlaybackType(), playbackParams.getPlaybackSpeed(), true);
            } else {
                toggleCommand.setSelected(true);
                playbackButton.setSelected(true);
                playbackButton.invokeAction();
            }
        }
    }

    protected void controlPlayback(BPlaybackControlInfo playbackControlInfo) {
        this.videoPlayer.changePlaybackControl(playbackControlInfo);
    }

    private void updateUiForNewPlayback(BPlaybackTypeEnum newPlaybackTypeEnum) {
        block8: {
            if (newPlaybackTypeEnum == BPlaybackTypeEnum.live) {
                this.setViewPaneTop((BWidget)this.presetIrisFocusPane);
                this.enableWidgetRecursive(this.viewPane.getTop(), true);
                this.videoPanTiltJoystick.setEnabled(true);
                this.videoZoomSlider.setEnabled(true);
                this.playCmd.setEnabled(false);
                this.ffwdCmd.setEnabled(false);
                this.sfwdCmd.setEnabled(false);
                this.rwdCmd.setEnabled(true);
                this.srwdCmd.setEnabled(true);
                this.pauseCmd.setEnabled(true);
                try {
                    String cameraDescription;
                    BIVideoDvr dvr;
                    if (this.hasSuccessfullyTriedToCache) {
                        dvr = this.cachedDvr;
                        cameraDescription = this.cachedVideoCameraDescription;
                    } else {
                        dvr = this.cachedDvr = this.videoCamera.getDvr();
                        cameraDescription = this.videoCamera.getCameraDescription();
                        this.hasSuccessfullyTriedToCache = true;
                    }
                    if (dvr == null) {
                        this.currentEventInfo.setText(LEX.getText("LiveVideo.status.standAloneCamera", new Object[]{cameraDescription}));
                        break block8;
                    }
                    this.currentEventInfo.setText(LEX.getText("LiveVideo.status.dvrCamera", new Object[]{dvr.getDvrDescription(), cameraDescription}));
                }
                catch (UnresolvedException ue) {
                    System.out.println("BVideoPlayback - switch to live - remote station offline - don't forget to implement some code for this");
                }
            } else {
                if (newPlaybackTypeEnum != BPlaybackTypeEnum.play) {
                    this.currentEventInfo.setText("");
                }
                this.setViewPaneTop((BWidget)this.currentEventInfoPane);
                this.enableWidgetRecursive(this.viewPane.getTop(), false);
                this.videoPanTiltJoystick.setEnabled(false);
                this.videoZoomSlider.setEnabled(false);
                this.playCmd.setEnabled(true);
                this.ffwdCmd.setEnabled(true);
                this.sfwdCmd.setEnabled(true);
                this.rwdCmd.setEnabled(true);
                this.srwdCmd.setEnabled(true);
                this.pauseCmd.setEnabled(true);
            }
        }
        this.browseEventsCmd.setEnabled(true);
        this.playFromTimeIndexCmd.setEnabled(true);
        this.liveCmd.setEnabled(true);
        this.centerEdgePane.relayout();
        this.centerEdgePane.repaint();
    }

    protected void changePlaybackAllowed(ToggleCommand selectedCmd, BPlaybackTypeEnum newPlaybackTypeEnum, BPlaybackSpeedEnum speed, boolean force) {
        this.updateUiForNewPlayback(newPlaybackTypeEnum);
        BVideoOverlayLabel message1 = this.videoPlayerPane.getStatusOverlayTop().getMessage1();
        BVideoOverlayLabel message2 = this.videoPlayerPane.getStatusOverlayTop().getMessage2();
        BImage icon = selectedCmd.getIcon();
        if (icon == null) {
            icon = BImage.NULL;
        }
        message1.setImage(icon);
        message2.setImage(icon);
        String label = selectedCmd.getLabel();
        if (label == null) {
            label = "";
        }
        message1.setText(label);
        message2.setText(label);
        if (newPlaybackTypeEnum != BPlaybackTypeEnum.play && newPlaybackTypeEnum == this.videoPlayer.getPlaybackParams().getPlaybackType()) {
            BVideoOverlayLabel message3 = this.videoPlayerPane.getStatusOverlayBottom().getMessage1();
            BVideoOverlayLabel message4 = this.videoPlayerPane.getStatusOverlayBottom().getMessage2();
            message3.setText(speed.getDisplayTag(null));
            message4.setText(speed.getDisplayTag(null));
            this.videoPlayerPane.getStatusOverlayBottom().clearSoon();
        }
        if (force || newPlaybackTypeEnum != BPlaybackTypeEnum.play || this.mostRecentValidSelection != this.playCmd) {
            BPlaybackControlInfo ci = new BPlaybackControlInfo(newPlaybackTypeEnum, speed, this.videoPlayer.getPlaybackParams().getTimeIndex());
            this.controlPlayback(ci);
        }
        this.mostRecentValidSelection = selectedCmd;
        if (newPlaybackTypeEnum != BPlaybackTypeEnum.pause) {
            this.videoPlayerPane.getStatusOverlayTop().clearSoon();
        }
    }

    private void hookWidgetsToDriver() {
        this.hookVideoPlayerToDriver();
        if (this.isZoomAvailable()) {
            this.hookZoomSliderToDriver();
        }
        if (this.isPanTiltAvailable()) {
            this.hookPanTiltJoystickToDriver();
        }
        if (BVideoPtzDialogPane.isIrisFocusOrBothAvailable(this.videoCamera)) {
            this.hookIrisFocusControlsToDriver();
        }
    }

    private void hookIrisFocusControlsToDriver() {
        this.linkTo((BComponent)this, (Slot)adjustFocus, (Slot)adjustFocusAction);
        this.linkTo((BComponent)this, (Slot)adjustIris, (Slot)adjustIrisAction);
    }

    public void doAdjustIrisAction(BVideoIrisEnum irisEnum) {
        if (this.videoCamera instanceof BIVideoIrisControl) {
            ((BIVideoIrisControl)this.videoCamera).irisControl(irisEnum);
        }
    }

    public void doAdjustFocusAction(BVideoFocusEnum focusEnum) {
        if (this.videoCamera instanceof BIVideoFocusControl) {
            ((BIVideoFocusControl)this.videoCamera).focusControl(focusEnum);
        }
    }

    private void hookZoomSliderToDriver() {
        this.linkTo((BComponent)this.videoZoomSlider, (Slot)BVideoZoomSlider.zoom, (Slot)zoom);
    }

    public void doZoom(BVideoZoomEnum zoomEnum) {
        if (this.videoCamera instanceof BIVideoZoomControl) {
            ((BIVideoZoomControl)this.videoCamera).zoom(zoomEnum);
        }
    }

    private void hookPanTiltJoystickToDriver() {
        this.linkTo((BComponent)this.videoPanTiltJoystick, (Slot)BVideoPanTiltJoystick.move, (Slot)move);
    }

    public void doMove(BVideoPanTiltEnum panTiltEnum) {
        if (this.videoCamera instanceof BIVideoPanTiltControl) {
            ((BIVideoPanTiltControl)this.videoCamera).move(panTiltEnum);
        }
    }

    private boolean isPanTiltAvailable() {
        try {
            return this.videoCamera instanceof BIVideoPanTiltControl && ((BIVideoPanTiltControl)this.videoCamera).isPanTiltEnabled() && (hasAdminInvoke || isMoveOperatorFlag && hasOperatorInvoke);
        }
        catch (UnresolvedException ue) {
            return false;
        }
    }

    private boolean isZoomAvailable() {
        try {
            return this.videoCamera instanceof BIVideoZoomControl && ((BIVideoZoomControl)this.videoCamera).isZoomEnabled() && (hasAdminInvoke || isZoomOperatorFlag && hasOperatorInvoke);
        }
        catch (UnresolvedException ue) {
            return false;
        }
    }

    private void configureVideoPlayerSettings() {
        if (this.videoCamera instanceof BIVideoSource) {
            this.videoPlayer.setCompression(((BIVideoSource)this.videoCamera).getPreferredCompression());
            this.videoPlayer.setFrameRate(((BIVideoSource)this.videoCamera).getPreferredFrameRate());
            this.videoPlayer.setResolution(((BIVideoSource)this.videoCamera).getPreferredResolution());
            this.videoPlayer.setShowTimeIndex(((BIVideoSource)this.videoCamera).isTimestampPreferred());
            this.videoPlayer.setAspectRatio(((BIVideoSource)this.videoCamera).getPreferredAspectRatio());
            this.videoPlayer.setBackgroundColor((BColor)((BIVideoSource)this.videoCamera).getPreferredBackgroundColor());
            if (((BIVideoSource)this.videoCamera).isFoxVideoStreamPreferred()) {
                this.videoPlayer.setVideoStreamFox(BFoxVideoStreamEnum.yes);
            } else {
                this.videoPlayer.setVideoStreamFox(BFoxVideoStreamEnum.no);
            }
        } else {
            log.warning("The video camera does not implement BIVideoSource!");
        }
    }

    private void hookVideoPlayerToDriver() {
        BOrd videoCameraStationOrd = null;
        if (this.videoCamera != null && this.videoCamera instanceof BComponent) {
            BComponent videoCameraComponent = (BComponent)this.videoCamera;
            videoCameraStationOrd = BOrd.make((String)("station:|" + videoCameraComponent.getSlotPathOrd()));
        }
        if (this.videoCamera != null && this.videoCamera instanceof BIVideoSource && videoCameraStationOrd != null) {
            this.configureVideoPlayerSettings();
            if (this.videoStreamBinding != null) {
                this.videoStreamBinding.stop();
            }
            this.videoStreamBinding = new BVideoStreamBinding(this);
            this.videoStreamBinding.setOrd(videoCameraStationOrd);
            if (this.videoPlayer.get("cameraBinding") == null) {
                this.videoPlayer.add("cameraBinding", (BValue)this.videoStreamBinding);
            } else {
                this.videoPlayer.set("cameraBinding", (BValue)this.videoStreamBinding);
            }
        }
    }

    protected void doBrowseEvents() {
        if (this.videoEventChooser == null && this.videoCamera instanceof BIVideoEventProvider) {
            BVideoEventRecall driverEventRecallComponent = ((BIVideoEventProvider)this.videoCamera).getEventRecaller();
            this.videoEventChooser = new BVideoEventChooser((BWidget)this, driverEventRecallComponent, this);
            this.videoEventChooser.setBoundsCenteredOnOwner();
        }
        this.retrieveDriverEvents(BAbsTime.now(), -20);
        this.videoEventChooser.open();
    }

    protected void doPlayFromTimeIndex() {
        BAbsTime playFrom;
        BAbsTime timeIndex;
        try {
            timeIndex = this.videoPlayer.getPlaybackParams().getTimeIndex();
        }
        catch (Exception e) {
            timeIndex = BAbsTime.now();
        }
        timeIndex = timeIndex.toLocalTime();
        try {
            playFrom = (BAbsTime)BWbFieldEditor.dialog((BWidget)this, (String)LEX.getText("VideoPlaybackView.PlayFromTimeIndex.title"), (BObject)timeIndex, (Context)BVideoEvent.EVENT_TIME_STAMP_TO_STRING_FACETS);
        }
        catch (Exception e) {
            playFrom = BAbsTime.NULL;
        }
        if (playFrom != null && !playFrom.isNull()) {
            this.playFromTimeIndex(LEX.getText("VideoPlaybackView.PlayFromTimeIndex.StatusText", new Object[]{playFrom.toString((Context)BVideoEvent.EVENT_TIME_STAMP_TO_STRING_FACETS)}), playFrom);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public static BIVideoCamera getVideoSource(BIVideoCamera videoSource) {
        if (videoSource instanceof BIRemoteVideoCamera) {
            try {
                BIRemoteVideoCamera remoteCamera = (BIRemoteVideoCamera)videoSource;
                return (BIVideoCamera)remoteCamera.getRemoteVideoOrd().get((BObject)videoSource);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        if (videoSource instanceof BIVideoCamera) {
            return videoSource;
        }
        throw new BajaRuntimeException("uknown source:" + videoSource.getType());
    }

    static {
        String localizedRefreshImageIconPath = LEX.get("videoPlaybackControls.refreshEvents.label", null);
        REFRESH_IMAGE_ICON = localizedRefreshImageIconPath == null ? BImage.NULL : BImage.make((BIcon)BIcon.make((String)LEX.getText("videoPlaybackControls.refreshEvents.label")));
        log = Logger.getLogger("videoDriver.videoPlaybackView");
        B_ABS_TIME_COMPARATOR_DESCENDING = new Comparator<BVideoEvent>(){

            @Override
            public int compare(BVideoEvent arg0, BVideoEvent arg1) {
                return -1 * arg0.getTimestamp().compareTo((Object)arg1.getTimestamp());
            }
        };
        icon = BIcon.std((String)"animate.png");
        hasOperatorInvoke = false;
        hasAdminInvoke = false;
        isMoveOperatorFlag = false;
        isZoomOperatorFlag = false;
    }
}

