/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.display;

import com.tridium.videoDriver.BIVideoDeviceSystem;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.display.BIVideoDisplayDeviceExt;
import com.tridium.videoDriver.display.BVideoDisplayChooser;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"videoDriver:VideoDisplayChooser"})})
public class BVideoDisplayChooserFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoDisplayChooserFE.class);
    BTextDropDown field = new BTextDropDown("", 20, false);
    Item[] items;
    public static final Lexicon LEX = Lexicon.make(BVideoDisplayChooser.class);
    public static final String CANNOT_MAKE_CAMERA_ACTIVE_BECAUSE_NO_DISPLAYS = "CannotMakeCameraActiveBecauseNoDisplays";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BVideoDisplayChooserFE() {
        this.setContent((BWidget)this.field);
        this.linkTo("la", (BComponent)this.field, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lb", (BComponent)this.field, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.field.getEditor().setEditable(false);
        this.field.setDropDownEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BVideoDisplayChooser videoDisplayChooser = (BVideoDisplayChooser)value;
        BOrd videoDisplayOrd = videoDisplayChooser.getVideoDisplayOrd();
        BOrd videoSystemOrd = videoDisplayChooser.getVideoSystemOrd();
        if (videoSystemOrd.isNull()) {
            return;
        }
        BComponent videoSystem = (BComponent)videoSystemOrd.get();
        BObject videoDisplay = null;
        try {
            videoDisplay = videoDisplayOrd.get();
        }
        catch (Exception e) {
            videoDisplay = null;
        }
        if (videoDisplay != null && videoDisplay instanceof BIVideoDisplay) {
            this.loadDisplay(videoDisplayChooser, (BIVideoDisplay)videoDisplay, videoSystem);
        } else {
            this.loadDisplay(videoDisplayChooser, null, videoSystem);
        }
    }

    public static String getDropDownText(BIVideoDisplay videoDisplay) {
        String displayDeviceExtSlotPathAsString;
        SlotPath videoDisplaySlotPath = videoDisplay.getSlotPath();
        SlotPath displayDeviceExtSlotPath = videoDisplay.getDisplayDeviceExt().getSlotPath();
        String videoDisplaySlotPathAsString = videoDisplaySlotPath.toDisplayString();
        if (videoDisplaySlotPathAsString.startsWith(displayDeviceExtSlotPathAsString = displayDeviceExtSlotPath.toDisplayString())) {
            return videoDisplaySlotPathAsString.substring(displayDeviceExtSlotPathAsString.length());
        }
        throw new IllegalStateException("Video display slot path does not begin with display ext slotpath. " + videoDisplay);
    }

    public void loadDisplay(BVideoDisplayChooser videoDisplayChooser, BIVideoDisplay display, BComponent videoSystemAsComponent) {
        String displayText = null;
        if (display != null) {
            displayText = BVideoDisplayChooserFE.getDropDownText(display);
            this.field.setText(displayText);
        }
        this.field.getList().removeAllItems();
        this.items = null;
        Object[] displays = this.listDisplays(videoSystemAsComponent);
        try {
            Array a = new Array(displays);
            a = a.filter(new IFilter(){

                public boolean accept(Object obj) {
                    BIVideoDisplay v = (BIVideoDisplay)obj;
                    if (v instanceof BComplex) {
                        BComplex parent = ((BComplex)v).getParent();
                        return parent == null || !Flags.isHidden((BComplex)parent, (Slot)((BComplex)v).getPropertyInParent());
                    }
                    return false;
                }
            });
            displays = (BIVideoDisplay[])a.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (displays.length > 0) {
            this.items = new Item[displays.length];
            Item match = null;
            for (int i = 0; i < this.items.length; ++i) {
                Item item = this.items[i] = new Item((BIVideoDisplay)displays[i]);
                if (display != null && item.displayText.equals(displayText)) {
                    match = item;
                }
                this.field.getList().addItem(item.icon, (Object)item);
            }
            if (match != null) {
                this.field.setText(match.displayText);
            } else {
                this.field.setText(this.items[0].displayText);
            }
            videoDisplayChooser.setVideoDisplayOrd(this.items[0].videoDisplayOrd);
        } else {
            this.setContent((BWidget)new BLabel(LEX.getText(CANNOT_MAKE_CAMERA_ACTIVE_BECAUSE_NO_DISPLAYS)));
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        return this.saveDisplay((BVideoDisplayChooser)value);
    }

    public BVideoDisplayChooser saveDisplay(BVideoDisplayChooser retVal) {
        String displayText = this.field.getText();
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                if (!this.items[i].displayText.equals(displayText)) continue;
                retVal.setVideoDisplayOrd(this.items[i].videoDisplayOrd);
                break;
            }
        }
        return retVal;
    }

    protected BIVideoDisplay[] listDisplays(BComponent videoSystemComponent) {
        BIVideoDeviceSystem videoSystem = (BIVideoDeviceSystem)videoSystemComponent;
        videoSystemComponent.loadSlots();
        BIVideoDisplayDeviceExt displayDeviceExt = videoSystem.getDisplayExt();
        if (displayDeviceExt instanceof BComponent) {
            ((BComponent)displayDeviceExt).loadSlots();
        }
        return displayDeviceExt.getAllDisplays();
    }

    static class Item {
        BOrd videoDisplayOrd;
        String displayText;
        BImage icon;

        Item(BIVideoDisplay videoDisplay) {
            this.displayText = BVideoDisplayChooserFE.getDropDownText(videoDisplay);
            this.videoDisplayOrd = ((BComponent)videoDisplay).getSlotPathOrd();
            this.icon = BImage.make((BIcon)((BComponent)videoDisplay).getIcon());
        }

        public String toString() {
            return this.displayText;
        }
    }
}

