/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.Binder;
import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.camera.BVideoCameraWidgetDialog;
import com.tridium.videoDriver.ui.camera.BVideoLayerPane;
import com.tridium.videoDriver.ui.camera.BVideoPtzBinding;
import com.tridium.videoDriver.ui.camera.BVideoPtzCameraWidgetBinding;
import com.tridium.videoDriver.ui.camera.BVideoPtzDialogPane;
import com.tridium.videoDriver.ui.playback.BLiveVideo;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.BSize;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLayout;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.units.BUnit;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.view.BWbView;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="cameraRectangleFill", type="BBrush", defaultValue="DEFAULT_CAMERA_RECTANGLE_BRUSH"), @NiagaraProperty(name="cameraRectangleFillMouseOver", type="BBrush", defaultValue="DEFAULT_CAMERA_RECTANGLE_BRUSH_MOUSE_OVER"), @NiagaraProperty(name="cameraTriangleFill", type="BBrush", defaultValue="DEFAULT_CAMERA_TRIANGLE_BRUSH"), @NiagaraProperty(name="cameraTriangleFillMouseOver", type="BBrush", defaultValue="DEFAULT_CAMERA_TRIANGLE_BRUSH_MOUSE_OVER"), @NiagaraProperty(name="cameraOutline", type="BPen", defaultValue="BPen.DEFAULT"), @NiagaraProperty(name="zoomBackground", type="BBrush", defaultValue="Theme.scrollBar().getControlBackground()"), @NiagaraProperty(name="ptzDialogSize", type="BSize", defaultValue="BSize.make(0,0)"), @NiagaraProperty(name="ptzBorder", type="BBorder", defaultValue="BBorder.inset"), @NiagaraProperty(name="panTiltKeepDownInterval", type="BRelTime", defaultValue="BRelTime.make(1000)", facets={@Facet(value="BFacets.make(BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE), BFacets.make(BFacets.MIN, BRelTime.make(100)))")}), @NiagaraProperty(name="zoomKeepDownInterval", type="BRelTime", defaultValue="BRelTime.make(1000)", facets={@Facet(value="BFacets.make(BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE), BFacets.make(BFacets.MIN, BRelTime.make(100)))")}), @NiagaraProperty(name="showActionsMenu", type="boolean", defaultValue="false"), @NiagaraProperty(name="refreshRate", type="int", defaultValue="50", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(25), BFacets.MAX, BInteger.make(1000), BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="resolution", type="BVideoResolutionEnum", defaultValue="BVideoResolutionEnum.low"), @NiagaraProperty(name="frameRate", type="BVideoFrameRateEnum", defaultValue="BVideoFrameRateEnum.low"), @NiagaraProperty(name="compression", type="BVideoCompressionEnum", defaultValue="BVideoCompressionEnum.medium"), @NiagaraProperty(name="streamFacets", type="BFacets", defaultValue="BFacets.DEFAULT"), @NiagaraProperty(name="videoStreamFox", type="BFoxVideoStreamEnum", defaultValue="BFoxVideoStreamEnum.inherit")})
public class BVideoCameraWidget
extends BWidget {
    public static final BBrush DEFAULT_CAMERA_RECTANGLE_BRUSH = BBrush.makeLinearGradient((BBrush.Stop[])new BBrush.Stop[]{BBrush.stop((double)90.0, (BColor)BColor.black), BBrush.stop((double)100.0, (BColor)BColor.gray)});
    public static final BBrush DEFAULT_CAMERA_TRIANGLE_BRUSH = BBrush.makeLinearGradient((BBrush.Stop[])new BBrush.Stop[]{BBrush.stop((double)80.0, (BColor)BColor.black), BBrush.stop((double)100.0, (BColor)BColor.gray)});
    public static final BBrush DEFAULT_CAMERA_RECTANGLE_BRUSH_MOUSE_OVER = BBrush.makeLinearGradient((BBrush.Stop[])new BBrush.Stop[]{BBrush.stop((double)90.0, (BColor)BColor.blue), BBrush.stop((double)100.0, (BColor)BColor.slateBlue)});
    public static final BBrush DEFAULT_CAMERA_TRIANGLE_BRUSH_MOUSE_OVER = BBrush.makeLinearGradient((BBrush.Stop[])new BBrush.Stop[]{BBrush.stop((double)80.0, (BColor)BColor.blue), BBrush.stop((double)100.0, (BColor)BColor.slateBlue)});
    public static final BBrush DEFAULT_JOYSTICK_BACKGROUND_BRUSH = BBrush.makeSolid((BColor)BColor.transparent);
    @Generated
    public static final Property cameraRectangleFill = BVideoCameraWidget.newProperty((int)0, (BValue)DEFAULT_CAMERA_RECTANGLE_BRUSH, null);
    @Generated
    public static final Property cameraRectangleFillMouseOver = BVideoCameraWidget.newProperty((int)0, (BValue)DEFAULT_CAMERA_RECTANGLE_BRUSH_MOUSE_OVER, null);
    @Generated
    public static final Property cameraTriangleFill = BVideoCameraWidget.newProperty((int)0, (BValue)DEFAULT_CAMERA_TRIANGLE_BRUSH, null);
    @Generated
    public static final Property cameraTriangleFillMouseOver = BVideoCameraWidget.newProperty((int)0, (BValue)DEFAULT_CAMERA_TRIANGLE_BRUSH_MOUSE_OVER, null);
    @Generated
    public static final Property cameraOutline = BVideoCameraWidget.newProperty((int)0, (BValue)BPen.DEFAULT, null);
    @Generated
    public static final Property zoomBackground = BVideoCameraWidget.newProperty((int)0, (BValue)Theme.scrollBar().getControlBackground(), null);
    @Generated
    public static final Property ptzDialogSize = BVideoCameraWidget.newProperty((int)0, (BValue)BSize.make((double)0.0, (double)0.0), null);
    @Generated
    public static final Property ptzBorder = BVideoCameraWidget.newProperty((int)0, (BValue)BBorder.inset, null);
    @Generated
    public static final Property panTiltKeepDownInterval = BVideoCameraWidget.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L))));
    @Generated
    public static final Property zoomKeepDownInterval = BVideoCameraWidget.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L))));
    @Generated
    public static final Property showActionsMenu = BVideoCameraWidget.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property refreshRate = BVideoCameraWidget.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)25), (String)"max", (BIDataValue)BInteger.make((int)1000), (String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    @Generated
    public static final Property resolution = BVideoCameraWidget.newProperty((int)0, (BValue)BVideoResolutionEnum.low, null);
    @Generated
    public static final Property frameRate = BVideoCameraWidget.newProperty((int)0, (BValue)BVideoFrameRateEnum.low, null);
    @Generated
    public static final Property compression = BVideoCameraWidget.newProperty((int)0, (BValue)BVideoCompressionEnum.medium, null);
    @Generated
    public static final Property streamFacets = BVideoCameraWidget.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Property videoStreamFox = BVideoCameraWidget.newProperty((int)0, (BValue)BFoxVideoStreamEnum.inherit, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoCameraWidget.class);
    private static final BIcon icon = BIcon.make((String)"module://videoDriver/icons/camera.png");
    protected double x;
    protected double y;
    protected double w;
    protected double h;
    protected PolygonGeom cameraTriangle = null;
    protected PolygonGeom cameraRectangle = null;
    protected BVideoPtzCameraWidgetBinding binding = new BVideoPtzCameraWidgetBinding();
    protected BVideoPlayer videoPlayer;
    protected boolean mouseOverWidget;
    public static final String PAN_TILT_ZOOM = "PanTiltZoom";

    @Generated
    public BBrush getCameraRectangleFill() {
        return (BBrush)this.get(cameraRectangleFill);
    }

    @Generated
    public void setCameraRectangleFill(BBrush v) {
        this.set(cameraRectangleFill, (BValue)v, null);
    }

    @Generated
    public BBrush getCameraRectangleFillMouseOver() {
        return (BBrush)this.get(cameraRectangleFillMouseOver);
    }

    @Generated
    public void setCameraRectangleFillMouseOver(BBrush v) {
        this.set(cameraRectangleFillMouseOver, (BValue)v, null);
    }

    @Generated
    public BBrush getCameraTriangleFill() {
        return (BBrush)this.get(cameraTriangleFill);
    }

    @Generated
    public void setCameraTriangleFill(BBrush v) {
        this.set(cameraTriangleFill, (BValue)v, null);
    }

    @Generated
    public BBrush getCameraTriangleFillMouseOver() {
        return (BBrush)this.get(cameraTriangleFillMouseOver);
    }

    @Generated
    public void setCameraTriangleFillMouseOver(BBrush v) {
        this.set(cameraTriangleFillMouseOver, (BValue)v, null);
    }

    @Generated
    public BPen getCameraOutline() {
        return (BPen)this.get(cameraOutline);
    }

    @Generated
    public void setCameraOutline(BPen v) {
        this.set(cameraOutline, (BValue)v, null);
    }

    @Generated
    public BBrush getZoomBackground() {
        return (BBrush)this.get(zoomBackground);
    }

    @Generated
    public void setZoomBackground(BBrush v) {
        this.set(zoomBackground, (BValue)v, null);
    }

    @Generated
    public BSize getPtzDialogSize() {
        return (BSize)this.get(ptzDialogSize);
    }

    @Generated
    public void setPtzDialogSize(BSize v) {
        this.set(ptzDialogSize, (BValue)v, null);
    }

    @Generated
    public BBorder getPtzBorder() {
        return (BBorder)this.get(ptzBorder);
    }

    @Generated
    public void setPtzBorder(BBorder v) {
        this.set(ptzBorder, (BValue)v, null);
    }

    @Generated
    public BRelTime getPanTiltKeepDownInterval() {
        return (BRelTime)this.get(panTiltKeepDownInterval);
    }

    @Generated
    public void setPanTiltKeepDownInterval(BRelTime v) {
        this.set(panTiltKeepDownInterval, (BValue)v, null);
    }

    @Generated
    public BRelTime getZoomKeepDownInterval() {
        return (BRelTime)this.get(zoomKeepDownInterval);
    }

    @Generated
    public void setZoomKeepDownInterval(BRelTime v) {
        this.set(zoomKeepDownInterval, (BValue)v, null);
    }

    @Generated
    public boolean getShowActionsMenu() {
        return this.getBoolean(showActionsMenu);
    }

    @Generated
    public void setShowActionsMenu(boolean v) {
        this.setBoolean(showActionsMenu, v, null);
    }

    @Generated
    public int getRefreshRate() {
        return this.getInt(refreshRate);
    }

    @Generated
    public void setRefreshRate(int v) {
        this.setInt(refreshRate, v, null);
    }

    @Generated
    public BVideoResolutionEnum getResolution() {
        return (BVideoResolutionEnum)this.get(resolution);
    }

    @Generated
    public void setResolution(BVideoResolutionEnum v) {
        this.set(resolution, (BValue)v, null);
    }

    @Generated
    public BVideoFrameRateEnum getFrameRate() {
        return (BVideoFrameRateEnum)this.get(frameRate);
    }

    @Generated
    public void setFrameRate(BVideoFrameRateEnum v) {
        this.set(frameRate, (BValue)v, null);
    }

    @Generated
    public BVideoCompressionEnum getCompression() {
        return (BVideoCompressionEnum)this.get(compression);
    }

    @Generated
    public void setCompression(BVideoCompressionEnum v) {
        this.set(compression, (BValue)v, null);
    }

    @Generated
    public BFacets getStreamFacets() {
        return (BFacets)this.get(streamFacets);
    }

    @Generated
    public void setStreamFacets(BFacets v) {
        this.set(streamFacets, (BValue)v, null);
    }

    @Generated
    public BFoxVideoStreamEnum getVideoStreamFox() {
        return (BFoxVideoStreamEnum)this.get(videoStreamFox);
    }

    @Generated
    public void setVideoStreamFox(BFoxVideoStreamEnum v) {
        this.set(videoStreamFox, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BVideoCameraWidget() {
        this.setLayout(BLayout.makeAbs((double)1.0, (double)1.0, (double)60.0, (double)20.0));
    }

    public void paint(Graphics g) {
        this.x = this.getX();
        this.y = this.getY();
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.computeCameraTriangle();
        this.drawCamera(g);
        super.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawCameraUserImage(Graphics g, BImage cameraImage) {
        try {
            BBrush mouseOverBrush;
            BBrush.Paint mouseOverPaint;
            g.push();
            if (this.mouseOverWidget && (mouseOverPaint = (mouseOverBrush = this.getCameraRectangleFillMouseOver()).getPaint()) instanceof BBrush.Image) {
                cameraImage = ((BBrush.Image)mouseOverPaint).getImage();
            }
            g.transform(BTransform.makeScale((double)(this.getWidth() / cameraImage.getWidth()), (double)(this.getHeight() / cameraImage.getHeight())));
            g.drawImage(cameraImage, 0.0, 0.0);
        }
        finally {
            g.pop();
        }
    }

    protected void drawCamera(Graphics g) {
        BBrush cameraRectangleBrush = this.getCameraRectangleFill();
        BBrush.Paint cameraRectangleGxPaint = cameraRectangleBrush.getPaint();
        if (cameraRectangleGxPaint instanceof BBrush.Image) {
            this.drawCameraUserImage(g, ((BBrush.Image)cameraRectangleGxPaint).getImage());
        } else {
            this.strokeCamera(g);
        }
    }

    protected void strokeCamera(Graphics g) {
        try {
            g.push();
            g.useAntiAliasing(true);
            g.setPen(this.getCameraOutline());
            if (this.mouseOverWidget) {
                g.setBrush(this.getCameraRectangleFillMouseOver());
            } else {
                g.setBrush(this.getCameraRectangleFill());
            }
            g.fillRect(0.0, 0.0, this.w * 0.8, this.h);
            g.strokeRect(0.0, 0.0, this.w * 0.8, this.h);
            if (this.mouseOverWidget) {
                g.setBrush(this.getCameraTriangleFillMouseOver());
            } else {
                g.setBrush(this.getCameraTriangleFill());
            }
            g.fill((IGeom)this.cameraTriangle);
            g.stroke((IGeom)this.cameraTriangle);
            g.useAntiAliasing(false);
        }
        finally {
            g.pop();
        }
    }

    protected void computeCameraTriangle() {
        this.cameraTriangle = new PolygonGeom(new double[]{this.w * 0.8, this.w, this.w}, new double[]{this.h * 0.5, 0.0, this.h}, 3);
    }

    public void computePreferredSize() {
        this.setPreferredSize(60.0, 20.0);
    }

    protected String getPtzDialogTitle() {
        String ptzDialogTitle = VideoDriverLexicon.LEX.getText(PAN_TILT_ZOOM);
        BVideoPtzBinding cameraBinding = this.getCameraBinding();
        BWbShell wbShell = BWbShell.getWbShell((BWidget)this);
        OrdTarget activeOrdTarget = wbShell.getActiveOrdTarget();
        BObject stationObject = activeOrdTarget.get();
        BIVideoCamera camera = (BIVideoCamera)cameraBinding.getOrd().get(stationObject);
        String cameraDescription = camera.getCameraDescription();
        if (cameraDescription.trim().length() > 0) {
            ptzDialogTitle = ptzDialogTitle + " - " + cameraDescription;
        }
        return ptzDialogTitle;
    }

    protected void showPtzDialog() {
        BWbShell wbShell;
        OrdTarget activeOrdTarget;
        BVideoPtzBinding cameraBinding = this.getCameraBinding();
        BOrd cameraBindingOrd = cameraBinding.getOrd();
        BIVideoCamera camera = (BIVideoCamera)cameraBindingOrd.get((activeOrdTarget = (wbShell = BWbShell.getWbShell((BWidget)this)).getActiveOrdTarget()).get());
        if (camera instanceof BComponent) {
            BLiveVideo liveView = new BLiveVideo();
            BVideoLayerPane videoLayerPane = new BVideoLayerPane();
            videoLayerPane.add("liveView", (BValue)liveView);
            BVideoCameraWidgetDialog dlg = new BVideoCameraWidgetDialog(this, this.getPtzDialogTitle(), false, videoLayerPane);
            dlg.setBoundsCenteredOnOwner();
            dlg.open();
            BVideoCameraWidget.hookViewToCamera(camera.asObject(), liveView);
        }
    }

    public static Binder hookViewToCamera(BObject videoCameraObject, BWbView view) {
        ((BComponent)videoCameraObject).lease();
        view.fw(403);
        Context context = null;
        try {
            BISession session = BOrd.toSession((BObject)videoCameraObject);
            if (session != null) {
                context = session.getSessionContext();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        view.prime();
        view.relayout();
        view.start();
        view.loadValue(videoCameraObject, context);
        if (view.getLoadError() != null) {
            throw new BajaRuntimeException(view.getLoadError());
        }
        Binder binder = (Binder)view.fw(302);
        binder.start(((BComponent)videoCameraObject).getNavOrd().resolve(), context);
        return binder;
    }

    public void showActionsMenu(BMouseEvent event) {
        try {
            BVideoPtzBinding cameraBinding = this.getCameraBinding();
            BWbShell wbShell = BWbShell.getWbShell((BWidget)this);
            OrdTarget activeOrdTarget = wbShell.getActiveOrdTarget();
            BObject stationObject = activeOrdTarget.get();
            BIVideoCamera camera = (BIVideoCamera)cameraBinding.getOrd().get(stationObject);
            if (camera instanceof BComponent) {
                BMenu actionsMenu = NavMenuUtil.makeActionsMenu((BWidget)this, (BComponent)((BComponent)camera));
                actionsMenu.open(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mouseEntered(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            this.setMouseCursor(MouseCursor.hand);
        }
        this.mouseOverWidget = true;
        this.repaint();
    }

    public void mouseExited(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            this.setMouseCursor(MouseCursor.normal);
        }
        this.mouseOverWidget = false;
        this.repaint();
    }

    public void mousePressed(BMouseEvent event) {
        if (this.getEnabled() && event.getClickCount() >= 1) {
            if ((event.getModifiersEx() & 0x400) != 0) {
                this.showPtzDialog();
            } else if (event.getClickCount() == 1 && (event.getModifiersEx() & 0x1000) != 0 && this.getShowActionsMenu()) {
                this.showActionsMenu(event);
            }
        }
    }

    public BVideoPtzDialogPane getPtzVideoPane() {
        BVideoPtzBinding cameraBinding = this.getCameraBinding();
        BIVideoCamera videoCamera = null;
        BWbShell wbShell = BWbShell.getWbShell((BWidget)this);
        OrdTarget activeOrdTarget = wbShell.getActiveOrdTarget();
        BObject stationObject = activeOrdTarget.get();
        if (cameraBinding != null) {
            try {
                BObject target = cameraBinding.getOrd().get(stationObject);
                if (target instanceof BIVideoCamera) {
                    videoCamera = (BIVideoCamera)target;
                } else {
                    System.out.println("Camera widget is not bound to a BIVideoCamera. It is bound to a " + target.getType().getTypeSpec() + ". Are the binding properties configured incorrectly? Please have my program examined.");
                    videoCamera = null;
                }
            }
            catch (Exception e) {
                videoCamera = null;
            }
        }
        BVideoPtzDialogPane ptzPane2 = new BVideoPtzDialogPane(this, videoCamera);
        return ptzPane2;
    }

    protected BVideoPtzBinding getCameraBinding() {
        Object[] cameraBindings = this.getChildren(BVideoPtzBinding.class);
        if (cameraBindings != null && cameraBindings.length > 0) {
            BVideoPtzBinding cameraBinding = (BVideoPtzBinding)((Object)cameraBindings[0]);
            return cameraBinding;
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }
}

