/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm.monitoring;

import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.videoDriver.alarm.monitoring.BAlarmTypeEnum;
import com.tridium.videoDriver.alarm.monitoring.BConsoleRecipientMonitor;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmConsole;
import com.tridium.videoDriver.ui.alarm.monitoring.BMonitorNotificationHandler;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType(agent={@AgentOn(types={"videoDriver:AlarmNotification"})})
public class BAlarmNotificationHandler
extends BMonitorNotificationHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmNotificationHandler.class);
    protected BConsoleRecipientMonitor crm;
    private static double DIALOG_SCALE_FACTOR = 1.0;
    private static final double DIALOG_ASPECT_RATIO = 1.618;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected static boolean isVideoAlarm(BAlarmRecord alarm) {
        if (alarm == null) {
            return false;
        }
        String cameraOrd = alarm.getAlarmData().gets("cameraOrd", null);
        String cameraHandleOrd = alarm.getAlarmData().gets("cameraHandleOrd", null);
        return cameraOrd != null || cameraHandleOrd != null;
    }

    protected static boolean isVideoDriverAvailable() {
        return BConsoleRecipientMonitor.videoDriverAvailable();
    }

    protected boolean monitoringAnyAlarm() {
        return this.crm.getAlarmTypeToMonitor().equals((Object)BAlarmTypeEnum.allAlarms);
    }

    protected boolean monitoringOnlyVideoAlarms() {
        return this.crm.getAlarmTypeToMonitor().equals((Object)BAlarmTypeEnum.videoAlarms) && BAlarmNotificationHandler.isVideoDriverAvailable() && BAlarmNotificationHandler.isVideoAlarm(this.crm.getLastAlarmRecord());
    }

    protected boolean alarmTransitionStateValid() {
        BAlarmRecord alarm = this.crm.getLastAlarmRecord();
        if (alarm == null) {
            return false;
        }
        BAlarmTransitionBits transitionBits = this.crm.getAlarmState();
        return transitionBits.includes(alarm.getSourceState());
    }

    protected boolean alarmAckStateValid() {
        BAlarmRecord record = this.crm.getLastAlarmRecord();
        return record != null && record.getAckState().equals((Object)this.crm.getAckState());
    }

    protected boolean isValidAlarmForNotification(BAlarmRecord alarm) {
        boolean alarmValid = this.alarmTransitionStateValid() && this.alarmAckStateValid() && (this.monitoringAnyAlarm() || this.monitoringOnlyVideoAlarms());
        return alarmValid;
    }

    @Override
    protected void processNotification() {
        String monitorUser;
        BUser user = this.getUser();
        if (user == null) {
            return;
        }
        String sessionUser = this.getUser().getUsername();
        if (!sessionUser.equals(monitorUser = ((BUser)this.monitor.getParent()).getUsername())) {
            return;
        }
        this.crm = (BConsoleRecipientMonitor)this.monitor;
        this.crm.lease();
        BAlarmRecord alarm = this.crm.getLastAlarmRecord();
        if (alarm == null) {
            return;
        }
    }

    protected BAlarmConsole getAlarmConsole() {
        switch (this.crm.getAlarmConsoleType().getOrdinal()) {
            case 1: {
                return new BVideoAlarmConsole();
            }
        }
        return new BAlarmConsole();
    }
}

