/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm;

import com.tridium.alarm.ui.SourceTableModel;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.videoDriver.alarm.BVideoAlarmActionEnum;
import com.tridium.videoDriver.alarm.BVideoAlarmConsoleOptions;
import com.tridium.videoDriver.alarm.monitoring.BConsoleRecipientMonitor;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.display.BIVideoDisplayLayout;
import com.tridium.videoDriver.ui.alarm.AlarmConsoleExt;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmConsole;
import com.tridium.videoDriver.ui.alarm.LayoutController;
import java.util.logging.Logger;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BObject;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BUuid;

public class AlarmConsoleController {
    protected BVideoAlarmConsole console;
    protected LayoutController layoutController;
    private static Logger log = Logger.getLogger("videoDriver.AlarmControlController");

    protected AlarmConsoleController(BVideoAlarmConsole console) {
        this.console = console;
    }

    void processAlarm(BAlarmRecord alarm, boolean force) {
        if ((this.isValidVideoAlarm(alarm) || force) && this.layoutController != null) {
            this.layoutController.loadVideoAlarm(alarm);
        }
    }

    protected void sendAlarmToVideoDisplay(final BAlarmRecord alarm) {
        new Thread(){

            @Override
            public void run() {
                BIVideoCamera videoCamera;
                BIVideoDisplay[] displays;
                BComponent camera = AlarmConsoleController.this.getVideoCameraForAlarm(alarm);
                if (camera != null && camera instanceof BIVideoCamera && (displays = (videoCamera = (BIVideoCamera)camera).getDvr().getDisplayExt().getAllDisplays()).length > 0) {
                    BIVideoDisplay display = displays[0];
                    if (display == null) {
                        return;
                    }
                    BFrozenEnum layout = display.getVideoDisplayMultistream().getLayout();
                    if (layout instanceof BIVideoDisplayLayout) {
                        BIVideoDisplayLayout singleCameraLayout = ((BIVideoDisplayLayout)layout).getSingleSegmentLayout();
                        display.switchToLayout(singleCameraLayout);
                        BOrd videoCameraOrd = camera.getHandleOrd();
                        display.mapCamerasToLayout(new BOrd[]{videoCameraOrd}, singleCameraLayout);
                        BAbsTime time = alarm.getTimestamp();
                        display.gotoPlaybackTime(time);
                    }
                }
            }
        }.start();
    }

    protected boolean isValidVideoAlarm(BAlarmRecord alarm) {
        return this.isVideoAlarm(alarm) && this.isVideoAlarmStateValid(alarm) && this.isVideoAlarmLoadable(alarm);
    }

    protected boolean isVideoAlarm(BAlarmRecord alarm) {
        String cameraOrd = alarm.getAlarmData().gets("cameraOrd", null);
        String cameraHandleOrd = alarm.getAlarmData().gets("cameraHandleOrd", null);
        return cameraOrd != null || cameraHandleOrd != null;
    }

    protected boolean isVideoAlarmStateValid(BAlarmRecord alarm) {
        BComponent alarmMonitor = this.getAlarmMonitor();
        if (alarmMonitor == null) {
            return false;
        }
        BAlarmTransitionBits alarmTransitionBits = (BAlarmTransitionBits)alarmMonitor.get("alarmState");
        BAckState alarmAckState = (BAckState)alarmMonitor.get("ackState");
        return alarmTransitionBits.includes(alarm.getSourceState()) && alarm.getAckState().equals((Object)alarmAckState);
    }

    protected boolean isVideoAlarmLoadable(BAlarmRecord alarm) {
        BVideoAlarmConsoleOptions vacOptions = this.getVideoAlarmConsoleOptions();
        boolean loadVideoOptionActive = vacOptions != null && vacOptions.getActionOnNewAlarm().equals((Object)BVideoAlarmActionEnum.loadVideo);
        return loadVideoOptionActive;
    }

    protected void deactivate() {
        if (this.layoutController != null) {
            this.layoutController.deactivate();
        }
    }

    protected void layout() {
        if (this.layoutController == null) {
            this.layoutController = LayoutController.make(this);
        }
        this.layoutController.layout();
    }

    BAlarmRecord getNewestUnackedOffnormalAlarm() {
        SourceTableModel model = this.console.getSourceTableModel();
        BAbsTime alarmTime = BAbsTime.DEFAULT;
        BAlarmRecord alarm = new BAlarmRecord(BUuid.make());
        int rows = model.getRowCount();
        for (int i = 0; i < rows; ++i) {
            BAlarmRecord record = model.getRecord(i);
            if (!record.getTimestamp().isAfter(alarmTime)) continue;
            alarmTime = record.getTimestamp();
            if (record.isNormal() || record.isAcknowledged() || record.isAckPending()) continue;
            alarm = record;
        }
        return alarm;
    }

    public BComponent getVideoCameraForAlarm(BAlarmRecord alarm) {
        BComponent camera;
        BOrd videoCameraOrd = AlarmConsoleExt.resolveVideoCameraObject((BObject)this.console.getConsoleRecipient(), alarm);
        if (videoCameraOrd != null && !videoCameraOrd.isNull() && (camera = videoCameraOrd.get((BObject)this.console.getConsoleRecipient()).asComponent()) != null) {
            camera.lease();
            return camera;
        }
        return null;
    }

    protected BComponent getAlarmMonitor() {
        BUser user = this.getUserForSession();
        user.lease(10);
        BComponent alarmMonitor = (BComponent)user.getMixIn(BConsoleRecipientMonitor.TYPE);
        if (alarmMonitor == null) {
            log.severe("No alarm monitor detected for user");
            return null;
        }
        alarmMonitor.lease();
        return alarmMonitor;
    }

    protected BVideoAlarmConsoleOptions getVideoAlarmConsoleOptions() {
        BUser user = this.getUserForSession();
        user.lease(10);
        BVideoAlarmConsoleOptions vacOptions = (BVideoAlarmConsoleOptions)user.getMixIn(BVideoAlarmConsoleOptions.TYPE);
        if (vacOptions == null) {
            log.severe("No video alarm console options detected for user");
            return null;
        }
        vacOptions.lease();
        return vacOptions;
    }

    protected BUser getUserForSession() {
        BFoxSession foxSession = this.getFoxSession();
        return this.getUser(foxSession.getUsername(), foxSession);
    }

    protected BFoxSession getFoxSession() {
        BISession session = this.console.getCurrentValueSession();
        if (!session.getType().is(BFoxSession.TYPE)) {
            return null;
        }
        BFoxSession foxSession = (BFoxSession)session;
        return foxSession;
    }

    protected BUser getUser(String userName, BFoxSession foxSession) {
        BUserService userService = (BUserService)foxSession.getService(BUserService.TYPE);
        userService.lease(10);
        BUser user = userService.getUser(foxSession.getUsername());
        return user;
    }
}

