/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProUtil.job;

import com.tridium.ui.theme.Theme;
import com.vykon.vykonProUtil.job.BGlobalJob;
import javax.baja.gx.BSize;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

public final class JobTracker {
    private static final Lexicon lex = Lexicon.make(BGlobalJob.class);
    private static final UiLexicon uilex = UiLexicon.bajaui();

    public static void open(BWidget owner, BComponent base, BOrd jobOrd) {
        JobWorker jobWorker = new JobWorker(base, jobOrd);
        BProgressDialog.open((BWidget)owner, (String)lex.getText("jobTracker.running"), (BProgressDialog.Worker)jobWorker);
        if (jobWorker.isCancelled()) {
            return;
        }
        if (!jobWorker.isCancelled()) {
            BTextEditor textField = new BTextEditor(jobWorker.getLog(), false);
            BConstrainedPane pane = new BConstrainedPane((BWidget)new BScrollPane((BWidget)textField));
            pane.setMinSize(BSize.make((double)800.0, (double)600.0));
            BGridPane buttonPane = new BGridPane();
            Ok okCmd = new Ok((BWidget)buttonPane, uilex.getText("dialog.ok"));
            buttonPane.add(null, (BValue)new BButton((Command)okCmd));
            buttonPane.setColumnCount(((BButton[])buttonPane.getChildren(BButton.class)).length);
            BEdgePane edgePane = new BEdgePane();
            edgePane.setCenter((BWidget)pane);
            edgePane.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 5.0, 5.0, 0.0, 5.0));
            BDialog.open((BWidget)owner, (String)lex.getText("jobTracker.log"), (Object)edgePane, (int)0);
        }
    }

    private static class Ok
    extends Command {
        public Ok(BWidget owner, String text) {
            super(owner, text);
        }

        public CommandArtifact doInvoke() throws Exception {
            BDialog dlg = this.findDialog(this.getOwner());
            dlg.close();
            return null;
        }

        private BDialog findDialog(BWidget w) {
            if (w == null) {
                return null;
            }
            if (w instanceof BDialog) {
                return (BDialog)w;
            }
            return this.findDialog((BWidget)w.getParent());
        }
    }

    private static class JobWorker
    extends BProgressDialog.Worker {
        private volatile boolean cancelled = false;
        private Object mon = new Object();
        private BComponent base;
        private BOrd jobOrd;
        private BJob jobRef;
        private StringBuffer buffLog = new StringBuffer();

        private JobWorker(BComponent base, BOrd jobOrd) {
            this.base = base;
            this.jobOrd = jobOrd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void doRun() throws Exception {
            this.getDialog().getProgressBar().setIndeterminate(true);
            this.getDialog().getProgressBar().setBackgroundBrush(Theme.widget().getSelectionForeground());
            this.getDialog().getProgressBar().setBarBrush(Theme.widget().getSelectionBackground());
            this.updateProgress(lex.getText("jobTracker.start"));
            this.base.getComponentSpace().sync();
            BJob job = (BJob)this.jobOrd.get((BObject)this.base);
            Object object = this.mon;
            // MONITORENTER : object
            this.jobRef = job;
            // MONITOREXIT : object
            if (this.isCancelled()) {
                return;
            }
            Subscriber sub = new Subscriber(){

                public void event(BComponentEvent event) {
                }
            };
            try {
                sub.subscribe((BComponent)job);
                Property currentProgProp = job.getProperty("currentProgress");
                Object object2 = this.mon;
                // MONITORENTER : object2
                while (!job.getJobState().isComplete()) {
                    String currentProg;
                    this.mon.wait(100L);
                    if (currentProgProp != null && (currentProg = job.get(currentProgProp).toString()).length() > 0) {
                        this.updateProgress(BFormat.format((String)currentProg, (Object)((Object)this)));
                    }
                    if (!this.cancelled) continue;
                    // MONITOREXIT : object2
                    return;
                }
                // MONITOREXIT : object2
                this.base.getComponentSpace().sync();
                if (job.getJobState() == BJobState.canceled) {
                    this.cancelled = true;
                }
            }
            finally {
                sub.unsubscribeAll();
            }
            if (this.isCancelled()) return;
            JobLog log = job instanceof BGlobalJob ? JobLog.decode((String)job.readLog().getString()) : JobLog.decode((String)job.readLog().getString());
            JobLogItem[] items = log.getItems();
            int i = 0;
            while (i < items.length) {
                this.buffLog.append(items[i].toString() + "\n");
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doCancel() throws Exception {
            this.cancelled = true;
            Object object = this.mon;
            synchronized (object) {
                this.mon.notify();
                if (this.jobRef != null) {
                    this.jobRef.cancel();
                }
            }
        }

        private boolean isCancelled() {
            return this.cancelled;
        }

        private String getLog() {
            return this.buffLog.toString();
        }
    }
}

