/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.platform;

import com.tridium.platform.daemon.NiagaraPlatformDaemon;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.platform.BackupManager;
import javax.baja.platform.DaemonSecurityManager;
import javax.baja.platform.FileManager;
import javax.baja.platform.InstallManager;
import javax.baja.platform.PlatformLicenseManager;
import javax.baja.platform.StationManager;
import javax.baja.security.BUsernameAndPassword;

public abstract class PlatformDaemon {
    public static PlatformDaemon make(String hostAddr, int port, String username, String password) throws Exception {
        return PlatformDaemon.make((BHost)BOrd.make((String)("ip:" + hostAddr)).get(), port, port != 3011, new BUsernameAndPassword(username, password));
    }

    public static PlatformDaemon make(String hostAddr, int port, boolean secure, String username, String password) throws Exception {
        return PlatformDaemon.make((BHost)BOrd.make((String)("ip:" + hostAddr)).get(), port, secure, new BUsernameAndPassword(username, password));
    }

    public static PlatformDaemon make(BHost host, int port, BUsernameAndPassword credentials) throws Exception {
        return PlatformDaemon.make(host, port, port != 3011, credentials);
    }

    public static PlatformDaemon make(BHost host, int port, boolean secure, BUsernameAndPassword credentials) throws Exception {
        return NiagaraPlatformDaemon.make(host, port, secure, credentials);
    }

    public abstract StationManager getStationManager();

    public abstract FileManager getFileManager();

    public abstract InstallManager getInstallManager();

    public abstract DaemonSecurityManager getSecurityManager();

    public abstract BackupManager getOfflineBackupManager() throws Exception;

    public abstract PlatformLicenseManager getLicenseManager() throws Exception;

    public abstract void close() throws Exception;

    public abstract boolean isNiagara4Platform() throws Exception;
}

