/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.platform;

import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEEncodingKey;
import com.tridium.nre.security.SecretChars;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.message.FileTransferMessage;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.baja.file.FilePath;
import javax.baja.platform.BOverwritePolicy;

public final class FileTransferOperation {
    public int operation;
    public FilePath[] source;
    public FilePath destinationDir;
    public boolean recurseDirs;
    public BOverwritePolicy overwritePolicy;
    private Supplier<char[]> passPhraseSupplier = null;
    private PBEEncodingKey pbeKey = null;
    public static final int FILE_TRANSFER_OPER_GET = 0;
    public static final int FILE_TRANSFER_OPER_PUT = 1;
    public static final int FILE_TRANSFER_OPER_DELETE = 2;
    public static final int FILE_TRANSFER_OPER_RENAME = 3;

    public static FileTransferOperation makeRename(FilePath remoteSource, String newName) {
        return new FileTransferOperation(3, new FilePath[]{remoteSource}, remoteSource.getParent().merge(newName), false, null);
    }

    public static FileTransferOperation makeGet(FilePath remoteSource, FilePath localDestDir) {
        return FileTransferOperation.makeGet(new FilePath[]{remoteSource}, localDestDir);
    }

    public static FileTransferOperation makeGet(FilePath[] remoteSource, FilePath localDestDir) {
        return FileTransferOperation.makeGet(remoteSource, localDestDir, true, BOverwritePolicy.different);
    }

    public static FileTransferOperation makeGet(FilePath remoteSource, FilePath localDestDir, boolean recurseDirs, BOverwritePolicy overwritePolicy) {
        return FileTransferOperation.makeGet(new FilePath[]{remoteSource}, localDestDir, recurseDirs, overwritePolicy);
    }

    public static FileTransferOperation makeGet(FilePath[] remoteSource, FilePath localDestDir, boolean recurseDirs, BOverwritePolicy overwritePolicy) {
        return new FileTransferOperation(0, remoteSource, localDestDir, recurseDirs, overwritePolicy);
    }

    public static FileTransferOperation makePut(FilePath localSource, FilePath remoteDestDir) {
        return FileTransferOperation.makePut(new FilePath[]{localSource}, remoteDestDir);
    }

    public static FileTransferOperation makePut(FilePath[] localSource, FilePath remoteDestDir) {
        return FileTransferOperation.makePut(localSource, remoteDestDir, true, BOverwritePolicy.different);
    }

    public static FileTransferOperation makePut(FilePath localSource, FilePath remoteDestDir, boolean recurseDirs, BOverwritePolicy overwritePolicy) {
        return FileTransferOperation.makePut(new FilePath[]{localSource}, remoteDestDir, recurseDirs, overwritePolicy);
    }

    public static FileTransferOperation makePut(FilePath[] localSource, FilePath remoteDestDir, boolean recurseDirs, BOverwritePolicy overwritePolicy) {
        return new FileTransferOperation(1, localSource, remoteDestDir, recurseDirs, overwritePolicy);
    }

    public static FileTransferOperation makeDelete(FilePath[] remoteFiles) {
        return new FileTransferOperation(2, remoteFiles, null, true, null);
    }

    private FileTransferOperation(int operation, FilePath[] source, FilePath destinationDir, boolean recurseDirs, BOverwritePolicy overwritePolicy) {
        this.operation = operation;
        this.source = source;
        this.destinationDir = destinationDir;
        this.recurseDirs = recurseDirs;
        this.overwritePolicy = overwritePolicy;
    }

    public void close() {
        this.passPhraseSupplier = null;
        this.pbeKey = null;
    }

    public void setPassPhraseSupplier(Supplier<char[]> value) {
        this.passPhraseSupplier = value;
    }

    public void setPBEEncodingInfo(PBEEncodingInfo value) throws IOException {
        Objects.requireNonNull(this.passPhraseSupplier);
        Objects.requireNonNull(value);
        if (this.pbeKey != null) {
            if (this.pbeKey.getEncodingIterationCount() != value.getEncodingIterationCount() || !this.pbeKey.getEncodingSaltHex().equals(value.getEncodingSaltHex())) {
                throw new IllegalStateException("Transfer has multiple encoded files, but encodings are incompatible");
            }
            return;
        }
        try (SecretChars passPhrase = new SecretChars(this.passPhraseSupplier.get(), true);){
            this.pbeKey = value.makePBEKey(passPhrase);
        }
    }

    public void initializeFileTransferMessage(BDaemonSession session, FileTransferMessage message) throws IOException {
        Objects.requireNonNull(session);
        Objects.requireNonNull(message);
        if (this.pbeKey == null) {
            return;
        }
        try {
            DaemonClientEncodingInfo.makeMessageInitializer(session, Optional.of(this.pbeKey), Optional.empty()).accept(message);
        }
        catch (IOException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

