/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.tcpip.link;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.GetFileMessage;
import com.tridium.platform.daemon.message.GetLinkCfgMessage;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.link.BBridgePriority;
import com.tridium.platform.tcpip.link.BDaisyChainSettings;
import com.tridium.platform.tcpip.link.BIsolatedLinkSettings;
import com.tridium.platform.tcpip.link.BLinkCfgHostSettings;
import com.tridium.platform.tcpip.link.BLinkMode;
import com.tridium.platform.tcpip.link.BPortPriority;
import com.tridium.platform.tcpip.link.BTcpIpLinkSettings;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.FilePath;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.SlotCursor;
import javax.baja.util.LexiconModule;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class LinkCfgUtil {
    private static final LexiconModule LEXICON = LexiconModule.make((String)"platform");
    public static final Logger LOG = Logger.getLogger("platform.link.util");
    public static final String LINKCFG_SLOT_NAME_MODES_SUPPORTED = "linkModesSupported";
    public static final String LINKCFG_SLOT_NAME_LINK_SETTINGS = "linkModeSettings";
    private static final String LINKCFG_NAME = "link.cfg";
    private static final String LINKCFG_MARKER_NEWLINE = "\n";
    private static final String LINKCFG_MARKER_SPACE = " ";
    private static final String LINKCFG_HEADER_START = "[";
    private static final String LINKCFG_HEADER_END = "]";
    private static final String LINKCFG_LINK_MODE_KEY = "mode";
    private static final String LINKCFG_LINK_MODE_STANDARD = "standard";
    private static final String LINKCFG_LINK_MODE_DAISYCHAIN = "daisychain";
    private static final String LINKCFG_STP_HEADER = "[stp]";
    private static final String LINKCFG_ENABLED_KEY = "enabled";
    private static final String LINKCFG_ENABLED_TRUE = "true";
    private static final String LINKCFG_ENABLED_FALSE = "false";
    private static final String LINKCFG_BRIDGE_PRIORITY_KEY = "bridge_priority";
    private static final String LINKCFG_PORT_PRIORITY_1_KEY = "port_priority_1";
    private static final String LINKCFG_PORT_PRIORITY_2_KEY = "port_priority_2";
    private static final String LINKCFG_HELLO_TIME_KEY = "hello_time";
    private static final String LINKCFG_FORWARD_DELAY_TIME_KEY = "forward_delay_time";
    private static final String LINKCFG_MAXIMUM_AGING_TIME_KEY = "maximum_aging_time";
    private static final String LINKCFG_PORT_PRIORITY_1_KEY_LEGACY = "port_priority1";
    private static final String LINKCFG_PORT_PRIORITY_2_KEY_LEGACY = "port_priority2";

    private LinkCfgUtil() {
    }

    public static void loadFromSession(BLinkCfgHostSettings settings, BDaemonSession session) throws Exception {
        if (!LinkCfgUtil.supportsLinkConfiguration(session)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Remote session '" + session.getHost() + "' does not support the link servlet, skipping load");
            }
            return;
        }
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading link settings from daemon session...");
            start = Clock.ticks();
        }
        InputStream xmlStream = session.getInputStream(new GetLinkCfgMessage());
        XElem rootElem = XParser.make((InputStream)xmlStream).parse();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Using Link servlet XML:");
            rootElem.dump();
        }
        LinkCfgUtil.linkCfgXmlToSettings(settings, rootElem);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Load of link settings from daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
    }

    private static void linkCfgXmlToSettings(BLinkCfgHostSettings settings, XElem rootElem) {
        boolean hostReadonly = rootElem.getb("readonly", false);
        settings.setLinkSettingsReadonly(hostReadonly);
        String filePath = rootElem.get("link_file_path");
        settings.setLinkConfPath(filePath);
        settings.getLinkModesSupported().removeAll();
        XElem linkmodesElem = rootElem.elem("linkmodes");
        if (linkmodesElem != null) {
            XElem[] linkmodeElems;
            for (XElem eachLinkmodeElem : linkmodeElems = linkmodesElem.elems("linkmode")) {
                String name = eachLinkmodeElem.get("name", null);
                if (LINKCFG_LINK_MODE_DAISYCHAIN.equals(name)) {
                    settings.getLinkModesSupported().add(BLinkMode.daisyChain.getTag(), (BValue)BLinkMode.daisyChain, 3);
                    continue;
                }
                if (LINKCFG_LINK_MODE_STANDARD.equals(name)) {
                    settings.getLinkModesSupported().add(BLinkMode.isolated.getTag(), (BValue)BLinkMode.isolated, 3);
                    continue;
                }
                LOG.warning("Unrecognized supported link mode '" + name + "' in remote servlet, ignoring");
            }
            if (linkmodeElems.length == 1) {
                String name = linkmodeElems[0].get("name", null);
                if (LINKCFG_LINK_MODE_DAISYCHAIN.equals(name)) {
                    if (!(settings.getLinkModeSettings() instanceof BDaisyChainSettings)) {
                        settings.setLinkModeSettings(new BDaisyChainSettings());
                    }
                } else if (LINKCFG_LINK_MODE_STANDARD.equals(name)) {
                    if (!(settings.getLinkModeSettings() instanceof BIsolatedLinkSettings)) {
                        settings.setLinkModeSettings(new BIsolatedLinkSettings());
                    }
                } else {
                    LOG.warning("Unrecognized single link mode '" + name + "' in remote servlet, ignoring");
                }
            }
        } else {
            LOG.severe("No supported link modes found in remote servlet response");
        }
        settings.getLinkModeSettings().setIsReadOnly(hostReadonly);
    }

    public static void loadLinkCfgFile(BLinkCfgHostSettings linkHostSettings, BDaemonSession session) throws Exception {
        String filePath = linkHostSettings.getLinkConfPath();
        FilePath confFilePath = new FilePath(filePath);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading link settings from file path '" + confFilePath + "'");
        }
        InputStream confFileStream = session.getInputStream(new GetFileMessage(confFilePath, session.getFileSpace()));
        LinkCfgUtil.linkCfgToSettings(linkHostSettings, confFileStream);
        if (LOG.isLoggable(Level.FINEST)) {
            StringBuilder linkSettingsSummary = new StringBuilder();
            linkSettingsSummary.append("readonly: " + linkHostSettings.getLinkSettingsReadonly()).append(LINKCFG_MARKER_NEWLINE);
            linkSettingsSummary.append("file path: " + linkHostSettings.getLinkConfPath()).append(LINKCFG_MARKER_NEWLINE);
            linkSettingsSummary.append("supported link modes: ");
            SlotCursor c = linkHostSettings.getLinkModesSupported().getProperties();
            while (c.next(BLinkMode.class)) {
                BLinkMode supportedMode = (BLinkMode)c.get();
                linkSettingsSummary.append("'" + (Object)((Object)supportedMode) + "' ");
            }
            linkSettingsSummary.append("\ncurrent link mode: ");
            linkSettingsSummary.append((Object)linkHostSettings.getLinkModeSettings());
            LOG.finest("Link settings after loadLinkCfgFile:\n" + linkSettingsSummary);
        }
    }

    public static void linkCfgToSettings(BLinkCfgHostSettings settings, InputStream in) throws Exception {
        if (in == null) {
            LOG.finest("linkCfgToSettings provided null input stream, assuming file does not exist");
            return;
        }
        String[] allLines = FileUtil.readLines((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        if (LOG.isLoggable(Level.FINEST)) {
            StringBuilder fileContent = new StringBuilder();
            for (String line : allLines) {
                fileContent.append(line).append(LINKCFG_MARKER_NEWLINE);
            }
            LOG.finest("linkCfgToSettings creating link settings from string:\n" + fileContent.toString());
        }
        BTcpIpLinkSettings currentLinkSettings = new BDaisyChainSettings();
        for (int i = 0; i < allLines.length; ++i) {
            String line = allLines[i].trim();
            if (!line.startsWith(LINKCFG_LINK_MODE_KEY)) continue;
            String[] words = line.split(LINKCFG_MARKER_SPACE);
            if (!words[1].equals(LINKCFG_LINK_MODE_DAISYCHAIN)) continue;
            currentLinkSettings = new BDaisyChainSettings();
            currentLinkSettings.setIsDaisyChainEnabled(true);
        }
        currentLinkSettings.setIsReadOnly(settings.getLinkSettingsReadonly());
        settings.setLinkModeSettings(currentLinkSettings);
    }

    private static int linkCfgStpToSettings(BDaisyChainSettings settings, String[] allLines, int i) {
        if (settings == null) {
            return i;
        }
        boolean endOfProtocolBlock = false;
        while (i < allLines.length && !endOfProtocolBlock) {
            String line = allLines[i].trim();
            String[] words = line.split(LINKCFG_MARKER_SPACE);
            if (line.startsWith(LINKCFG_HEADER_START) && line.endsWith(LINKCFG_HEADER_END)) {
                endOfProtocolBlock = true;
            } else {
                switch (words[0].trim()) {
                    case "enabled": {
                        settings.setIsStpEnabled(Boolean.valueOf(words[1].toLowerCase()));
                        break;
                    }
                    case "bridge_priority": {
                        settings.setBridgePriority(BBridgePriority.make(Integer.parseInt(words[1])));
                        break;
                    }
                    case "port_priority_1": 
                    case "port_priority1": {
                        settings.setPortPriority1(BPortPriority.make(Integer.parseInt(words[1])));
                        break;
                    }
                    case "port_priority_2": 
                    case "port_priority2": {
                        settings.setPortPriority2(BPortPriority.make(Integer.parseInt(words[1])));
                        break;
                    }
                    case "hello_time": {
                        settings.setHelloTime(BRelTime.makeSeconds((int)Integer.parseInt(words[1])));
                        break;
                    }
                    case "forward_delay_time": {
                        settings.setForwardDelayTime(BRelTime.makeSeconds((int)Integer.parseInt(words[1])));
                        break;
                    }
                    case "maximum_aging_time": {
                        settings.setMaxAgingTime(BRelTime.makeSeconds((int)Integer.parseInt(words[1])));
                        break;
                    }
                    default: {
                        LOG.warning("Unrecognized key value pair '" + line + "' present in platform link configuration file, ignoring");
                    }
                }
            }
            ++i;
        }
        return i;
    }

    public static void saveToSession(BLinkCfgHostSettings settings, BDaemonSession session) throws Exception {
        if (session == null) {
            return;
        }
        if (settings == null) {
            return;
        }
        if (!LinkCfgUtil.supportsLinkConfiguration(session)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Remote session '" + session.getHost() + "' does not support the link servlet, skipping save");
            }
            return;
        }
        if (settings.getLinkSettingsReadonly()) {
            LOG.finest("Skipping readonly host during 802.1X save");
            return;
        }
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Saving link settings to daemon session...");
            start = Clock.ticks();
        }
        String fileContent = LinkCfgUtil.settingsToLinkCfgFile(settings, session);
        FilePath linkConfigPath = new FilePath(settings.getLinkConfPath());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Writing link settings to file path '" + linkConfigPath + "'");
        }
        FileTransferMessage msg = new FileTransferMessage(session.getFileSpace());
        msg.addElement(new ByteArrayFileTransferElement(linkConfigPath, fileContent.getBytes(), session.getFileSpace()));
        DaemonFileUtil.transfer(session, msg, null);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Save of link settings to daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
    }

    private static String settingsToLinkCfgFile(BLinkCfgHostSettings linkCfgSettings, BDaemonSession session) {
        BDaisyChainSettings daisyChainSettings;
        StringBuilder newFileContent = new StringBuilder();
        BTcpIpLinkSettings settings = linkCfgSettings.getLinkModeSettings();
        String activeMode = LINKCFG_LINK_MODE_DAISYCHAIN;
        if (settings instanceof BDaisyChainSettings) {
            activeMode = LINKCFG_LINK_MODE_DAISYCHAIN;
        } else if (settings instanceof BIsolatedLinkSettings) {
            activeMode = LINKCFG_LINK_MODE_STANDARD;
        }
        newFileContent.append(LINKCFG_LINK_MODE_KEY).append(LINKCFG_MARKER_SPACE).append(activeMode).append(LINKCFG_MARKER_NEWLINE);
        if (settings instanceof BDaisyChainSettings && (daisyChainSettings = (BDaisyChainSettings)settings).getIsStpSupported()) {
            newFileContent.append(LINKCFG_MARKER_NEWLINE).append(LINKCFG_STP_HEADER).append(LINKCFG_MARKER_NEWLINE);
            newFileContent.append(LINKCFG_ENABLED_KEY).append(LINKCFG_MARKER_SPACE).append(daisyChainSettings.getIsStpEnabled() ? LINKCFG_ENABLED_TRUE : LINKCFG_ENABLED_FALSE).append(LINKCFG_MARKER_NEWLINE);
            int bridgePriority = daisyChainSettings.getBridgePriority().getOrdinal();
            try {
                if (new Version(session.getHostProperties().getDaemonVersion()).compareTo(new Version("4.8.0.0")) < 0) {
                    bridgePriority = BBridgePriority.getLegacyOrdinal(bridgePriority);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            newFileContent.append(LINKCFG_BRIDGE_PRIORITY_KEY).append(LINKCFG_MARKER_SPACE).append(bridgePriority).append(LINKCFG_MARKER_NEWLINE);
            newFileContent.append(LINKCFG_PORT_PRIORITY_1_KEY).append(LINKCFG_MARKER_SPACE).append((Object)daisyChainSettings.getPortPriority1()).append(LINKCFG_MARKER_NEWLINE);
            newFileContent.append(LINKCFG_PORT_PRIORITY_2_KEY).append(LINKCFG_MARKER_SPACE).append((Object)daisyChainSettings.getPortPriority2()).append(LINKCFG_MARKER_NEWLINE);
            newFileContent.append(LINKCFG_HELLO_TIME_KEY).append(LINKCFG_MARKER_SPACE).append(daisyChainSettings.getHelloTime().getSeconds()).append(LINKCFG_MARKER_NEWLINE);
            newFileContent.append(LINKCFG_FORWARD_DELAY_TIME_KEY).append(LINKCFG_MARKER_SPACE).append(daisyChainSettings.getForwardDelayTime().getSeconds()).append(LINKCFG_MARKER_NEWLINE);
            newFileContent.append(LINKCFG_MAXIMUM_AGING_TIME_KEY).append(LINKCFG_MARKER_SPACE).append(daisyChainSettings.getMaxAgingTime().getSeconds()).append(LINKCFG_MARKER_NEWLINE);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("settingsToLinkCfgFile created link configuration string:\n" + newFileContent.toString());
        }
        return newFileContent.toString();
    }

    public static void copyLinkCfgSlotToHost(BLinkCfgHostSettings linkCfgHostSettings, BTcpIpHostSettings hostSettings) {
        BTcpIpLinkSettings providedLinkSettings = linkCfgHostSettings.getLinkModeSettings();
        if (hostSettings.get(LINKCFG_SLOT_NAME_LINK_SETTINGS) != null) {
            BTcpIpLinkSettings currentSettings = (BTcpIpLinkSettings)hostSettings.get(LINKCFG_SLOT_NAME_LINK_SETTINGS);
            if (currentSettings instanceof BDaisyChainSettings && providedLinkSettings instanceof BDaisyChainSettings) {
                BDaisyChainSettings currentDaisyChainSettings = (BDaisyChainSettings)currentSettings;
                BDaisyChainSettings providedDaisyChainSettings = (BDaisyChainSettings)providedLinkSettings;
                currentDaisyChainSettings.copyFrom((BComplex)providedDaisyChainSettings);
            } else if (currentSettings instanceof BIsolatedLinkSettings && providedLinkSettings instanceof BIsolatedLinkSettings) {
                BIsolatedLinkSettings currentIsolatedSettings = (BIsolatedLinkSettings)currentSettings;
                BIsolatedLinkSettings providedIsolatedSettings = (BIsolatedLinkSettings)providedLinkSettings;
                currentIsolatedSettings.copyFrom((BComplex)providedIsolatedSettings);
            } else {
                hostSettings.set(LINKCFG_SLOT_NAME_LINK_SETTINGS, providedLinkSettings.newCopy());
            }
        } else {
            hostSettings.add(LINKCFG_SLOT_NAME_LINK_SETTINGS, providedLinkSettings.newCopy(), 3);
        }
        BVector providedLinkModesSupported = linkCfgHostSettings.getLinkModesSupported();
        if (hostSettings.get(LINKCFG_SLOT_NAME_MODES_SUPPORTED) != null) {
            BVector currentSupportedModes = (BVector)hostSettings.get(LINKCFG_SLOT_NAME_MODES_SUPPORTED);
            currentSupportedModes.removeAll();
            SlotCursor c = providedLinkModesSupported.getProperties();
            while (c.next(BLinkMode.class)) {
                BLinkMode supportedMode = (BLinkMode)c.get();
                currentSupportedModes.add(supportedMode.getTag(), (BValue)supportedMode, 3);
            }
        } else {
            hostSettings.add(LINKCFG_SLOT_NAME_MODES_SUPPORTED, providedLinkModesSupported.newCopy(), 3);
        }
    }

    public static void copyLinkCfgSlotFromHost(BLinkCfgHostSettings linkCfgHostSettings, BTcpIpHostSettings hostSettings) {
        BTcpIpLinkSettings hostLinkSettings = (BTcpIpLinkSettings)hostSettings.get(LINKCFG_SLOT_NAME_LINK_SETTINGS);
        if (hostLinkSettings != null) {
            linkCfgHostSettings.setLinkModeSettings((BTcpIpLinkSettings)hostLinkSettings.newCopy());
        }
    }

    public static void setReadOnly(BLinkCfgHostSettings settings, boolean readonly) {
        settings.setLinkSettingsReadonly(readonly);
        settings.getLinkModeSettings().setIsReadOnly(readonly);
    }

    public static boolean supportsLinkConfiguration(BDaemonSession session) {
        return session.getHostProperties().isNiagara4() && session.getHostProperties().supportsServlet("linkcfg");
    }
}

