/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.tcpip;

import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import javax.baja.naming.SlotPath;
import javax.baja.platform.tcpip.TcpIpManager;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class PlatformTcpIpManager
implements TcpIpManager {
    private static final String readonlyNsg = "Can not set value because settings are readonly";
    private static final String dhcpNotSupportedMsg = "Can not set value because DHCP is not supported";
    private static final String dhcpEnabledMsg = "Can not set value because DHCP is enabled";
    private static final String serverArrayTooLargeMsg = "Server array exceeds maximum size";

    private PlatformTcpIpManager() {
        this.loadPlatformProperties();
    }

    public static PlatformTcpIpManager make() {
        return new PlatformTcpIpManager();
    }

    @Override
    public String[] getAdapterIds() {
        BTcpIpAdapterSettings[] adapters = this.getAllTcpIpAdapterSettings();
        int count = adapters.length;
        String[] ids = new String[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = adapters[i].getAdapterId();
        }
        return ids;
    }

    @Override
    public String getDefaultGateway(String adapterId) {
        BTcpIpHostSettings hostSettings = this.getTcpIpHostSettings();
        if (hostSettings.getUsesAdapterLevelSettings()) {
            return this.getTcpIpAdapterSettings(hostSettings, adapterId).getDefaultGateway();
        }
        return hostSettings.getDefaultGateway();
    }

    @Override
    public void setDefaultGateway(String adapterId, String gateway) {
        BTcpIpHostSettings hostSettings = this.getTcpIpHostSettings();
        if (hostSettings.getUsesAdapterLevelSettings()) {
            BTcpIpAdapterSettings adapterSettings = this.getTcpIpAdapterSettings(hostSettings, adapterId);
            if (adapterSettings.getIsAdapterReadonly()) {
                throw new IllegalStateException(readonlyNsg);
            }
            if (this.usingDhcp(adapterSettings)) {
                throw new IllegalStateException(dhcpEnabledMsg);
            }
            adapterSettings.setDefaultGateway(gateway);
        } else {
            if (hostSettings.getIsReadonly()) {
                throw new IllegalStateException(readonlyNsg);
            }
            if (this.usingDhcp()) {
                throw new IllegalStateException(dhcpEnabledMsg);
            }
            hostSettings.setDefaultGateway(gateway);
        }
    }

    @Override
    public boolean isDhcpEnabled(String adapterId) {
        return this.getTcpIpAdapterSettings(adapterId).getIsDhcpEnabled();
    }

    @Override
    public void enableDhcp(String adapterId, boolean enable) {
        BTcpIpAdapterSettings adapterSettings = this.getTcpIpAdapterSettings(adapterId);
        if (adapterSettings.getIsAdapterReadonly()) {
            throw new IllegalStateException(readonlyNsg);
        }
        if (!adapterSettings.getCanUseDhcp()) {
            throw new IllegalStateException(dhcpNotSupportedMsg);
        }
        adapterSettings.setIsDhcpEnabled(enable);
    }

    @Override
    public int getDnsServerLimit(String adapterId) {
        BTcpIpHostSettings hostSettings = this.getTcpIpHostSettings();
        if (hostSettings.getUsesAdapterLevelSettings()) {
            return this.getTcpIpAdapterSettings(hostSettings, adapterId).getMaxDnsHosts();
        }
        return hostSettings.getMaxDnsHosts();
    }

    @Override
    public String[] getDnsServers(String adapterId) {
        BTcpIpHostSettings hostSettings = this.getTcpIpHostSettings();
        BVector v = hostSettings.getUsesAdapterLevelSettings() ? this.getTcpIpAdapterSettings(hostSettings, adapterId).getDnsHosts() : hostSettings.getDnsHosts();
        BString[] hosts = (BString[])v.getChildren(BString.class);
        int count = hosts.length;
        String[] array = new String[count];
        for (int i = 0; i < count; ++i) {
            array[i] = hosts[i].toString();
        }
        return array;
    }

    @Override
    public void setDnsServers(String adapterId, String[] servers) {
        BVector v = this.buildHostsVector(servers);
        if (v.getSlotCount() > this.getDnsServerLimit(adapterId)) {
            throw new IllegalArgumentException(serverArrayTooLargeMsg);
        }
        BTcpIpHostSettings hostSettings = this.getTcpIpHostSettings();
        if (hostSettings.getUsesAdapterLevelSettings()) {
            BTcpIpAdapterSettings adapterSettings = this.getTcpIpAdapterSettings(hostSettings, adapterId);
            if (adapterSettings.getIsAdapterReadonly()) {
                throw new IllegalStateException(readonlyNsg);
            }
            if (this.usingDhcp(adapterSettings)) {
                throw new IllegalStateException(dhcpEnabledMsg);
            }
            adapterSettings.setDnsHosts(v);
        } else {
            if (hostSettings.getIsReadonly()) {
                throw new IllegalStateException(readonlyNsg);
            }
            if (this.usingDhcp()) {
                throw new IllegalStateException(dhcpEnabledMsg);
            }
            hostSettings.setDnsHosts(v);
        }
    }

    @Override
    public String getDomain(String adapterId) {
        BTcpIpHostSettings hostSettings = this.getTcpIpHostSettings();
        if (hostSettings.getUsesAdapterLevelSettings()) {
            return this.getTcpIpAdapterSettings(hostSettings, adapterId).getDomain();
        }
        return hostSettings.getDomain();
    }

    @Override
    public void setDomain(String adapterId, String domain) {
        BTcpIpHostSettings hostSettings = this.getTcpIpHostSettings();
        if (hostSettings.getUsesAdapterLevelSettings()) {
            BTcpIpAdapterSettings adapterSettings = this.getTcpIpAdapterSettings(hostSettings, adapterId);
            if (this.usingDhcp(adapterSettings)) {
                throw new IllegalStateException(dhcpEnabledMsg);
            }
            if (adapterSettings.getIsAdapterReadonly()) {
                throw new IllegalStateException(readonlyNsg);
            }
            adapterSettings.setDomain(domain);
        } else {
            if (this.usingDhcp()) {
                throw new IllegalStateException(dhcpEnabledMsg);
            }
            if (hostSettings.getIsReadonly()) {
                throw new IllegalStateException(readonlyNsg);
            }
            hostSettings.setDomain(domain);
        }
    }

    @Override
    public String getHostName() {
        return this.getTcpIpHostSettings().getHostName();
    }

    @Override
    public void setHostName(String newName) {
        if (this.getTcpIpHostSettings().getIsReadonly()) {
            throw new IllegalStateException(readonlyNsg);
        }
        this.getTcpIpHostSettings().setHostName(newName);
    }

    @Override
    public String getIpAddress(String adapterId) {
        return this.getTcpIpAdapterSettings(adapterId).getIpAddress();
    }

    @Override
    public void setIpAddress(String adapterId, String address) {
        BTcpIpAdapterSettings adapterSettings = this.getTcpIpAdapterSettings(adapterId);
        if (adapterSettings.getIsAdapterReadonly()) {
            throw new IllegalStateException(readonlyNsg);
        }
        if (this.usingDhcp(adapterSettings)) {
            throw new IllegalStateException(dhcpEnabledMsg);
        }
        adapterSettings.setIpAddress(address);
    }

    @Override
    public String getSubnetMask(String adapterId) {
        return this.getTcpIpAdapterSettings(adapterId).getSubnetMask();
    }

    @Override
    public void setSubnetMask(String adapterId, String mask) {
        BTcpIpAdapterSettings adapterSettings = this.getTcpIpAdapterSettings(adapterId);
        if (adapterSettings.getIsAdapterReadonly()) {
            throw new IllegalStateException(readonlyNsg);
        }
        if (this.usingDhcp(adapterSettings)) {
            throw new IllegalStateException(dhcpEnabledMsg);
        }
        adapterSettings.setSubnetMask(mask);
    }

    @Override
    public String getMediaAccessControlAddress(String adapterId) {
        return this.getTcpIpAdapterSettings(adapterId).getMediaAccessControlAddress();
    }

    @Override
    public void saveProperties() {
        if (this.getTcpIpHostSettings().getIsReadonly()) {
            throw new IllegalStateException(readonlyNsg);
        }
        this.getTcpIpService().savePlatformServiceProperties();
    }

    private BVector buildHostsVector(String[] servers) {
        BVector v = new BVector();
        for (String server : servers) {
            v.add(SlotPath.escape((String)server), (BValue)BString.make((String)server));
        }
        return v;
    }

    private BTcpIpHostSettings getTcpIpHostSettings() {
        return this.getTcpIpService().getSettings();
    }

    private BTcpIpAdapterSettings getTcpIpAdapterSettings(BTcpIpHostSettings hostSettings, String adapterId) {
        BTcpIpAdapterSettings[] settings = (BTcpIpAdapterSettings[])hostSettings.getAdapters().getChildren(BTcpIpAdapterSettings.class);
        return this.resolveAdapter(settings, adapterId);
    }

    private BTcpIpAdapterSettings getTcpIpAdapterSettings(String adapterId) {
        BTcpIpAdapterSettings[] settings = this.getAllTcpIpAdapterSettings();
        return this.resolveAdapter(settings, adapterId);
    }

    private BTcpIpAdapterSettings resolveAdapter(BTcpIpAdapterSettings[] settings, String adapterId) {
        for (BTcpIpAdapterSettings setting : settings) {
            if (!setting.getAdapterId().equals(adapterId)) continue;
            return setting;
        }
        return settings[0];
    }

    private BTcpIpAdapterSettings[] getAllTcpIpAdapterSettings() {
        return (BTcpIpAdapterSettings[])this.getTcpIpHostSettings().getAdapters().getChildren(BTcpIpAdapterSettings.class);
    }

    private BTcpIpPlatformService getTcpIpService() {
        return (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
    }

    private void loadPlatformProperties() {
        this.getTcpIpService().poll();
    }

    private boolean usingDhcp() {
        BTcpIpAdapterSettings[] settings;
        for (BTcpIpAdapterSettings setting : settings = this.getAllTcpIpAdapterSettings()) {
            if (!this.usingDhcp(setting)) continue;
            return true;
        }
        return false;
    }

    private boolean usingDhcp(BTcpIpAdapterSettings settings) {
        return settings.getCanUseDhcp() && settings.getIsDhcpEnabled();
    }
}

