/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.sys.license.dom.VendorLicense;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BDataFile;
import javax.baja.file.BIFileStore;
import javax.baja.nre.annotations.FileExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ext={@FileExt(name="lar")})
public class BLicenseArchiveFile
extends BDataFile {
    @Generated
    public static final Type TYPE = Sys.loadType(BLicenseArchiveFile.class);
    private static final BIcon icon = BIcon.std((String)"file.png");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLicenseArchiveFile(BIFileStore store) {
        super(store);
    }

    public BLicenseArchiveFile() {
    }

    public VendorLicense[] getLicenses() throws Exception {
        return this.getLicenses(obj -> true);
    }

    public VendorLicense[] getLicenses(String hostId) throws Exception {
        return this.getLicenses(obj -> {
            String entryName = (String)obj;
            return entryName.startsWith("licenses/" + hostId + "/");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLicenses(VendorLicense[] licenses) throws Exception {
        OutputStream out = this.getOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(out);
        try {
            for (VendorLicense license : licenses) {
                zipOut.putNextEntry(new ZipEntry("licenses/" + license.getHostId() + "/" + license.getLicenseName() + ".license"));
                license.save((OutputStream)zipOut, false);
                zipOut.closeEntry();
            }
        }
        finally {
            try {
                zipOut.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VendorLicense[] getLicenses(IFilter entryNameFilter) throws Exception {
        Array result = new Array(VendorLicense.class);
        ZipInputStream zipIn = new ZipInputStream(this.getInputStream());
        try {
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                if (entryNameFilter.accept((Object)entry.getName())) {
                    VendorLicense lic = VendorLicense.make((String)this.getFileName(), (InputStream)zipIn, (boolean)false);
                    result.add((Object)lic);
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        finally {
            try {
                zipIn.close();
            }
            catch (Exception exception) {}
        }
        return (VendorLicense[])result.trim();
    }

    public String getMimeType() {
        return "application/x-baja-license-archive";
    }

    public BIcon getIcon() {
        return icon;
    }
}

