/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.nre.subscription.EntitlementApi;
import com.tridium.nre.subscription.EntitlementException;
import com.tridium.nre.subscription.RequestCertificates;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.license.BLicensePlatformService;
import com.tridium.sys.Nre;
import com.tridium.sys.license.NLicenseManager;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.sys.license.subscription.SubscriptionLicenseManager;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.xml.XElem;

@NiagaraType
public class BLicenseChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BLicenseChannel.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLicenseChannel() {
        super("license");
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (command.equals("listcertificates")) {
            return this.listcertificates(request);
        }
        if (command.equals("listlicenses")) {
            return this.listlicenses(request);
        }
        if (command.equals("updateentitlements")) {
            return this.updateentitlements(request);
        }
        if (command.equals("updatecertificate")) {
            return this.updatecertificate(request);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        if (command.equals("read")) {
            this.read(circuit);
            return;
        }
        if (command.equals("write")) {
            this.write(circuit);
            return;
        }
        if (command.equals("delete")) {
            this.delete(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    public BIFile[] listcertificates(BFoxFileSpace space) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:listcertificates");
        }
        FoxRequest req = this.makeRequest("listcertificates");
        FoxResponse resp = this.sendSync(req);
        FoxTuple[] messages = resp.list("file");
        BFoxFileStore[] stores = new BFoxFileStore[messages.length];
        for (int i = 0; i < stores.length; ++i) {
            FoxMessage msg = (FoxMessage)messages[i];
            String name = msg.getString("name");
            stores[i] = BFileChannel.msgToStore((BFoxFileSpace)space, (FilePath)this.getCertificatesDirPath(true).merge(name), (FoxMessage)msg);
        }
        BIFile[] files = new BIFile[stores.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = space.makeFile((BIFileStore)stores[i]);
        }
        return files;
    }

    public FoxResponse listcertificates(FoxRequest req) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:listcertificates");
        }
        FoxResponse resp = new FoxResponse(req);
        try {
            AccessController.doPrivileged(() -> {
                FilePath path = this.getCertificatesDirPath(false);
                BIFile file = BFileSystem.INSTANCE.resolveFile(path);
                if (file instanceof BIDirectory) {
                    BIFile[] files;
                    BIDirectory dir = (BIDirectory)file;
                    for (BIFile biFile : files = dir.listFiles()) {
                        BPermissions permissions = this.getPermissionsFor(biFile);
                        FoxMessage msg = new FoxMessage("file");
                        msg.add("name", biFile.getStore().getFileName());
                        msg.add("dir", biFile.getStore().isDirectory());
                        msg.add("readonly", biFile.getStore().isReadonly() || !permissions.has(BPermissions.operatorWrite));
                        msg.add("modified", biFile.getStore().getLastModified().getMillis());
                        msg.add("size", String.valueOf(biFile.getStore().getSize()));
                        msg.add("permissions", permissions.encodeToString());
                        resp.add((FoxTuple)msg);
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        return resp;
    }

    public BIFile[] listlicenses(BFoxFileSpace space) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:listlicenses");
        }
        FoxRequest req = this.makeRequest("listlicenses");
        FoxResponse resp = this.sendSync(req);
        FoxTuple[] messages = resp.list("file");
        BFoxFileStore[] stores = new BFoxFileStore[messages.length];
        for (int i = 0; i < stores.length; ++i) {
            FoxMessage msg = (FoxMessage)messages[i];
            String name = msg.getString("name");
            stores[i] = BFileChannel.msgToStore((BFoxFileSpace)space, (FilePath)this.getLicensesDirPath(true).merge(name), (FoxMessage)msg);
        }
        BIFile[] files = new BIFile[stores.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = space.makeFile((BIFileStore)stores[i]);
        }
        return files;
    }

    public FoxResponse listlicenses(FoxRequest req) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:listlicenses");
        }
        FoxResponse resp = new FoxResponse(req);
        try {
            AccessController.doPrivileged(() -> {
                FilePath path = this.getLicensesDirPath(false);
                BIFile file = BFileSystem.INSTANCE.resolveFile(path);
                if (file instanceof BIDirectory) {
                    BIFile[] files;
                    BIDirectory dir = (BIDirectory)file;
                    for (BIFile biFile : files = dir.listFiles()) {
                        BPermissions permissions = this.getPermissionsFor(biFile);
                        FoxMessage msg = new FoxMessage("file");
                        msg.add("name", biFile.getStore().getFileName());
                        msg.add("dir", biFile.getStore().isDirectory());
                        msg.add("readonly", biFile.getStore().isReadonly() || !permissions.has(BPermissions.operatorWrite));
                        msg.add("modified", biFile.getStore().getLastModified().getMillis());
                        msg.add("size", String.valueOf(biFile.getStore().getSize()));
                        msg.add("permissions", permissions.encodeToString());
                        resp.add((FoxTuple)msg);
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        return resp;
    }

    public Map<String, String> updateentitlements() throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:updateentitlements");
        }
        FoxRequest req = this.makeRequest("updateentitlements");
        FoxResponse resp = this.sendSync(req);
        HashMap<String, String> licenses = new HashMap<String, String>();
        int n = 0;
        FoxTuple[] messages = resp.list("error");
        FoxTuple[] foxTupleArray = messages;
        int n2 = foxTupleArray.length;
        if (n < n2) {
            FoxTuple message = foxTupleArray[n];
            FoxMessage msg = (FoxMessage)message;
            this.log.warning("License update request returned an error: " + msg.getString("details"));
            throw new EntitlementException("License update request returned an error: " + msg.getString("details"));
        }
        for (FoxTuple message : messages = resp.list("license")) {
            FoxMessage msg = (FoxMessage)message;
            String vendor = msg.getString("vendor");
            String xml = msg.getString("xml");
            licenses.put(vendor, xml);
        }
        return licenses;
    }

    public FoxResponse updateentitlements(FoxRequest req) throws Exception {
        XElem[] licenseElems;
        if (this.isTraceOn()) {
            this.trace("s:updateentitlements");
        }
        FoxResponse resp = new FoxResponse(req);
        if (!(Nre.getLicenseManager() instanceof SubscriptionLicenseManager)) {
            FoxMessage msg = new FoxMessage("error");
            msg.add("details", "Subscription license manager was not found.");
            resp.add((FoxTuple)msg);
            return resp;
        }
        EntitlementApi.EntitlementStatus es = AccessController.doPrivileged(this::fetchEntitlements);
        if (!es.isSuccess()) {
            FoxMessage msg = new FoxMessage("error");
            msg.add("details", es.getMessage());
            resp.add((FoxTuple)msg);
            return resp;
        }
        for (XElem elem : licenseElems = es.getLicenses().elems("license")) {
            VendorLicense license = VendorLicense.make((String)"entitlement", (XElem)elem);
            FoxMessage msg = new FoxMessage("license");
            msg.add("name", license.getLicenseName());
            msg.add("vendor", license.getVendor());
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            license.save((OutputStream)bytes);
            msg.add("xml", bytes.toString());
            resp.add((FoxTuple)msg);
        }
        return resp;
    }

    public EntitlementApi.EntitlementStatus fetchEntitlements() throws BajaException {
        NLicenseManager licenseManager = Nre.getLicenseManager();
        if (!(licenseManager instanceof SubscriptionLicenseManager)) {
            throw new BajaException("License Manager is not a Subscription License Manager");
        }
        SubscriptionLicenseManager slm = (SubscriptionLicenseManager)licenseManager;
        return slm.getLicenseUpdate();
    }

    public String updatecertificate(String vendor) throws Exception {
        FoxTuple[] messages;
        if (this.isTraceOn()) {
            this.trace("c:updatecertificate");
        }
        FoxRequest req = this.makeRequest("updatecertificate");
        req.add("vendor", vendor);
        FoxResponse resp = this.sendSync(req);
        FoxTuple[] foxTupleArray = messages = resp.list("error");
        int n = foxTupleArray.length;
        int n2 = 0;
        if (n2 < n) {
            FoxTuple message = foxTupleArray[n2];
            FoxMessage msg = (FoxMessage)message;
            this.log.warning("Certificate update request returned an error: " + msg.getString("details"));
            throw new EntitlementException("Certificate update request returned an error: " + msg.getString("details"));
        }
        for (FoxTuple message : messages = resp.list("certificate")) {
            FoxMessage msg = (FoxMessage)message;
            String certVendor = msg.getString("vendor");
            if (!vendor.equals(certVendor)) continue;
            return msg.getString("xml");
        }
        return "";
    }

    public FoxResponse updatecertificate(FoxRequest req) throws Exception {
        XElem[] certElems;
        String vendor = req.getString("vendor");
        if (this.isTraceOn()) {
            this.trace("s:updatecertificate \"" + vendor + "\"");
        }
        FoxResponse resp = new FoxResponse(req);
        if (!(Nre.getLicenseManager() instanceof SubscriptionLicenseManager)) {
            FoxMessage msg = new FoxMessage("error");
            msg.add("details", "Subscription license manager was not found.");
            resp.add((FoxTuple)msg);
            return resp;
        }
        EntitlementApi.EntitlementStatus es = this.fetchCertificates(vendor);
        if (!es.isSuccess()) {
            FoxMessage msg = new FoxMessage("error");
            msg.add("details", es.getMessage());
            resp.add((FoxTuple)msg);
        }
        for (XElem elem : certElems = es.getCertificates().elems("certificate")) {
            VendorCertificate certificate = VendorCertificate.make((String)"entitlement", (XElem)elem);
            FoxMessage msg = new FoxMessage("certificate");
            msg.add("vendor", vendor);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            certificate.save((OutputStream)bytes);
            msg.add("xml", bytes.toString());
            resp.add((FoxTuple)msg);
        }
        return resp;
    }

    public EntitlementApi.EntitlementStatus fetchCertificates(String vendor) throws BajaException {
        NLicenseManager licenseManager = Nre.getLicenseManager();
        if (!(licenseManager instanceof SubscriptionLicenseManager)) {
            throw new BajaException("License Manager is not a Subscription License Manager");
        }
        RequestCertificates rc = new RequestCertificates();
        SubscriptionLicenseManager slm = (SubscriptionLicenseManager)licenseManager;
        return slm.updateCertificates(rc, vendor);
    }

    public InputStream read(BFoxFileStore store) throws Exception {
        FilePath path = store.getFilePath();
        if (this.isTraceOn()) {
            this.trace("c:read \"" + path.getBody() + "\"");
        }
        if (!path.getBody().startsWith(this.getCertificatesDirPath(true).getBody()) && !path.getBody().startsWith(this.getLicensesDirPath(true).getBody())) {
            return null;
        }
        FoxCircuit circuit = this.openCircuit("read");
        FoxMessage messageOut = new FoxMessage();
        messageOut.add("path", store.getFilePath().getBody());
        circuit.writeMessage(messageOut);
        circuit.flush();
        return circuit.getInputStream();
    }

    public void read(FoxCircuit circuit) throws Exception {
        FoxMessage messageIn = circuit.readMessage();
        FilePath path = new FilePath(messageIn.getString("path"));
        try {
            AccessController.doPrivileged(() -> {
                if (!path.getBody().startsWith(this.getCertificatesDirPath(false).getBody()) && !path.getBody().startsWith(this.getLicensesDirPath(false).getBody())) {
                    return null;
                }
                if (this.isTraceOn()) {
                    this.trace("s:read \"" + path.getBody() + "\"");
                }
                BIFile file = BFileSystem.INSTANCE.resolveFile(path);
                long size = file.getSize();
                InputStream in = file.getInputStream();
                OutputStream out = circuit.getOutputStream();
                try {
                    BajaFileUtil.pipe((InputStream)in, (long)size, (OutputStream)out);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                    try {
                        circuit.close();
                    }
                    catch (Exception exception) {}
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public OutputStream write(BFoxFileStore store) throws Exception {
        FilePath path = store.getFilePath();
        if (this.isTraceOn()) {
            this.trace("c:write \"" + path.getBody() + "\"");
        }
        if (!path.getBody().startsWith(this.getCertificatesDirPath(true).getBody()) && !path.getBody().startsWith(this.getLicensesDirPath(true).getBody())) {
            return null;
        }
        FoxCircuit circuit = this.openCircuit("write");
        FoxMessage messageOut = new FoxMessage();
        messageOut.add("path", path.getBody());
        messageOut.add("size", String.valueOf(store.getSize()));
        circuit.writeMessage(messageOut);
        circuit.flush();
        return circuit.getOutputStream();
    }

    public void write(FoxCircuit circuit) throws Exception {
        BLicensePlatformService lps = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)lps);
        if (!BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)lps).hasAdminInvoke()) {
            throw new PermissionException("insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
        }
        FoxMessage messageIn = circuit.readMessage();
        FilePath path = new FilePath(messageIn.getString("path"));
        long size = Long.parseLong(messageIn.getString("size"));
        try {
            AccessController.doPrivileged(() -> {
                if (!path.getBody().startsWith(this.getCertificatesDirPath(false).getBody()) && !path.getBody().startsWith(this.getLicensesDirPath(false).getBody())) {
                    return null;
                }
                if (this.isTraceOn()) {
                    this.trace("s:write \"" + path.getBody() + "\"");
                }
                BIFile file = BFileSystem.INSTANCE.makeFile(path);
                InputStream in = circuit.getInputStream();
                OutputStream out = file.getOutputStream();
                try {
                    BajaFileUtil.pipe((InputStream)in, (long)size, (OutputStream)out);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                    try {
                        circuit.close();
                    }
                    catch (Exception exception) {}
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public OutputStream delete(BFoxFileStore store) throws Exception {
        FilePath path = store.getFilePath();
        if (this.isTraceOn()) {
            this.trace("c:delete \"" + path.getBody() + "\"");
        }
        if (!path.getBody().startsWith(this.getCertificatesDirPath(true).getBody()) && !path.getBody().startsWith(this.getLicensesDirPath(true).getBody())) {
            return null;
        }
        FoxCircuit circuit = this.openCircuit("delete");
        FoxMessage messageOut = new FoxMessage();
        messageOut.add("path", path.getBody());
        circuit.writeMessage(messageOut);
        circuit.flush();
        return circuit.getOutputStream();
    }

    public void delete(FoxCircuit circuit) throws Exception {
        BLicensePlatformService lps = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)lps);
        if (!BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)lps).hasAdminInvoke()) {
            throw new PermissionException("insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
        }
        FoxMessage messageIn = circuit.readMessage();
        FilePath path = new FilePath(messageIn.getString("path"));
        try {
            AccessController.doPrivileged(() -> {
                if (!path.getBody().startsWith(this.getCertificatesDirPath(false).getBody()) && !path.getBody().startsWith(this.getLicensesDirPath(false).getBody())) {
                    return null;
                }
                if (this.isTraceOn()) {
                    this.trace("s:delete \"" + path.getBody() + "\"");
                }
                BFileSystem.INSTANCE.delete(path);
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    private FilePath getCertificatesDirPath(boolean isClient) {
        try {
            BSystemPlatformService plat = this.getSystemPlatformService(isClient);
            return SystemFilePaths.getCertificatesDirPath(true, plat.getHostIdStatus().isPerpetual(), plat.getIsNiagaraHomeReadonly());
        }
        catch (Exception e) {
            this.log.warning("Unable to resolve the certificates directory through the System Platform Service, using default directory.", (Throwable)e);
            return SystemFilePaths.getCertificatesDirPath(true);
        }
    }

    private FilePath getLicensesDirPath(boolean isClient) {
        try {
            BSystemPlatformService plat = this.getSystemPlatformService(isClient);
            return SystemFilePaths.getLicensesDirPath(true, plat.getHostIdStatus().isPerpetual(), plat.getIsNiagaraHomeReadonly());
        }
        catch (Exception e) {
            this.log.warning("Unable to resolve the licenses directory through the System Platform Service, using default directory.", (Throwable)e);
            return SystemFilePaths.getLicensesDirPath(true);
        }
    }

    private BSystemPlatformService getSystemPlatformService(boolean isClient) {
        if (isClient) {
            BFoxSession session = this.getFoxSession();
            return (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)session);
        }
        return (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
    }
}

