/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import javax.baja.sys.SlotCursor;

public class UpdateTcpIpAdapterMessage
extends XmlResponseMessage {
    private final StringBuilder path = new StringBuilder("tcpip?update=true");

    public UpdateTcpIpAdapterMessage(BTcpIpAdapterSettings settings) {
        SlotCursor c;
        this.path.append("&adapterId=").append(HttpUtil.encodeUrl((String)settings.getAdapterId()));
        this.path.append("&enabled=").append(settings.getIsAdapterEnabled());
        if (settings.getCanUseDhcp()) {
            this.path.append("&dhcpEnabled=").append(settings.getIsDhcpEnabled());
        }
        if (settings.getIsIpv6Supported()) {
            if (settings.getCanDisableIpv6()) {
                this.path.append("&ipv6Enabled=").append(settings.getIsIpv6Enabled());
            }
            if (settings.getCanUseIpv6Dhcp()) {
                this.path.append("&ipv6DhcpEnabled=").append(settings.getIsIpv6Enabled() && settings.getIsIpv6DhcpEnabled());
            }
        }
        if (!settings.getIsDhcpEnabled()) {
            this.path.append("&ipAddress=").append(HttpUtil.encodeUrl((String)settings.getIpAddress()));
            this.path.append("&subnetMask=").append(HttpUtil.encodeUrl((String)settings.getSubnetMask()));
            if (settings.getUsesAdapterLevelSettings()) {
                this.path.append("&defaultGateway=").append(HttpUtil.encodeUrl((String)settings.getDefaultGateway()));
                this.path.append("&domain=").append(HttpUtil.encodeUrl((String)settings.getDomain()));
                StringBuilder hostsString = new StringBuilder();
                c = settings.getDnsHosts().loadSlots().getProperties();
                while (c.next()) {
                    if (hostsString.length() > 0) {
                        hostsString.append("%2C");
                    }
                    hostsString.append(HttpUtil.encodeUrl((String)c.get().toString()));
                }
                this.path.append("&dnsHosts=").append((CharSequence)hostsString);
            }
        }
        if (settings.getIsIpv6Enabled() && !settings.getIsIpv6DhcpEnabled()) {
            this.path.append("&ipv6Address=").append(HttpUtil.encodeUrl((String)settings.getIpv6Address()));
            this.path.append("&ipv6SubnetPrefixLength=").append(settings.getIpv6SubnetPrefixLength());
            if (settings.getUsesAdapterLevelSettings()) {
                this.path.append("&ipv6DefaultGateway=").append(HttpUtil.encodeUrl((String)settings.getIpv6DefaultGateway()));
                StringBuilder ipv6HostsString = new StringBuilder();
                c = settings.getIpv6DnsHosts().loadSlots().getProperties();
                while (c.next()) {
                    if (ipv6HostsString.length() > 0) {
                        ipv6HostsString.append("%2C");
                    }
                    ipv6HostsString.append(HttpUtil.encodeUrl((String)c.get().toString()));
                }
                this.path.append("&ipv6DnsHosts=").append((CharSequence)ipv6HostsString);
            }
        }
    }

    @Override
    public String getMessageString() {
        return this.path.toString();
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }
}

