/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.message.EncryptableXmlResponseMessage;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.AccessController;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.security.BPassword;

public class UpdateSSLSettingsMessage
extends EncryptableXmlResponseMessage {
    private static final Pattern COMPILE = Pattern.compile(" ");
    private final StringBuilder path;
    private final BPlatformSSLSettings settings;

    public UpdateSSLSettingsMessage(BPlatformSSLSettings settings, boolean includeAlgorithm, SharedSecretKey sharedSecretKey) {
        this.settings = settings;
        try {
            this.path = new StringBuilder("updatedaemon");
            this.path.append("?sslEnabled=").append(settings.getSslEnabled()).append("&sslOnly=").append(settings.getSslOnly()).append("&sslPort=").append(settings.getSslPort()).append("&tlsCipherSuiteGroup=").append(settings.getTlsCipherSuiteGroup().getTag()).append("&tlsUseExtendedMasterSecret=").append(settings.getUseExtendedMasterSecret());
            if (includeAlgorithm) {
                this.path.append("&sslAlgType=").append(settings.getSslAlgType().getTag());
            }
            String alias = settings.getKeyAlias().toLowerCase(Locale.ENGLISH);
            try {
                alias = URLEncoder.encode(alias, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                alias = COMPILE.matcher(alias).replaceAll("");
            }
            this.path.append("&keyAlias=").append(alias);
            if (!settings.getKeyPassphrase().isDefault()) {
                this.sharedSecretKey = sharedSecretKey;
                BPassword keyPass = settings.getKeyPassphrase();
                String keyPassValue = AccessController.doPrivileged(() -> ((BPassword)keyPass).getValue());
                String keyPassStr = this.prepareMessage(keyPassValue);
                this.path.append("&keyPassphrase=").append(keyPassStr);
                this.path.append('&').append("sharedKeyName").append('=').append(sharedSecretKey.getName());
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getMessageString() {
        return this.path.toString();
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }

    public BPlatformSSLSettings getSettings() {
        return this.settings;
    }

    @Override
    public int getConnectionFlags() {
        return 12;
    }
}

