/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import java.util.Set;
import javax.baja.file.FilePath;

public class RenameFileTransferMessageElement
extends FileTransferMessageElement {
    int completed = 0;
    String newName;

    public RenameFileTransferMessageElement(FilePath currentPath, String newName, BDaemonFileSpace space) {
        super(currentPath, space);
        currentPath.merge(newName);
        this.newName = newName;
    }

    @Override
    public String getRequestMethod() {
        return "GET";
    }

    @Override
    public String getFullUri(FileTransferMessage msg, boolean first) {
        return super.getFullUri(msg, first) + "&rename=" + HttpUtil.encodeUrl((String)this.newName);
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public long getSizeDelta(BDaemonSession session, FileTransferMessage msg) {
        return 0L;
    }

    @Override
    public void initProgress() {
        this.completed = 0;
    }

    @Override
    public void updateProgress(int nWritten) {
        this.completed = 100;
    }

    @Override
    public int getProgress() {
        return this.completed;
    }

    @Override
    public void updateTransferInfo(Set<FilePath> removed, Set<FilePath> transferred) {
        FilePath newPath;
        if (!transferred.contains(this.getFilePath())) {
            removed.add(this.getFilePath());
        }
        if (!removed.contains(newPath = this.getFilePath().getParent().merge(this.newName))) {
            transferred.add(newPath);
        }
    }

    @Override
    protected String getProgressLexiconKey() {
        return "RenameFileTransferMessageElement.progress";
    }
}

