/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.FileTransferMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Set;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class FileTransferMessageElement {
    private static final BIcon icon = BIcon.std((String)"file.png");
    private static final Lexicon lex = Sys.loadModule((String)"platform").getLexicon();
    private InputStream stream;
    private long size;
    private long existingSize = -1L;
    private String shortUri;
    private long transferTotal;
    private long transferComplete;
    private FilePath path;
    private BDaemonFileSpace space;

    protected FileTransferMessageElement(FilePath pPath, BDaemonFileSpace space) {
        this.shortUri = space.filePathToUri(pPath);
        this.path = pPath;
        this.space = space;
    }

    public FileTransferMessageElement(FilePath path, InputStream pStream, long pSize, BDaemonFileSpace space) {
        this(path, space);
        this.stream = pStream;
        this.size = pSize;
    }

    public String getRequestMethod() {
        return "POST";
    }

    public String getFullUri(FileTransferMessage msg, boolean first) {
        StringBuilder result = new StringBuilder(this.getUri());
        if (msg.isAutoCommit()) {
            result.append("?transaction=standalone");
            if (msg.getPBEEncodingInfo() != null) {
                result.append("&encodingValidator=");
                result.append(msg.getPBEEncodingInfo().getEncodedValidator());
                result.append("&encodingIterationCount=");
                result.append(String.valueOf(msg.getPBEEncodingInfo().getEncodingIterationCount()));
                result.append("&encodingSalt=");
                result.append(msg.getPBEEncodingInfo().getEncodingSaltHex());
            }
        } else if (msg.getTransactionId() != null) {
            result.append("?transaction=current&transactionId=");
            result.append(msg.getTransactionId());
        } else if (first) {
            result.append("?transaction=new");
            if (msg.getPBEEncodingInfo() != null) {
                result.append("&encodingValidator=");
                result.append(msg.getPBEEncodingInfo().getEncodedValidator());
                result.append("&encodingIterationCount=");
                result.append(String.valueOf(msg.getPBEEncodingInfo().getEncodingIterationCount()));
                result.append("&encodingSalt=");
                result.append(msg.getPBEEncodingInfo().getEncodingSaltHex());
            }
        } else {
            throw new IllegalStateException("program error: missing transaction id");
        }
        return result.toString();
    }

    public String getUri() {
        return this.shortUri;
    }

    public FilePath getFilePath() {
        return this.path;
    }

    public InputStream getStream() throws IOException {
        return this.stream;
    }

    protected BDaemonFileSpace getDaemonFileSpace() {
        return this.space;
    }

    public long getSize() {
        return this.size;
    }

    public void initProgress() {
        this.transferComplete = 0L;
        this.transferTotal = this.getSize();
    }

    public void updateProgress(int nWritten) {
        this.transferComplete += (long)nWritten;
    }

    public int getProgress() {
        return this.transferTotal == 0L ? 100 : (int)(100.0 * (double)this.transferComplete / (double)this.transferTotal);
    }

    public void updateTransferInfo(Set<FilePath> removed, Set<FilePath> transferred) {
        removed.remove(this.getFilePath());
        transferred.add(this.getFilePath());
    }

    public BIcon getIcon() {
        return icon;
    }

    public String toString() {
        return this.getRequestMethod() + " " + this.getUri();
    }

    protected String getProgressLexiconKey() {
        return "FileTransferMessageElement.progress";
    }

    public String getProgressText() {
        return lex.getText(this.getProgressLexiconKey(), new Object[]{HttpUtil.decodeUrl((String)this.getUri())});
    }

    public long getSizeDelta(BDaemonSession session, FileTransferMessage msg) throws AuthenticationException, ConnectException {
        return this.getSize() - this.getExistingSize(session, msg);
    }

    public long getExistingSize(BDaemonSession session, FileTransferMessage msg) throws AuthenticationException, ConnectException {
        if (this.existingSize == -1L) {
            int cacheStatus = msg.getCache().getCacheStatus(this.getFilePath());
            if (cacheStatus == 0) {
                BIFileStore existingStore = msg.getCache().getStore(this.getFilePath());
                this.existingSize = existingStore.isDirectory() ? 0L : existingStore.getSize();
            } else if (cacheStatus == 1) {
                this.existingSize = 0L;
            }
            for (FilePath parent = this.getFilePath().getParent(); parent != null; parent = parent.getParent()) {
                if (msg.getCache().getCacheStatus(parent) != 1) continue;
                this.existingSize = 0L;
                msg.getCache().cacheNotFound(this.getFilePath());
                break;
            }
            if (this.existingSize < 0L) {
                BDaemonDirectoryStore existingParent = BDaemonDirectoryStore.make(session.getFileSpace(), this.getFilePath().getParent(), msg.getCache());
                if (existingParent == null) {
                    msg.getCache().cacheNotFound(this.getFilePath());
                    this.existingSize = 0L;
                } else {
                    BIFileStore existingStore = existingParent.getChild(this.getFilePath().getName());
                    this.existingSize = existingStore == null ? 0L : existingStore.getSize();
                }
            }
        }
        return this.existingSize;
    }
}

