/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.EncryptableXmlResponseMessage;
import java.security.AccessController;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.security.BPassword;
import javax.baja.sys.BajaRuntimeException;

public class AuthenticateUserMessage
extends EncryptableXmlResponseMessage {
    public static final int AUTH_USER_MESSAGE_TIMEOUT = Math.max(BDaemonSession.DEFAULT_TIMEOUT, 90000);
    public static final String AUTH_USER_MESSAGE_MIME_TYPE = "text/xml";
    private final String username;
    private final BPassword password;

    public AuthenticateUserMessage(String username, BPassword password, SharedSecretKey sharedSecretKey) {
        this.username = username;
        this.password = password;
        this.sharedSecretKey = sharedSecretKey;
    }

    @Override
    public String getMessageString() {
        try {
            return "auth?reqUsername=" + this.prepareMessage(this.username) + "&reqPassword=" + this.prepareMessage(AccessController.doPrivileged(() -> ((BPassword)this.password).getValue())) + "&" + "sharedKeyName" + "=" + this.sharedSecretKey.getName();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }
}

