/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.PlatformOperationListener;
import com.tridium.platform.daemon.message.DeleteStationMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import java.net.ConnectException;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFileSpace;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.platform.RemoteStation;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.LocalizableRuntimeException;

public class RemotePlatformStation
implements RemoteStation {
    private BStationSurrogate station;
    private static final Logger logger = Logger.getLogger("platform.remotePlatformStation");

    private RemotePlatformStation(BStationSurrogate station) {
        this.station = station;
    }

    @Override
    public BStationStatus getStatus() {
        return this.station.getStationStatus();
    }

    @Override
    public String getName() {
        return this.station.getStationName();
    }

    @Override
    public BOrd getFoxOrd() {
        return this.station.getFoxOrd();
    }

    @Override
    public void poll() throws Exception {
        this.station.poll();
    }

    @Override
    public boolean canStart() throws Exception {
        this.poll();
        if (this.station.isStationRunning()) {
            return false;
        }
        if (!(this.canRestart() || this.station.getStationStatus() != BStationStatus.halted && this.station.getStationStatus() != BStationStatus.failed)) {
            return false;
        }
        System.out.println("canRestart = " + this.canRestart());
        System.out.println("status = " + (Object)((Object)this.station.getStationStatus()));
        return true;
    }

    @Override
    public void start(IPlatformOperationListener listener) throws Exception {
        this.poll();
        if (!(this.station.isStationRunning() || this.canRestart() || this.station.getStationStatus() != BStationStatus.halted && this.station.getStationStatus() != BStationStatus.failed)) {
            throw new LocalizableRuntimeException("platform", "RemotePlatformStation.cannotStartHalted");
        }
        PlatformOperationListener l = new PlatformOperationListener(listener);
        this.station.startStation(l, l);
    }

    @Override
    public void startAsync() throws Exception {
        this.poll();
        if (this.station.isStationRunning()) {
            throw new LocalizableRuntimeException("platform", "RemotePlatformStation.stationRunning");
        }
        if (!(this.canRestart() || this.station.getStationStatus() != BStationStatus.halted && this.station.getStationStatus() != BStationStatus.failed)) {
            throw new LocalizableRuntimeException("platform", "RemotePlatformStation.cannotStartHalted");
        }
        this.station.startStationAsync();
    }

    @Override
    public void saveAsync() throws ConnectException, AuthenticationException {
        this.station.saveStationAsync();
    }

    @Override
    public void save(IPlatformOperationListener listener) throws ConnectException, AuthenticationException {
        PlatformOperationListener l = new PlatformOperationListener(listener);
        this.station.saveStation(l, l);
    }

    @Override
    public void rename(String newName, IPlatformOperationListener listener) throws Exception {
        logger.fine(() -> String.format("Renaming station %s to %s", this.station.getStationName(), newName));
        PlatformOperationListener l = new PlatformOperationListener(listener);
        BDaemonSession session = this.station.getDaemonSession();
        boolean restart = false;
        UpdateStationMessage updateMsg = new UpdateStationMessage(newName, false, this.station.getIsAutoStart(), this.station.getIsAutoRestart(), true);
        DeleteStationMessage deleteMsg = new DeleteStationMessage(this.station.getStationName());
        if (this.station.isStationRunning()) {
            restart = this.station.isRestartEnabled();
            logger.fine(() -> String.format("Stopping running station %s, restart enabled = %b", this.station.getStationName(), this.station.isRestartEnabled()));
            this.station.stopStation(l, l);
        }
        FilePath stationPath = SystemFilePaths.getStationsDirPath((BIFileSpace)session.getFileSpace()).merge(this.station.getStationName());
        logger.fine(() -> String.format("Sending rename message for path %s", stationPath.toString()));
        DaemonFileUtil.transfer(session, FileTransferMessage.makeRename(stationPath, newName, session.getFileSpace()), null, l);
        logger.fine(() -> String.format("Sending DeleteStationMessage for old station", new Object[0]));
        session.sendMessage(deleteMsg);
        logger.fine(() -> String.format("Requesting niagarad to reload its station list", new Object[0]));
        session.sendMessage(new UpdateStationMessage());
        session.sendMessage(updateMsg);
        this.station = BStationSurrogate.make(session, newName);
        if (restart) {
            logger.fine(() -> String.format("Restarting station %s", newName));
            this.station.startStation(l, l);
        }
        logger.fine(() -> String.format("Rename of station %s to %s complete", this.station.getStationName(), newName));
    }

    @Override
    public void stopAsync() throws ConnectException, AuthenticationException {
        this.station.stopStationAsync();
    }

    @Override
    public void stop(IPlatformOperationListener listener) throws ConnectException, AuthenticationException {
        PlatformOperationListener l = new PlatformOperationListener(listener);
        this.station.stopStation(l, l);
    }

    @Override
    public boolean canRestart() throws Exception {
        return this.station.isRestartEnabled();
    }

    @Override
    public void restartAsync() throws Exception {
        if (!this.canRestart()) {
            throw new LocalizableRuntimeException("platform", "RemotePlatformStation.restartNotAllowed");
        }
        this.station.restartStationAsync();
    }

    @Override
    public void killAsync() throws ConnectException, AuthenticationException {
        this.station.killStationAsync();
    }

    @Override
    public void delete(IPlatformOperationListener listener) throws ConnectException, AuthenticationException {
        PlatformOperationListener l = new PlatformOperationListener(listener);
        this.station.deleteStation(l, l);
    }

    @Override
    public void makeLocalCopy(BDirectory localDir, IPlatformOperationListener listener) throws Exception {
        PlatformOperationListener l = new PlatformOperationListener(listener);
        this.station.makeStationCopy(localDir, l);
    }

    @Override
    public void updateStationCertAlias(String alias) throws ConnectException {
        this.station.updateStationCertAlias(alias);
    }

    @Override
    public void updateStationTlsVersion(String tlsVersion) throws ConnectException {
        this.station.updateStationTlsVersion(tlsVersion);
    }

    private static RemoteStation[] array(BStationSurrogate[] stations) {
        RemoteStation[] result = new RemoteStation[stations.length];
        for (int i = 0; i < stations.length; ++i) {
            result[i] = new RemotePlatformStation(stations[i]);
        }
        return result;
    }

    public static RemoteStation[] getAllStations(BDaemonSession daemonSession) throws Exception {
        return RemotePlatformStation.array(BStationSurrogate.makeAll(daemonSession));
    }

    public static RemoteStation getStation(BDaemonSession daemonSession, String stationName) throws Exception {
        return new RemotePlatformStation(BStationSurrogate.make(daemonSession, stationName));
    }

    public static RemoteStation[] stopAllStations(BDaemonSession daemonSession, IPlatformOperationListener listener) throws Exception {
        PlatformOperationListener l = new PlatformOperationListener(listener);
        return RemotePlatformStation.array(BStationSurrogate.stopAllStations(daemonSession, l, l));
    }
}

