/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.BDaemonSession;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.baja.file.BIFile;
import javax.baja.job.BJob;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.BackupManager;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.platform.PlatformDaemon;
import javax.baja.platform.RemoteStation;
import javax.baja.sys.Sys;

public class PlatformBackupManager
implements BackupManager {
    private PlatformDaemon daemon;

    private PlatformBackupManager(BDaemonSession session, PlatformDaemon daemon) {
        this.daemon = daemon;
    }

    public static PlatformBackupManager make(BDaemonSession session, PlatformDaemon daemon) {
        return new PlatformBackupManager(session, daemon);
    }

    @Override
    public void backup(BIFile backupFile, IPlatformOperationListener listener) throws Exception {
        RemoteStation[] stations;
        for (RemoteStation station : stations = this.daemon.getStationManager().getAllStations()) {
            if (station.getStatus() != BStationStatus.starting && station.getStatus() != BStationStatus.stopping && station.getStatus() != BStationStatus.running && station.getStatus() != BStationStatus.unknown) continue;
            throw new IllegalStateException("Cannot make offline backup while a station is running");
        }
        Class svc = Sys.loadClass((String)"backup", (String)"javax.baja.backup.BBackupService");
        Object instance = svc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Method zip = svc.getDeclaredMethod("zip", BJob.class, PlatformDaemon.class, OutputStream.class, Boolean.TYPE);
        zip.invoke(instance, null, this.daemon, backupFile.getOutputStream(), Boolean.TRUE);
    }
}

