/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.NiagaraLicenseManager;
import com.tridium.platform.daemon.PlatformBackupManager;
import com.tridium.platform.daemon.PlatformFileManager;
import com.tridium.platform.daemon.PlatformInstallManager;
import com.tridium.platform.daemon.PlatformSecurityManager;
import com.tridium.platform.daemon.PlatformStationManager;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.lang.reflect.Method;
import javax.baja.naming.BHost;
import javax.baja.platform.BackupManager;
import javax.baja.platform.DaemonSecurityManager;
import javax.baja.platform.FileManager;
import javax.baja.platform.InstallManager;
import javax.baja.platform.PlatformDaemon;
import javax.baja.platform.PlatformLicenseManager;
import javax.baja.platform.StationManager;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;

public class NiagaraPlatformDaemon
extends PlatformDaemon {
    private BDaemonSession daemonSession;
    private PlatformStationManager stationManager;
    private PlatformFileManager fileManager;
    private PlatformSecurityManager securityManager;
    private PlatformBackupManager backupManager;
    private InstallManager installManager;
    private NiagaraLicenseManager licenseManager;
    private BRemoteDaemonPlatform platform = null;

    private NiagaraPlatformDaemon(BHost host, int port, boolean secure, BUsernameAndPassword credentials) throws Exception {
        if (secure) {
            Class typeClass;
            try {
                typeClass = Sys.getType((String)"platCrypto:DaemonSecureSession").getTypeClass();
            }
            catch (Exception e) {
                throw new BajaRuntimeException("Cannot make secure connection without platCrypto-se installed");
            }
            Method make = typeClass.getMethod("make", BHost.class, Integer.TYPE);
            this.daemonSession = (BDaemonSession)((Object)make.invoke((Object)typeClass, host, port));
        } else {
            this.daemonSession = BDaemonSession.make(host, port);
        }
        this.daemonSession.setCredentials((BICredentials)credentials, true);
        this.daemonSession.connect();
        this.daemonSession.reloadHostProperties();
        this.stationManager = PlatformStationManager.make(this.daemonSession);
        this.fileManager = PlatformFileManager.make(this.daemonSession);
        this.installManager = PlatformInstallManager.make(this.daemonSession);
        this.securityManager = PlatformSecurityManager.make(this.daemonSession);
        this.backupManager = PlatformBackupManager.make(this.daemonSession, this);
        this.licenseManager = NiagaraLicenseManager.make(this.daemonSession);
    }

    private NiagaraPlatformDaemon(BRemoteDaemonPlatform platform) {
        this.platform = platform;
        this.daemonSession = platform.getDaemonSession();
        this.stationManager = PlatformStationManager.make(this.daemonSession);
        this.fileManager = PlatformFileManager.make(this.daemonSession);
        this.installManager = PlatformInstallManager.make(this.daemonSession);
        this.securityManager = PlatformSecurityManager.make(this.daemonSession);
        this.backupManager = PlatformBackupManager.make(this.daemonSession, this);
        this.licenseManager = NiagaraLicenseManager.make(this.daemonSession);
    }

    public static PlatformDaemon make(BHost host, int port, boolean secure, BUsernameAndPassword credentials) throws Exception {
        return new NiagaraPlatformDaemon(host, port, secure, credentials);
    }

    public static PlatformDaemon make(BHost host, int port, BUsernameAndPassword credentials) throws Exception {
        return NiagaraPlatformDaemon.make(host, port, port != 3011, credentials);
    }

    public static NiagaraPlatformDaemon make(BRemoteDaemonPlatform platform) {
        return new NiagaraPlatformDaemon(platform);
    }

    public static NiagaraPlatformDaemon make(BDaemonSession session, DaemonSessionTaskListener listener) throws Exception {
        BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make(session, listener);
        return new NiagaraPlatformDaemon(platform);
    }

    @Override
    public StationManager getStationManager() {
        return this.stationManager;
    }

    @Override
    public FileManager getFileManager() {
        return this.fileManager;
    }

    @Override
    public InstallManager getInstallManager() {
        return this.installManager;
    }

    @Override
    public DaemonSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public PlatformLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    @Override
    public BackupManager getOfflineBackupManager() throws Exception {
        return this.backupManager;
    }

    @Override
    public void close() throws Exception {
        this.daemonSession.close();
    }

    public BRemoteDaemonPlatform getDaemonPlatform(DaemonSessionTaskListener listener) throws Exception {
        if (this.platform == null) {
            this.platform = BRemoteDaemonPlatform.make(this.daemonSession, listener);
        }
        return this.platform;
    }

    @Override
    public boolean isNiagara4Platform() throws Exception {
        return this.daemonSession.getHostProperties().isNiagara4();
    }
}

