/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.Authenticator;
import com.tridium.platform.daemon.BDaemonSession;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import javax.baja.naming.BHost;
import javax.baja.net.HttpConnection;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;

@Deprecated
public class DigestAuthenticator
extends Authenticator {
    private static Random clientRandom;
    private final BHost host;
    private final int port;
    private int nc;
    private final String realm;
    private boolean finalAuthorizationSet = false;

    DigestAuthenticator(BHost host, int port, BUsernameAndPassword credentials, String realm) {
        this(host, port, realm);
        this.setCredentials((BICredentials)credentials);
    }

    DigestAuthenticator(BHost host, int port, String realm) {
        this.host = host;
        this.port = port;
        this.realm = realm;
    }

    public BHost getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuthenticationScheme() {
        return "HTTP-Digest";
    }

    @Override
    public boolean setAuthorization(HttpConnection conn, String uri) throws IOException {
        Properties fields = DigestAuthenticator.parseHeader(conn, "WWW-Authenticate");
        return this.setAuthorization(conn, uri, fields);
    }

    @Override
    public boolean setAuthorization(HttpConnection conn, String uri, Properties fields) throws IOException {
        if (fields == null) {
            return false;
        }
        String realm = fields.getProperty("realm");
        String nonce = fields.getProperty("nonce");
        String qop = fields.getProperty("qop");
        if (nonce == null || this.getUserAndPwd() == null) {
            return false;
        }
        ++this.nc;
        String cnonce = this.getCnonce();
        StringBuilder response = new StringBuilder();
        response.append("Digest username=").append(DigestAuthenticator.quote(this.getUserAndPwd().getUsername())).append(", ");
        response.append("realm=").append(DigestAuthenticator.quote(realm)).append(", ");
        response.append("nonce=").append(DigestAuthenticator.quote(nonce)).append(", ");
        response.append("uri=").append(DigestAuthenticator.quote(uri)).append(", ");
        response.append("nc=").append(this.nc).append(", ");
        response.append("qop=").append(DigestAuthenticator.unquote(qop)).append(", ");
        response.append("cnonce=\"").append(cnonce).append("\", ");
        response.append("response=\"");
        response.append(this.hexMD5(this.hexMD5(DigestAuthenticator.unquote(this.getUserAndPwd().getUsername()) + ':' + DigestAuthenticator.unquote(realm) + ':' + AccessController.doPrivileged(() -> ((BPassword)this.getUserAndPwd().getPassword()).getValue())) + ':' + DigestAuthenticator.unquote(nonce) + ':' + this.nc + ':' + cnonce + ':' + DigestAuthenticator.unquote(qop) + ':' + this.hexMD5(conn.getRequestMethod() + ":" + uri)));
        response.append("\"");
        conn.setRequestHeader("Authorization", response.toString());
        this.finalAuthorizationSet = true;
        return true;
    }

    @Override
    public boolean finalAuthorizationSet() {
        return this.finalAuthorizationSet;
    }

    @Override
    public String getAuthenticationFailureMessage() {
        return null;
    }

    public String getAuthenticationRealmName() {
        return this.realm;
    }

    @Override
    public boolean canReuseAuthorizationHeader() {
        return true;
    }

    private String getCnonce() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            out.writeUTF("cnonce");
            out.writeInt(this.nc);
            out.writeUTF(this.host.getHostname());
            out.writeInt(this.port);
            out.writeLong(System.currentTimeMillis());
            out.writeInt(clientRandom.nextInt());
            return this.hexMD5(new String(bout.toByteArray()));
        }
        catch (Exception e) {
            BDaemonSession.log.log(Level.SEVERE, "error creating cnonce", e);
            return "xyzzy";
        }
    }

    static {
        try {
            clientRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            clientRandom = new SecureRandom();
        }
        long millis = System.currentTimeMillis();
        BDaemonSession.log.log(Level.FINE, "digest authenticator starting RNG seed...");
        clientRandom.nextInt();
        BDaemonSession.log.log(Level.FINE, "digest authenticator completed RNG seed [" + (System.currentTimeMillis() - millis) + " ms]");
    }
}

