/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.message.GetTimeMessage;
import com.tridium.platform.daemon.message.UpdateTimeMessage;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.timezone.TzJarUtil;
import com.tridium.timezone.TzXmlDecoder;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.logging.Logger;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.timezone.TimeZoneException;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class DaemonTimeUtil {
    private static final Logger logger = Logger.getLogger("daemon.timeUtil");

    public static BAbsTime getLocalTime(BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        return DaemonTimeUtil.getLocalTime(daemonSession, (BTimeZone)null, null);
    }

    public static BAbsTime getLocalTime(BDaemonSession daemonSession, BTimeZone localCurrent, BTimeZone[] localAll) throws ConnectException, AuthenticationException {
        XElem currentTimeElem = DaemonTimeUtil.getCurrentTimeElem(daemonSession);
        return DaemonTimeUtil.getLocalTime(daemonSession, currentTimeElem, localCurrent, localAll);
    }

    public static BAbsTime getLocalTime(BDaemonSession daemonSession, XElem currentTimeElem, BTimeZone localCurrent, BTimeZone[] localAll) throws ConnectException, AuthenticationException {
        if (localCurrent == null) {
            if (localAll == null) {
                localAll = DaemonTimeUtil.getLocalTimeZones(daemonSession);
            }
            localCurrent = DaemonTimeUtil.getLocalTimeZone(currentTimeElem, localAll);
        }
        return DaemonTimeUtil.getLocalTime(daemonSession, currentTimeElem, localCurrent);
    }

    private static BAbsTime getLocalTime(BDaemonSession daemonSession, XElem currentTimeElem, BTimeZone tz) throws ConnectException, AuthenticationException {
        if (currentTimeElem == null) {
            return null;
        }
        if (currentTimeElem.get("millis", null) == null) {
            return BAbsTime.make((int)currentTimeElem.geti("year"), (BMonth)BMonth.make((int)currentTimeElem.geti("month")), (int)currentTimeElem.geti("day"), (int)currentTimeElem.geti("hour"), (int)currentTimeElem.geti("minute"), (int)currentTimeElem.geti("second"), (int)0, (BTimeZone)tz);
        }
        return BAbsTime.make((long)currentTimeElem.getl("millis"), (BTimeZone)tz);
    }

    public static BTimeZone getEquivalentTimeZone(BTimeZone zone, BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        return DaemonTimeUtil.getEquivalentTimeZone(zone, DaemonTimeUtil.getLocalTimeZones(daemonSession));
    }

    public static BTimeZone getEquivalentTimeZone(BTimeZone zone, BTimeZone[] zones) {
        if (zones == null) {
            return null;
        }
        try {
            BTimeZone result = null;
            if (zone.getId().equals("STD")) {
                zone = BTimeZone.UTC;
            }
            for (BTimeZone zone1 : zones) {
                if (!TimeZoneUtil.isEquivalent(zone, zone1)) continue;
                if (zone.getId().equals(zone1.getId())) {
                    return zone1;
                }
                if (result != null) continue;
                result = zone1;
            }
            return result;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static BTimeZone getLocalTimeZone(BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        return DaemonTimeUtil.getLocalTimeZone(daemonSession, DaemonTimeUtil.getLocalTimeZones(daemonSession));
    }

    public static XElem getCurrentTimeElem(BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        try {
            InputStream stream = daemonSession.getInputStream(GetTimeMessage.getInstance());
            if (stream == null) {
                return null;
            }
            return XParser.make((InputStream)stream).parse();
        }
        catch (RuntimeException | ConnectException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static BTimeZone getLocalTimeZone(BDaemonSession daemonSession, BTimeZone[] remoteZones) throws ConnectException, AuthenticationException {
        return DaemonTimeUtil.getLocalTimeZone(DaemonTimeUtil.getCurrentTimeElem(daemonSession), remoteZones);
    }

    public static BTimeZone getOsTimeZone(BDaemonSession daemonSession) throws Exception {
        XElem currentTimeElem = DaemonTimeUtil.getCurrentTimeElem(daemonSession);
        if (currentTimeElem == null) {
            return null;
        }
        return DaemonTimeUtil.getOsTimeZone(currentTimeElem);
    }

    public static BTimeZone getOsTimeZone(XElem currentTimeElem) throws Exception {
        if (currentTimeElem == null) {
            return null;
        }
        XElem nativeZoneElem = currentTimeElem.elem("zone");
        if (nativeZoneElem == null) {
            return null;
        }
        try {
            return TzXmlDecoder.getTimeZone((XElem)nativeZoneElem, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BTimeZone.UTC;
        }
    }

    public static BTimeZone getLocalTimeZone(XElem currentTimeElem, BTimeZone[] remoteZones) throws ConnectException, AuthenticationException {
        BTimeZone nativeZone;
        XElem nativeZoneElem;
        if (currentTimeElem == null) {
            return null;
        }
        String nativeZoneId = currentTimeElem.get("timeZone", "UTC");
        if (nativeZoneId.trim().length() > 0 && remoteZones != null) {
            for (BTimeZone remoteZone1 : remoteZones) {
                if (!remoteZone1.getId().equals(nativeZoneId)) continue;
                return remoteZone1;
            }
            try {
                BTimeZone localDefinition = BTimeZone.getTimeZone((String)nativeZoneId);
                if (localDefinition != null) {
                    if (TimeZoneUtil.isEquivalent(localDefinition, BTimeZone.UTC)) {
                        return BTimeZone.UTC;
                    }
                    for (BTimeZone remoteZone : remoteZones) {
                        if (!TimeZoneUtil.isEquivalent(remoteZone, localDefinition)) continue;
                        return remoteZone;
                    }
                    return localDefinition;
                }
            }
            catch (TimeZoneException localDefinition) {
                // empty catch block
            }
        }
        if ((nativeZoneElem = currentTimeElem.elem("zone")) == null) {
            return BTimeZone.UTC;
        }
        try {
            nativeZone = TzXmlDecoder.getTimeZone((XElem)nativeZoneElem, (boolean)false);
            if (nativeZone.getId().equals("STD") || nativeZone.getId().equals("DST")) {
                if (TimeZoneUtil.isEquivalent(nativeZone, BTimeZone.UTC)) {
                    nativeZone = BTimeZone.UTC;
                } else if (TimeZoneUtil.isEquivalent(nativeZone, BTimeZone.getLocal())) {
                    nativeZone = BTimeZone.getLocal();
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        if (remoteZones != null) {
            BTimeZone result = null;
            for (BTimeZone remoteZone : remoteZones) {
                if (!TimeZoneUtil.isEquivalent(remoteZone, nativeZone)) continue;
                if (remoteZone.getId().equals(nativeZone.getId())) {
                    return remoteZone;
                }
                result = remoteZone;
            }
            if (result != null) {
                return result;
            }
        }
        return BTimeZone.UTC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BTimeZone[] getLocalTimeZones(BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        try {
            Array results = new Array(BTimeZone.class);
            if (daemonSession.getHostProperties().isNiagara4()) {
                Object[] zones = TimeZoneDatabase.get().getTimeZones();
                results.addAll(zones);
                results = results.sort(BTimeZone.OFFSET_COMPARATOR);
                return (BTimeZone[])results.trim();
            }
            BDaemonFileStore jarStore = new BDaemonFileStore(daemonSession.getFileSpace(), new FilePath("!lib/timezones.jar"));
            InputStream jarStream = null;
            jarStream = jarStore.getInputStream();
            if (jarStream == null) {
                BDaemonFileStore xmlStore = new BDaemonFileStore(daemonSession.getFileSpace(), new FilePath("!lib/timezones.xml"));
                InputStream xmlStream = null;
                try {
                    XElem[] timeZoneElems;
                    xmlStream = xmlStore.getInputStream();
                    if (xmlStream == null) {
                        logger.warning("unable to determine remote time zones, returning remote OS time zone");
                        BTimeZone[] bTimeZoneArray = new BTimeZone[]{DaemonTimeUtil.getOsTimeZone(daemonSession)};
                        return bTimeZoneArray;
                    }
                    XElem root = XParser.make((InputStream)xmlStream).parse();
                    for (XElem timeZoneElem : timeZoneElems = root.elems("zone")) {
                        String zoneId = timeZoneElem.get("id");
                        if (TimeZoneDatabase.isZoneIdSupported((String)zoneId)) {
                            results.add((Object)BTimeZone.getTimeZone((String)zoneId));
                            continue;
                        }
                        logger.warning("remote time zone \"" + zoneId + "\" is not supported locally, ignoring");
                    }
                    results = results.sort(BTimeZone.OFFSET_COMPARATOR);
                    XElem[] xElemArray = (BTimeZone[])results.trim();
                    return xElemArray;
                }
                finally {
                    try {
                        xmlStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            results.addAll(TzJarUtil.getTimeZones((InputStream)jarStream));
            results = results.sort(BTimeZone.OFFSET_COMPARATOR);
            return (BTimeZone[])results.trim();
            finally {
                try {
                    jarStream.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (RuntimeException | ConnectException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static boolean isSystemTimeReadonly(BDaemonSession daemonSession) throws ConnectException, AuthenticationException {
        XElem currentTimeElem = DaemonTimeUtil.getCurrentTimeElem(daemonSession);
        if (currentTimeElem == null) {
            return daemonSession.getHostProperties().hasFullAccess();
        }
        return DaemonTimeUtil.isSystemTimeReadonly(daemonSession, currentTimeElem);
    }

    public static boolean isSystemTimeReadonly(BDaemonSession daemonSession, XElem currentTimeElem) throws AuthenticationException {
        if (currentTimeElem == null) {
            return false;
        }
        return currentTimeElem.getb("readonly", daemonSession.getHostProperties().hasFullAccess());
    }

    public static void updateLocalTime(BDaemonSession daemonSession, BAbsTime time, String bajaTzId, BTimeZone osTimeZone) throws ConnectException, AuthenticationException {
        BHostProperties hostProperties = daemonSession.getHostProperties();
        daemonSession.sendMessage(new UpdateTimeMessage(time, bajaTzId, TimeZoneUtil.makeCompatible(time.getMillis(), osTimeZone, hostProperties.getTimezoneDayModeSupport()), !hostProperties.isNiagara4()));
    }
}

