/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleInputStream
extends InputStream {
    private InputStream in;
    private final boolean isWebSocket;
    private final byte[] buf = new byte[8192];
    private int bufSize = 0;
    private int pendingRead = 0;
    private int nextRead = 0;
    public static Logger log = Logger.getLogger("platform.console");

    public static ConsoleInputStream make(InputStream in) {
        return ConsoleInputStream.make(in, false);
    }

    public static ConsoleInputStream make(InputStream in, boolean isWebSocket) {
        return in == null ? null : new ConsoleInputStream(in, isWebSocket);
    }

    private ConsoleInputStream(InputStream in, boolean isWebSocket) {
        this.in = in;
        this.isWebSocket = isWebSocket;
    }

    private boolean isWebSocket() {
        return this.isWebSocket;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }

    @Override
    public long skip(long len) throws IOException {
        if (this.in == null) {
            throw new IOException("skip() on closed stream");
        }
        if (this.isWebSocket) {
            return this.in.skip(len);
        }
        if (!this.checkBuffer()) {
            return 0L;
        }
        int avail = this.bufSize - this.nextRead;
        int toSkip = len <= (long)avail ? (int)len : avail;
        this.nextRead += toSkip;
        return toSkip;
    }

    @Override
    public int read(byte[] outBuf) throws IOException {
        return this.read(outBuf, 0, outBuf.length);
    }

    @Override
    public int read(byte[] outBuf, int offset, int len) throws IOException {
        int avail;
        if (this.in == null) {
            throw new IOException("read() on closed stream");
        }
        if (this.isWebSocket) {
            return this.in.read(outBuf, offset, len);
        }
        if (!this.checkBuffer()) {
            ConsoleInputStream.throwEOFException("Error in checkBuffer");
        }
        int toRead = len <= (avail = this.bufSize - this.nextRead) ? len : avail;
        System.arraycopy(this.buf, this.nextRead, outBuf, offset, toRead);
        this.nextRead += toRead;
        return toRead;
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            throw new IOException("read() on closed stream");
        }
        if (this.isWebSocket) {
            return this.in.read();
        }
        if (!this.checkBuffer()) {
            return -1;
        }
        int result = this.buf[this.nextRead] & 0xFF;
        ++this.nextRead;
        return result;
    }

    private boolean checkBuffer() throws IOException {
        if (this.in == null) {
            throw new IOException("Called checkBuffer() on closed stream");
        }
        if (this.isWebSocket) {
            return true;
        }
        while (this.nextRead >= this.bufSize) {
            if (this.pendingRead == 0) {
                int b = this.in.read();
                if (b == -1) {
                    ConsoleInputStream.throwEOFException("invalid buflength byte 0");
                }
                this.pendingRead = b << 24;
                try {
                    b = this.in.read();
                    if (b == -1) {
                        ConsoleInputStream.throwEOFException("invalid buflength byte 1");
                    }
                    this.pendingRead += b << 16;
                    b = this.in.read();
                    if (b == -1) {
                        ConsoleInputStream.throwEOFException("invalid buflength byte 2");
                    }
                    this.pendingRead += b << 8;
                    b = this.in.read();
                    if (b == -1) {
                        ConsoleInputStream.throwEOFException("invalid buflength byte 3");
                    }
                    this.pendingRead += b << 0;
                }
                catch (InterruptedIOException ste) {
                    this.pendingRead = 0;
                    throw new IOException("Timeout while reading buffer size");
                }
            }
            if (this.pendingRead > 8192) {
                this.bufSize = 0;
                this.nextRead = 0;
                this.pendingRead = 0;
                throw new IOException("Improper buffer size (" + this.bufSize + "), stream probably corrupt");
            }
            if (this.pendingRead > 0) {
                this.bufSize = this.in.read(this.buf, 0, this.pendingRead);
                if (this.bufSize < 0) {
                    this.bufSize = 0;
                    this.nextRead = 0;
                    return false;
                }
                this.pendingRead -= this.bufSize;
                this.nextRead = 0;
                return true;
            }
            if (this.pendingRead >= 0) continue;
            this.bufSize = 0;
            this.nextRead = 0;
            throw new IOException("Improper buffer size, stream probably corrupt");
        }
        return true;
    }

    private static void throwEOFException(String traceMessage) throws EOFException {
        EOFException e = new EOFException();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, traceMessage, e);
        }
        throw e;
    }
}

