/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.nre.security.EncryptionAlgorithmBundle;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BasicAuthenticator;
import com.tridium.platform.daemon.DigestAuthenticator;
import com.tridium.platform.daemon.ScramAuthenticator;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.baja.naming.BHost;
import javax.baja.net.HttpConnection;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;

public abstract class Authenticator
implements AuthenticationRealm {
    protected BUsernameAndPassword credentials;

    public static Authenticator make(BHost host, int port, String defaultRealm, HttpConnection conn) {
        return Authenticator.make(null, host, port, defaultRealm, conn);
    }

    public static Authenticator make(Authenticator auth, BHost host, int port, String defaultRealm, HttpConnection conn) {
        Properties wwwAuth = Authenticator.parseHeader(conn, "WWW-Authenticate");
        if (wwwAuth == null) {
            return null;
        }
        Authenticator result = auth;
        String authScheme = wwwAuth.getProperty("0");
        String realm = Authenticator.unquote(wwwAuth.getProperty("realm", defaultRealm));
        if (realm.equals("Niagara-Admin")) {
            realm = defaultRealm;
        }
        if (authScheme.equalsIgnoreCase("digest")) {
            if (result == null || !(result instanceof DigestAuthenticator)) {
                result = new DigestAuthenticator(host, port, realm);
            } else {
                DigestAuthenticator da = (DigestAuthenticator)result;
                if (!da.getHost().getAbsoluteOrd().equals((Object)host.getAbsoluteOrd()) || da.getPort() != port) {
                    result = new DigestAuthenticator(host, port, realm);
                }
            }
        } else if (authScheme.equalsIgnoreCase("basic")) {
            if (result == null || !(result instanceof BasicAuthenticator)) {
                result = new BasicAuthenticator(realm);
            }
        } else if (authScheme.equalsIgnoreCase("scram-sha512") || authScheme.equalsIgnoreCase("scram-glibc-sha256") || authScheme.equalsIgnoreCase("scram-glibc-sha512")) {
            if (result == null || !(result instanceof ScramAuthenticator)) {
                result = new ScramAuthenticator(realm, authScheme);
            }
            ((ScramAuthenticator)result).reset();
        } else {
            throw new IllegalArgumentException("Unsupported auth scheme: " + authScheme);
        }
        return result;
    }

    public abstract boolean setAuthorization(HttpConnection var1, String var2) throws IOException;

    public abstract boolean setAuthorization(HttpConnection var1, String var2, Properties var3) throws IOException;

    public abstract boolean finalAuthorizationSet();

    public abstract boolean canReuseAuthorizationHeader();

    public abstract String getAuthenticationFailureMessage();

    public boolean hasCredentials() {
        return this.credentials != null && this.credentials.getPassword() != null && this.credentials.getUsername() != null && !this.credentials.getUsername().equals("");
    }

    protected BUsernameAndPassword getUserAndPwd() {
        return (BUsernameAndPassword)this.getCredentials();
    }

    public void setCredentials(BICredentials value) {
        this.credentials = (BUsernameAndPassword)value;
    }

    public BICredentials getCredentials() {
        if (this.hasCredentials()) {
            return this.credentials;
        }
        return null;
    }

    public BICredentials makeCredentials() {
        return new BUsernameAndPassword();
    }

    protected String hexMD5(String in) {
        StringBuilder result = new StringBuilder();
        try {
            byte[] bytesToHash;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            for (byte byteToHash : bytesToHash = md5.digest(in.getBytes())) {
                result.append(TextUtil.toLowerCase((String)TextUtil.byteToHexString((int)byteToHash)));
            }
        }
        catch (Exception e) {
            BDaemonSession.log.log(Level.SEVERE, "error creating digest", e);
        }
        return result.toString();
    }

    protected static String quote(String in) {
        if (in.length() == 0) {
            return "\"\"";
        }
        if (in.charAt(0) == '\"') {
            return in;
        }
        return '\"' + in + '\"';
    }

    protected static String unquote(String in) {
        if (in.length() == 0) {
            return in;
        }
        StringBuilder result = new StringBuilder(in);
        if (result.charAt(0) == '\"') {
            result.deleteCharAt(0);
        }
        if (result.charAt(result.length() - 1) == '\"') {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    protected static Properties parseHeader(HttpConnection conn, String headerName) {
        String authHeader = conn.getResponseHeader(headerName);
        if (authHeader == null) {
            return null;
        }
        return Authenticator.parseHeader(authHeader, "Set-Cookie".equalsIgnoreCase(headerName));
    }

    private static Properties parseHeader(String header, boolean cookies) {
        Properties fields = new Properties();
        int namelessCount = 0;
        String delimiters = " ";
        if (cookies && header.indexOf(" ") == -1) {
            delimiters = " ;";
        }
        StringTokenizer tok = new StringTokenizer(header, delimiters);
        while (tok.hasMoreTokens()) {
            String parseMe = tok.nextToken();
            if (parseMe.endsWith(",")) {
                parseMe = parseMe.substring(0, parseMe.length() - 1);
            } else if (cookies && parseMe.endsWith(";")) {
                parseMe = parseMe.substring(0, parseMe.length() - 1);
            }
            int eqsign = parseMe.indexOf(61);
            if (eqsign < 0) {
                fields.setProperty(String.valueOf(namelessCount++), parseMe);
                continue;
            }
            boolean isBase64 = false;
            if (eqsign == parseMe.length() - 1) {
                try {
                    Base64.getDecoder().decode(parseMe);
                    isBase64 = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (isBase64) {
                fields.setProperty(String.valueOf(namelessCount++), parseMe);
                continue;
            }
            fields.setProperty(parseMe.substring(0, eqsign), parseMe.substring(eqsign + 1));
        }
        return fields;
    }

    public boolean supportsSecureKeyExchange() {
        return false;
    }

    public boolean keyExchangeEnabled() {
        return false;
    }

    protected byte[] extractSessionKey() {
        return null;
    }

    protected EncryptionAlgorithmBundle getEncryptionAlgorithmBundle() {
        return null;
    }
}

