/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.command;

import com.tridium.platform.command.BAbstractPlatformCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.util.CommandLineArguments;
import java.lang.reflect.Method;
import java.net.ConnectException;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BDaemonSessionCommand
extends BAbstractPlatformCommand
implements DaemonSessionTaskListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BDaemonSessionCommand.class);
    private String lastTaskMessage = null;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * Loose catch block
     */
    protected BDaemonSession getSession(CommandLineArguments args) throws ConnectException {
        BDaemonSession result;
        BHost host = this.getHost(args);
        if (host == null) {
            return null;
        }
        int port = this.getPort(args);
        if (port == 5011 || args.hasOption("secure")) {
            Class typeClass;
            try {
                typeClass = Sys.getType((String)"platCrypto:DaemonSecureSession").getTypeClass();
            }
            catch (Exception e) {
                throw new BajaRuntimeException("Cannot make secure connection without platCrypto-se installed");
            }
            try {
                Method make = typeClass.getMethod("make", BHost.class, Integer.TYPE);
                result = (BDaemonSession)((Object)make.invoke((Object)typeClass, host, port));
            }
            catch (Exception e) {
                throw new BajaRuntimeException("Cannot make secure connection", (Throwable)e);
            }
        }
        result = BDaemonSession.make(host, port);
        BUsernameAndPassword cred = this.getCredentials(result, args);
        result.setCredentials((BICredentials)cred);
        while (true) {
            try {
                result.connect();
                return result;
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (AuthenticationException ae) {
                if (args.hasOption("noinput")) {
                    throw ae;
                }
                BDaemonSessionCommand.println("Authentication failed", new Object[0]);
                cred = this.getCredentials(result, null);
                result.setCredentials((BICredentials)cred);
                continue;
            }
            catch (RuntimeException re) {
                throw re;
            }
            break;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected BHost getHost(CommandLineArguments args) {
        String hostOrdArg = args.getOption("h");
        return hostOrdArg == null ? null : (BHost)BOrd.make((String)hostOrdArg).get();
    }

    public int getPort(CommandLineArguments args) {
        return args.getIntOption("p", args.hasOption("secure") ? 5011 : 3011);
    }

    public BUsernameAndPassword getCredentials(BDaemonSession session, CommandLineArguments args) throws ConnectException {
        char[] pwdArg;
        String usrArg;
        String string = usrArg = args == null ? null : args.getOption("usr");
        if (args == null) {
            pwdArg = null;
        } else {
            char[] cArray = pwdArg = args.hasOption("pwd") ? args.getOption("pwd").toCharArray() : null;
        }
        if (!(usrArg != null || args != null && args.hasOption("noinput"))) {
            usrArg = this.promptString("User: ");
        }
        if (!(pwdArg != null || args != null && args.hasOption("noinput"))) {
            pwdArg = this.promptPassword("Password: ");
        }
        if (usrArg == null || pwdArg == null) {
            return null;
        }
        BUsernameAndPassword result = (BUsernameAndPassword)session.makeCredentials();
        if (result == null) {
            return null;
        }
        result.setUsername(usrArg);
        result.setPassword(BPassword.make((char[])pwdArg));
        return result;
    }

    @Override
    public void taskStarted(DaemonSessionTask task) {
        if (!task.getMessage().equals(this.lastTaskMessage)) {
            System.out.println(task.getMessage());
            this.lastTaskMessage = task.getMessage();
        }
    }

    @Override
    public void taskUpdated(DaemonSessionTask task) {
        this.taskStarted(task);
    }

    @Override
    public void taskFinished(DaemonSessionTask task) {
    }

    @Override
    public boolean isCancelEnabled() {
        return false;
    }
}

