/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipArchiveReader {
    private final ZipInputStream in;
    private boolean isVerbose = false;

    public ZipArchiveReader(File archiveFile, boolean isVerbose) throws IOException {
        if (!archiveFile.exists()) {
            throw new IllegalArgumentException("File does not exist: " + archiveFile);
        }
        if (archiveFile.isDirectory()) {
            throw new IllegalArgumentException("File is directory: " + archiveFile);
        }
        this.in = new ZipInputStream(new FileInputStream(archiveFile));
        this.isVerbose = isVerbose;
        if (isVerbose) {
            System.out.println("archive file name: " + archiveFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractAll(File dir) throws IOException {
        if (!dir.exists()) {
            throw new IllegalArgumentException("Path does not exist " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Path not a directory: " + dir);
        }
        byte[] buf = new byte[65536];
        try {
            ZipEntry entry;
            while ((entry = this.in.getNextEntry()) != null) {
                try {
                    String name = dir.getPath() + "/" + entry.getName();
                    String parentDir = name.substring(0, name.lastIndexOf(47));
                    File parentDirFile = new File(parentDir);
                    if (!parentDirFile.exists() && !parentDirFile.mkdirs()) {
                        throw new IOException("Could not create zip parent directory '" + parentDirFile + "'");
                    }
                    if (entry.isDirectory()) {
                        File newDir;
                        if (this.isVerbose) {
                            System.out.println("ZipArchiveReader: creating dir " + name);
                        }
                        if ((newDir = new File(name)).exists() || newDir.mkdir()) continue;
                        throw new IOException("Could not create zip entry directory '" + name + "'");
                    }
                    if (this.isVerbose) {
                        System.out.println("ZipArchiveReader: expanding " + name);
                    }
                    FileOutputStream out = new FileOutputStream(name);
                    Throwable throwable = null;
                    try {
                        int bytesRead = this.in.read(buf);
                        while (bytesRead >= 0) {
                            out.write(buf, 0, bytesRead);
                            bytesRead = this.in.read(buf);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                finally {
                    this.in.closeEntry();
                }
            }
            return;
        }
        finally {
            this.in.close();
        }
    }
}

