/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.nre.util.NiagaraFiles;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.sys.license.Brand;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import javax.baja.file.BIFileSpace;
import javax.baja.file.FilePath;
import javax.baja.util.Lexicon;

public class SystemFilePaths {
    private static final FilePath CERTS_PATH_AX = new FilePath("!certificates");
    private static final FilePath LEXICON_HOME_PATH_AX = new FilePath("!lexicon");
    private static final FilePath LICENSES_DIR_PATH_AX = new FilePath("!licenses");
    private static final FilePath SUBSCRIPTION_DIR_DEFAULT_PATH = new FilePath("!security/subscription");
    private static final FilePath SUBSCRIPTION_DIR_USER_PATH = new FilePath("~security/subscription");
    private static final FilePath BRAND_PROPS_PATH_AX = new FilePath("!lib/brand.properties");
    private static final FilePath STATIONS_DIR_PATH = new FilePath("~stations");
    private static final FilePath STATIONS_DIR_PATH_AX = new FilePath("!stations");
    private static final FilePath MODULES_DEFAULT_BASE_PATH = new FilePath("!");
    private static final FilePath MODULES_USER_BASE_PATH = new FilePath("~");
    private static final String MODULES_DIRECTORY_NAME = "modules";
    private static final String MODULE_COPIES_DIRECTORY_NAME = "moduleCopies";
    private static final FilePath PLATFORM_BOG_DEFAULT_PATH = new FilePath("!defaults/platform.bog");
    private static final FilePath PLATFORM_BOG_USER_PATH = new FilePath("~etc/platform.bog");
    private static final FilePath PLATFORM_BOG_PATH_AX = new FilePath("!lib/platform.bog");
    private static final FilePath SYSTEM_PROPERTIES_DEFAULT_PATH = new FilePath("!defaults/system.properties");
    private static final FilePath SYSTEM_PROPERTIES_USER_PATH = new FilePath("~etc/system.properties");
    private static final FilePath LICENSE_PROPERTIES_DEFAULT_PATH = new FilePath("!defaults/license.properties");
    private static final FilePath LICENSE_PROPERTIES_USER_PATH = new FilePath("~etc/license.properties");
    private static final FilePath PLATFORM_AUDIT_DIR_PATH = new FilePath("~audits");
    private static final FilePath FIPS_COOKIE_DIR_DEFAULT_PATH = new FilePath("!security/fips/cookies");
    private static final FilePath FIPS_COOKIE_DIR_USER_PATH = new FilePath("~security/fips/cookies");
    private static final FilePath BCFIPS_PROVIDER_DIR_PATH = new FilePath("!bin/ext/bcfips");
    private static final FilePath SW_SIGNATURES = new FilePath("signing/signers");
    private static final FilePath SYSTEM_SW_BASE_PATH = new FilePath("!sw");
    private static final FilePath USER_SW_BASE_PATH = new FilePath("~sw");
    private static final FilePath SYSTEM_NPSDK_UPDATES_BASE_PATH = new FilePath("!npsdkUpdates");
    private static final FilePath USER_NPSDK_UPDATES_BASE_PATH = new FilePath("~npsdkUpdates");

    public static FilePath getLocalModulesPath() {
        return SystemFilePaths.getModulesPath(NiagaraFiles.isNiagaraHomeReadonly());
    }

    public static FilePath getModulesPath(boolean isNiagaraHomeReadonly) {
        return SystemFilePaths.getModulesBasePath(isNiagaraHomeReadonly).merge(MODULES_DIRECTORY_NAME);
    }

    public static FilePath getModuleCopiesPath(boolean isNiagaraHomeReadonly) {
        return SystemFilePaths.getModulesBasePath(isNiagaraHomeReadonly).merge(MODULE_COPIES_DIRECTORY_NAME);
    }

    private static FilePath getModulesBasePath(boolean isNiagaraHomeReadonly) {
        return isNiagaraHomeReadonly ? MODULES_USER_BASE_PATH : MODULES_DEFAULT_BASE_PATH;
    }

    public static FilePath getUserSwBasePath() {
        return USER_SW_BASE_PATH;
    }

    public static FilePath getSwBasePath(boolean isNiagaraHomeReadonly) {
        return isNiagaraHomeReadonly ? USER_SW_BASE_PATH : SYSTEM_SW_BASE_PATH;
    }

    public static FilePath getSystemNpsdkUpdatesBasePath() {
        return SYSTEM_NPSDK_UPDATES_BASE_PATH;
    }

    public static FilePath getUserNpsdkUpdatesBasePath() {
        return USER_NPSDK_UPDATES_BASE_PATH;
    }

    public static FilePath getNpsdkUpdatesBasePath(boolean isNiagaraHomeReadonly) {
        return isNiagaraHomeReadonly ? USER_NPSDK_UPDATES_BASE_PATH : SYSTEM_NPSDK_UPDATES_BASE_PATH;
    }

    public static FilePath getPlatformBogPath(boolean forNiagara4, boolean isNiagaraHomeReadonly) {
        return forNiagara4 ? (isNiagaraHomeReadonly ? PLATFORM_BOG_USER_PATH : PLATFORM_BOG_DEFAULT_PATH) : PLATFORM_BOG_PATH_AX;
    }

    public static FilePath getSystemPropertiesPath(boolean isNiagaraHomeReadonly) {
        return isNiagaraHomeReadonly ? SYSTEM_PROPERTIES_USER_PATH : SYSTEM_PROPERTIES_DEFAULT_PATH;
    }

    public static FilePath getLicensePropertiesPath(boolean isNiagaraHomeReadonly) {
        return isNiagaraHomeReadonly ? LICENSE_PROPERTIES_USER_PATH : LICENSE_PROPERTIES_DEFAULT_PATH;
    }

    public static FilePath getStationsDirPath() {
        return SystemFilePaths.getStationsDirPath(true);
    }

    public static FilePath getStationsDirPath(boolean forNiagara4) {
        return forNiagara4 ? STATIONS_DIR_PATH : STATIONS_DIR_PATH_AX;
    }

    public static FilePath getStationsDirPath(BIFileSpace space) {
        return BDaemonFileSpace.isAxDaemonFileSpace(space) ? STATIONS_DIR_PATH_AX : STATIONS_DIR_PATH;
    }

    public static FilePath translateStationPath(FilePath path, String stationName, boolean forNiagara4) {
        if (path.isStationHomeAbsolute() || path.isProtectedStationHomeAbsolute()) {
            FilePath result = SystemFilePaths.getStationsDirPath(forNiagara4).merge(stationName);
            if (path.isStationHomeAbsolute() && forNiagara4) {
                result = result.merge("shared");
            }
            for (int i = 0; i < path.depth(); ++i) {
                result = result.merge(path.nameAt(i));
            }
            return result;
        }
        return path;
    }

    public static FilePath getLicensesDirPath() {
        return SystemFilePaths.getLicensesDirPath(true);
    }

    public static FilePath getLicensesDirPath(boolean forNiagara4) {
        return forNiagara4 ? LicenseDatabase.getPerpetualLicenseDirPath() : LICENSES_DIR_PATH_AX;
    }

    public static FilePath getLicensesDirPath(boolean forNiagara4, boolean isPerpetual, boolean isNiagaraHomeReadonly) {
        if (!forNiagara4) {
            return LICENSES_DIR_PATH_AX;
        }
        if (!isPerpetual) {
            return LicenseDatabase.getSubscriptionLicensesDirPath((boolean)isNiagaraHomeReadonly);
        }
        return LicenseDatabase.getPerpetualLicenseDirPath((boolean)isNiagaraHomeReadonly);
    }

    public static FilePath getLicensesDirPath(BIFileSpace space, boolean isPerpetual, boolean isNiagaraHomeReadonly) {
        if (BDaemonFileSpace.isAxDaemonFileSpace(space)) {
            return LICENSES_DIR_PATH_AX;
        }
        if (!isPerpetual) {
            return LicenseDatabase.getSubscriptionLicensesDirPath((boolean)isNiagaraHomeReadonly);
        }
        return LicenseDatabase.getPerpetualLicenseDirPath((boolean)isNiagaraHomeReadonly);
    }

    public static FilePath getCertificatesDirPath(boolean forNiagara4) {
        return forNiagara4 ? CertificateDatabase.getPerpetualCertificateDirPath() : CERTS_PATH_AX;
    }

    public static FilePath getCertificatesDirPath(boolean forNiagara4, boolean isPerpetual, boolean isNiagaraHomeReadonly) {
        if (!forNiagara4) {
            return CERTS_PATH_AX;
        }
        if (!isPerpetual) {
            return CertificateDatabase.getSubscriptionCertificateDirPath((boolean)isNiagaraHomeReadonly);
        }
        return CertificateDatabase.getPerpetualCertificateDirPath((boolean)isNiagaraHomeReadonly);
    }

    public static FilePath getCertificatesDirPath(BIFileSpace space) {
        return BDaemonFileSpace.isAxDaemonFileSpace(space) ? CERTS_PATH_AX : CertificateDatabase.getPerpetualCertificateDirPath();
    }

    public static FilePath getCertificatesDirPath(BIFileSpace space, boolean isPerpetual, boolean isNiagaraHomeReadonly) {
        if (BDaemonFileSpace.isAxDaemonFileSpace(space)) {
            return CERTS_PATH_AX;
        }
        if (!isPerpetual) {
            return CertificateDatabase.getSubscriptionCertificateDirPath((boolean)isNiagaraHomeReadonly);
        }
        return CertificateDatabase.getPerpetualCertificateDirPath((boolean)isNiagaraHomeReadonly);
    }

    public static FilePath getCertificatesDirPath() {
        return SystemFilePaths.getCertificatesDirPath(true);
    }

    public static FilePath getSubscriptionDirPath(boolean isNiagaraHomeReadonly) {
        return isNiagaraHomeReadonly ? SUBSCRIPTION_DIR_USER_PATH : SUBSCRIPTION_DIR_DEFAULT_PATH;
    }

    public static FilePath getBrandPropsPath() {
        return SystemFilePaths.getBrandPropsPath(true);
    }

    public static FilePath getBrandPropsPath(boolean isNiagara4) {
        return isNiagara4 ? Brand.BRAND_PROPS_PATH : BRAND_PROPS_PATH_AX;
    }

    public static FilePath getBrandPropsPath(BIFileSpace space) {
        return BDaemonFileSpace.isAxDaemonFileSpace(space) ? BRAND_PROPS_PATH_AX : Brand.BRAND_PROPS_PATH;
    }

    public static FilePath getLexiconHomePath() {
        return SystemFilePaths.getLexiconHomePath(true);
    }

    public static FilePath getLexiconHomePath(boolean forNiagara4) {
        return forNiagara4 ? Lexicon.LEXICON_HOME_PATH : LEXICON_HOME_PATH_AX;
    }

    public static FilePath getLexiconHomePath(BIFileSpace space) {
        return BDaemonFileSpace.isAxDaemonFileSpace(space) ? LEXICON_HOME_PATH_AX : Lexicon.LEXICON_HOME_PATH;
    }

    public static FilePath getPlatformAuditDirPath() {
        return PLATFORM_AUDIT_DIR_PATH;
    }

    public static FilePath getFipsCookieDirPath(boolean isNiagaraHomeReadonly) {
        return isNiagaraHomeReadonly ? FIPS_COOKIE_DIR_USER_PATH : FIPS_COOKIE_DIR_DEFAULT_PATH;
    }

    public static FilePath getFipsProviderDirPath() {
        return BCFIPS_PROVIDER_DIR_PATH;
    }

    public static FilePath getSwSignatures() {
        return SystemFilePaths.getSwBasePath(NiagaraFiles.isNiagaraHomeReadonly()).merge(SW_SIGNATURES);
    }
}

