/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.DeleteStationMessage;
import java.security.AccessController;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="oldStationName", type="String", defaultValue="")
public final class BStationRenameCleanupJob
extends BSimpleJob {
    @Generated
    public static final Property oldStationName = BStationRenameCleanupJob.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BStationRenameCleanupJob.class);

    @Generated
    public String getOldStationName() {
        return this.getString(oldStationName);
    }

    @Generated
    public void setOldStationName(String v) {
        this.setString(oldStationName, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void stationStarted() throws Exception {
        new Thread(this.getType().toString()){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BStationRenameCleanupJob.this.getParent().asComponent().remove(BStationRenameCleanupJob.this.getName());
                BStationRenameCleanupJob.this.submit(null);
            }
        }.start();
    }

    public void run(Context cx) throws Exception {
        BDaemonSession daemon;
        this.setProgress(50);
        if (!Sys.getStation().getStationName().equals(this.getOldStationName())) {
            daemon = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
            if (daemon == null) {
                throw new Exception("Could not rename Station. Please ensure Station is running from Platform!");
            }
        } else {
            throw new Exception("Cannot rename station; station files must locked by another process.");
        }
        daemon.sendMessage(new DeleteStationMessage(this.getOldStationName()));
        this.log().success("Station rename from " + this.getOldStationName() + " to " + Sys.getStation().getStationName() + " complete.");
        this.setProgress(100);
    }
}

