/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.part;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.PartSpec;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BApplicationPart;
import com.tridium.install.part.BArchPart;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BVmPart;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.install.BPlatformPartType;
import javax.baja.platform.install.PlatformPart;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="dependencies", type="BVector", defaultValue="new BVector()", flags=1), @NiagaraProperty(name="partName", type="String", defaultValue="unknown", flags=1), @NiagaraProperty(name="version", type="BVersion", defaultValue="BVersion.makeZero()", flags=1), @NiagaraProperty(name="description", type="String", defaultValue="", flags=1)})
public abstract class BPart
extends BComponent {
    @Generated
    public static final Property dependencies = BPart.newProperty((int)1, (BValue)new BVector(), null);
    @Generated
    public static final Property partName = BPart.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Property version = BPart.newProperty((int)1, (BValue)BVersion.makeZero(), null);
    @Generated
    public static final Property description = BPart.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPart.class);
    private BInstallable installable = null;
    private PartSpec spec = null;

    @Generated
    public BVector getDependencies() {
        return (BVector)this.get(dependencies);
    }

    @Generated
    public void setDependencies(BVector v) {
        this.set(dependencies, (BValue)v, null);
    }

    @Generated
    public String getPartName() {
        return this.getString(partName);
    }

    @Generated
    public void setPartName(String v) {
        this.setString(partName, v, null);
    }

    @Generated
    public BVersion getVersion() {
        return (BVersion)this.get(version);
    }

    @Generated
    public void setVersion(BVersion v) {
        this.set(version, (BValue)v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean equivalent(Object obj) {
        if (obj instanceof BPart) {
            BPart p = (BPart)((Object)obj);
            return this.getPartName().equals(p.getPartName()) && this.getType().equals(p.getType()) && this.getVersion().equivalent((Object)p.getVersion());
        }
        return false;
    }

    public abstract boolean meets(BDependency var1);

    public BInstallable getInstallable() {
        if (this.installable == null) {
            for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BInstallable)) continue;
                this.installable = (BInstallable)parent;
                break;
            }
        }
        return this.installable;
    }

    public void setInstallable(BInstallable value) {
        this.installable = value;
    }

    public boolean isInstallable() {
        return false;
    }

    public XElem getXml() {
        throw new UnsupportedOperationException();
    }

    public static String getVendorVersion(XElem elem) {
        return elem.get("vendorVersion", elem.get("version", "0"));
    }

    public static BPart makePart(XElem elem, BInstallable installable) {
        BPart result = null;
        if (elem.name().equals("os")) {
            result = BOsPart.make(elem, installable);
        } else if (elem.name().equals("vm")) {
            result = BVmPart.make(elem, installable);
        } else if (elem.name().equals("arch")) {
            result = BArchPart.make(elem, installable);
        } else if (elem.name().equals("brand")) {
            result = BBrandPart.make(elem, installable);
        } else if (elem.name().equals("nre")) {
            result = BNrePart.make(elem, installable);
        } else if (elem.name().equals("part")) {
            result = BGenericPart.make(elem, installable);
        } else if (elem.name().equals("model")) {
            result = BModelPart.make(elem, installable);
        } else if (elem.name().equals("app")) {
            result = BApplicationPart.make(elem, installable);
        }
        return result;
    }

    public PartSpec getPartSpec() {
        if (this.spec == null) {
            this.spec = new PartSpec(this.getPartName(), this.getType());
        }
        return this.spec;
    }

    public PlatformPart asPlatformPart() {
        if (this.isNull()) {
            return null;
        }
        return new PlatformPart(){

            @Override
            public String getPartName() {
                return BPart.this.getPartName();
            }

            @Override
            public BPlatformPartType getPartType() {
                return BPart.getPlatformPartType(BPart.this.getType().getTypeSpec());
            }

            @Override
            public Version getPartVersion() {
                return BPart.this.getVersion().getVendorVersion();
            }
        };
    }

    public static BPlatformPartType getPlatformPartType(BTypeSpec partType) {
        if (partType.equals((Object)BArchPart.TYPE.getTypeSpec())) {
            return BPlatformPartType.arch;
        }
        if (partType.equals((Object)BBrandPart.TYPE.getTypeSpec())) {
            return BPlatformPartType.brand;
        }
        if (partType.equals((Object)BModelPart.TYPE.getTypeSpec())) {
            return BPlatformPartType.model;
        }
        if (partType.equals((Object)BModulePart.TYPE.getTypeSpec())) {
            return BPlatformPartType.module;
        }
        if (partType.equals((Object)BNrePart.TYPE.getTypeSpec())) {
            return BPlatformPartType.nre;
        }
        if (partType.equals((Object)BOsPart.TYPE.getTypeSpec())) {
            return BPlatformPartType.os;
        }
        if (partType.equals((Object)BVmPart.TYPE.getTypeSpec())) {
            return BPlatformPartType.vm;
        }
        return BPlatformPartType.other;
    }

    public static String getPartTypeName(Type partType) {
        Lexicon lex = partType.getModule().getLexicon();
        String result = BPart.getLexiconText(lex, partType.getTypeName() + ".typeName");
        if (result == null) {
            if (partType.getSuperType() == null) {
                return TYPE.getModule().getLexicon().getText("Unknown.typeName");
            }
            return BPart.getPartTypeName(partType.getSuperType());
        }
        return result;
    }

    public static BIcon getPartTypeIcon(Type partType) {
        Lexicon lex = partType.getModule().getLexicon();
        String iconOrd = BPart.getLexiconText(lex, partType.getTypeName() + ".typeIcon");
        if (iconOrd == null) {
            if (partType.getSuperType() == null) {
                iconOrd = TYPE.getModule().getLexicon().getText("Unknown.typeIcon");
            } else {
                return BPart.getPartTypeIcon(partType.getSuperType());
            }
        }
        return BIcon.make((String)iconOrd);
    }

    public static String getPartTypeShortName(Type partType) {
        Lexicon lex = partType.getModule().getLexicon();
        String result = BPart.getLexiconText(lex, partType.getTypeName() + ".typeNameShort");
        if (result == null && (result = BPart.getLexiconText(lex, partType.getTypeName() + ".typeName")) == null) {
            if (partType.getSuperType() == null) {
                return TYPE.getModule().getLexicon().getText("Unknown.typeName");
            }
            return BPart.getPartTypeShortName(partType.getSuperType());
        }
        return result;
    }

    public BDependency[] getDependencyArray() {
        Property[] p = this.getDependencies().getPropertiesArray();
        BDependency[] result = new BDependency[p.length];
        for (int i = 0; i < p.length; ++i) {
            result[i] = (BDependency)this.getDependencies().get(p[i]);
        }
        return result;
    }

    public boolean matchesName(String nameMask) {
        return BPart.matchesName(this.getPartName(), nameMask);
    }

    public static boolean isWildcardName(String nameMask) {
        for (int i = 0; i < nameMask.length(); ++i) {
            switch (nameMask.charAt(i)) {
                case '\t': 
                case ' ': 
                case '*': 
                case ',': 
                case ';': 
                case '?': {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean matchesName(String name, String nameMask) {
        if (nameMask == null) {
            return false;
        }
        PatternFilter[] patterns = PatternFilter.parseList((String)nameMask);
        for (int i = 0; i < patterns.length; ++i) {
            if (!patterns[i].accept(name)) continue;
            return true;
        }
        return false;
    }

    private static String getLexiconText(Lexicon lex, String key) {
        String result = lex.getText(key);
        if (result.equals(key)) {
            return null;
        }
        return result;
    }
}

