/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.part;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BPart;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType
public class BGenericPart
extends BPart {
    @Generated
    public static final Type TYPE = Sys.loadType(BGenericPart.class);
    private static final BIcon icon = BPart.getPartTypeIcon(TYPE);
    private boolean isInstallable = false;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BGenericPart() {
    }

    public BGenericPart(String pName, String pDescription) {
        this(pName, pDescription, null, BVersion.makeZero());
    }

    public BGenericPart(String pName, String pDescription, BInstallable pInstallable) {
        this(pName, pDescription, pInstallable, BVersion.makeZero());
    }

    public BGenericPart(String pName, String pDescription, BInstallable pInstallable, BVersion version) {
        this.setPartName(pName);
        this.setDescription(pDescription);
        this.setInstallable(pInstallable);
        this.setVersion(version);
    }

    public BGenericPart(String pName, String pDescription, boolean isInstallable, BInstallable pInstallable, BVersion version) {
        this.setPartName(pName);
        this.setDescription(pDescription);
        this.setInstallable(pInstallable);
        this.setVersion(version);
        this.setIsInstallable(isInstallable);
    }

    public static BPart make(XElem elem) {
        return BGenericPart.make(elem, null);
    }

    public static BPart make(XElem elem, BInstallable installable) {
        if (elem == null) {
            return null;
        }
        if (elem.name().equals("part")) {
            return new BGenericPart(elem.get("name"), elem.get("description", elem.get("desc", "")), elem.getb("installable", false), installable, new BVersion(elem.get("vendor", ""), BGenericPart.getVendorVersion(elem)));
        }
        return null;
    }

    @Override
    public boolean meets(BDependency depend) {
        return depend.getPartType().is(TYPE) && this.getVersion().meets(depend) && this.matchesName(depend.getPartName());
    }

    @Override
    public boolean isInstallable() {
        return this.isInstallable;
    }

    public void setIsInstallable(boolean isInstallable) {
        this.isInstallable = isInstallable;
    }

    public String toString(Context context) {
        return "Part: " + this.getPartName() + (this.getVersion().equals((Object)BVersion.ZERO) ? "" : " " + (Object)((Object)this.getVersion()));
    }

    public BIcon getIcon() {
        return icon;
    }
}

