/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.installable;

import com.tridium.crypto.core.cert.JarSignatureRegistry;
import com.tridium.install.BDependency;
import com.tridium.install.BRegisteredModuleList;
import com.tridium.install.BVersion;
import com.tridium.install.FilenameFilterUtil;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.nre.util.NiagaraFiles;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.IFilter;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.util.Version;

public class LocalInstallableRegistry
implements InstallableRegistry {
    private boolean initialized = false;
    private InstallableCache installableCache = null;
    private boolean initializing = false;
    private List<RegistryListener> listeners = new ArrayList<RegistryListener>();
    private JarSignatureRegistry signatureRegistry;
    private static LocalInstallableRegistry INSTANCE = null;
    public static final BTypeSpec MODULE_PART = BModulePart.TYPE.getTypeSpec();
    public static final BTypeSpec MODULE_INST = BModuleInstallable.TYPE.getTypeSpec();
    public static final String INBOX_DIR = "inbox";
    public static final String FAILED_DIR = "failed_imports";
    private static final Lexicon LEX = Lexicon.make((String)"platform");
    private Map<String, Type> installableTypesByFileExt = new HashMap<String, Type>();

    private LocalInstallableRegistry() {
    }

    public static LocalInstallableRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LocalInstallableRegistry();
        }
        return INSTANCE;
    }

    public void reload(DaemonSessionTaskListener listener) throws Exception {
        this.reset();
        this.init(listener);
    }

    public void reset() {
        this.initialized = false;
    }

    public void init() throws Exception {
        this.init(null);
    }

    public void init(DaemonSessionTaskListener listener) throws Exception {
        if (!this.initialized && !this.initializing) {
            if (listener == null) {
                listener = DaemonSessionTaskListener.NULL_TASK_LISTENER;
            }
            File propertiesFile = BFileSystem.INSTANCE.pathToLocalFile(SystemFilePaths.getSwSignatures());
            this.signatureRegistry = JarSignatureRegistry.getInstance((File)propertiesFile);
            AccessController.doPrivileged(new InitPrivilegedAction(listener));
            this.initialized = true;
            this.initializing = false;
        }
    }

    public boolean isRegistered(BInstallable inst) throws Exception {
        String version = inst.getVersion().getVendorVersion() == null ? "0" : inst.getVersion().getVendorVersion().toString();
        BDirectory versionDir = AccessController.doPrivileged(() -> BFileSystem.INSTANCE.makeDir(LocalInstallableRegistry.getSystemSwPath().merge(version)));
        BIFile current = (BIFile)versionDir.getNavChild(inst.getInstallableFileName());
        if (current == null) {
            return false;
        }
        try {
            BOrd ordToCheck = inst.getInstallableFileOrd();
            if (ordToCheck.isNull()) {
                return true;
            }
            BIFile toCheck = (BIFile)ordToCheck.get();
            return toCheck.getLastModified().isAfter(current.getLastModified());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void register(BInstallable inst, DaemonSessionTaskListener listener) throws Exception {
        this.register(null, inst, listener, true);
    }

    public void register(String name, String fileName, BVersion version, InputStream contents, DaemonSessionTaskListener listener) throws Exception {
        AccessController.doPrivileged(new PublicRegisterPrivilegedAction(name, fileName, version, contents, listener));
    }

    private void register(DaemonSessionTask task, BInstallable inst, DaemonSessionTaskListener listener, boolean reparse) throws Exception {
        AccessController.doPrivileged(new PrivateRegisterPrivilegedAction(task, inst, listener, reparse));
    }

    public void importDirectory(BDirectory dir, DaemonSessionTaskListener listener) throws Exception {
        AccessController.doPrivileged(new ImportDirectoryPrivilegedAction(dir, listener));
    }

    private void importDirectory(BDirectory dir, DaemonSessionTaskListener listener, DaemonSessionTask task, boolean move) throws Exception {
        for (BIFile kid : dir.listFiles()) {
            FilePath dest;
            if (kid instanceof BDirectory) {
                this.importDirectory((BDirectory)kid, listener, task, move);
                continue;
            }
            task.setMessage(LEX.getText("LocalInstallableRegistry.parse", new Object[]{kid.getFilePath().getBody()}));
            listener.taskUpdated(task);
            BInstallable inst = BInstallable.make(kid);
            if (inst != null) {
                inst.close();
            }
            if (inst == null || !inst.getIsValid() || !inst.getIsInstallable() || inst instanceof BModuleInstallable && ((BModuleInstallable)inst).getModulePart().getManifestSchemaVersion() < 4 && ((BModuleInstallable)inst).getModulePart().getArchiveContent() != BModuleContent.doc) {
                FilePath srcPath = kid.getFilePath();
                dest = new FilePath(srcPath.getAbsoluteBase());
                for (int ixPath = 0; ixPath < srcPath.depth(); ++ixPath) {
                    dest = srcPath.nameAt(ixPath).equals(INBOX_DIR) ? dest.merge(FAILED_DIR) : dest.merge(srcPath.nameAt(ixPath));
                }
            } else {
                dest = LocalInstallableRegistry.getSystemSwPath().merge(inst.getVersion().getVendorVersion().toString()).merge(this.getNormalFileName(inst, kid));
                inst.setInstallableFileOrd(BOrd.make((OrdQuery)dest));
            }
            if (dest.getBody().equals(kid.getFilePath().getBody())) continue;
            BIFile current = BFileSystem.INSTANCE.findFile(dest);
            if (current != null) {
                try {
                    current.delete();
                }
                catch (IOException e) {
                    task.setMessage(LEX.getText("LocalInstallableRegistry.init.import.replaceFailed", new Object[]{dest.getBody()}));
                    continue;
                }
            }
            task.setMessage(LEX.getText("LocalInstallableRegistry.init.import.copyFile", new Object[]{kid.getFilePath().getBody()}));
            listener.taskUpdated(task);
            if (dest.depth() > 0) {
                BFileSystem.INSTANCE.makeDir(dest.getParent(), null);
            }
            if (move) {
                BFileSystem.INSTANCE.move(kid.getFilePath(), dest);
            } else {
                BIFile destFile = BFileSystem.INSTANCE.makeFile(dest);
                BajaFileUtil.pipe((BIFile)kid, (BIFile)destFile);
            }
            this.notifyRegistration(inst);
        }
        if (move && !dir.getFilePath().getBody().equals(LocalInstallableRegistry.getInboxPath().getBody())) {
            dir.delete();
        }
    }

    private String getNormalFileName(BInstallable inst, BIFile file) {
        SlotCursor c = inst.getParts().getProperties();
        if (c.next(BPart.class)) {
            BPart p = (BPart)c.get();
            return p.getPartName() + "." + file.getExtension();
        }
        return file.getFileName();
    }

    private List<BDirectory> getVersionSubdirs() {
        return AccessController.doPrivileged(() -> {
            BDirectory swDir = (BDirectory)BFileSystem.INSTANCE.findFile(LocalInstallableRegistry.getSystemSwPath());
            ArrayList<BDirectory> result = new ArrayList<BDirectory>();
            for (BIFile kid : swDir.listFiles()) {
                if (kid == null || !(kid instanceof BDirectory)) continue;
                try {
                    new Version(kid.getFileName());
                    result.add((BDirectory)kid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result.sort((d1, d2) -> {
                Version v1;
                String fn1 = d1.getFileName();
                String fn2 = d2.getFileName();
                Version v2 = new Version(fn2);
                int result1 = v2.compareTo(v1 = new Version(fn1));
                return result1 == 0 ? fn2.compareTo(fn1) : result1;
            });
            return result;
        });
    }

    @Override
    public BInstallable findInstallable(BDependency depend, DaemonSessionTaskListener listener) throws Exception {
        this.init(listener);
        return this.installableCache.getInstallable(this.findInstallableFile(depend, listener), listener);
    }

    @Override
    public IterableCursor<BInstallable> getInstallables(BDependency depend, DaemonSessionTaskListener listener) throws Exception {
        this.init(listener);
        return new InstallableFileCursor(this.findInstallableFiles(depend, listener), this.installableCache, listener);
    }

    private static boolean matchesDepend(BIFile file, BDependency depend, PatternFilter[] namePatterns) {
        if (file == null) {
            return false;
        }
        String ext = file.getExtension();
        if (depend.getPartTypeSpec().equals((Object)MODULE_PART) || depend.getPartTypeSpec().equals((Object)MODULE_INST) ? !"jar".equals(ext) && !"sjar".equals(ext) : !"dist".equals(ext) && LocalInstallableRegistry.getInstance().getInstallableTypeForExt(ext) == null) {
            return false;
        }
        String fname = file.getFileName().substring(0, file.getFileName().length() - ext.length() - 1);
        for (PatternFilter namePattern : namePatterns) {
            if (!namePattern.accept(fname)) continue;
            return true;
        }
        return false;
    }

    private static String[] getFixedFileNames(BDependency depend) {
        if (BPart.isWildcardName(depend.getPartName())) {
            return new String[0];
        }
        if (depend.getPartTypeSpec().equals((Object)MODULE_PART) || depend.getPartTypeSpec().equals((Object)MODULE_INST)) {
            return new String[]{depend.getPartName() + ".jar", depend.getPartName() + ".sjar"};
        }
        return new String[]{depend.getPartName() + ".dist"};
    }

    public BIFile findInstallableFile(BDependency depend, DaemonSessionTaskListener listener) throws Exception {
        if (depend == null) {
            return null;
        }
        this.init(listener);
        PatternFilter[] patterns = PatternFilter.parseList((String)depend.getPartName());
        String[] fixedFileNames = LocalInstallableRegistry.getFixedFileNames(depend);
        try {
            return AccessController.doPrivileged(() -> {
                block9: {
                    block7: {
                        FilePath path;
                        block8: {
                            if (depend.getVersionRelation() != BVersionRelation.exact) break block7;
                            if (depend.getVersion() == null || depend.getVersion().getVendorVersion() == null) {
                                return null;
                            }
                            path = LocalInstallableRegistry.getSystemSwPath().merge(depend.getVersion().getVendorVersion().toString());
                            if (fixedFileNames.length != 0) break block8;
                            BDirectory dir = (BDirectory)BFileSystem.INSTANCE.findFile(path);
                            if (dir == null) break block9;
                            for (BIFile kid : dir.listFiles()) {
                                if (!LocalInstallableRegistry.matchesDepend(kid, depend, patterns)) continue;
                                return kid;
                            }
                            break block9;
                        }
                        for (String fixedFileName : fixedFileNames) {
                            BIFile result = BFileSystem.INSTANCE.findFile(path.merge(fixedFileName));
                            if (result == null) continue;
                            return result;
                        }
                        break block9;
                    }
                    for (BDirectory subdir : this.getVersionSubdirs()) {
                        Version v = new Version(subdir.getFileName());
                        if (!BVersion.meets(v, depend)) continue;
                        if (fixedFileNames.length == 0) {
                            for (String string : subdir.listFiles()) {
                                if (!LocalInstallableRegistry.matchesDepend((BIFile)string, depend, patterns)) continue;
                                return string;
                            }
                            continue;
                        }
                        for (String string : fixedFileNames) {
                            BIFile result = (BIFile)subdir.getNavChild(string);
                            if (result == null) continue;
                            return result;
                        }
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public BIFile[] findInstallableFiles(BDependency depend, DaemonSessionTaskListener listener) throws Exception {
        this.init(listener);
        PatternFilter[] patterns = PatternFilter.parseList((String)depend.getPartName());
        String[] fixedFileNames = LocalInstallableRegistry.getFixedFileNames(depend);
        ArrayList result = new ArrayList();
        try {
            AccessController.doPrivileged(() -> {
                block6: {
                    block7: {
                        FilePath path;
                        block8: {
                            if (depend.getVersionRelation() != BVersionRelation.exact) break block7;
                            path = LocalInstallableRegistry.getSystemSwPath().merge(depend.getVersion().getVendorVersion().toString());
                            if (fixedFileNames.length != 0) break block8;
                            BDirectory dir = (BDirectory)BFileSystem.INSTANCE.findFile(path);
                            if (dir == null) break block6;
                            for (BIFile kid : dir.listFiles()) {
                                if (!LocalInstallableRegistry.matchesDepend(kid, depend, patterns)) continue;
                                result.add(kid);
                            }
                            break block6;
                        }
                        for (String fixedFileName : fixedFileNames) {
                            BIFile file = BFileSystem.INSTANCE.findFile(path.merge(fixedFileName));
                            if (file == null) continue;
                            result.add(file);
                            break block6;
                        }
                        break block6;
                    }
                    block2: for (BDirectory subdir : this.getVersionSubdirs()) {
                        Version v = new Version(subdir.getFileName());
                        if (!BVersion.meets(v, depend)) continue;
                        if (fixedFileNames.length == 0) {
                            for (String string : subdir.listFiles()) {
                                if (!LocalInstallableRegistry.matchesDepend((BIFile)string, depend, patterns)) continue;
                                result.add(string);
                            }
                            continue;
                        }
                        for (String string : fixedFileNames) {
                            BIFile file = (BIFile)subdir.getNavChild(string);
                            if (file == null) continue;
                            result.add(file);
                            continue block2;
                        }
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        return result.toArray(new BIFile[0]);
    }

    public BInstallable findInstallable(String installableName, Version version, Type installableType, DaemonSessionTaskListener listener) throws Exception {
        if (installableName.indexOf(46) > 0) {
            installableName = installableName.substring(0, installableName.indexOf(46));
        }
        if (version.isNull()) {
            return this.findInstallable(new BDependency(installableName, BVersion.ZERO, BVersionRelation.minimum, installableType.getTypeSpec()), listener);
        }
        return this.findInstallable(new BDependency(installableName, new BVersion(version.toString()), BVersionRelation.exact, installableType.getTypeSpec()), listener);
    }

    @Override
    public IterableCursor<BInstallable> getInstallables(boolean latestOnly, DaemonSessionTaskListener listener) throws Exception {
        return this.getInstallables(latestOnly, listener, null, null);
    }

    public IterableCursor<BInstallable> getInstallables(boolean latestOnly, DaemonSessionTaskListener listener, String includes) throws Exception {
        return this.getInstallables(latestOnly, listener, includes, null);
    }

    public IterableCursor<BInstallable> getInstallables(boolean latestOnly, DaemonSessionTaskListener listener, String includes, String excludes) throws Exception {
        this.init(listener);
        return new InstallableCursor(latestOnly, listener, FilenameFilterUtil.make(includes, excludes));
    }

    public void addListener(RegistryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RegistryListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyRegistration(BInstallable inst) {
        if (inst == null) {
            return;
        }
        for (RegistryListener listener : this.listeners) {
            try {
                listener.installableRegistered(inst);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void registerInstallableFileType(String ext, Type installableType) {
        this.installableTypesByFileExt.put(ext, installableType);
    }

    public Type getInstallableTypeForExt(String ext) {
        return this.installableTypesByFileExt.get(ext);
    }

    public static FilePath getSystemSwPath() {
        return LocalInstallableRegistryHolder.SYSTEM_SW_PATH;
    }

    public static FilePath getUserSwPath() {
        return LocalInstallableRegistryHolder.USER_SW_PATH;
    }

    public static FilePath getInboxPath() {
        return LocalInstallableRegistryHolder.INBOX_PATH;
    }

    private class ImportDirectoryPrivilegedAction
    implements PrivilegedExceptionAction<Void> {
        private BDirectory dir;
        private DaemonSessionTaskListener listener;

        public ImportDirectoryPrivilegedAction(BDirectory dir, DaemonSessionTaskListener listener) {
            this.dir = dir;
            this.listener = listener;
        }

        @Override
        public Void run() throws Exception {
            if (!LocalInstallableRegistry.this.initializing) {
                LocalInstallableRegistry.this.init(this.listener);
            }
            if (this.listener == null) {
                this.listener = DaemonSessionTaskListener.NULL_TASK_LISTENER;
            }
            DaemonSessionTask task = new DaemonSessionTask(LEX, "LocalInstallableRegistry.init.import.title", "LocalInstallableRegistry.init.import.message");
            this.listener.taskStarted(task);
            try {
                LocalInstallableRegistry.this.importDirectory(this.dir, this.listener, task, false);
            }
            finally {
                this.listener.taskFinished(task);
            }
            return null;
        }
    }

    private class PrivateRegisterPrivilegedAction
    implements PrivilegedExceptionAction<Void> {
        private DaemonSessionTask task;
        private BInstallable inst;
        private DaemonSessionTaskListener listener;
        private boolean reparse;

        public PrivateRegisterPrivilegedAction(DaemonSessionTask task, BInstallable inst, DaemonSessionTaskListener listener, boolean reparse) {
            this.task = task;
            this.inst = inst;
            this.listener = listener;
            this.reparse = reparse;
        }

        @Override
        public Void run() throws Exception {
            BModuleInstallable mi;
            if (!LocalInstallableRegistry.this.initializing) {
                LocalInstallableRegistry.this.init(this.listener);
            }
            if (this.inst instanceof BModuleInstallable && (mi = (BModuleInstallable)this.inst).getModulePart().getManifestSchemaVersion() < 4 && mi.getModulePart().getArchiveContent() != BModuleContent.doc) {
                return null;
            }
            if (this.listener == null) {
                this.listener = DaemonSessionTaskListener.NULL_TASK_LISTENER;
            }
            boolean taskStarted = false;
            if (this.task == null) {
                this.task = new DaemonSessionTask(LEX, "LocalInstallableRegistry.init.import.title", "LocalInstallableRegistry.init.import.message");
                this.listener.taskStarted(this.task);
                taskStarted = true;
            } else {
                this.task.setMessage(LEX.getText("LocalInstallableRegistry.init.import.message"));
                this.listener.taskUpdated(this.task);
            }
            try {
                BIFile src;
                BDirectory versionDir = BFileSystem.INSTANCE.makeDir(LocalInstallableRegistry.getSystemSwPath().merge(this.inst.getVersion().getVendorVersion().toString()));
                if (versionDir.getNavChild(this.inst.getInstallableFileName()) == null && (src = (BIFile)this.inst.getInstallableFileOrd().get()) != null) {
                    this.task.setMessage(LEX.getText("LocalInstallableRegistry.init.import.copyModule", new Object[]{this.inst.getInstallableName()}));
                    this.listener.taskUpdated(this.task);
                    BIFile dest = BFileSystem.INSTANCE.makeFile(versionDir.getFilePath().merge(this.inst.getInstallableFileName()));
                    BajaFileUtil.pipe((BIFile)src, (BIFile)dest);
                    if (this.reparse) {
                        this.inst = BInstallable.make(dest);
                        LocalInstallableRegistry.this.installableCache.register(dest, this.inst);
                    } else {
                        LocalInstallableRegistry.this.installableCache.register(dest, this.inst);
                    }
                    LocalInstallableRegistry.this.notifyRegistration(this.inst);
                }
            }
            catch (NullPointerException npe) {
                Logger.getLogger("platform.install").warning("Unable to register module: " + this.inst.getInstallableFileName() + ". Missing or invalid Vendor Version. Module ignored.");
                if (Logger.getLogger("platform.install").isLoggable(Level.FINE)) {
                    Logger.getLogger("platform.install").log(Level.FINE, "Stack trace for error: ", npe);
                }
                throw new BajaRuntimeException("Error registering " + this.inst.getInstallableFileName() + ". Missing or invalid Vendor Version. Module ignored.", (Throwable)npe);
            }
            finally {
                if (taskStarted) {
                    this.listener.taskFinished(this.task);
                }
            }
            return null;
        }
    }

    private class InitPrivilegedAction
    implements PrivilegedExceptionAction<Void> {
        private DaemonSessionTaskListener listener;

        public InitPrivilegedAction(DaemonSessionTaskListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run() throws Exception {
            DaemonSessionTask task = new DaemonSessionTask(LEX, "LocalInstallableRegistry.init.import.title", "LocalInstallableRegistry.init.import.message");
            BFileSystem.INSTANCE.makeDir(LocalInstallableRegistry.getSystemSwPath());
            LocalInstallableRegistry.this.initializing = true;
            try {
                this.listener.taskStarted(task);
                LocalInstallableRegistry.this.installableCache = new InstallableCache();
                LocalInstallableRegistry.this.importDirectory(BFileSystem.INSTANCE.makeDir(LocalInstallableRegistry.getInboxPath()), this.listener, task, true);
                BRegisteredModuleList.getInstance().doInit(this.listener);
                SlotCursor c = BRegisteredModuleList.getInstance().getModules().getProperties();
                while (c.next(BModuleInstallable.class)) {
                    BModuleInstallable inst = (BModuleInstallable)c.get();
                    if (inst.getModulePart().getManifestSchemaVersion() != 4 && inst.getModulePart().getArchiveContent() != BModuleContent.doc) continue;
                    if (LocalInstallableRegistry.this.isRegistered(inst)) {
                        LocalInstallableRegistry.this.installableCache.register(LocalInstallableRegistry.getSystemSwPath().merge(inst.getVersion().getVendorVersion().toString()).merge(inst.getInstallableFileName()), (BInstallable)inst);
                        continue;
                    }
                    try {
                        LocalInstallableRegistry.this.register(task, inst, this.listener, false);
                    }
                    catch (BajaRuntimeException bre) {
                        Logger.getLogger("platform.install").warning("Unable to register module: " + bre.getMessage());
                        if (!Logger.getLogger("platform.install").isLoggable(Level.FINE)) continue;
                        Logger.getLogger("platform.install").log(Level.FINE, "Stack trace for error: ", bre);
                    }
                }
                IterableCursor<BInstallable> installables = LocalInstallableRegistry.this.getInstallables(false, this.listener);
                while (installables.next()) {
                    BInstallable installable = (BInstallable)installables.get();
                    if (!(installable instanceof BModuleInstallable)) continue;
                    ((BModuleInstallable)installable).getModulePart().initCodeSigners(LocalInstallableRegistry.this.signatureRegistry);
                }
                LocalInstallableRegistry.this.signatureRegistry.save();
            }
            finally {
                this.listener.taskFinished(task);
            }
            return null;
        }
    }

    private class PublicRegisterPrivilegedAction
    implements PrivilegedExceptionAction<Void> {
        private String name;
        private String fileName;
        private BVersion version;
        private InputStream contents;
        private DaemonSessionTaskListener listener;

        public PublicRegisterPrivilegedAction(String name, String fileName, BVersion version, InputStream contents, DaemonSessionTaskListener listener) {
            this.name = name;
            this.fileName = fileName;
            this.version = version;
            this.contents = contents;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run() throws Exception {
            if (!LocalInstallableRegistry.this.initializing) {
                LocalInstallableRegistry.this.init(this.listener);
            }
            if (this.listener == null) {
                this.listener = DaemonSessionTaskListener.NULL_TASK_LISTENER;
            }
            if (this.version.getVendorVersion().equals((Object)Version.ZERO)) {
                return null;
            }
            DaemonSessionTask task = new DaemonSessionTask(LEX, "LocalInstallableRegistry.init.import.title", "LocalInstallableRegistry.init.import.message");
            this.listener.taskStarted(task);
            try {
                BDirectory versionDir = BFileSystem.INSTANCE.makeDir(LocalInstallableRegistry.getSystemSwPath().merge(this.version.getVendorVersion().toString()));
                task.setMessage(LEX.getText("LocalInstallableRegistry.init.import.copyModule", new Object[]{this.name}));
                this.listener.taskUpdated(task);
                BIFile dest = BFileSystem.INSTANCE.makeFile(versionDir.getFilePath().merge(this.fileName));
                try (OutputStream outputStream = dest.getOutputStream();){
                    FileUtil.pipe((InputStream)this.contents, (OutputStream)outputStream);
                }
                BInstallable inst = BInstallable.make(dest);
                LocalInstallableRegistry.this.installableCache.register(dest, inst);
                LocalInstallableRegistry.this.notifyRegistration(inst);
            }
            finally {
                this.listener.taskFinished(task);
            }
            return null;
        }
    }

    private static class InstallableCache {
        private Set<FilePath> pathsNotFound = new TreeSet<FilePath>();
        private Map<FilePath, BInstallable> instByPath = new TreeMap<FilePath, BInstallable>();

        public void register(BIFile file, BInstallable installable) {
            this.register(file.getFilePath(), installable);
        }

        public void register(FilePath path, BInstallable installable) {
            this.pathsNotFound.remove(path);
            this.instByPath.put(path, installable);
        }

        public BInstallable getInstallable(BIFile file, DaemonSessionTaskListener listener) {
            return this.getInstallable(file, listener, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BInstallable getInstallable(BIFile file, DaemonSessionTaskListener listener, DaemonSessionTask task) {
            if (file == null) {
                return null;
            }
            if (this.pathsNotFound.contains(file.getFilePath())) {
                return null;
            }
            BInstallable result = this.instByPath.get(file.getFilePath());
            if (result == null) {
                if (listener == null) {
                    listener = DaemonSessionTaskListener.NULL_TASK_LISTENER;
                }
                boolean taskStarted = false;
                if (task == null) {
                    task = new DaemonSessionTask(LEX, "LocalInstallableRegistry.parse.genericTitle", "LocalInstallableRegistry.parse", new Object[]{file.getFilePath().getBody()});
                    listener.taskStarted(task);
                    taskStarted = true;
                } else {
                    task.setMessage(LEX.getText("LocalInstallableRegistry.parse", new Object[]{file.getFilePath().getBody()}));
                    listener.taskUpdated(task);
                }
                try {
                    result = AccessController.doPrivileged(() -> BInstallable.make(file));
                }
                finally {
                    if (taskStarted) {
                        listener.taskFinished(task);
                    }
                }
                if (result == null) {
                    this.pathsNotFound.add(file.getFilePath());
                } else {
                    this.instByPath.put(file.getFilePath(), result);
                }
            }
            return result;
        }
    }

    public class InstallableCursor
    implements IterableCursor<BInstallable> {
        BInstallable current = null;
        Iterator<FilePath> iterator;
        DaemonSessionTaskListener listener;
        IFilter fileNameFilter;

        public InstallableCursor(boolean latestOnly, DaemonSessionTaskListener listener, IFilter fileNameFilter) {
            ArrayList<FilePath> paths = new ArrayList<FilePath>();
            HashSet<String> names = new HashSet<String>();
            this.fileNameFilter = fileNameFilter;
            this.listener = listener == null ? DaemonSessionTaskListener.NULL_TASK_LISTENER : listener;
            for (BDirectory subdir : LocalInstallableRegistry.this.getVersionSubdirs()) {
                for (BIFile kid : AccessController.doPrivileged(() -> ((BDirectory)subdir).listFiles())) {
                    FilePath path = kid.getFilePath();
                    String extension = BajaFileUtil.getExtension((String)path.getName());
                    if (!"dist".equals(extension) && !"jar".equals(extension) && !"sjar".equals(extension) && LocalInstallableRegistry.this.getInstallableTypeForExt(extension) == null || latestOnly && names.contains(path.getName())) continue;
                    paths.add(path);
                    names.add(path.getName());
                }
            }
            this.iterator = paths.iterator();
        }

        public Context getContext() {
            return null;
        }

        public void close() {
        }

        public boolean next() {
            while (this.iterator.hasNext()) {
                FilePath currentPath = this.iterator.next();
                if (!this.fileNameFilter.accept((Object)currentPath)) continue;
                this.current = AccessController.doPrivileged(() -> LocalInstallableRegistry.this.installableCache.getInstallable(BFileSystem.INSTANCE.findFile(currentPath), this.listener));
                if (this.current == null) continue;
                return true;
            }
            return false;
        }

        public boolean nextComponent() {
            return this.next(BComponent.class);
        }

        public boolean nextDist() {
            while (this.iterator.hasNext()) {
                FilePath currentPath = this.iterator.next();
                if (!this.fileNameFilter.accept((Object)currentPath) || !"dist".equals(BajaFileUtil.getExtension((String)currentPath.getName()))) continue;
                this.current = AccessController.doPrivileged(() -> LocalInstallableRegistry.this.installableCache.getInstallable(BFileSystem.INSTANCE.findFile(currentPath), this.listener));
                if (this.current == null) continue;
                return true;
            }
            return false;
        }

        public boolean nextModule() {
            while (this.iterator.hasNext()) {
                FilePath currentPath = this.iterator.next();
                if (!this.fileNameFilter.accept((Object)currentPath) || !"jar".equals(BajaFileUtil.getExtension((String)currentPath.getName())) && !"sjar".equals(BajaFileUtil.getExtension((String)currentPath.getName())) && LocalInstallableRegistry.this.getInstallableTypeForExt(BajaFileUtil.getExtension((String)currentPath.getName())) == null) continue;
                this.current = LocalInstallableRegistry.this.installableCache.getInstallable(BFileSystem.INSTANCE.findFile(currentPath), this.listener);
                if (this.current == null) continue;
                return true;
            }
            return false;
        }

        public boolean next(Class<?> cls) {
            if (BModuleInstallable.class.isAssignableFrom(cls)) {
                while (this.nextModule()) {
                    if (!cls.isInstance(this.current)) continue;
                    return true;
                }
            } else if (BDistribution.class.isAssignableFrom(cls)) {
                while (this.nextDist()) {
                    if (!cls.isInstance(this.current)) continue;
                    return true;
                }
            } else {
                while (this.next()) {
                    if (!cls.isInstance(this.current)) continue;
                    return true;
                }
            }
            return false;
        }

        public BInstallable get() {
            return this.current;
        }
    }

    public static interface RegistryListener {
        public void installableRegistered(BInstallable var1);
    }

    private static class LocalInstallableRegistryHolder {
        public static final FilePath SYSTEM_SW_PATH = SystemFilePaths.getSwBasePath(NiagaraFiles.isNiagaraHomeReadonly());
        public static final FilePath USER_SW_PATH = SystemFilePaths.getUserSwBasePath();
        public static final FilePath INBOX_PATH = USER_SW_PATH.merge("inbox");

        private LocalInstallableRegistryHolder() {
        }
    }

    protected static class InstallableFileCursor
    implements IterableCursor<BInstallable> {
        private BIFile[] files;
        private int index;
        private InstallableCache cache;
        private DaemonSessionTaskListener listener;

        public InstallableFileCursor(BIFile[] files, InstallableCache cache, DaemonSessionTaskListener listener) {
            this.files = files;
            this.index = -1;
            this.cache = cache;
            this.listener = listener;
        }

        public void close() {
        }

        public BInstallable get() {
            if (this.index < 0 || this.index >= this.files.length) {
                return null;
            }
            return this.cache.getInstallable(this.files[this.index], this.listener);
        }

        public Context getContext() {
            return null;
        }

        public boolean next() {
            if (this.index < this.files.length - 1) {
                ++this.index;
                return true;
            }
            return false;
        }
    }
}

