/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.installable;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.io.BIEncodable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="installableName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="version", type="BVersion", defaultValue="new BVersion()", flags=1), @NiagaraProperty(name="installableType", type="BTypeSpec", defaultValue="BTypeSpec.NULL", flags=1)})
public class BInstallableSpec
extends BStruct
implements BIEncodable {
    @Generated
    public static final Property installableName = BInstallableSpec.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property version = BInstallableSpec.newProperty((int)1, (BValue)new BVersion(), null);
    @Generated
    public static final Property installableType = BInstallableSpec.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BInstallableSpec.class);
    public static final BInstallableSpec DEFAULT = new BInstallableSpec();

    @Generated
    public String getInstallableName() {
        return this.getString(installableName);
    }

    @Generated
    public void setInstallableName(String v) {
        this.setString(installableName, v, null);
    }

    @Generated
    public BVersion getVersion() {
        return (BVersion)this.get(version);
    }

    @Generated
    public void setVersion(BVersion v) {
        this.set(version, (BValue)v, null);
    }

    @Generated
    public BTypeSpec getInstallableType() {
        return (BTypeSpec)this.get(installableType);
    }

    @Generated
    public void setInstallableType(BTypeSpec v) {
        this.set(installableType, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BInstallableSpec() {
    }

    public BInstallableSpec(String name, Version vendorVersion, Type instType) {
        this(name, new BVersion(vendorVersion.toString()), instType);
    }

    public BInstallableSpec(String name, BVersion version, Type instType) {
        this.setInstallableName(name);
        this.setVersion(version);
        this.setInstallableType(instType.getTypeSpec());
    }

    public static BInstallableSpec make(BInstallable inst) {
        return new BInstallableSpec(inst.getInstallableName(), (BVersion)inst.getVersion().newCopy(), inst.getType());
    }

    public BDependency asDependency() {
        return new BDependency(this.getInstallableName(), this.getVersion(), BVersionRelation.exact, this.getInstallableType());
    }

    public String toString(Context cx) {
        String versionString = this.getVersion().toString(cx);
        if (versionString.trim().length() == 0) {
            return this.getInstallableName();
        }
        return BVersion.nameVersionText.getText(cx, new Object[]{this.getInstallableName(), versionString});
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.getInstallableName());
        this.getVersion().encode(out);
        this.getInstallableType().encode(out);
    }

    public BObject decode(DataInput in) throws IOException {
        BInstallableSpec result = new BInstallableSpec();
        result.setInstallableName(in.readUTF());
        result.setVersion((BVersion)BVersion.ZERO.decode(in));
        result.setInstallableType((BTypeSpec)BTypeSpec.DEFAULT.decode(in));
        return result;
    }

    public String encodeToString() throws IOException {
        StringBuilder result = new StringBuilder(128);
        result.append(this.getInstallableName());
        result.append(';');
        result.append(this.getVersion().getBajaVersionString());
        result.append(';');
        result.append(this.getVersion().getVendor());
        result.append(';');
        result.append(this.getVersion().getVendorVersionString());
        result.append(';');
        result.append(this.getInstallableType().encodeToString());
        return result.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        BInstallableSpec result = new BInstallableSpec();
        String[] values = TextUtil.split((String)s, (char)';');
        result.setInstallableName(values[0]);
        result.getVersion().setBajaVersionString(values[1]);
        result.getVersion().setVendor(values[2]);
        result.getVersion().setVendorVersionString(values[3]);
        result.setInstallableType((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(values[4]));
        return result;
    }
}

