/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.installable;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.PartSpec;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BArchPart;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.File;
import java.util.Optional;
import java.util.TreeMap;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="parts", type="BVector", defaultValue="new BVector()", flags=1), @NiagaraProperty(name="dependencies", type="BVector", defaultValue="new BVector()", flags=1), @NiagaraProperty(name="exclusions", type="BVector", defaultValue="new BVector()", flags=1), @NiagaraProperty(name="installableName", type="String", defaultValue="unknown", flags=1), @NiagaraProperty(name="description", type="String", defaultValue="", flags=1), @NiagaraProperty(name="version", type="BVersion", defaultValue="BVersion.makeZero()", flags=1), @NiagaraProperty(name="installableFileOrd", type="BOrd", defaultValue="BOrd.NULL", flags=1), @NiagaraProperty(name="installableFileName", type="String", defaultValue="unknown", flags=1), @NiagaraProperty(name="installableFileSize", type="long", defaultValue="-1", flags=1), @NiagaraProperty(name="updateModuleContent", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="newModuleContent", type="BModuleContent", defaultValue="BModuleContent.doc", flags=1), @NiagaraProperty(name="newOsTimeZone", type="BTimeZone", defaultValue="BTimeZone.NULL", flags=1), @NiagaraProperty(name="isValid", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="isStandalone", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="isInstallable", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="updateRuntimeProfilesEnabled", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="enabledRuntimeProfileNames", type="String", defaultValue="", flags=1), @NiagaraProperty(name="releaseDateString", type="String", defaultValue="", flags=1)})
public abstract class BInstallable
extends BComponent
implements Comparable<Object> {
    @Generated
    public static final Property parts = BInstallable.newProperty((int)1, (BValue)new BVector(), null);
    @Generated
    public static final Property dependencies = BInstallable.newProperty((int)1, (BValue)new BVector(), null);
    @Generated
    public static final Property exclusions = BInstallable.newProperty((int)1, (BValue)new BVector(), null);
    @Generated
    public static final Property installableName = BInstallable.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Property description = BInstallable.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property version = BInstallable.newProperty((int)1, (BValue)BVersion.makeZero(), null);
    @Generated
    public static final Property installableFileOrd = BInstallable.newProperty((int)1, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property installableFileName = BInstallable.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Property installableFileSize = BInstallable.newProperty((int)1, (int)-1, null);
    @Generated
    public static final Property updateModuleContent = BInstallable.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property newModuleContent = BInstallable.newProperty((int)1, (BValue)BModuleContent.doc, null);
    @Generated
    public static final Property newOsTimeZone = BInstallable.newProperty((int)1, (BValue)BTimeZone.NULL, null);
    @Generated
    public static final Property isValid = BInstallable.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property isStandalone = BInstallable.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property isInstallable = BInstallable.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property updateRuntimeProfilesEnabled = BInstallable.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property enabledRuntimeProfileNames = BInstallable.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property releaseDateString = BInstallable.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BInstallable.class);
    private PartSpec partSpec = null;
    public static final long FLAG_NO_RUNNING_APP = 1L;
    public static final long FLAG_NO_RUNNING_STATION = 2L;
    public static final long FLAG_UPDATE_RUNNING_STATION = 4L;
    public static final long FLAG_REBOOT = 65536L;
    public static final long FLAG_OS_INSTALL = 131072L;
    public static final long FLAG_UPDATE_DAEMON = 262144L;
    public static final long FLAG_UPDATE_TCPIP = 524288L;
    public static final long FLAG_UPDATE_CONTENT = 0x100000L;
    public static final long FLAG_UPDATE_OS_TZ = 0x200000L;
    public static final long FLAG_UPDATE_RUNTIME_PROFILES = 0x400000L;

    @Generated
    public BVector getParts() {
        return (BVector)this.get(parts);
    }

    @Generated
    public void setParts(BVector v) {
        this.set(parts, (BValue)v, null);
    }

    @Generated
    public BVector getDependencies() {
        return (BVector)this.get(dependencies);
    }

    @Generated
    public void setDependencies(BVector v) {
        this.set(dependencies, (BValue)v, null);
    }

    @Generated
    public BVector getExclusions() {
        return (BVector)this.get(exclusions);
    }

    @Generated
    public void setExclusions(BVector v) {
        this.set(exclusions, (BValue)v, null);
    }

    @Generated
    public String getInstallableName() {
        return this.getString(installableName);
    }

    @Generated
    public void setInstallableName(String v) {
        this.setString(installableName, v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public BVersion getVersion() {
        return (BVersion)this.get(version);
    }

    @Generated
    public void setVersion(BVersion v) {
        this.set(version, (BValue)v, null);
    }

    @Generated
    public BOrd getInstallableFileOrd() {
        return (BOrd)this.get(installableFileOrd);
    }

    @Generated
    public void setInstallableFileOrd(BOrd v) {
        this.set(installableFileOrd, (BValue)v, null);
    }

    @Generated
    public String getInstallableFileName() {
        return this.getString(installableFileName);
    }

    @Generated
    public void setInstallableFileName(String v) {
        this.setString(installableFileName, v, null);
    }

    @Generated
    public long getInstallableFileSize() {
        return this.getLong(installableFileSize);
    }

    @Generated
    public void setInstallableFileSize(long v) {
        this.setLong(installableFileSize, v, null);
    }

    @Generated
    public boolean getUpdateModuleContent() {
        return this.getBoolean(updateModuleContent);
    }

    @Generated
    public void setUpdateModuleContent(boolean v) {
        this.setBoolean(updateModuleContent, v, null);
    }

    @Generated
    public BModuleContent getNewModuleContent() {
        return (BModuleContent)this.get(newModuleContent);
    }

    @Generated
    public void setNewModuleContent(BModuleContent v) {
        this.set(newModuleContent, (BValue)v, null);
    }

    @Generated
    public BTimeZone getNewOsTimeZone() {
        return (BTimeZone)this.get(newOsTimeZone);
    }

    @Generated
    public void setNewOsTimeZone(BTimeZone v) {
        this.set(newOsTimeZone, (BValue)v, null);
    }

    @Generated
    public boolean getIsValid() {
        return this.getBoolean(isValid);
    }

    @Generated
    public void setIsValid(boolean v) {
        this.setBoolean(isValid, v, null);
    }

    @Generated
    public boolean getIsStandalone() {
        return this.getBoolean(isStandalone);
    }

    @Generated
    public void setIsStandalone(boolean v) {
        this.setBoolean(isStandalone, v, null);
    }

    @Generated
    public boolean getIsInstallable() {
        return this.getBoolean(isInstallable);
    }

    @Generated
    public void setIsInstallable(boolean v) {
        this.setBoolean(isInstallable, v, null);
    }

    @Generated
    public boolean getUpdateRuntimeProfilesEnabled() {
        return this.getBoolean(updateRuntimeProfilesEnabled);
    }

    @Generated
    public void setUpdateRuntimeProfilesEnabled(boolean v) {
        this.setBoolean(updateRuntimeProfilesEnabled, v, null);
    }

    @Generated
    public String getEnabledRuntimeProfileNames() {
        return this.getString(enabledRuntimeProfileNames);
    }

    @Generated
    public void setEnabledRuntimeProfileNames(String v) {
        this.setString(enabledRuntimeProfileNames, v, null);
    }

    @Generated
    public String getReleaseDateString() {
        return this.getString(releaseDateString);
    }

    @Generated
    public void setReleaseDateString(String v) {
        this.setString(releaseDateString, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public abstract long getProcessingFlags(BDaemonPlatform var1, DaemonSessionTaskListener var2);

    public abstract FileTransferMessageElement[] getTransferElements(BDaemonPlatform var1, StoreCache var2, ICancelHint var3, DaemonSessionTaskListener var4) throws Exception;

    public BInstallable makeInstallableForPart(String partName) {
        if (this.getParts().get(SlotPath.escape((String)partName)) == null) {
            return null;
        }
        return this;
    }

    public BTcpIpHostSettings getTcpIpChanges() {
        return null;
    }

    public BPart getPart() {
        SlotCursor c = this.getParts().getProperties();
        return c.next(BPart.class) ? (BPart)c.get() : null;
    }

    public PartSpec getPartSpec() {
        if (this.partSpec == null) {
            BPart p = this.getPart();
            this.partSpec = p == null ? new PartSpec(this.getInstallableName(), this.getType()) : p.getPartSpec();
        }
        return this.partSpec;
    }

    public Optional<Long> getReleaseDate() {
        if (this.getReleaseDateString().equals("")) {
            return Optional.empty();
        }
        return Optional.of(LicenseUtil.parseDate((String)this.getReleaseDateString(), (boolean)true));
    }

    public void setReleaseDate(Optional<Long> value) {
        if (value.isPresent()) {
            this.setReleaseDateString(LicenseUtil.formatDate((long)value.get()));
        } else {
            this.setReleaseDateString("");
        }
    }

    public abstract void close() throws Exception;

    public abstract BInstallable makeLocalInstance();

    protected void setInstallableFileProperties(BIFile pFile) {
        this.setInstallableFileOrd(pFile.getOrdInSession());
        this.setInstallableFileName(pFile.getFileName());
        this.setInstallableFileSize(pFile.getSize());
        if (this.getInstallableName().equals("unknown")) {
            this.setInstallableName(pFile.getFileName());
        }
    }

    public File getLocalInstallableFile() {
        if (!this.getInstallableFileOrd().isNull()) {
            try {
                BIFile file = (BIFile)this.getInstallableFileOrd().get();
                if (file != null && file.getStore() instanceof BLocalFileStore) {
                    return ((BLocalFileStore)file.getStore()).getLocalFile();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isInstallableFile(BIFile pFile) {
        if (pFile == null || pFile instanceof BIDirectory || pFile.getExtension() == null) {
            return false;
        }
        if (pFile.getExtension().equals("dist")) {
            return true;
        }
        if (pFile.getExtension().equals("jar") || pFile.getExtension().equals("sjar")) {
            return true;
        }
        return LocalInstallableRegistry.getInstance().getInstallableTypeForExt(pFile.getExtension()) != null;
    }

    public static BInstallable make(BIFile pFile) {
        if (pFile == null || pFile instanceof BIDirectory || pFile.getExtension() == null) {
            return null;
        }
        if (pFile.getExtension().equals("dist")) {
            return BInstallable.make(BDistribution.TYPE, pFile);
        }
        if (pFile.getExtension().equals("jar") || pFile.getExtension().equals("sjar")) {
            return BInstallable.make(BModuleInstallable.TYPE, pFile);
        }
        Type installableType = LocalInstallableRegistry.getInstance().getInstallableTypeForExt(pFile.getExtension());
        if (installableType != null) {
            return BInstallable.make(installableType, pFile);
        }
        return null;
    }

    public static BInstallable make(Type pSpec, BIFile pFile) {
        BInstallable result = (BInstallable)pSpec.getInstance();
        result.setInstallableFileProperties(pFile);
        return result.makeLocalInstance();
    }

    public static BInstallable makeRemote(BIFile pFile) {
        if (pFile == null || pFile instanceof BIDirectory || pFile.getExtension() == null) {
            return null;
        }
        if (pFile.getExtension().equals("dist")) {
            return BInstallable.makeRemote(BDistribution.TYPE, pFile);
        }
        if (pFile.getExtension().equals("jar") || pFile.getExtension().equals("sjar")) {
            return BInstallable.makeRemote(BModuleInstallable.TYPE, pFile);
        }
        Type installableType = LocalInstallableRegistry.getInstance().getInstallableTypeForExt(pFile.getExtension());
        if (installableType != null) {
            return BInstallable.makeRemote(installableType, pFile);
        }
        return null;
    }

    public static BInstallable makeRemote(Type pSpec, BIFile pFile) {
        BInstallable result = (BInstallable)pSpec.getInstance();
        result.setInstallableFileProperties(pFile);
        return result;
    }

    public final BDependency[] getAllDependencies() {
        TreeMap<PartSpec, BDependency> resultMap = new TreeMap<PartSpec, BDependency>();
        SlotCursor d = this.getDependencies().getProperties();
        while (d.next()) {
            this.updateDependencyMap(resultMap, (BDependency)d.get());
        }
        SlotCursor p = this.getParts().getProperties();
        while (p.next()) {
            BPart part = (BPart)p.get();
            SlotCursor d2 = part.getDependencies().getProperties();
            while (d2.next()) {
                this.updateDependencyMap(resultMap, (BDependency)d2.get());
            }
        }
        return resultMap.values().toArray(new BDependency[0]);
    }

    public BDependency[] getAllExclusions() {
        Array result = new Array(BDependency.class);
        SlotCursor d = this.getExclusions().getProperties();
        while (d.next()) {
            result.add((Object)((BDependency)d.get()));
        }
        return (BDependency[])result.trim();
    }

    private void updateDependencyMap(TreeMap<PartSpec, BDependency> resultMap, BDependency newDepend) {
        BDependency currentDep = resultMap.get(newDepend.getPartSpec());
        if (currentDep == null || newDepend.supersedes(currentDep)) {
            resultMap.put(newDepend.getPartSpec(), newDepend);
        }
    }

    public Array<BDependency> getUnmetPlatformDependencies(BDaemonPlatform platform) {
        Array resultArray = new Array(BDependency.class);
        SlotCursor c = this.getDependencies().getProperties();
        while (c.next()) {
            boolean partInstallable;
            BDependency depend = (BDependency)c.get();
            Type dependType = depend.getPartType();
            if (dependType.is(BOsPart.TYPE)) {
                partInstallable = false;
                if (platform.getOsPart().matchesName(depend.getPartName())) {
                    partInstallable = platform.getOsPart().isInstallable();
                }
                if (partInstallable || platform.meets(depend)) continue;
                resultArray.add((Object)((BDependency)depend.newCopy()));
                continue;
            }
            if (dependType.is(BGenericPart.TYPE)) {
                partInstallable = false;
                BPart part = platform.getPart(depend);
                if (part != null) {
                    partInstallable = part.isInstallable();
                }
                if (partInstallable || platform.meets(depend)) continue;
                resultArray.add((Object)((BDependency)depend.newCopy()));
                continue;
            }
            if (!dependType.is(BArchPart.TYPE) && !dependType.is(BModelPart.TYPE) || platform.meets(depend)) continue;
            resultArray.add((Object)((BDependency)depend.newCopy()));
        }
        return resultArray;
    }

    public boolean equivalent(Object obj) {
        if (obj instanceof BInstallable) {
            BInstallable inst = (BInstallable)obj;
            return inst.getInstallableFileOrd().equivalent((Object)this.getInstallableFileOrd());
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        if (this.equivalent(obj)) {
            return 0;
        }
        if (obj instanceof BInstallable) {
            BInstallable inst = (BInstallable)obj;
            if (this.getType().equals(inst.getType())) {
                int result = inst.getInstallableName().compareTo(this.getInstallableName());
                if (result == 0) {
                    return this.getVersion().compareTo((Object)inst.getVersion());
                }
                return result;
            }
            return this.getType().toString().compareTo(inst.getType().toString());
        }
        return this.toString().compareTo(obj.toString());
    }

    public final BPart getPart(String name) {
        return this.getPart(name, null);
    }

    public BPart getPart(String name, DaemonSessionTaskListener listener) {
        if (BPart.isWildcardName(name)) {
            SlotCursor c = this.getParts().getProperties();
            while (c.next(BPart.class)) {
                BPart p = (BPart)c.get();
                if (!p.matchesName(name)) continue;
                return p;
            }
            return null;
        }
        return (BPart)this.getParts().get(SlotPath.escape((String)name));
    }

    public void registerInstallableResources(DaemonSessionTaskListener listener) throws Exception {
    }

    public final boolean meets(BDependency depend) {
        return this.meets(depend, null);
    }

    public boolean meets(BDependency depend, DaemonSessionTaskListener listener) {
        BPart part = this.getPart(depend.getPartName(), listener);
        return part != null && part.meets(depend);
    }

    public boolean meetsLicenseCriteria(VendorLicense license) {
        return true;
    }

    public String toString(Context cx) {
        String versionString = this.getVersion().toString(cx);
        if (versionString.trim().length() == 0) {
            return this.getInstallableName();
        }
        return BVersion.nameVersionText.getText(cx, new Object[]{this.getInstallableName(), versionString});
    }
}

