/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDependency;
import com.tridium.install.DistLicenseFeatureFilter;
import com.tridium.install.InstallScenario;
import com.tridium.install.InstallableCandidates;
import com.tridium.install.InstallableFilter;
import com.tridium.install.installable.BInstallable;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.util.Arrays;
import java.util.List;

public class SolutionParameters {
    public DaemonSessionTaskListener listener;
    public boolean latestOnly = false;
    public String[] solvers = new String[]{"default"};
    public InstallableFilter[] installableFilters = new InstallableFilter[0];

    public SolutionParameters(DaemonSessionTaskListener listener) {
        this.listener = listener;
    }

    public SolutionParameters(DaemonSessionTaskListener listener, boolean latestOnly, String solver) {
        this(listener, latestOnly, new String[]{solver});
    }

    public SolutionParameters(DaemonSessionTaskListener listener, boolean latestOnly, String[] solvers) {
        this.listener = listener;
        this.latestOnly = latestOnly;
        this.solvers = solvers;
    }

    public InstallableFilter getFailedFilter(BInstallable inst) {
        for (int i = 0; i < this.installableFilters.length; ++i) {
            if (this.installableFilters[i].acceptInstallable(inst)) continue;
            return this.installableFilters[i];
        }
        return null;
    }

    public boolean acceptInstallable(BInstallable inst) {
        return this.getFailedFilter(inst) == null;
    }

    public void addFilter(InstallableFilter filter) {
        InstallableFilter[] temp = new InstallableFilter[this.installableFilters.length + 1];
        System.arraycopy(this.installableFilters, 0, temp, 0, this.installableFilters.length);
        temp[this.installableFilters.length] = filter;
        this.installableFilters = temp;
    }

    public void removeDistLicenseFeatureFilters() {
        List<InstallableFilter> temp = Arrays.asList(this.installableFilters);
        InstallableFilter[] filteredCollection = (InstallableFilter[])temp.stream().filter(e -> !(e instanceof DistLicenseFeatureFilter)).toArray(InstallableFilter[]::new);
        this.installableFilters = filteredCollection;
    }

    public SolutionParameters newCopy() {
        SolutionParameters result = new SolutionParameters(this.listener);
        result.latestOnly = this.latestOnly;
        result.installableFilters = new InstallableFilter[this.installableFilters.length];
        System.arraycopy(this.installableFilters, 0, result.installableFilters, 0, this.installableFilters.length);
        result.solvers = new String[this.solvers.length];
        System.arraycopy(this.solvers, 0, result.solvers, 0, this.solvers.length);
        return result;
    }

    public InstallableCandidates getAdditionalCandidates(InstallScenario scenario, BDependency dep) throws Exception {
        return new InstallableCandidates();
    }
}

