/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.part.BModulePart;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class PartSpec
implements Comparable<PartSpec> {
    private String spec;
    private String partName;
    private BTypeSpec partType;

    public PartSpec(String partName, Type partType) {
        this(partName, partType.getTypeSpec());
    }

    public PartSpec(String partName, BTypeSpec partType) {
        this.spec = partName + ":" + partType.toString();
        this.partName = partName;
        this.partType = partType;
    }

    public static PartSpec forModule(String moduleName) {
        return new PartSpec(moduleName, BModulePart.TYPE);
    }

    public String getPartName() {
        return this.partName;
    }

    public BTypeSpec getPartType() {
        return this.partType;
    }

    public boolean equals(Object o) {
        return o instanceof PartSpec && ((PartSpec)o).spec.equals(this.spec);
    }

    public String toString() {
        return this.spec;
    }

    public int hashCode() {
        return this.spec.hashCode();
    }

    @Override
    public int compareTo(PartSpec s) {
        if (this == s) {
            return 0;
        }
        if (this.getPartType().equals((Object)s.getPartType())) {
            return this.getPartName().compareTo(s.getPartName());
        }
        return this.getPartType().toString().compareTo(s.getPartType().toString());
    }
}

