/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.InstallableFilter;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.platform.license.LicenseInfo;
import java.util.Collection;
import java.util.Collections;

public abstract class DistLicenseFeatureFilter
implements InstallableFilter {
    protected Collection<LicenseInfo> licenses;

    public final void setLicenses(Collection<LicenseInfo> licenses) {
        this.licenses = licenses == null ? null : Collections.unmodifiableCollection(licenses);
    }

    @Override
    public final boolean acceptInstallable(BInstallable inst) {
        if (inst instanceof BDistribution && this.shouldCheckDist((BDistribution)inst)) {
            if (this.licenses != null) {
                for (LicenseInfo info : this.licenses) {
                    for (String feature : this.getSatisfyingFeatures()) {
                        if (info.vendorLicense.getFeature(feature) == null) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    protected abstract boolean shouldCheckDist(BDistribution var1);

    public abstract String[] getSatisfyingFeatures();
}

