/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.Attrib;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ClassCondenser {
    private static final int MAGIC = -889275714;
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_MethodHandle = 15;
    private static final int CONSTANT_MethodType = 16;
    private static final int CONSTANT_InvokeDynamic = 18;
    private static final String CODE_ATTRIB = "Code";
    private static final String LINE_NUMBER_TABLE_ATTRIB = "LineNumberTable";
    private static final int EXCEPTION_TABLE_ENTRY_SIZE = 8;
    private static final int ATTRIB_HEADER_SIZE = 6;
    private String[] cpUtf;

    public void condense(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.condense(inputStream, outputStream, true);
    }

    public void condense(InputStream inputStream, OutputStream outputStream, boolean closeStreams) throws IOException {
        int i;
        DataInputStream in = new DataInputStream(new BufferedInputStream(inputStream));
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(outputStream));
        if (this.echoInt(in, out) != -889275714) {
            throw new IOException("Invalid magic");
        }
        this.echoUnsignedShort(in, out);
        this.echoUnsignedShort(in, out);
        this.cpUtf = new String[this.echoUnsignedShort(in, out)];
        for (int i2 = 1; i2 < this.cpUtf.length; ++i2) {
            boolean doubleWidth = this.echoCpInfo(in, out, i2);
            if (!doubleWidth) continue;
            ++i2;
        }
        this.echoUnsignedShort(in, out);
        this.echoUnsignedShort(in, out);
        this.echoUnsignedShort(in, out);
        this.echoFully(in, out, this.echoUnsignedShort(in, out) * 2);
        int n = this.echoUnsignedShort(in, out);
        for (i = 0; i < n; ++i) {
            this.echoField(in, out);
        }
        n = this.echoUnsignedShort(in, out);
        for (i = 0; i < n; ++i) {
            this.echoMethod(in, out);
        }
        n = this.echoUnsignedShort(in, out);
        for (i = 0; i < n; ++i) {
            this.echoAttrib(in, out);
        }
        out.flush();
        if (closeStreams) {
            out.close();
            outputStream.close();
            in.close();
            inputStream.close();
        }
    }

    private int echoUnsignedByte(DataInputStream in, DataOutputStream out) throws IOException {
        int n = in.readUnsignedByte();
        out.writeByte(n);
        return n;
    }

    private int echoUnsignedShort(DataInputStream in, DataOutputStream out) throws IOException {
        int n = in.readUnsignedShort();
        out.writeShort(n);
        return n;
    }

    private int echoInt(DataInputStream in, DataOutputStream out) throws IOException {
        int n = in.readInt();
        out.writeInt(n);
        return n;
    }

    private byte[] echoFully(DataInputStream in, DataOutputStream out, int len) throws IOException {
        byte[] b = new byte[len];
        in.readFully(b, 0, len);
        out.write(b, 0, len);
        return b;
    }

    private String echoUTF(DataInputStream in, DataOutputStream out) throws IOException {
        String str = DataInputStream.readUTF(in);
        out.writeUTF(str);
        return str;
    }

    private void echoMethod(DataInputStream in, DataOutputStream out) throws IOException {
        this.echoUnsignedShort(in, out);
        this.echoUnsignedShort(in, out);
        this.echoUnsignedShort(in, out);
        int n = this.echoUnsignedShort(in, out);
        for (int i = 0; i < n; ++i) {
            this.echoAttrib(in, out);
        }
    }

    private void echoField(DataInputStream in, DataOutputStream out) throws IOException {
        this.echoUnsignedShort(in, out);
        this.echoUnsignedShort(in, out);
        this.echoUnsignedShort(in, out);
        int n = this.echoUnsignedShort(in, out);
        for (int i = 0; i < n; ++i) {
            this.echoAttrib(in, out);
        }
    }

    private void echoAttrib(DataInputStream in, DataOutputStream out) throws IOException {
        int idx = in.readUnsignedShort();
        int len = in.readInt();
        String name = this.cpUtf[idx];
        if (name == null) {
            throw new IOException("Could not look up attribute.");
        }
        if (name.equals(CODE_ATTRIB)) {
            this.echoCodeAttrib(in, out, idx, len);
        } else {
            out.writeShort(idx);
            out.writeInt(len);
            this.echoFully(in, out, len);
        }
    }

    private void echoCodeAttrib(DataInputStream in, DataOutputStream out, int idx, int len) throws IOException {
        int i;
        int maxStack = in.readUnsignedShort();
        int maxLocals = in.readUnsignedShort();
        int codeLen = in.readInt();
        byte[] code = new byte[codeLen];
        in.readFully(code, 0, codeLen);
        int exLen = in.readUnsignedShort();
        int exTableLen = exLen * 8;
        byte[] exTable = new byte[exTableLen];
        in.readFully(exTable, 0, exTableLen);
        Attrib[] attribs = new Attrib[in.readUnsignedShort()];
        int validAttribs = 0;
        for (i = 0; i < attribs.length; ++i) {
            attribs[i] = new Attrib(in, this.cpUtf);
            if (attribs[i].name.equals(LINE_NUMBER_TABLE_ATTRIB)) {
                len -= attribs[i].len + 6;
                attribs[i] = null;
                continue;
            }
            ++validAttribs;
        }
        out.writeShort(idx);
        out.writeInt(len);
        out.writeShort(maxStack);
        out.writeShort(maxLocals);
        out.writeInt(codeLen);
        out.write(code, 0, codeLen);
        out.writeShort(exLen);
        out.write(exTable, 0, exTableLen);
        out.writeShort(validAttribs);
        for (i = 0; i < attribs.length; ++i) {
            if (attribs[i] == null) continue;
            out.writeShort(attribs[i].nameIndex);
            out.writeInt(attribs[i].len);
            out.write(attribs[i].info, 0, attribs[i].len);
        }
    }

    private boolean echoCpInfo(DataInputStream in, DataOutputStream out, int index) throws IOException {
        int tag = this.echoUnsignedByte(in, out);
        switch (tag) {
            case 1: {
                this.cpUtf[index] = this.echoUTF(in, out);
                return false;
            }
            case 3: {
                this.echoFully(in, out, 4);
                return false;
            }
            case 4: {
                this.echoFully(in, out, 4);
                return false;
            }
            case 5: {
                this.echoFully(in, out, 8);
                return true;
            }
            case 6: {
                this.echoFully(in, out, 8);
                return true;
            }
            case 7: {
                this.echoFully(in, out, 2);
                return false;
            }
            case 8: {
                this.echoFully(in, out, 2);
                return false;
            }
            case 9: {
                this.echoFully(in, out, 4);
                return false;
            }
            case 10: {
                this.echoFully(in, out, 4);
                return false;
            }
            case 11: {
                this.echoFully(in, out, 4);
                return false;
            }
            case 12: {
                this.echoFully(in, out, 4);
                return false;
            }
            case 15: {
                this.echoFully(in, out, 3);
                return false;
            }
            case 16: {
                this.echoFully(in, out, 2);
                return false;
            }
            case 18: {
                this.echoFully(in, out, 4);
                return false;
            }
        }
        throw new IOException("Invalid cp tag 0x" + Integer.toHexString(tag));
    }
}

