/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BModuleList;
import com.tridium.install.installable.BCodeSigner;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.net.HttpUtil;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.file.BDefaultDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.GetModuleListMessage;
import com.tridium.platform.daemon.message.RequestGarbageCollectionMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.CodeSigner;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
public class BRemoteModuleList
extends BModuleList {
    @Generated
    public static final Type TYPE = Sys.loadType(BRemoteModuleList.class);
    private BDaemonSession session = null;
    private boolean initialized = false;
    private String signers = "optional";
    private static Logger LOG = Logger.getLogger("platform");
    private XElem[] moduleElems = null;
    private XElem certPathsElem = null;
    private final Object moduleElemLock = new Object();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRemoteModuleList() {
    }

    public BRemoteModuleList(BDaemonSession session) {
        this.session = session;
        this.setLocalInstance(true);
        this.reset();
    }

    @Override
    public void doReload(DaemonSessionTaskListener listener) {
        this.init(listener);
    }

    @Override
    public void reset() {
        super.reset();
        this.moduleElems = null;
        this.getModules().removeAll();
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void doInit(DaemonSessionTaskListener listener) {
        if (!this.isLocalInstance()) {
            return;
        }
        if (!this.initialized) {
            long t0 = Clock.ticks();
            LOG.fine("building remote module list");
            this.getModules().removeAll();
            CancelableDaemonSessionTask task = this.getNewModuleInfoTask();
            if (listener != null) {
                listener.taskStarted(task);
            }
            try {
                XElem[] elems;
                Object object = this.moduleElemLock;
                synchronized (object) {
                    if (this.moduleElems == null) {
                        XElem elem = this.fetchModuleList(null, this.signers);
                        this.moduleElems = elem.elems("moduleItem");
                        this.certPathsElem = elem.elem("certPaths");
                    }
                    elems = this.moduleElems;
                }
                CertPath[] certPaths = null;
                if (this.certPathsElem != null) {
                    XElem[] certPathElems = this.certPathsElem.elems("certPath");
                    certPaths = new CertPath[certPathElems.length];
                    for (int i = 0; i < certPathElems.length; ++i) {
                        String certPathBase64 = certPathElems[i].string();
                        byte[] certPathBytes = Base64.getDecoder().decode(certPathBase64);
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(certPathBytes));
                        certPaths[i] = (CertPath)in.readObject();
                    }
                }
                for (int i = 0; i < elems.length && !task.isCanceled(); ++i) {
                    FilePath modulePath = this.uriToFilePath(elems[i].get("path"));
                    assert (modulePath != null);
                    if (modulePath.getParent().getName().equals("lib")) continue;
                    BModuleInstallable module = new BModuleInstallable(elems[i].getl("size", -1L), modulePath.getName(), elems[i].elem("module"));
                    XElem signersElem = elems[i].elem("signers");
                    if (signersElem != null) {
                        BModulePart part = module.getModulePart();
                        BVector codeSigners = part.getCodeSigners();
                        codeSigners.removeAll();
                        List<CodeSigner> signers = BRemoteModuleList.decodeSigners(signersElem, certPaths);
                        for (CodeSigner signer : signers) {
                            codeSigners.add(null, (BValue)new BCodeSigner(signer));
                        }
                        String signatureFailureCause = elems[i].get("signatureFailureCause");
                        part.setSignatureFailureCause(signatureFailureCause);
                        part.setSignersInitialized(true);
                    }
                    String slotName = SlotPath.escape((String)module.getInstallableName());
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("adding remote module " + module.getInstallableName());
                    }
                    if (this.getModules().getProperty(slotName) == null) {
                        this.getModules().add(slotName, (BValue)module);
                        continue;
                    }
                    LOG.severe(this.getLexicon().getText("ModuleList.exception.dupModule", new Object[]{module.getInstallableName()}));
                    throw new LocalizableRuntimeException("platform", "ModuleList.exception.dupModule", new Object[]{module.getInstallableName()});
                }
                if (task.isCanceled()) {
                    throw new ICancelHint.CanceledException();
                }
                this.initialized = true;
            }
            catch (ICancelHint.CanceledException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("platform", "RemoteModuleList.exception.xmlParse", (Throwable)e);
            }
            finally {
                Logger log = Logger.getLogger("platform.daemonTuning");
                if (log.isLoggable(Level.FINE)) {
                    log.fine("moduleList " + (Clock.ticks() - t0) + "ms");
                }
                if (listener != null) {
                    listener.taskFinished(task);
                }
            }
        }
    }

    protected XElem[] fetchModules(String modulePartName, String signers) throws Exception {
        return this.fetchModuleList(modulePartName, signers).elems("moduleItem");
    }

    protected XElem fetchModuleList(String modulePartName, String signers) throws Exception {
        XElem elem = XParser.make((InputStream)this.session.getInputStream((DaemonMessage)new GetModuleListMessage(false, true, false, modulePartName, signers), 90000)).parse();
        BHostProperties props = this.session.getHostProperties();
        if (props.getOsName().toLowerCase().startsWith("win") && !props.isNiagara4()) {
            LOG.fine("sending remote garbage collection");
            try {
                this.session.sendMessage(RequestGarbageCollectionMessage.getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return elem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModuleElems(XElem[] moduleElems) {
        Object object = this.moduleElemLock;
        synchronized (object) {
            this.moduleElems = moduleElems;
        }
    }

    public CancelableDaemonSessionTask getNewModuleInfoTask() {
        return new CancelableDaemonSessionTask(this.getLexicon(), "RemoteModuleList.dialog.loading.title", "RemoteModuleList.dialog.loading.message");
    }

    private FilePath uriToFilePath(String uri) {
        if (uri.startsWith("/files")) {
            return new FilePath("/" + HttpUtil.decodeUrl((String)uri.substring(7)));
        }
        if (uri.startsWith("/niagara_user")) {
            return new FilePath("~" + HttpUtil.decodeUrl((String)uri.substring(14)));
        }
        if (uri.startsWith("/niagara")) {
            return new FilePath("!" + HttpUtil.decodeUrl((String)uri.substring(9)));
        }
        return null;
    }

    public Stream<BModuleInstallable> getUnregisteredModules() {
        return this.getUnregisteredModules(null);
    }

    public Stream<BModuleInstallable> getUnregisteredModules(DaemonSessionTaskListener listener) {
        return this.getInstallables(false, listener).stream(true).map(installable -> (BModuleInstallable)installable).filter(remoteInst -> {
            block6: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Checking : " + remoteInst.getInstallableName());
                }
                try {
                    if (LocalInstallableRegistry.getInstance().isRegistered((BInstallable)remoteInst)) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Already Registered : " + remoteInst.getInstallableName() + " v" + (Object)((Object)remoteInst.getVersion()));
                        }
                        break block6;
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Not Currently Registered   : " + remoteInst.getInstallableName());
                    }
                    return true;
                }
                catch (Exception e) {
                    LOG.warning(e.toString());
                }
            }
            return false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BModuleInstallable> importUnregisteredModules(DaemonSessionTaskListener taskListener, ICancelHint cancelHint) {
        if (!this.session.getHostProperties().isNiagara4()) {
            throw new UnsupportedOperationException("Cannot import from Niagara AX host");
        }
        ArrayList<BModuleInstallable> result = new ArrayList<BModuleInstallable>();
        BDefaultDaemonFileSpace fileSpace = this.session.getFileSpace();
        if (taskListener == null) {
            taskListener = DaemonSessionTaskListener.NULL_TASK_LISTENER;
        }
        CancelableDaemonSessionTask task = new CancelableDaemonSessionTask(this.getLexicon(), "RemoteModuleList.importUnregisteredModules.taskTitle", "RemoteModuleList.importUnregisteredModules.taskTitle", cancelHint);
        task.setCancelLabel(this.getLexicon().getText("RemoteModuleList.importUnregisteredModules.taskCancel"));
        task.setIsCancelEnabled(true);
        taskListener.taskStarted(task);
        try {
            for (BModuleInstallable remote : this.getUnregisteredModules(taskListener)::iterator) {
                if (task.isCanceled()) {
                    break;
                }
                String filename = remote.getInstallableFileName();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("File to Import    : " + filename);
                }
                task.setMessage(this.getLexicon().getText("RemoteModuleList.importUnregisteredModules.fileMessage", new Object[]{remote.getInstallableName()}));
                taskListener.taskUpdated(task);
                FilePath filePath = SystemFilePaths.getModulesPath(this.session.getHostProperties().getIsNiagaraHomeReadonly()).merge(filename);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Remote File path  : " + filePath);
                }
                BIFile remoteFile = fileSpace.findFile(filePath);
                try {
                    InputStream remoteStream = remoteFile.getInputStream();
                    Throwable throwable = null;
                    try {
                        LocalInstallableRegistry.getInstance().register(remote.getInstallableName(), remote.getInstallableFileName(), remote.getVersion(), remoteStream, taskListener);
                        result.add(remote);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (remoteStream == null) continue;
                        if (throwable != null) {
                            try {
                                remoteStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        remoteStream.close();
                    }
                }
                catch (Exception e) {
                    LOG.warning(e.toString());
                }
            }
        }
        finally {
            taskListener.taskFinished(task);
        }
        return result;
    }

    public void setSigners(String signers) {
        this.signers = signers;
    }

    private static List<CodeSigner> decodeSigners(XElem signers, CertPath[] certPaths) throws IOException {
        XElem[] signerElems;
        ArrayList<CodeSigner> codeSigners = new ArrayList<CodeSigner>();
        for (XElem signer : signerElems = signers.elems("signer")) {
            CertPath signerCertPath = certPaths[signer.geti("certPathIndex")];
            long timestampTime = signer.getl("timestampTime", -1L);
            int timestampCertPathIndex = signer.geti("timestampCertPathIndex", -1);
            Timestamp timestamp = null;
            if (timestampTime != -1L && timestampCertPathIndex != -1) {
                timestamp = new Timestamp(new Date(timestampTime), certPaths[timestampCertPathIndex]);
            }
            codeSigners.add(new CodeSigner(signerCertPath, timestamp));
        }
        return codeSigners;
    }
}

