/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.PartSpec;
import com.tridium.install.part.BApplicationPart;
import com.tridium.install.part.BArchPart;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.io.BIEncodable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.install.BPlatformPartType;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.platform.install.PlatformDependency;
import javax.baja.platform.install.PlatformPart;
import javax.baja.registry.DependencyInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.LexiconText;
import javax.baja.util.PatternFilter;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="partName", type="String", defaultValue="unknown", flags=1), @NiagaraProperty(name="version", type="BVersion", defaultValue="BVersion.makeZero()", flags=1), @NiagaraProperty(name="versionRelation", type="BVersionRelation", defaultValue="BVersionRelation.minimum", flags=1), @NiagaraProperty(name="partTypeSpec", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", flags=1), @NiagaraProperty(name="solverFiltersString", type="String", defaultValue="*", flags=1)})
public class BDependency
extends BStruct
implements BIEncodable {
    @Generated
    public static final Property partName = BDependency.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Property version = BDependency.newProperty((int)1, (BValue)BVersion.makeZero(), null);
    @Generated
    public static final Property versionRelation = BDependency.newProperty((int)1, (BValue)BVersionRelation.minimum, null);
    @Generated
    public static final Property partTypeSpec = BDependency.newProperty((int)1, (BValue)BTypeSpec.DEFAULT, null);
    @Generated
    public static final Property solverFiltersString = BDependency.newProperty((int)1, (String)"*", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDependency.class);
    private Type resolvedType = null;
    private PartSpec spec = null;
    private PatternFilter[] solverFilters = null;
    public static final LexiconText NAME_VERSION_TEXT = LexiconText.make((Type)TYPE, (String)"Dependency.nameVersion");
    public static final LexiconText NAME_VERSION_TEXT_WITH_EXCLUDE = LexiconText.make((Type)TYPE, (String)"Dependency.nameVersion.exclude");
    public static final LexiconText NAME_VERSION_TEXT_WITH_PROFILE = LexiconText.make((Type)TYPE, (String)"Dependency.nameVersion.disabledProfile");
    public static final LexiconText ANY_VERSION_TEXT = LexiconText.make((Type)TYPE, (String)"Dependency.anyVersion");
    public static final LexiconText ANY_VERSION_TEXT_WITH_EXCLUDE = LexiconText.make((Type)TYPE, (String)"Dependency.anyVersion.exclude");
    public static final LexiconText ANY_VERSION_TEXT_WITH_PROFILE = LexiconText.make((Type)TYPE, (String)"Dependency.anyVersion.disabledProfile");
    public static final LexiconText MIN_VERSION_TEXT = LexiconText.make((Type)TYPE, (String)"Dependency.minVersion");
    public static final LexiconText MIN_VERSION_TEXT_WITH_EXCLUDE = LexiconText.make((Type)TYPE, (String)"Dependency.minVersion.exclude");
    public static final LexiconText MIN_VERSION_TEXT_WITH_PROFILE = LexiconText.make((Type)TYPE, (String)"Dependency.minVersion.disabledProfile");
    public static final LexiconText MIN_VERSION_EXCLUSIVE_TEXT = LexiconText.make((Type)TYPE, (String)"Dependency.minVersionExclusive");
    public static final LexiconText MIN_VERSION_EXCLUSIVE_TEXT_WITH_EXCLUDE = LexiconText.make((Type)TYPE, (String)"Dependency.minVersionExclusive.exclude");
    public static final LexiconText MIN_VERSION_EXCLUSIVE_TEXT_WITH_PROFILE = LexiconText.make((Type)TYPE, (String)"Dependency.minVersionExclusive.disabledProfile");
    public static final LexiconText MAX_VERSION_TEXT = LexiconText.make((Type)TYPE, (String)"Dependency.maxVersion");
    public static final LexiconText MAX_VERSION_TEXT_WITH_EXCLUDE = LexiconText.make((Type)TYPE, (String)"Dependency.maxVersion.exclude");
    public static final LexiconText MAX_VERSION_TEXT_WITH_PROFILE = LexiconText.make((Type)TYPE, (String)"Dependency.maxVersion.disabledProfile");
    public static final LexiconText EXACT_VERSION_TEXT = LexiconText.make((Type)TYPE, (String)"Dependency.exactVersion");
    public static final LexiconText EXACT_VERSION_TEXT_WITH_EXCLUDE = LexiconText.make((Type)TYPE, (String)"Dependency.exactVersion.exclude");
    public static final LexiconText EXACT_VERSION_TEXT_WITH_PROFILE = LexiconText.make((Type)TYPE, (String)"Dependency.exactVersion.disabledProfile");
    public static final LexiconText NOT_EQUAL_VERSION_TEXT = LexiconText.make((Type)TYPE, (String)"Dependency.notEqualVersion");
    public static final LexiconText MIN_MAX_TEXT = LexiconText.make((Type)TYPE, (String)"Dependency.minMax");
    public static final LexiconText MIN_NE_TEXT = LexiconText.make((Type)TYPE, (String)"Dependency.minNe");
    public static final LexiconText MAX_INCLUSIVE_MIN_EXCLUSIVE_TEXT = LexiconText.make((Type)TYPE, (String)"Dependency.maxInclusiveMinExclusive");
    public static final LexiconText MIN_INCLUSIVE_MAX_EXCLUSIVE_TEXT = LexiconText.make((Type)TYPE, (String)"Dependency.minInclusiveMaxExclusive");
    public static final DependencySync DEP_SYNC_KEEP_FIRST = new DependencySync("keep first");
    public static final DependencySync DEP_SYNC_KEEP_SECOND = new DependencySync("keep second");
    public static final DependencySync DEP_SYNC_NO_CHANGE = new DependencySync("no change");
    public static final DependencySync DEP_SYNC_CONFLICT = new DependencySync("conflict");
    public static final String DEFAULT_SOLVER = "default";
    public static final String NO_SOLVERS = "";
    public static final String COMMISSIONING_SOLVER = "commissioning";
    public static final String APP_SOLVER = "app";
    public static final String ANY_SOLVER = "*";
    public static final String EXCLUSION_FACET = "exclusion";
    public static final String DISABLED_PROFILE_FACET = "disabledProfile";
    private static final Logger LOGGER = Logger.getLogger("platform.install");
    public static final Comparator<BDependency> COMPARATOR = (d1, d2) -> {
        int result = d1.getPartTypeSpec().toString().compareTo(d2.getPartTypeSpec().toString());
        if (result == 0 && (result = d1.getPartName().compareTo(d2.getPartName())) == 0 && (result = d1.getVersion().compareTo((Object)d2.getVersion())) == 0) {
            result = d1.getVersionRelation().getTag().compareTo(d2.getVersionRelation().getTag());
        }
        return result;
    };

    @Generated
    public String getPartName() {
        return this.getString(partName);
    }

    @Generated
    public void setPartName(String v) {
        this.setString(partName, v, null);
    }

    @Generated
    public BVersion getVersion() {
        return (BVersion)this.get(version);
    }

    @Generated
    public void setVersion(BVersion v) {
        this.set(version, (BValue)v, null);
    }

    @Generated
    public BVersionRelation getVersionRelation() {
        return (BVersionRelation)this.get(versionRelation);
    }

    @Generated
    public void setVersionRelation(BVersionRelation v) {
        this.set(versionRelation, (BValue)v, null);
    }

    @Generated
    public BTypeSpec getPartTypeSpec() {
        return (BTypeSpec)this.get(partTypeSpec);
    }

    @Generated
    public void setPartTypeSpec(BTypeSpec v) {
        this.set(partTypeSpec, (BValue)v, null);
    }

    @Generated
    public String getSolverFiltersString() {
        return this.getString(solverFiltersString);
    }

    @Generated
    public void setSolverFiltersString(String v) {
        this.setString(solverFiltersString, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDependency() {
    }

    public BDependency(String pPartName, BVersion pVersion, BTypeSpec pPartTypeSpec) {
        this(pPartName, pVersion, BVersionRelation.minimum, pPartTypeSpec, ANY_SOLVER);
    }

    public BDependency(String pPartName, BVersion pVersion, BVersionRelation pVersionRelation, BTypeSpec pPartTypeSpec) {
        this(pPartName, pVersion, pVersionRelation, pPartTypeSpec, ANY_SOLVER);
    }

    public BDependency(String pPartName, BVersion pVersion, BVersionRelation pVersionRelation, BTypeSpec pPartTypeSpec, String pSolversString) {
        this.setPartName(pPartName);
        this.setVersion((BVersion)pVersion.newCopy());
        this.setVersionRelation(pVersionRelation);
        this.setPartTypeSpec(pPartTypeSpec);
        this.setSolverFiltersString(pSolversString);
    }

    public BDependency(DependencyInfo pInfo) {
        this.setPartTypeSpec(BModulePart.TYPE.getTypeSpec());
        this.setPartName(pInfo.getModulePartName());
        if (pInfo.getVendor() != null) {
            this.getVersion().setVendor(pInfo.getVendor());
        }
        this.getVersion().setVendorVersion(pInfo.getVendorVersion());
    }

    public XElem getXml() {
        XElem result = new XElem();
        result.setAttr("name", this.getPartName());
        if (!this.getSolverFiltersString().equals(ANY_SOLVER)) {
            result.setAttr("solvers", this.getSolverFiltersString());
        }
        if (!this.getVersion().getBajaVersionString().trim().isEmpty()) {
            result.setAttr("bajaVersion", this.getVersion().getBajaVersionString());
        }
        if (!this.getVersion().getVendorVersionString().trim().isEmpty()) {
            result.setAttr("vendorVersion", this.getVersion().getVendorVersionString());
            if (this.getVersionRelation() != BVersionRelation.minimum) {
                result.setAttr("rel", this.getVersionRelation().getTag());
            }
        }
        if (!this.getVersion().getVendor().trim().isEmpty()) {
            result.setAttr("vendor", this.getVersion().getVendor());
        }
        if (this.getPartTypeSpec().equals((Object)BModulePart.TYPE.getTypeSpec())) {
            result.setName("dependency");
        } else if (this.getPartTypeSpec().equals((Object)BOsPart.TYPE.getTypeSpec())) {
            result.setName("os");
        } else if (this.getPartTypeSpec().equals((Object)BVmPart.TYPE.getTypeSpec())) {
            result.setName("vm");
        } else if (this.getPartTypeSpec().equals((Object)BArchPart.TYPE.getTypeSpec())) {
            result.setName("arch");
        } else if (this.getPartTypeSpec().equals((Object)BModelPart.TYPE.getTypeSpec())) {
            result.setName("model");
        } else if (this.getPartTypeSpec().equals((Object)BBrandPart.TYPE.getTypeSpec())) {
            result.setName("brand");
        } else if (this.getPartTypeSpec().equals((Object)BNrePart.TYPE.getTypeSpec())) {
            result.setName("nre");
        } else if (this.getPartTypeSpec().equals((Object)BApplicationPart.TYPE.getTypeSpec())) {
            result.setName(APP_SOLVER);
        } else {
            result.setName("part");
            if (!(this.getVersion().equivalent((Object)BVersion.ZERO) || this.getVersionRelation().equals((Object)BVersionRelation.maximum) || this.getSolverFiltersString().equals(NO_SOLVERS))) {
                result.setAttr("installable", "true");
            }
        }
        return result;
    }

    public static BDependency forModule(String moduleName) {
        return new BDependency(moduleName, BVersion.ZERO, BModulePart.TYPE.getTypeSpec());
    }

    public static BDependency forPart(BPart part) {
        return BDependency.forPart(part, BVersionRelation.minimum);
    }

    public static BDependency forPart(BPart part, BVersionRelation relation) {
        return new BDependency(part.getPartName(), part.getVersion(), relation, part.getType().getTypeSpec(), ANY_SOLVER);
    }

    public static BDependency make(XElem elem) {
        if (elem.name().equals("dependency") || elem.name().equals("module")) {
            return new BDependency(elem.get("name"), new BVersion(elem.get("vendor", NO_SOLVERS), BDependency.getVendorVersion(elem)), BVersionRelation.make(elem.get("rel", "minimum")), BModulePart.TYPE.getTypeSpec(), elem.get("solvers", ANY_SOLVER));
        }
        if (elem.name().equals("os")) {
            return new BDependency(elem.get("name"), new BVersion(elem.get("vendor", NO_SOLVERS), BDependency.getVendorVersion(elem)), BVersionRelation.make(elem.get("rel", "minimum")), BOsPart.TYPE.getTypeSpec(), elem.get("solvers", ANY_SOLVER));
        }
        if (elem.name().equals("vm")) {
            return new BDependency(elem.get("name"), new BVersion(elem.get("vendor", NO_SOLVERS), BDependency.getVendorVersion(elem)), BVersionRelation.make(elem.get("rel", "minimum")), BVmPart.TYPE.getTypeSpec(), elem.get("solvers", ANY_SOLVER));
        }
        if (elem.name().equals("arch")) {
            return new BDependency(elem.get("name"), new BVersion(null, BDependency.getVendorVersion(elem)), BVersionRelation.make(elem.get("rel", "minimum")), BArchPart.TYPE.getTypeSpec(), NO_SOLVERS);
        }
        if (elem.name().equals("model")) {
            return new BDependency(elem.get("name"), new BVersion(null, BDependency.getVendorVersion(elem)), BVersionRelation.make(elem.get("rel", "minimum")), BModelPart.TYPE.getTypeSpec(), NO_SOLVERS);
        }
        if (elem.name().equals("brand")) {
            return new BDependency(elem.get("name"), BVersion.ZERO, BVersionRelation.minimum, BBrandPart.TYPE.getTypeSpec(), elem.get("solvers", NO_SOLVERS));
        }
        if (elem.name().equals("nre")) {
            return new BDependency(elem.get("name"), new BVersion(elem.get("vendor", NO_SOLVERS), BDependency.getVendorVersion(elem)), BVersionRelation.make(elem.get("rel", "minimum")), BNrePart.TYPE.getTypeSpec(), elem.get("solvers", ANY_SOLVER));
        }
        if (elem.name().equals(APP_SOLVER)) {
            return new BDependency(elem.get("name"), new BVersion(elem.get("vendor", NO_SOLVERS), BDependency.getVendorVersion(elem)), BVersionRelation.make(elem.get("rel", "minimum")), BApplicationPart.TYPE.getTypeSpec(), elem.get("solvers", APP_SOLVER));
        }
        if (elem.get("name", null) != null) {
            boolean installable = elem.getb("installable", false);
            return new BDependency(elem.get("name"), new BVersion(installable ? elem.get("vendor", NO_SOLVERS) : null, BDependency.getVendorVersion(elem)), BVersionRelation.make(elem.get("rel", "minimum")), BGenericPart.TYPE.getTypeSpec(), elem.get("solvers", installable ? ANY_SOLVER : NO_SOLVERS));
        }
        return null;
    }

    public PlatformDependency asPlatformDependency() {
        return new PlatformDependency(){

            @Override
            public PlatformPart getPartPrototype() {
                return new PlatformPart(){

                    @Override
                    public String getPartName() {
                        return BDependency.this.getPartName();
                    }

                    @Override
                    public BPlatformPartType getPartType() {
                        return BPart.getPlatformPartType(BDependency.this.getPartTypeSpec());
                    }

                    @Override
                    public Version getPartVersion() {
                        return BDependency.this.getVersion().getVendorVersion();
                    }
                };
            }

            @Override
            public BVersionRelation getVersionRelation() {
                return BDependency.this.getVersionRelation();
            }
        };
    }

    private static String getVendorVersion(XElem elem) {
        return elem.get("vendorVersion", elem.get("version", NO_SOLVERS));
    }

    public Type getPartType() {
        if (this.resolvedType == null) {
            this.resolvedType = this.getPartTypeSpec().getResolvedType();
        }
        return this.resolvedType;
    }

    public PartSpec getPartSpec() {
        if (this.spec == null) {
            this.spec = new PartSpec(this.getPartName(), this.getPartTypeSpec());
        }
        return this.spec;
    }

    public void changed(Property prop, Context context) {
        if (prop == partTypeSpec) {
            this.resolvedType = this.getPartTypeSpec().getResolvedType();
        }
    }

    public boolean equivalent(Object obj) {
        if (obj instanceof BDependency) {
            BDependency dep = (BDependency)((Object)obj);
            return this.getPartName().equals(dep.getPartName()) && this.getPartType().equals(dep.getPartType()) && this.getVersionRelation().equals((Object)dep.getVersionRelation()) && this.getVersion().equivalent((Object)dep.getVersion()) && this.getSolverFiltersString().equals(dep.getSolverFiltersString());
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static DependencySync sync(BDependency dep1, BDependency dep2) {
        block24: {
            block28: {
                block38: {
                    block39: {
                        block32: {
                            block37: {
                                block36: {
                                    block35: {
                                        block33: {
                                            block34: {
                                                block25: {
                                                    block31: {
                                                        block29: {
                                                            block30: {
                                                                block26: {
                                                                    block27: {
                                                                        if (dep1 == dep2 || dep1.equivalent((Object)dep2)) {
                                                                            return BDependency.DEP_SYNC_KEEP_FIRST;
                                                                        }
                                                                        if (!dep1.getPartTypeSpec().equals((Object)dep2.getPartTypeSpec())) break block24;
                                                                        if (dep1.getPartName().equals(dep2.getPartName()) || BPart.isWildcardName(dep2.getPartName()) && BPart.matchesName(dep1.getPartName(), dep2.getPartName())) {
                                                                            resultPartName = dep1.getPartName();
                                                                        } else if (BPart.isWildcardName(dep1.getPartName()) && BPart.matchesName(dep2.getPartName(), dep1.getPartName())) {
                                                                            resultPartName = dep2.getPartName();
                                                                        } else {
                                                                            return BDependency.DEP_SYNC_NO_CHANGE;
                                                                        }
                                                                        check = dep1.getVersion().checkVersionRequirement(dep2.getVersion());
                                                                        if (check == 8) {
                                                                            return BDependency.DEP_SYNC_CONFLICT;
                                                                        }
                                                                        if (dep1.getVersionRelation() != BVersionRelation.exact) break block25;
                                                                        if (dep2.getVersionRelation() != BVersionRelation.exact) break block26;
                                                                        if (check != 2 && check != 16) break block27;
                                                                        resultVersion = dep1.getVersion();
                                                                        resultRelation = BVersionRelation.exact;
                                                                        break block28;
                                                                    }
                                                                    return BDependency.DEP_SYNC_CONFLICT;
                                                                }
                                                                if (dep2.getVersionRelation() != BVersionRelation.minimum) break block29;
                                                                if (check != 2 && check != 16 && check != 1 && check != 32) break block30;
                                                                resultVersion = dep1.getVersion();
                                                                resultRelation = BVersionRelation.exact;
                                                                break block28;
                                                            }
                                                            return BDependency.DEP_SYNC_CONFLICT;
                                                        }
                                                        if (check != 4 && check != 32 && check != 2 && check != 16) break block31;
                                                        resultVersion = dep1.getVersion();
                                                        resultRelation = BVersionRelation.exact;
                                                        break block28;
                                                    }
                                                    return BDependency.DEP_SYNC_CONFLICT;
                                                }
                                                if (dep1.getVersionRelation() != BVersionRelation.minimum) break block32;
                                                if (dep2.getVersionRelation() != BVersionRelation.exact) break block33;
                                                if (check != 2 && check != 16 && check != 4 && check != 64) break block34;
                                                resultVersion = dep2.getVersion();
                                                resultRelation = BVersionRelation.exact;
                                                break block28;
                                            }
                                            return BDependency.DEP_SYNC_CONFLICT;
                                        }
                                        if (dep2.getVersionRelation() != BVersionRelation.minimum) break block35;
                                        resultRelation = BVersionRelation.minimum;
                                        resultVersion = check == 2 || check == 16 || check == 1 || check == 32 ? dep1.getVersion() : dep2.getVersion();
                                        break block28;
                                    }
                                    if (check != 2 && check != 16) break block36;
                                    resultVersion = dep1.getVersion();
                                    resultRelation = BVersionRelation.exact;
                                    break block28;
                                }
                                if (check != 64) break block37;
                                resultVersion = dep2.getVersion();
                                resultRelation = BVersionRelation.maximum;
                                break block28;
                            }
                            if (check == 4) {
                                return BDependency.DEP_SYNC_NO_CHANGE;
                            }
                            return BDependency.DEP_SYNC_CONFLICT;
                        }
                        if (dep2.getVersionRelation() != BVersionRelation.exact) break block38;
                        if (check != 2 && check != 16 && check != 1) break block39;
                        resultVersion = dep2.getVersion();
                        resultRelation = BVersionRelation.exact;
                        break block28;
                    }
                    return BDependency.DEP_SYNC_CONFLICT;
                }
                if (dep2.getVersionRelation() != BVersionRelation.minimum) ** GOTO lbl86
                if (check == 2 || check == 16) {
                    resultVersion = dep1.getVersion();
                    resultRelation = BVersionRelation.exact;
                } else if (check == 32) {
                    resultVersion = dep1.getVersion();
                    resultRelation = BVersionRelation.maximum;
                } else {
                    if (check == 1) {
                        return BDependency.DEP_SYNC_NO_CHANGE;
                    }
                    return BDependency.DEP_SYNC_CONFLICT;
lbl86:
                    // 1 sources

                    resultRelation = BVersionRelation.maximum;
                    resultVersion = check == 2 || check == 16 || check == 4 ? dep1.getVersion() : dep2.getVersion();
                }
            }
            if (dep1.getSolverFiltersString().equals(dep2.getSolverFiltersString())) {
                resultSolvers = dep1.getSolverFiltersString();
            } else if (dep1.getSolverFiltersString().equals("*") || dep2.getSolverFiltersString().equals("*")) {
                resultSolvers = "*";
            } else {
                solverFilterByPattern = new TreeMap<String, PatternFilter>();
                for (PatternFilter solverPatternDep1 : dep1.getSolvers()) {
                    solverFilterByPattern.put(solverPatternDep1.getPattern(), solverPatternDep1);
                }
                for (PatternFilter solverPatternDep2 : dep2.getSolvers()) {
                    if (solverFilterByPattern.containsKey(solverPatternDep2.getPattern())) continue;
                    mustAdd = true;
                    for (PatternFilter filter : solverFilterByPattern.values()) {
                        if (filter.accept(solverPatternDep2.getPattern())) {
                            mustAdd = false;
                            break;
                        }
                        if (!solverPatternDep2.accept(filter.getPattern())) continue;
                        solverFilterByPattern.remove(filter.getPattern());
                        break;
                    }
                    if (!mustAdd) continue;
                    solverFilterByPattern.put(solverPatternDep2.getPattern(), solverPatternDep2);
                }
                solverBuf = new StringBuilder();
                for (String s : solverFilterByPattern.keySet()) {
                    if (solverBuf.length() > 0) {
                        solverBuf.append(';');
                    }
                    solverBuf.append(s);
                }
                resultSolvers = solverBuf.toString();
            }
            if (dep1.getPartName().equals(resultPartName) && dep1.getVersion().equivalent((Object)resultVersion) && dep1.getVersionRelation().equals((Object)resultRelation) && dep1.getSolverFiltersString().equals(resultSolvers)) {
                return BDependency.DEP_SYNC_KEEP_FIRST;
            }
            if (dep2.getPartName().equals(resultPartName) && dep2.getVersion().equivalent((Object)resultVersion) && dep2.getVersionRelation().equals((Object)resultRelation) && dep2.getSolverFiltersString().equals(resultSolvers)) {
                return BDependency.DEP_SYNC_KEEP_SECOND;
            }
            return new DependencySync(new BDependency(resultPartName, resultVersion, resultRelation, dep1.getPartTypeSpec(), resultSolvers));
        }
        return BDependency.DEP_SYNC_NO_CHANGE;
    }

    public boolean supersedes(BDependency dep) {
        return BDependency.sync(this, dep) == DEP_SYNC_KEEP_FIRST;
    }

    public boolean isPlatformDependency(BDaemonPlatform platform) {
        if (this.getPartTypeSpec().equals((Object)BModelPart.TYPE.getTypeSpec()) || this.getPartTypeSpec().equals((Object)BArchPart.TYPE.getTypeSpec())) {
            return true;
        }
        if (this.getPartTypeSpec().equals((Object)BOsPart.TYPE.getTypeSpec())) {
            return !platform.getOsPart().isInstallable();
        }
        if (this.getPartTypeSpec().equals((Object)BGenericPart.TYPE.getTypeSpec())) {
            BPart part = platform.getPart(this);
            if (part != null) {
                return !part.isInstallable();
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Could not find generic part for dependency '" + (Object)((Object)this) + "' on platform. Assuming platform dependency.");
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString(Context cx) {
        String versionString;
        BDependency exclusion = null;
        String disabledProfile = null;
        if (cx != null) {
            BString profileFacet;
            BString exclusionFacet = (BString)cx.getFacet(EXCLUSION_FACET);
            if (exclusionFacet != null) {
                try {
                    exclusion = (BDependency)new BDependency().decodeFromString(exclusionFacet.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((profileFacet = (BString)cx.getFacet(DISABLED_PROFILE_FACET)) != null) {
                disabledProfile = profileFacet.toString();
            }
            cx = new BasicContext(cx.getUser(), cx.getLanguage());
        }
        if ((versionString = this.getVersion().toString(cx)).trim().isEmpty()) {
            if (exclusion != null) {
                if (!exclusion.getPartName().equals(this.getPartName())) return ANY_VERSION_TEXT_WITH_EXCLUDE.getText(cx, new Object[]{this.getPartName(), exclusion.toString(cx)});
                if (exclusion.getVersionRelation() == BVersionRelation.minimum) {
                    return MAX_VERSION_TEXT.getText(cx, new Object[]{this.getPartName(), exclusion.getVersion()});
                }
                if (exclusion.getVersionRelation() == BVersionRelation.maximum) {
                    return MIN_VERSION_EXCLUSIVE_TEXT.getText(cx, new Object[]{this.getPartName(), exclusion.getVersion()});
                }
                if (exclusion.getVersionRelation() != BVersionRelation.maximum) return this.getPartName();
                return NOT_EQUAL_VERSION_TEXT.getText(cx, new Object[]{this.getPartName(), exclusion.getVersion()});
            }
            if (disabledProfile == null) return this.getPartName();
            return ANY_VERSION_TEXT_WITH_PROFILE.getText(cx, new Object[]{this.getPartName(), disabledProfile});
        }
        if (versionString.equals("0")) {
            if (exclusion != null) {
                if (exclusion.getPartName().equals(this.getPartName())) {
                    if (exclusion.getVersionRelation() == BVersionRelation.minimum) {
                        return MAX_VERSION_TEXT.getText(cx, new Object[]{this.getPartName(), exclusion.getVersion()});
                    }
                    if (exclusion.getVersionRelation() == BVersionRelation.maximum) {
                        return MIN_VERSION_EXCLUSIVE_TEXT.getText(cx, new Object[]{this.getPartName(), exclusion.getVersion()});
                    }
                    if (exclusion.getVersionRelation() == BVersionRelation.exact) {
                        return NOT_EQUAL_VERSION_TEXT.getText(cx, new Object[]{this.getPartName(), exclusion.getVersion()});
                    }
                }
            } else if (disabledProfile != null) {
                return ANY_VERSION_TEXT_WITH_PROFILE.getText(cx, new Object[]{this.getPartName(), disabledProfile});
            }
            versionString = ANY_VERSION_TEXT.getText(cx);
        }
        if (this.getVersionRelation() == BVersionRelation.minimum) {
            if (exclusion != null) {
                if (!exclusion.getPartName().equals(this.getPartName())) return MIN_VERSION_TEXT_WITH_EXCLUDE.getText(cx, new Object[]{this.getPartName(), versionString, exclusion.toString(cx)});
                if (exclusion.getVersionRelation() == BVersionRelation.minimum) {
                    return MIN_INCLUSIVE_MAX_EXCLUSIVE_TEXT.getText(cx, new Object[]{this.getPartName(), versionString, exclusion.getVersion()});
                }
                if (exclusion.getVersionRelation() == BVersionRelation.maximum && this.getVersion().compareTo((Object)exclusion.getVersion()) <= 0) {
                    return MIN_VERSION_EXCLUSIVE_TEXT.getText(cx, new Object[]{this.getPartName(), exclusion.getVersion()});
                }
                if (exclusion.getVersionRelation() != BVersionRelation.maximum) return MIN_VERSION_TEXT.getText(cx, new Object[]{this.getPartName(), versionString});
                return MIN_NE_TEXT.getText(cx, new Object[]{this.getPartName(), versionString, exclusion.getVersion()});
            }
            if (disabledProfile == null) return MIN_VERSION_TEXT.getText(cx, new Object[]{this.getPartName(), versionString});
            return MIN_VERSION_TEXT_WITH_PROFILE.getText(cx, new Object[]{this.getPartName(), versionString, disabledProfile});
        }
        if (this.getVersionRelation() == BVersionRelation.maximum) {
            if (exclusion != null) {
                if (!exclusion.getPartName().equals(this.getPartName())) return MAX_VERSION_TEXT_WITH_EXCLUDE.getText(cx, new Object[]{this.getPartName(), versionString, exclusion.toString(cx)});
                if (exclusion.getVersionRelation() == BVersionRelation.minimum && this.getVersion().compareTo((Object)exclusion.getVersion()) > 0) {
                    return MAX_VERSION_TEXT.getText(cx, new Object[]{this.getPartName(), exclusion.getVersion()});
                }
                if (exclusion.getVersionRelation() != BVersionRelation.maximum) return MAX_VERSION_TEXT.getText(cx, new Object[]{this.getPartName(), versionString});
                return MAX_INCLUSIVE_MIN_EXCLUSIVE_TEXT.getText(cx, new Object[]{this.getPartName(), versionString, exclusion.getVersion()});
            }
            if (disabledProfile == null) return MAX_VERSION_TEXT.getText(cx, new Object[]{this.getPartName(), versionString});
            return MAX_VERSION_TEXT_WITH_PROFILE.getText(cx, new Object[]{this.getPartName(), versionString, disabledProfile});
        }
        if (exclusion != null) {
            if (!exclusion.getPartName().equals(this.getPartName())) return EXACT_VERSION_TEXT.getText(cx, new Object[]{this.getPartName(), versionString});
            return EXACT_VERSION_TEXT_WITH_EXCLUDE.getText(cx, new Object[]{this.getPartName(), versionString, exclusion.toString(cx)});
        }
        if (disabledProfile == null) return EXACT_VERSION_TEXT.getText(cx, new Object[]{this.getPartName(), versionString});
        return EXACT_VERSION_TEXT_WITH_PROFILE.getText(cx, new Object[]{this.getPartName(), versionString, disabledProfile});
    }

    public BIcon getIcon() {
        if (this.getPartTypeSpec() != BTypeSpec.DEFAULT) {
            return BPart.getPartTypeIcon(this.getPartType());
        }
        return BIcon.make((String)BPart.TYPE.getModule().getLexicon().getText("Unknown.typeIcon"));
    }

    public static BDependency[] merge(BDependency[] toMerge) {
        Array result = new Array((Object[])toMerge);
        result = result.sort(COMPARATOR);
        for (int i1 = 0; i1 < result.size() - 1; ++i1) {
            BDependency d1 = (BDependency)((Object)result.get(i1));
            int i2 = i1 + 1;
            while (i2 < result.size()) {
                BDependency d2 = (BDependency)((Object)result.get(i2));
                DependencySync s = BDependency.sync(d1, d2);
                if (s == DEP_SYNC_KEEP_FIRST) {
                    result.remove(i2);
                    continue;
                }
                if (s == DEP_SYNC_KEEP_SECOND) {
                    result.swap(i1, i2);
                    result.remove(i2);
                    continue;
                }
                if (s == DEP_SYNC_CONFLICT || s == DEP_SYNC_NO_CHANGE) {
                    ++i2;
                    continue;
                }
                result.set(i1, (Object)s.mergedResult);
                result.remove(i2);
            }
        }
        return (BDependency[])result.trim();
    }

    public PatternFilter[] getSolvers() {
        if (this.solverFilters == null) {
            this.solverFilters = PatternFilter.parseList((String)this.getSolverFiltersString());
        }
        return this.solverFilters;
    }

    public boolean canSolveWith(String[] solvers) {
        for (String solver : solvers) {
            if (!this.canSolveWith(solver)) continue;
            return true;
        }
        return false;
    }

    public boolean canSolveWith(String solver) {
        this.getSolvers();
        for (PatternFilter solverFilter : this.solverFilters) {
            if (!solverFilter.accept(solver)) continue;
            return true;
        }
        return false;
    }

    public BObject decode(DataInput in) throws IOException {
        this.setPartName(in.readUTF());
        this.setVersion((BVersion)BVersion.ZERO.decode(in));
        this.setVersionRelation((BVersionRelation)BVersionRelation.minimum.decode(in));
        this.setPartTypeSpec(BTypeSpec.make((String)in.readUTF()));
        this.setSolverFiltersString(in.readUTF());
        return null;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.getPartName());
        this.getVersion().encode(out);
        this.getVersionRelation().encode(out);
        out.writeUTF(this.getPartTypeSpec().toString());
        out.writeUTF(this.getSolverFiltersString());
    }

    public BObject decodeFromString(String s) throws IOException {
        BDependency result = new BDependency();
        String[] values = TextUtil.split((String)s, (char)';');
        result.setPartName(values[0]);
        result.getVersion().setBajaVersionString(values[1]);
        result.getVersion().setVendor(values[2]);
        result.getVersion().setVendorVersionString(values[3]);
        result.setVersionRelation(BVersionRelation.make(values[4]));
        result.setPartTypeSpec(BTypeSpec.make((String)values[5]));
        StringBuilder filters = new StringBuilder();
        for (int i = 6; i < values.length; ++i) {
            if (filters.length() > 0) {
                filters.append(';');
            }
            filters.append(values[i]);
        }
        result.setSolverFiltersString(filters.toString());
        return result;
    }

    public String encodeToString() throws IOException {
        return this.getPartName() + ';' + this.getVersion().encodeToString() + ';' + this.getVersionRelation().getTag() + ';' + this.getPartTypeSpec().toString() + ';' + this.getSolverFiltersString();
    }

    public static class DependencySync {
        public BDependency mergedResult;
        public String description;

        public DependencySync(BDependency mergedResult) {
            this.mergedResult = mergedResult;
            this.description = null;
        }

        public DependencySync(String description) {
            this.mergedResult = null;
            this.description = description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.mergedResult != null && o instanceof DependencySync) {
                return ((DependencySync)o).mergedResult != null && ((DependencySync)o).mergedResult.equivalent((Object)this.mergedResult);
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.description == null ? "merge into " + this.mergedResult.toString() : this.description;
        }
    }
}

