/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfIp.tcp.comm;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddfIp.comm.BDdfIpAdapter;
import com.tridium.ddfIp.comm.BDdfIpAddressPort;
import com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="destinationAddress", type="BDdfIpAddressPort", defaultValue="new BDdfIpAddressPort()", facets={@Facet(value="MGR_INCLUDE")}), @NiagaraProperty(name="socketConnectionTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)", facets={@Facet(value="BFacets.make(BFacets.make(BFacets.SHOW_MILLISECONDS,BBoolean.TRUE), \n                                  BFacets.MIN,BRelTime.make(1))")})})
public class BDdfTcpHelper
extends BStruct
implements IDdfFacetConst {
    @Generated
    public static final Property destinationAddress = BDdfTcpHelper.newProperty((int)0, (BValue)new BDdfIpAddressPort(), (BFacets)MGR_INCLUDE);
    @Generated
    public static final Property socketConnectionTimeout = BDdfTcpHelper.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), (String)"min", (BIDataValue)BRelTime.make((long)1L)));
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfTcpHelper.class);
    BDdfTcpCommunicator tcpCommunicator;
    private static final BIcon icon = BIcon.std((String)"connection.png");

    @Generated
    public BDdfIpAddressPort getDestinationAddress() {
        return (BDdfIpAddressPort)this.get(destinationAddress);
    }

    @Generated
    public void setDestinationAddress(BDdfIpAddressPort v) {
        this.set(destinationAddress, (BValue)v, null);
    }

    @Generated
    public BRelTime getSocketConnectionTimeout() {
        return (BRelTime)this.get(socketConnectionTimeout);
    }

    @Generated
    public void setSocketConnectionTimeout(BRelTime v) {
        this.set(socketConnectionTimeout, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        return this.getDestinationAddress().getIpAddress() + ':' + this.getDestinationAddress().getIpPort();
    }

    public Socket createSocket() throws IOException {
        return this.createSocket(this.getTcpCommunicator().getNetworkInterface(), this.getLocalPort());
    }

    public int getLocalPort() {
        return -1;
    }

    public BDdfTcpCommunicator getTcpCommunicator() {
        if (this.tcpCommunicator == null) {
            this.tcpCommunicator = (BDdfTcpCommunicator)this.getParent();
        }
        return this.tcpCommunicator;
    }

    protected Socket createSocket(BDdfIpAdapter networkInterface, int bindPort) throws IOException {
        if (networkInterface.isDefaultLocalHost()) {
            return this.makeLocalHostSocket(bindPort);
        }
        return this.makeFullySpecifiedSocket(networkInterface, bindPort);
    }

    protected Socket makeLocalHostSocket(int bindPort) throws IOException {
        if (bindPort < 0) {
            return new Socket(this.getDestinationAddress().getIpAddress(), this.getDestinationAddress().getIpPort());
        }
        return null;
    }

    protected Socket makeFullySpecifiedSocket(BDdfIpAdapter networkInterface, int bindPort) throws IOException {
        if (bindPort < 0) {
            Socket tempSocket = null;
            for (int port = 49152; port <= 65535 && tempSocket == null; ++port) {
                try {
                    tempSocket = new Socket(this.getDestinationAddress().getIpAddress(), this.getDestinationAddress().getIpPort(), InetAddress.getByName(networkInterface.getIpAddress()), port);
                    continue;
                }
                catch (SocketException socketException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (tempSocket == null) {
                throw new SocketException("No Available Dynamic Port in Range [49152-65535]");
            }
            return tempSocket;
        }
        return new Socket(this.getDestinationAddress().getIpAddress(), this.getDestinationAddress().getIpPort(), InetAddress.getByName(networkInterface.getIpAddress()), bindPort);
    }

    public BIcon getIcon() {
        return icon;
    }
}

